<?php
/**
 * Custom Prices metadata.
 *
 * @package EDD_Custom_Prices
 * @since 1.5.9
 */

defined( 'ABSPATH' ) || exit;

/**
 * Add custom price fields in metabox
 *
 * @param int $post_id The post ID.
 */
function edd_cp_render_custom_price_field( $post_id ) {
	if ( edd_cp_download_editor_has_sections() ) {
		return;
	}

	$download       = edd_get_download( $post_id );
	$custom_pricing = edd_cp_has_custom_pricing( $download->ID );

	?>
	<p>
		<strong><?php esc_html_e( 'Custom Pricing:', 'edd_cp' ); ?></strong>
	</p>

	<p>
		<label for="edd_cp_custom_pricing">
			<input type="checkbox" name="_edd_cp_custom_pricing" id="edd_cp_custom_pricing" value="1" <?php checked( (bool) $custom_pricing ); ?> />
			<?php esc_html_e( 'Enable custom pricing', 'edd_cp' ); ?>
		</label>
	</p>
	<?php

	include EDD_CUSTOM_PRICES_DIR . 'views/custom-price-metabox.php';
}
add_action( 'edd_after_price_field', 'edd_cp_render_custom_price_field' );

/**
 * Add custom pricing enable checkbox
 *
 * @since 1.5.10
 * @param int $download_id The download ID.
 */
function edd_cp_render_custom_pricing_enable( $download_id ) {
	if ( ! edd_cp_download_editor_has_sections() ) {
		return;
	}

	remove_action( 'edd_after_price_field', 'edd_recurring_metabox_custom_options' );

	$enabled = edd_cp_has_custom_pricing( $download_id );
	?>
	<div class="edd-form-group">
		<div class="edd-form-group__control edd-toggle">
			<input type="checkbox" name="_edd_cp_custom_pricing" id="edd_cp_custom_pricing" value="1" class="edd-requirement" <?php checked( true, $enabled, true ); ?> data-edd-requirement="custom-prices"/>
			<label for="edd_cp_custom_pricing"><?php esc_html_e( 'Enable custom pricing for this product.', 'edd_cp' ); ?></label>
		</div>
	</div>
	<?php
}
add_action( 'edd_meta_box_fields', 'edd_cp_render_custom_pricing_enable' );

/**
 * Add the custom prices metabox to the product settings in wp-admin.
 *
 * @since 1.5.10
 * @param array $sections The existing sections.
 * @return array The updated sections.
 */
function edd_cp_add_download_section( $sections ) {
	$sections['custom-prices'] = EDD\CustomPrices\Admin\Metabox::class;

	return $sections;
}
add_filter( 'edd_download_details_sections', 'edd_cp_add_download_section' );

/**
 * Add fields to be saved
 *
 * @param array $fields The fields to be saved.
 */
function edd_cp_metabox_fields_save( $fields ) {
	$fields[] = '_edd_cp_custom_pricing';
	$fields[] = 'edd_cp_min';
	$fields[] = 'cp_button_text';
	$fields[] = 'edd_cp_default_price';
	return $fields;
}
add_filter( 'edd_metabox_fields_save', 'edd_cp_metabox_fields_save' );

/**
 * Sanitize the amounts on save.
 *
 * @since 1.5.8
 */
add_filter( 'edd_metabox_save_edd_cp_default_price', 'edd_sanitize_amount' );
add_filter( 'edd_metabox_save_edd_cp_min', 'edd_sanitize_amount' );
add_action(
	'edd_save_download',
	function ( $post_id ) {
		if ( empty( $_POST['bonus_item']['product'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			delete_post_meta( $post_id, 'bonus_item' );
		} else {
			$bonus_item = array(
				'condition' => sanitize_text_field( $_POST['bonus_item']['condition'] ), // phpcs:ignore WordPress.Security.NonceVerification
				'price'     => edd_sanitize_amount( $_POST['bonus_item']['price'] ), // phpcs:ignore WordPress.Security.NonceVerification
				'product'   => (int) $_POST['bonus_item']['product'], // phpcs:ignore WordPress.Security.NonceVerification
			);

			update_post_meta( $post_id, 'bonus_item', $bonus_item );
		}
	}
);

/**
 * Check if the download editor has sections, added in EDD 3.3.6.
 *
 * @sinc 1.5.10
 * @return bool
 */
function edd_cp_download_editor_has_sections() {
	return class_exists( 'EDD\\Admin\\Downloads\\Editor\\Section' );
}
