<?php
/**
 * Enqueue admin scripts/styles.
 *
 * @package EDD_Custom_Prices
 * @since 1.5.9
 */

defined( 'ABSPATH' ) || exit;

/**
 * Enqueue admin scripts.
 */
function edd_cp_load_admin_scripts() {
	if ( ! function_exists( 'edd_is_admin_page' ) ) {
		return;
	}
	if ( ! edd_is_admin_page( 'download', 'new' ) && ! edd_is_admin_page( 'download', 'edit' ) ) {
		return;
	}

	wp_enqueue_script( 'edd-cp-admin-scripts', EDD_CUSTOM_PRICES_URL . 'assets/build/js/edd-cp-admin.js', array( 'jquery' ), EDD_CUSTOM_PRICES, true );
	wp_enqueue_style( 'edd-cp-admin', EDD_CUSTOM_PRICES_URL . 'assets/build/css/edd-cp-admin.css', array( 'edd-admin' ), EDD_CUSTOM_PRICES );
}
add_action( 'admin_enqueue_scripts', 'edd_cp_load_admin_scripts' );
