<?php
/**
 * Actions
 *
 * @package EDD_Custom_Prices
 */

defined( 'ABSPATH' ) || exit;

/**
 * Enqueue scripts
 */
function edd_cp_load_scripts() {
	wp_enqueue_script( 'edd-cp-form', EDD_CUSTOM_PRICES_URL . 'assets/build/js/edd-cp-form.js', array( 'jquery' ), EDD_CUSTOM_PRICES, true );
	wp_localize_script(
		'edd-cp-form',
		'edd_cp',
		array(
			'currency'           => edd_currency_filter( '' ),
			'add_to_cart_text'   => edd_get_option( 'add_to_cart_text', __( 'Purchase', 'edd_cp' ) ),
			'ajax_enabled'       => (int) edd_is_ajax_enabled(),
			'currency_position'  => edd_get_option( 'currency_position', 'before' ),
			'min_price_error'    => __( 'Please enter a custom price higher than the minimum amount', 'edd_cp' ),
			'thousandsSeparator' => edd_get_option( 'thousands_separator', ',' ),
			'decimalSeparator'   => edd_get_option( 'decimal_separator', '.' ),
			'currencyDecimals'   => edd_currency_decimal_filter(),
		)
	);
}
add_action( 'wp_enqueue_scripts', 'edd_cp_load_scripts' );

/**
 * Add additional list item if variable pricing is enabled
 *
 * @param int   $key         The price option key.
 * @param array $price       The price option array.
 * @param int   $download_id The download ID.
 */
function edd_cp_after_price_options_list( $key, $price, $download_id ) {
	if ( ! edd_cp_has_custom_pricing( $download_id ) ) {
		return;
	}

	if ( ! edd_single_price_option_mode( $download_id ) ) {
		return;
	}

	$default_price_option = edd_get_default_variable_price( $download_id );
	$button_text          = get_post_meta( $download_id, 'cp_button_text', true );
	$display              = 'none';
	$currency_position    = edd_get_option( 'currency_position', 'before' );
	if ( $key === $default_price_option ) {
		$display = 'block';
	}
	?>

	<div class="edd-cp-price-option-wrapper" style="display: <?php echo esc_attr( $display ); ?>;">
		<label for="edd_cp_price" class="edd-cp-price-label"><?php esc_html_e( 'Name your price', 'edd_cp' ); ?></label>
		<?php
		if ( 'before' === $currency_position ) :
			?>
			<?php echo esc_html( edd_currency_filter( '' ) ); ?> <input type="text" name="edd_cp_price[<?php echo esc_attr( $key ); ?>]" id="edd_cp_price" class="edd_cp_price" value="<?php echo esc_attr( $price['amount'] ); ?>" data-min="" data-default-text="<?php echo esc_attr( $button_text ); ?>" />
		<?php else : ?>
			<input type="text" name="edd_cp_price[<?php echo esc_attr( $key ); ?>]" id="edd_cp_price" class="edd_cp_price" value="<?php echo esc_attr( $price['amount'] ); ?>" data-min="" data-default-text="<?php echo esc_attr( $button_text ); ?>" />
				<?php
				echo esc_html( edd_currency_filter( '' ) );
		endif;
		?>
	</div>
	<?php
}
add_action( 'edd_after_price_option', 'edd_cp_after_price_options_list', 10, 3 );
