<?php
/**
 * Plugin Name: Easy Digital Downloads - Custom Prices
 * Plugin URI: https://easydigitaldownloads.com/downloads/custom-prices/
 * Description: Allow customers to enter a custom price for a product, based on a minimum price set in the admin.
 * Version: 1.5.11
 * Requires PHP: 7.4
 * Requires at least: 5.8
 * Text Domain: edd_cp
 * Author: Easy Digital Downloads
 * Author URI: https://easydigitaldownloads.com
 */

// Plugin version.
if ( ! defined( 'EDD_CUSTOM_PRICES' ) ) {
	define( 'EDD_CUSTOM_PRICES', '1.5.11' );
}

// Plugin Folder URL.
if ( ! defined( 'EDD_CUSTOM_PRICES_URL' ) ) {
	define( 'EDD_CUSTOM_PRICES_URL', plugin_dir_url( __FILE__ ) );
}

// Plugin Folder Path.
if ( ! defined( 'EDD_CUSTOM_PRICES_DIR' ) ) {
	define( 'EDD_CUSTOM_PRICES_DIR', plugin_dir_path( __FILE__ ) );
}

// Plugin Root File.
if ( ! defined( 'EDD_CUSTOM_PRICES_FILE' ) ) {
	define( 'EDD_CUSTOM_PRICES_FILE', __FILE__ );
}

// Plugin name.
if ( ! defined( 'EDD_CUSTOM_PRICES_PLUGIN_NAME' ) ) {
	define( 'EDD_CUSTOM_PRICES_PLUGIN_NAME', 'Custom Prices' );
}

/**
 * Plugin updates/license key
 */
add_action(
	'edd_extension_license_init',
	function ( \EDD\Extensions\ExtensionRegistry $registry ) {
		$registry->addExtension( EDD_CUSTOM_PRICES_FILE, EDD_CUSTOM_PRICES_PLUGIN_NAME, 32001, EDD_CUSTOM_PRICES );
	}
);

/**
 * Internationalization
 *
 * @access      public
 * @since       1.5.5
 * @return      void
 */
function edd_cp_load_textdomain() {
	// Set filter for language directory.
	$lang_dir = dirname( plugin_basename( __FILE__ ) ) . '/languages/';
	$lang_dir = apply_filters( 'edd_cp_language_directory', $lang_dir );

	// Traditional WordPress plugin locale filter.
	$locale = apply_filters( 'plugin_locale', get_locale(), '' );
	$mofile = sprintf( '%1$s-%2$s.mo', 'edd_cp', $locale );

	// Setup paths to current locale file.
	$mofile_local  = $lang_dir . $mofile;
	$mofile_global = WP_LANG_DIR . '/edd-custom-prices/' . $mofile;

	if ( file_exists( $mofile_global ) ) {
		// Look in global /wp-content/languages/edd-custom-prices/ folder.
		load_textdomain( 'edd_cp', $mofile_global );
	} elseif ( file_exists( $mofile_local ) ) {
		// Look in local /wp-content/plugins/edd-custom-prices/ folder.
		load_textdomain( 'edd_cp', $mofile_local );
	} else {
		// Load the default language files.
		load_plugin_textdomain( 'edd_cp', false, $lang_dir );
	}
}

/**
 * Bootstraps the plugin.
 *
 * @since 1.5.9
 */
function edd_cp_bootstrap() {
	$files = array(
		'actions',
		'deprecated',
		'filters',
		'functions',
	);
	foreach ( $files as $file ) {
		require_once EDD_CUSTOM_PRICES_DIR . 'includes/' . $file . '.php';
	}

	$admin_files = array(
		'enqueue',
		'meta',
	);
	foreach ( $admin_files as $file ) {
		require_once EDD_CUSTOM_PRICES_DIR . 'includes/admin/' . $file . '.php';
	}

	add_action( 'init', 'edd_cp_load_textdomain' );
}

require_once __DIR__ . '/vendor/autoload.php';
\EDD\ExtensionUtils\v1\ExtensionLoader::loadOrQuit(
	__FILE__,
	'edd_cp_bootstrap',
	array(
		'php'                    => '7.4',
		'easy-digital-downloads' => '3.2.12',
		'wp'                     => '5.8',
	)
);
