<?php
/**
 * Add scripts and styles
 *
 * @package     EDD\ContentRestriction\Scripts
 * @copyright   Copyright (c) 2013-2014, Pippin Williamson
 * @since       1.0.0
 */


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Enqueue scripts if necessary
 *
 * @since       2.2.0
 * @return      void
 */
function edd_cr_scripts() {
	// Only enqueue if this is the success page
	if ( edd_is_success_page() ) {
		wp_enqueue_style( 'edd-cr', EDD_CONTENT_RESTRICTION_URL . 'assets/css/edd-cr.css' );
	}
}
add_action( 'wp_enqueue_scripts', 'edd_cr_scripts' );


/**
 * Enqueue admin scripts if necessary.
 *
 * @since  1.0.0
 * @param  string $pagenow The current admin page.
 * @return void
 */
function edd_cr_admin_scripts( $pagenow ) {
	$style_dependencies = array();
	if ( wp_style_is( 'edd-admin-downloads', 'registered' ) ) {
		$style_dependencies[] = 'edd-admin-downloads';
	}

	$script_dependencies     = array( 'jquery' );
	$edd_script_dependancies = array( 'jquery-ui-tooltip', 'edd-admin-scripts', 'edd-admin-downloads' );
	foreach ( $edd_script_dependancies as $script ) {
		if ( wp_script_is( $script, 'registered' ) ) {
			$script_dependencies[] = $script;
		}
	}

	wp_enqueue_script( 'edd-cr', EDD_CONTENT_RESTRICTION_URL . 'assets/build/index.js', $script_dependencies, EDD_CONTENT_RESTRICTION_VER, true );
	wp_enqueue_style( 'edd-cr', EDD_CONTENT_RESTRICTION_URL . 'assets/css/admin.css', $style_dependencies, EDD_CONTENT_RESTRICTION_VER );

	wp_localize_script( 'edd-cr', 'edd_cr_admin_vars',
		array(
			'remove_products_before_unchecking_message' => __( 'Disabling restriction will remove all product requirements. This action is not reversible. Click OK to disable restriction. Click Cancel to make no change.', 'edd-cr' )
		)
	);
}
