<?php
/**
 * Redirect Editor.
 *
 * @since 1.2.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$redirect_id = filter_input( INPUT_GET, 'redirect', FILTER_SANITIZE_NUMBER_INT );
$redirect    = $redirect_id ? edd_csr_get_redirect( $redirect_id ) : false;

?>
<form id="edd-edit-redirect" action="" method="post">
	<?php do_action( 'edd_csr_edit_redirect_form_top', $redirect_id, $redirect ); ?>
	<table class="form-table">
		<tbody>
			<tr class="form-field">
				<th scope="row" valign="top">
					<?php // translators: %s is the singular label for the download post type. ?>
					<label for="download"><?php printf( esc_html__( 'Select %s', 'edd-csr' ), edd_get_label_singular() ); ?></label>
				</th>
				<td>
					<?php
					// current download.
					$include = $redirect_id ? absint( get_post_meta( $redirect_id, '_edd_redirect_download', true ) ) : '';

					// remove downloads from dropdown.
					$excluded_products = edd_csr_get_meta_values();
					$excluded_products = array_map( 'absint', array_filter( $excluded_products ) );

					$download_to_remove = array_keys( $excluded_products, $include, true );

					foreach ( $download_to_remove as $download ) {
						unset( $excluded_products[ $download ] );
					}

					echo EDD()->html->product_dropdown(
						array(
							'excluded_products' => $excluded_products,
							'name'              => 'download',
							'id'                => 'download',
							'selected'          => $include,
							'chosen'            => true,
						)
					);
					?>
					<?php // translators: %s is the singular label for the download post type. ?>
					<p class="description"><?php printf( esc_html__( 'Select the %s that will trigger the redirect when it is successfully purchased on its own.', 'edd-csr' ), edd_get_label_singular( true ) ); ?></p>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="edd-page"><?php esc_html_e( 'Redirect Page', 'edd-csr' ); ?></label>
				</th>
				<td>
					<?php
					echo EDD()->html->select(
						array(
							'name'             => 'page',
							'id'               => 'edd-page',
							'selected'         => $redirect_id ? edd_csr_get_redirect_page_id( $redirect_id ) : '',
							'chosen'           => true,
							'options'          => edd_get_pages( true ),
							'placeholder'      => __( 'Select a page', 'easy-digital-downloads' ),
							'show_option_none' => false,
							'show_option_all'  => false,
						)
					);
					?>
					<?php // translators: %s is the singular label for the download post type. ?>
					<p class="description"><?php printf( esc_html__( 'Select the page to redirect to when the %s above has been successfully purchased.', 'edd-csr' ), edd_get_label_singular( true ) ); ?></p>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="edd-status"><?php esc_html_e( 'Status', 'edd-csr' ); ?></label>
				</th>
				<td>
					<div class="edd-form-group edd-toggle">
						<div class="edd-form-group__control">
							<input type="hidden" name="status" value="edd-csr-inactive">
							<?php
							$checked = $redirect ?
								checked( 'edd-csr-active', $redirect->post_status, false ) :
								'';
							?>
							<input type="checkbox" id="edd-status" name="status" value="edd-csr-active"<?php echo $checked; ?>>
							<label for="edd-status"><?php esc_html_e( 'Activate Redirect', 'edd-csr' ); ?></label>
						</div>
					</div>
				</td>
			</tr>

		</tbody>
	</table>

	<?php
	do_action( 'edd_csr_edit_redirect_form_bottom', $redirect_id, $redirect );
	$action = $redirect_id ? 'edit_redirect' : 'add_redirect';
	$label  = $redirect_id ? __( 'Update Redirect', 'edd-csr' ) : __( 'Add Redirect', 'edd-csr' );
	?>

	<p class="submit">
		<input type="hidden" name="edd-action" value="<?php echo esc_attr( $action ); ?>"/>
		<input type="hidden" name="redirect-id" value="<?php echo esc_attr( $redirect_id ); ?>" />
		<input type="hidden" name="edd-redirect-nonce" value="<?php echo esc_attr( wp_create_nonce( 'edd_redirect_nonce' ) ); ?>" />
		<input type="submit" value="<?php echo esc_html( $label ); ?>" class="button button-primary" />
	</p>
</form>
