<?php
/**
 * Post Type Functions
 *
 * @since       1.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Possibly update the post statuses of redirects to be prefixed.
 *
 * This is to avoid conflicts with other plugins that might register a post status with the same name and will allow filtering the post
 * list to work.
 *
 * @since 1.2.0
 */
function edd_csr_maybe_update_redirect_post_statuses() {
	if ( edd_has_upgrade_completed( 'edd_csr_prefix_post_status' ) ) {
		return;
	}

	global $wpdb;

	$result_inactive = $wpdb->query( "UPDATE $wpdb->posts SET post_status = 'edd-csr-inactive' WHERE post_type = 'edd_redirect' AND post_status = 'inactive'" );
	$result_active   = $wpdb->query( "UPDATE $wpdb->posts SET post_status = 'edd-csr-active' WHERE post_type = 'edd_redirect' AND post_status = 'active'" );

	if ( false !== $result_active && false !== $result_inactive ) {
		edd_set_upgrade_complete( 'edd_csr_prefix_post_status' );
	}
}
add_action( 'init', 'edd_csr_maybe_update_redirect_post_statuses', 1 );

/**
 * Registers and sets up the Downloads custom post type
 *
 * @since 1.0
 * @return void
 */
function edd_csr_setup_post_type() {

	// Redirect Post Type.
	$redirect_labels = array(
		'name'               => _x( 'Redirects', 'post type general name', 'edd-csr' ),
		'singular_name'      => _x( 'Redirect', 'post type singular name', 'edd-csr' ),
		'add_new'            => __( 'Add New', 'edd-csr' ),
		'add_new_item'       => __( 'Add New Redirect', 'edd-csr' ),
		'edit_item'          => __( 'Edit Redirect', 'edd-csr' ),
		'new_item'           => __( 'New Redirect', 'edd-csr' ),
		'all_items'          => __( 'All Redirects', 'edd-csr' ),
		'view_item'          => __( 'View Redirect', 'edd-csr' ),
		'search_items'       => __( 'Search Redirects', 'edd-csr' ),
		'not_found'          => __( 'No Redirects found', 'edd-csr' ),
		'not_found_in_trash' => __( 'No Redirects found in Trash', 'edd-csr' ),
		'parent_item_colon'  => '',
		'menu_name'          => __( 'Redirects', 'edd-csr' ),
	);

	$redirect_args = array(
		'labels'          => apply_filters( 'edd_csr_redirect_labels', $redirect_labels ),
		'public'          => false,
		'query_var'       => false,
		'rewrite'         => false,
		'show_ui'         => false,
		'capability_type' => 'manage_shop_settings',
		'map_meta_cap'    => true,
		'supports'        => array( 'title' ),
		'can_export'      => true,
		'show_in_rest'    => false,
	);
	register_post_type( 'edd_redirect', $redirect_args );

	register_post_status(
		'edd-csr-active',
		array(
			'label'                     => _x( 'Active', 'edd-csr' ),
			'public'                    => false,
			'internal'                  => true,
			'protected'                 => true,
			'private'                   => false,
			'exclude_from_search'       => true,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			/* translators: %s: number of active redirects. */
			'label_count'               => _n_noop( 'Active <span class="count">(%s)</span>', 'Active <span class="count">(%s)</span>', 'edd-csr' ),
		)
	);
	register_post_status(
		'edd-csr-inactive',
		array(
			'label'                     => _x( 'Inactive', 'edd-csr' ),
			'public'                    => false,
			'internal'                  => true,
			'protected'                 => true,
			'private'                   => false,
			'exclude_from_search'       => true,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			/* translators: %s: number of inactive redirects. */
			'label_count'               => _n_noop( 'Inactive <span class="count">(%s)</span>', 'Inactive <span class="count">(%s)</span>', 'edd-csr' ),
		)
	);
}
add_action( 'init', 'edd_csr_setup_post_type', 1 );
