<?php
/**
 * Admin Notices
 *
 * @since       1.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Admin Messages
 *
 * @since 1.0
 * @return void
 */
function edd_csr_admin_messages() {

	// If the user can't manage shop settings, bail.
	if ( ! current_user_can( 'manage_shop_settings' ) ) {
		return;
	}

	// Editing & Adding Redirects set `edd-message`.
	$message = isset( $_GET['edd-message'] ) // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		? sanitize_text_field( wp_unslash( $_GET['edd-message'] ) ) // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		: '';

	// If there is no message or action, bail.
	if ( empty( $message ) ) {
		return;
	}

	// Check for a message and add the appropriate notice.
	switch ( $message ) {
		case 'redirect_added':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-added',
				__( 'Redirect added.', 'edd-csr' ),
				'updated'
			);
			break;
		case 'redirect_add_failed':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-add-fail',
				__( 'There was a problem adding your redirect, please try again.', 'edd-csr' ),
				'error'
			);
			break;
		case 'redirect_updated':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-updated',
				__( 'Redirect updated.', 'edd-csr' ),
				'updated'
			);
			break;
		case 'redirect_update_failed':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-updated-fail',
				__( 'There was a problem updating your redirect, please try again.', 'edd-csr' ),
				'error'
			);
			break;
		case 'deactivate_redirect':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-deactivated',
				__( 'Redirect Deactivated', 'edd-csr' ),
				'updated'
			);
			break;
		case 'deactivate_redirect_failed':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-deactivated',
				__( 'There was a problem deactivating your redirect, please try again.', 'edd-csr' ),
				'error'
			);
			break;
		case 'activate_redirect':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-activated',
				__( 'Redirect Activated', 'edd-csr' ),
				'updated'
			);
			break;
		case 'activate_redirect_failed':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-activated',
				__( 'There was a problem activating your redirect, please try again.', 'edd-csr' ),
				'error'
			);
			break;
		case 'delete_redirect':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-deleted',
				__( 'Redirect Deleted', 'edd-csr' ),
				'updated'
			);
			break;
		case 'delete_redirect_failed':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-deleted',
				__( 'There was a problem removing your redirect, please try again.', 'edd-csr' ),
				'error'
			);
			break;
		case 'no_download_selected':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-no-download',
				__( 'Please select a download.', 'edd-csr' ),
				'error'
			);
			break;
		case 'no_page_selected':
			add_settings_error(
				'edd-csr-notices',
				'edd-redirect-no-page',
				__( 'Please select a page.', 'edd-csr' ),
				'error'
			);
			break;
	}

	settings_errors( 'edd-csr-notices' );
}
add_action( 'admin_notices', 'edd_csr_admin_messages' );
