<?php
/**
 * Plugin Name: Easy Digital Downloads - Conditional Success Redirects
 * Plugin URI: https://easydigitaldownloads.com/downloads/conditional-success-redirects/
 * Description: Allows per-product confirmation pages on successful purchases.
 * Version: 1.2.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Easy Digital Downloads
 * Author URI: https://easydigitaldownloads.com/
 * Text Domain: edd-csr
 * Domain Path: languages
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

const EDD_CONDITIONAL_SUCCESS_REDIRECTS_VERSION = '1.2.0';
const EDD_CONDITIONAL_SUCCESS_REDIRECTS_FILE    = __FILE__;

/**
 * The main function responsible for returning the one true EDD_Conditional_Success_Redirects
 * instance to functions everywhere
 *
 * @since       1.1
 * @return      \EDD_Conditional_Success_Redirects The one true EDD_Conditional_Success_Redirects
 */
function edd_csr_redirects() {
	if ( ! class_exists( 'EDD_Conditional_Success_Redirects' ) ) {
		require_once __DIR__ . '/class-edd-conditional-success-redirects.php';
	}

	return EDD_Conditional_Success_Redirects::instance();
}

require_once __DIR__ . '/vendor/autoload.php';
\EDD\ExtensionUtils\v1\ExtensionLoader::loadOrQuit(
	EDD_CONDITIONAL_SUCCESS_REDIRECTS_FILE,
	'edd_csr_redirects',
	array(
		'php'                    => '7.4',
		'easy-digital-downloads' => '3.2.0',
		'wp'                     => '5.8',
	)
);

if ( ! class_exists( 'EDD_Conditional_Success_Redirects_Success_URI' ) ) {
	class EDD_Conditional_Success_Redirects_Success_URI {
		public $uri = '';

		function uri() {
			return $this->uri;
		}
	}
}
