<?php
/**
 * Integration functions to make All Access compatible with the Marketify Theme
 *
 * @package     EDD\EDDAllAccess\Functions
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrates EDD All Access with the Marketify Theme - which acts much like a plugin.
 *
 * @since 1.0.0
 */
class EDD_All_Access_Marketify {

	/**
	 * Get things started
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function __construct() {

		// Check to hook actions until after theme is set up and loaded.
		add_action( 'after_setup_theme', array( $this, 'after_setup_theme' ) );

	}

	/**
	 * Wait until the theme is loaded so we can see if Marketify exists or not.
	 *
	 * @since    1.0.0
	 * @return   void
	 */
	public function after_setup_theme() {

		if ( ! class_exists( 'Marketify' ) ) {
			return;
		}

		add_filter( 'marketify_purchase_button_text', array( $this, 'edd_all_access_marketify_purchase_button_text' ), 10, 2 );

	}

	/**
	 * Marketify completely changes the way that the purchase button is displayed by bringing up a pop-up modal when you click "Purchase".
	 * We need to filter the text on that custom theme button to say "Download" if the user has access through All Access.
	 *
	 * @since    1.0.0
	 * @param    string $button_text The text showing on the button.
	 * @param    int    $download_id The download id in question.
	 * @return   string
	 */
	public function edd_all_access_marketify_purchase_button_text( $button_text, $download_id ) {

		$user_can_download = edd_all_access_check( array( 'download_id' => $download_id ) );

		if ( isset( $user_can_download['success'] ) && $user_can_download['success'] ) {
			$button_text = __( 'Download', 'edd-all-access' );
		}

		return $button_text;

	}

}
