<?php
/**
 * Integration functions to make All Access compatible with the EDD Custom Prices extension
 *
 * @package     EDD\EDDAllAccess\Functions
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrates EDD All Access with the EDD Simple Shipping extension
 *
 * @since 1.0.0
 */
class EDD_All_Access_Custom_Prices {

	/**
	 * Get things started
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function __construct() {

		if ( ! function_exists( 'edd_cp_admin_notice' ) ) {
			return;
		}

		add_action( 'template_redirect', array( $this, 'maybe_remove_custom_prices_output' ) );

	}

	/**
	 * If the customer has all access to the product in question, don't output the custom prices option. They ain't paying anything.
	 *
	 * @since       1.0.0
	 * @return      void
	 */
	public function maybe_remove_custom_prices_output() {

		global $post;

		if ( empty( $post ) ) {
			return;
		}

		$download_id = $post->ID;

		// Check if this product being viewed has variable pricing.
		$has_variable_prices = edd_has_variable_prices( $download_id );

		// Check if any of the variable prices exclude All Access.
		$variable_prices = edd_get_variable_prices( $download_id );

		// If this product has variable pricing and any of those variable prices are not covered by an All Access Pass, return the normal purchase form.
		if ( $has_variable_prices ) {

			// Loop through each price id to check if it is excluded from All Access.
			foreach ( $variable_prices as $variable_price_id => $variable_price_settings ) {

				$check_args = array(
					'download_id' => $download_id,
					'price_id'    => $variable_price_id,
				);

				$all_access_check = edd_all_access_check( $check_args );

				// If the customer does have all access to this download, unhook the custom prices output.
				if ( $all_access_check['success'] ) {
					remove_filter( 'edd_purchase_link_top', 'edd_cp_purchase_link_top' );
					remove_filter( 'edd_after_price_options_list', 'edd_cp_after_price_options_list', 10, 2 );
				}
			}
		} else {

			$check_args = array(
				'download_id' => $download_id,
				'price_id'    => 0,
			);

			$all_access_check = edd_all_access_check( $check_args );

			// If the customer does have all access to this download, unhook the custom prices output.
			if ( $all_access_check['success'] ) {
				remove_filter( 'edd_purchase_link_top', 'edd_cp_purchase_link_top' );
				remove_filter( 'edd_after_price_options_list', 'edd_cp_after_price_options_list', 10, 2 );
			}
		}

	}

}
