<?php
/**
 * Integration functions to make All Access compatible with the EDD Bookings extension
 *
 * @package     EDD\EDDAllAccess\Functions
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrates EDD All Access with the EDD Bookings extension
 *
 * @since 1.0.0
 */
class EDD_All_Access_Bookings {

	/**
	 * Get things started
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function __construct() {

		if ( ! function_exists( 'eddBookings' ) ) {
			return;
		}

		add_filter( 'edd_all_access_allow', array( $this, 'allow_bookings' ), 10, 5 );

	}

	/**
	 * Don't allow All Access to change the download form shown to the user if the post is a Bookings post.
	 * You can't download a booking-enabled post so having "access"to download it doesn't make sense here.
	 *
	 * @since    1.0.0
	 * @param    bool   $allowed Whether to allow All Access to change the download form for this product or not.
	 * @param    string $purchase_form The actual form output which is being filtered.
	 * @param    array  $args The arguments passed to the edd_purchase_download_form filter.
	 * @param    int    $post_id The ID of the product which is being shown.
	 * @param    int    $price_id The variable price ID of the product which is being shown.
	 * @return   bool   $allowed Whether to allow All Access to change the download form for this product or not.
	 */
	public function allow_bookings( $allowed, $purchase_form, $args, $post_id, $price_id ) {

		if ( get_post_meta( $post_id, 'edd_bk_bookings_enabled', true ) ) {
			return false;
		}

		return $allowed;

	}

}
