<?php
/**
 * Core
 *
 * @package     EDD\AllAccess
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.2.8
 */

namespace EDD\AllAccess;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\Subscribers;

/**
 * Core class.
 */
class Core extends Subscribers {

	/**
	 * Get the service providers.
	 *
	 * @since 1.2.8
	 * @return array
	 */
	protected function get_service_providers() {
		return array();
	}

	/**
	 * Get the admin providers.
	 *
	 * @since 1.2.8
	 * @return array
	 */
	protected function get_admin_providers() {
		return array(
			new Admin\Orders\Details\PassDetails(),
		);
	}
}
