<?php
/**
 * Integration functions to make All Access compatible with the EDD Free Downloads extension
 *
 * All Access and Free Downloads work together like this:
 * If the user is logged out and a price is free, they will get the normal "Free Downloads" dialog when trying to download/purchase.
 * If the user is logged in, a price is free, and they DO NOT have All Access permission to download the item,
 * they will get the normal "Free Downloads" dialog when trying to download/purchase.
 * If the user is logged in, a price is free, and they DO have All Access permission to download the item, they will download it using the All Access download URL and it will be logged
 * using the All Access payment as the payment used to download the item. At this time, no special functions are needed to make this work.
 * If you wish to "force" a free download to always use the "Free Downloads" dialog/system, edit the product in question and check the box called "Exclude from All Access?" for that price.
 *
 * @package     EDD\EDDAllAccess\Functions
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrates EDD All Access with the EDD Free Downloads extension
 *
 * @since 1.0.0
 */
class EDD_All_Access_Free_Downloads {

	/**
	 * Get things started
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function __construct() {

		if ( ! class_exists( 'EDD_Free_Downloads' ) ) {
			return;
		}

	}

}
