<?php
/**
 * Integration functions to make All Access compatible with the EDD Auto Register extension
 *
 * @package     EDD\EDDAllAccess\Functions
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integrates EDD All Access with the EDD Auto Register extension
 *
 * @since 1.0.0
 */
class EDD_All_Access_Auto_Register {

	/**
	 * Get things started
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function __construct() {

		if ( ! class_exists( 'EDD_Auto_Register' ) ) {
			return;
		}

		add_filter( 'edd_all_access_bypass_login_requirement', array( $this, 'bypass_login_requirement' ), 10, 3 );

	}

	/**
	 * Since customers will be automatically registered, bypass the login check upon checkout
	 *
	 * @since       1.0.0
	 */
	public function bypass_login_requirement() {

		return true;

	}

}
