<?php

/**
 * Utility functions related to the share counters
 * 
 * @since 8.0
 * @package EasySocialShareButtons
 * @author appscreo
 */

/**
 * Update single post sahre counters
 * 
 * @param string $post_id
 * @return array
 */
function essb_update_single_post_counters($post_id = '')
{
    $result = array();

    if (!empty($post_id)) {
        /**
         * Remove the last expiration time to get the counters fresh
         */

        if (!class_exists('ESSB_Cached_Share_Counters')) {
            include_once(ESSB3_PLUGIN_ROOT . 'lib/classes/share-button/class-cached-share-counters.php');
        }
        ESSB_Cached_Share_Counters::clear_single_post_cache_expire(($post_id));

        $share_data = essb_get_single_post_share_details($post_id);
        $share_data['full_url'] = $share_data['url'];
        $networks = essb_option_value('networks');
        $result = ESSBCachedCounters::get_counters(get_the_ID(), $share_data, $networks);
    }

    return $result();
}
