<?php

abstract class ESSB_Share_Position_Base extends ESSB_Share_Position_Settings
{

    private $admin_ui_tab = '';

    public function set_name_and_id($id = '', $name = '', $type)
    {
        $this->set_id($id);
        $this->set_name($name);
        $this->set_type($type);
    }

    /**
     * Returns the ID of the admin options tab associated with this share position.
     *
     * This method should be implemented by subclasses to provide a unique identifier
     * for the admin options tab related to the share position configuration.
     *
     * @return string The admin options tab ID.
     */
    public function admin_options_tab_id()
    {
        return $this->admin_ui_tab;
    }

    public function admin_options_section_id()
    {
        return 'position_' . $this->get_id();
    }

    public function attach_admin_page($ui_section = '')
    {
        $this->admin_ui_tab = $ui_section;
        ESSBControlCenter::register_sidebar_section_menu($this->admin_ui_tab, $this->admin_options_section_id(), $this->get_name());
        $this->attach_admin_options();
    }

    public function attach_admin_options()
    {

        $this->attach_admin_options_responsive();
        $this->attach_admin_options_custom_code();
        $this->attach_admin_options_networks_styles();
    }

    public function attach_admin_options_responsive()
    {
        if ($this->is_supported('responsive')) {
            $tab_id = $this->admin_options_tab_id();
            $menu_id = $this->admin_options_section_id();
            $location = $this->get_id();

            ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Responsive Appearance', 'essb'), '', 'ti-mobile essb-icon21', array("mode" => "toggle", "state" => "closed", "css_class" => "essb-auto-open"));

            ESSBOptionsStructureHelper::field_switch($tab_id, $menu_id, $location . '_mobile_deactivate', esc_html__('Do not show on mobile', 'essb'), '', '', esc_html__('Yes', 'essb'), esc_html__('No', 'essb'));
            ESSBOptionsStructureHelper::field_switch($tab_id, $menu_id, $location . '_tablet_deactivate', esc_html__('Do not show on tablet', 'essb'), '', '', esc_html__('Yes', 'essb'), esc_html__('No', 'essb'));
            ESSBOptionsStructureHelper::field_switch($tab_id, $menu_id, $location . '_desktop_deactivate', esc_html__('Do not show on desktop', 'essb'), '', '', esc_html__('Yes', 'essb'), esc_html__('No', 'essb'));
            ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
        }
    }

    public function attach_admin_options_custom_code()
    {
        if (essb_options_bool_value('activate_customcode_share_methods')) {
            $tab_id = $this->admin_options_tab_id();
            $menu_id = $this->admin_options_section_id();
            $location = $this->get_id();

            if ($this->is_supported('custom_code')) {
                ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Custom Code for The Display Method'), '', 'essb-icon21 fa fa-terminal', array("mode" => "switch", 'switch_id' => $location . '_code', 'switch_on' => esc_html__('Yes', 'essb'), 'switch_off' => esc_html__('No', 'essb'), 'switch_submit' => 'true'));
                if (essb_option_bool_value($location . '_code')) {
                    ESSBOptionsStructureHelper::hint($tab_id, $menu_id, '', esc_html__('The custom code fields supports HTML, shortcode, custom CSS (wrapped in styles tag). If you wish to write a specific custom CSS code working for this display only, you can use the {instance_class} variable - example: ', 'essb') . '<code>&lt;style type="text/css"&gt;{instance_class} li a { color: red !important; }</style></code>');
                    ESSBOptionsStructureHelper::field_editor($tab_id, $menu_id, $location . '_code_before', esc_html__('Before Display', 'essb'), '', 'htmlmixed');
                    ESSBOptionsStructureHelper::field_editor($tab_id, $menu_id, $location . '_code_after', esc_html__('After Display', 'essb'), '', 'htmlmixed');
                }
                ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
            }

            if ($this->is_supported('custom_css')) {
                ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Custom CSS'), '', 'essb-icon21 fa fa-code', array("mode" => "switch", 'switch_id' => $location . '_css', 'switch_on' => esc_html__('Yes', 'essb'), 'switch_off' => esc_html__('No', 'essb'), 'switch_submit' => 'true'));
                if (essb_option_bool_value($location . '_css')) {
                    ESSBOptionsStructureHelper::hint($tab_id, $menu_id, '', 'Use {selector} to target wrapper element. Examples:
<br/>
<code>{selector} {background-color: red;}</code>
<code>{selector} li a {color: red !important;}</code>');
                    ESSBOptionsStructureHelper::field_editor($tab_id, $menu_id, $location . '_css_code', esc_html__('Add your own custom CSS here', 'essb'), '', 'htmlmixed');
                }
                ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
            }
        }
    }

    public function attach_admin_options_networks_styles()
    {
        if ($this->is_supported('styles') || $this->is_supported('networks')) {
            $tab_id = $this->admin_options_tab_id();
            $menu_id = $this->admin_options_section_id();
            $location = $this->get_id();

            ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Overwrite global share button styles and networks', 'essb'), '', 'essb-icon21 ti-layout-accordion-list', array("mode" => "switch", 'switch_id' => $location . '_activate', 'switch_on' => esc_html__('Yes', 'essb'), 'switch_off' => esc_html__('No', 'essb'), 'switch_submit' => 'true'));

            if (essb_option_bool_value($location . '_activate')) {
                if ($this->is_supported('styles')) {
                    $this->attach_admin_options_position_styles($tab_id, $menu_id, $location);
                }

                if ($this->is_supported('networks') && !essb_option_bool_value('user_fixed_networks')) {
                    $this->attach_admin_options_position_networks($tab_id, $menu_id, $location);
                }
            }

            ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id); // customization
        }
    }

    private function attach_admin_options_position_styles($tab_id, $menu_id, $location)
    {
        ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, 'essb-advanced-location-setup');

        if ($this->is_one_of_style_properties_supported(['template', 'style', 'align', 'size_desktop', 'size_mobile', 'without_space', 'animation'])) {
            essb_heading_with_related_section_open($tab_id, $menu_id, esc_html__('Style', 'essb'), '');

            if ($this->is_style_property_supported('template')) {
                ESSBOptionsStructureHelper::field_template_select($tab_id, $menu_id, $location . '_template', $location, '', esc_html__('Template', 'essb'));
            }

            if ($this->is_style_property_supported('style')) {
                ESSBOptionsStructureHelper::field_buttonstyle_select($tab_id, $menu_id, $location . '_button_style', $location, false, esc_html__('Style', 'essb'));
            }

            if ($this->is_style_property_supported('align')) {
                $select_values = array(
                    '' => array('title' => 'Left', 'content' => '<i class="ti-align-left"></i>'),
                    'center' => array('title' => 'Center', 'content' => '<i class="ti-align-center"></i>'),
                    'right' => array('title' => 'Right', 'content' => '<i class="ti-align-right"></i>'),
                    'stretched' => array('title' => 'Stetched', 'content' => '<i class="ti-layout-slider"></i>')
                );
                ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_button_pos', esc_html__('Align', 'essb'), '', $select_values, '', '', '', 'essb-align-selector control_essb-width-section-' . $location);
            }

            $select_values = array(
                '' => array('title' => 'Default', 'content' => 'Default'),
                'xs' => array('title' => 'Extra Small', 'content' => 'XS'),
                's' => array('title' => 'Small', 'content' => 'S'),
                'm' => array('title' => 'Medium', 'content' => 'M'),
                'l' => array('title' => 'Large', 'content' => 'L'),
                'xl' => array('title' => 'Extra Large', 'content' => 'XL'),
                'xxl' => array('title' => 'Extra Extra Large', 'content' => 'XXL')
            );

            if ($this->is_style_property_supported('size_desktop')) {
                ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_button_size', esc_html__('Size on desktop', 'essb') . essb_generate_desktop_badge(), '', $select_values, '', '', 'button_size');
            }

            if ($this->is_style_property_supported('size_mobile')) {
                ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_button_size_mobile', esc_html__('Size on mobile', 'essb') . essb_generate_mobile_badge(), '', $select_values, '', '', 'button_size_mobile');
            }

            if ($this->is_style_property_supported('without_space')) {
                ESSBOptionsStructureHelper::field_switch($tab_id, $menu_id, $location . '_nospace', esc_html__('Without space between buttons', 'essb'), esc_html__('Activate this option if you wish to connect share buttons without any space between them.', 'essb'), '', esc_html__('Yes', 'essb'), esc_html__('No', 'essb'), '', '');
            }

            if ($this->is_style_property_supported('animation')) {
                ESSBOptionsStructureHelper::field_animation_select($tab_id, $menu_id, $location . '_css_animations', $location, esc_html__('Animate', 'essb'));
            }

            essb_heading_with_related_section_close($tab_id, $menu_id);
        }

        if (!essb_options_bool_value('deactivate_share_counters') && $this->is_style_property_supported('counters')) {
            essb_heading_with_related_section_open($tab_id, $menu_id, esc_html__('Counters', 'essb'), '');

            ESSBOptionsStructureHelper::field_switch($tab_id, $menu_id, $location . '_show_counter', esc_html__('Display counter of sharing', 'essb'), esc_html__('Activate display of share counters.', 'essb'), '', esc_html__('Yes', 'essb'), esc_html__('No', 'essb'), '', '');
            //essb5_main_singlecounter_selection
            ESSBOptionsStructureHelper::field_counterposition_select($tab_id, $menu_id, $location . '_counter_pos', $location, esc_html__('Single button share counter position', 'essb'));

            ESSBOptionsStructureHelper::field_totalcounterposition_select($tab_id, $menu_id, $location . '_total_counter_pos', $location, esc_html__('Total share counter position', 'essb'));
            essb_heading_with_related_section_close($tab_id, $menu_id);
        }

        if ($this->is_style_property_supported('width')) {
            essb_heading_with_related_section_open($tab_id, $menu_id, esc_html__('Width', 'essb'), '');

            $select_values = array(
                '' => array('title' => 'Automatic Width', 'content' => 'AUTO', 'isText' => true),
                'fixed' => array('title' => 'Fixed Width', 'content' => 'Fixed', 'isText' => true),
                'full' => array('title' => 'Full Width', 'content' => 'Full', 'isText' => true),
                'flex' => array('title' => 'Fluid', 'content' => 'Fluid', 'isText' => true),
                'column' => array('title' => 'Columns', 'content' => 'Columns', 'isText' => true),
            );
            ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_button_width', esc_html__('Button width', 'essb'), '', $select_values);


            ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, $location . '-essb-fixed-width essb-hidden-open', $location . '-essb-fixed-width');
            ESSBOptionsStructureHelper::title($tab_id, $menu_id, esc_html__('Customize fixed width display', 'essb'), esc_html__('In fixed width mode buttons will have exactly same width defined by you no matter of device or screen resolution (not responsive).', 'essb'), 'inner-row');
            ESSBOptionsStructureHelper::field_section_start_panels($tab_id, $menu_id, '', esc_html__('Customize the fixed width options', 'essb'));
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fixed_width_value', esc_html__('Custom buttons width', 'essb'), esc_html__('Provide custom width of button in pixels without the px symbol.', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_select_panel($tab_id, $menu_id, $location . '_fixed_width_align', esc_html__('Choose alignment of network name', 'essb'), esc_html__('Provide different alignment of network name, when fixed button width is activated. When counter position is Inside or Inside name, that alignment will be applied for the counter. Default value is center.', 'essb'), array("" => "Center", "left" => "Left", "right" => "Right"));
            ESSBOptionsStructureHelper::field_section_end_panels($tab_id, $menu_id);
            ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);

            ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, $location . '-essb-full-width essb-hidden-open', $location . '-essb-full-width');
            ESSBOptionsStructureHelper::title($tab_id, $menu_id, esc_html__('Customize full width display', 'essb'), esc_html__('In full width mode buttons will distribute over the entire screen width on each device (responsive).', 'essb'), 'inner-row');
            ESSBOptionsStructureHelper::field_select_panel($tab_id, $menu_id, $location . '_fullwidth_align', esc_html__('Choose alignment of network name', 'essb'), esc_html__('Provide different alignment of network name (counter when position inside or inside name). Default value is left.', 'essb'), array("left" => "Left", "center" => "Center", "right" => "Right"));
            ESSBOptionsStructureHelper::field_section_start_panels($tab_id, $menu_id, esc_html__('Customize width of first two buttons', 'essb'), esc_html__('Provide different width for the first two buttons in the row. The width should be entered as number in percents (without the % mark). You can fill only one of the values or both values.', 'essb'), '', 'true');
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fullwidth_first_button', esc_html__('Width of first button', 'essb'), esc_html__('Provide custom width of first button when full width is active. This value is number in percents without the % symbol.', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fullwidth_second_button', esc_html__('Width of second button', 'essb'), esc_html__('Provide custom width of second button when full width is active. This value is number in percents without the % symbol.', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_section_end_panels($tab_id, $menu_id);

            ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Fix button apperance', 'essb'), esc_html__('Full width share buttons uses formula to calculate the best width of buttons. In some cases based on other site styles you may need to personalize some of the values in here', 'essb'), '', array("mode" => "toggle", 'state' => 'closed'));
            ESSBOptionsStructureHelper::field_section_start_panels($tab_id, $menu_id, '', esc_html__('Full width option will make buttons to take the width of your post content area.', 'essb'));
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fullwidth_share_buttons_correction', esc_html__('Max width of button on desktop', 'essb'), esc_html__('Provide custom width of single button when full width is active. This value is number in percents without the % symbol.', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fullwidth_share_buttons_correction_mobile', esc_html__('Max width of button on mobile', 'essb'), esc_html__('Provide custom width of single button when full width is active. This value is number in percents without the % symbol.', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_fullwidth_share_buttons_container', esc_html__('Max width of buttons container element', 'essb'), esc_html__('If you wish to display total counter along with full width share buttons please provide custom max width of buttons container in percent without % (example: 90). Leave this field blank for default value of 100 (100%).', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_section_end_panels($tab_id, $menu_id);
            ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
            ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);

            ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, $location . '-essb-column-width essb-hidden-open', $location . '-essb-column-width');
            ESSBOptionsStructureHelper::title($tab_id, $menu_id, esc_html__('Customize column display', 'essb'), esc_html__('In column mode buttons will distribute over the entire screen width on each device in the number of columns you setup (responsive).', 'essb'), 'inner-row');
            ESSBOptionsStructureHelper::field_section_start_panels($tab_id, $menu_id, '', '');
            $listOfOptions = array("1" => "1", "2" => "2", "3" => "3", "4" => "4", "5" => "5", "6" => "6", "7" => "7", "8" => "8", "9" => "9", "10" => "10");
            ESSBOptionsStructureHelper::field_select_panel($tab_id, $menu_id, $location . '_fullwidth_share_buttons_columns', esc_html__('Number of columns', 'essb'), esc_html__('Choose the number of columns that buttons will be displayed.', 'essb'), $listOfOptions);
            ESSBOptionsStructureHelper::field_select_panel($tab_id, $menu_id, $location . '_fullwidth_share_buttons_columns_align', esc_html__('Choose alignment of network name', 'essb'), esc_html__('Provide different alignment of network name (counter when position inside or inside name). Default value is left.', 'essb'), array("" => "Left", "center" => "Center", "right" => "Right"));
            ESSBOptionsStructureHelper::field_section_end_panels($tab_id, $menu_id);
            ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);

            ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, $location . '-essb-flex-width essb-hidden-open', $location . '-essb-flex-width');
            ESSBOptionsStructureHelper::title($tab_id, $menu_id, esc_html__('Customize Flex Buttons', 'essb'), esc_html__('In flexible width mode buttons will always take the full width of content area. You can customize the alignment or preserve space for the total area.', 'essb'), 'inner-row');
            ESSBOptionsStructureHelper::field_section_start_panels($tab_id, $menu_id, '', esc_html__('Customize the flex width options', 'essb'));
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_flex_width_value', esc_html__('Preserve Space For Total Counter (%)', 'essb'), esc_html__('Use this field to setup custom width for the total counter area (numeric value only as a percent)', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_textbox_panel($tab_id, $menu_id, $location . '_flex_button_value', esc_html__('Assign a Specific Button Width (%)', 'essb'), esc_html__('Use this field to setup custom width for single button (numeric value only as a percent)', 'essb'), '', 'input60', 'fa-arrows-h', 'right');
            ESSBOptionsStructureHelper::field_select_panel($tab_id, $menu_id, $location . '_flex_width_align', esc_html__('Choose alignment of network name', 'essb'), esc_html__('Provide different alignment of network name, when this button width is activated. When counter position is Inside or Inside name, that alignment will be applied for the counter. Default value is center.', 'essb'), array("" => "Left", "center" => "Center", "right" => "Right"));
            ESSBOptionsStructureHelper::field_section_end_panels($tab_id, $menu_id);
            ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);

            essb_heading_with_related_section_close($tab_id, $menu_id);
        }

        ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);
    }

    private function attach_admin_options_position_networks($tab_id, $menu_id, $location)
    {
        ESSBOptionsStructureHelper::field_heading($tab_id, $menu_id, 'heading7', esc_html__('Personalize Social Networks', 'essb'), '', 'mt40 pb0', '<i class="ti-share"></i>');
        ESSBOptionsStructureHelper::holder_start($tab_id, $menu_id, 'essb-related-heading7', '');


        ESSBOptionsStructureHelper::title($tab_id, $menu_id, esc_html__('Personalize Displayed Social Networks', 'essb'), esc_html__('Choose a personalized list of social networks that will run for this display only (different than global set). Leave blank to use the global set list of social networks', 'essb'));
        ESSBOptionsStructureHelper::field_network_select($tab_id, $menu_id, $location . '_networks', $location);


        if (essb_is_active_social_network('more') && !essb_options_bool_value('more_button_global_settings')) {
            ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('More Button', 'essb'), '', 'fa21 essb_icon_more', array("mode" => "toggle", "state" => "closed", "css_class" => "essb-auto-open"));
            $more_options = array("1" => "Display all active networks after more button", "2" => "Display all social networks as pop up", "3" => "Display only active social networks as pop up", "4" => "Display all active networks after more button in popup");
            ESSBOptionsStructureHelper::field_select($tab_id, $menu_id, $location . '_more_button_func', esc_html__('More button', 'essb'), esc_html__('Select networks that you wish to appear in your list. With drag and drop you can rearrange them.', 'essb'), essb_available_more_button_commands());
            $more_options = array("plus" => "Plus icon", "dots" => "Dots icon");

            $select_values = array(
                'plus' => array('title' => 'Plus Icon', 'content' => '<i class="essb_icon_more"></i>'),
                'dots' => array('title' => 'Dots Icon', 'content' => '<i class="essb_icon_more_dots"></i>')
            );
            ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_more_button_icon', esc_html__('More button icon', 'essb'), esc_html__('Select more button icon style. You can choose from default + symbol or dots symbol', 'essb'), $select_values);
            ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
        }

        if (essb_is_active_social_network('share') && !essb_option_bool_value('share_button_global_settings')) {
            ESSBOptionsStructureHelper::panel_start($tab_id, $menu_id, esc_html__('Share Button', 'essb'), '', 'fa21 essb_icon_share', array("mode" => "toggle", "state" => "closed", "css_class" => "essb-auto-open"));
            $more_options = array("1" => "Display all active networks after more button", "2" => "Display all social networks as pop up", "3" => "Display only active social networks as pop up", "4" => "Display all active networks after more button in popup");
            ESSBOptionsStructureHelper::field_select($tab_id, $menu_id, $location . '_share_button_func', esc_html__('Share button function', 'essb'), esc_html__('Select networks that you wish to appear in your list. With drag and drop you can rearrange them.', 'essb'), essb_available_more_button_commands());


            $select_values = array(
                'plus' => array('title' => '', 'content' => '<i class="essb_icon_more"></i>'),
                'dots' => array('title' => '', 'content' => '<i class="essb_icon_more_dots"></i>'),
                'share' => array('title' => '', 'content' => '<i class="essb_icon_share"></i>'),
                'share-alt-square' => array('title' => '', 'content' => '<i class="essb_icon_share-alt-square"></i>'),
                'share-alt' => array('title' => '', 'content' => '<i class="essb_icon_share-alt"></i>'),
                'share-tiny' => array('title' => '', 'content' => '<i class="essb_icon_share-tiny"></i>'),
                'share-outline' => array('title' => '', 'content' => '<i class="essb_icon_share-outline"></i>')
            );
            ESSBOptionsStructureHelper::field_toggle($tab_id, $menu_id, $location . '_share_button_icon', esc_html__('Share button icon', 'essb'), esc_html__('Choose the share button icon you will use (default is share if nothing is selected)', 'essb'), $select_values);


            $more_options = array("" => "Default from settings (like other share buttons)", "icon" => "Icon only", "button" => "Button", "text" => "Text only");
            ESSBOptionsStructureHelper::field_select($tab_id, $menu_id, $location . '_share_button_style', esc_html__('Share button style', 'essb'), esc_html__('Select more button icon style. You can choose from default + symbol or dots symbol', 'essb'), $more_options);

            $share_counter_pos = array("hidden" => "No counter", "inside" => "Inside button without text", "insidename" => "Inside button after text", "insidebeforename" => "Inside button before text", "topn" => "Top", "bottom" => "Bottom");
            ESSBOptionsStructureHelper::field_select($tab_id, $menu_id, $location . '_share_button_counter', esc_html__('Display total counter with the following position', 'essb'), esc_html__('Choose where you wish to display total counter of shares assigned with this button. <br/> To view total counter you need to have share counters active and they should not be running in real time mode. Also you need to have your share button set with style button. When you use share button with counter we highly recommend to hide total counter by setting position to be hidden - this will avoid having two set of total value on screen.', 'essb'), $share_counter_pos);

            ESSBOptionsStructureHelper::panel_end($tab_id, $menu_id);
        }


        ESSBOptionsStructureHelper::holder_end($tab_id, $menu_id);
    }
}
