<?php

if (!function_exists('essb_admin_ajax_helper_post_actions')) {
    function essb_admin_ajax_helper_post_actions()
    {
        if (! isset($_REQUEST['essb_admin_post_action_token']) || !wp_verify_nonce($_REQUEST['essb_admin_post_action_token'], 'essb_admin_post_action')) {
            print 'Sorry, your nonce did not verify.';
            wp_die();
        }

        $status = array('code' => 0);

        if (isset($_REQUEST['cmd']) && $_REQUEST['cmd'] == 'clear_short') {
            $post_id = isset($_POST['post_id']) ? $_POST['post_id'] : '';

            if (!empty($post_id) && class_exists('ESSB_Short_URL')) {
                ESSB_Short_URL::clear_post_cached_urls($post_id);
                $status['code'] = 200;
            }
        }

        if (isset($_REQUEST['cmd']) && $_REQUEST['cmd'] == 'clear_share_counters') {
            $post_id = isset($_POST['post_id']) ? $_POST['post_id'] : '';

            if (!empty($post_id)) {
                if (!class_exists('ESSB_Cached_Share_Counters')) {
                    include_once(ESSB3_PLUGIN_ROOT . 'lib/classes/share-button/class-cached-share-counters.php');
                }
                ESSB_Cached_Share_Counters::clear_single_post_cache_expire($post_id);
                ESSB_Cached_Share_Counters::clear_single_post_share_counters($post_id);
                $status['code'] = 200;
            }
        }

        wp_send_json($status);
        die();
    }
}
