<?php

/**
 * Generate the plugin default settings that will be loaded. The function is used when
 * plugin is activated for the very first time or each time the reset settings buttons is
 * clicked
 *
 * @since 5.9.3
 * @updated 8.5
 * @updated 9.3 Switched X style to be the default Twitter selection
 * @package EasySocialShareButtons
 * @author appscreo
 */

if (!function_exists('essb_generate_default_settings')) {
	function essb_generate_default_settings() {
		$options = '{"afterclose_type":"follow","afterclose_like_cols":"onecol","aftershare_optin_design":"design1","networks":["facebook","twitter","pinterest","linkedin"],"more_button_func":"1","share_button_func":"1","share_button_counter":"hidden","twitter_message_optimize_method":"1","subscribe_function":"form","subscribe_optin_design":"design1","subscribe_optin_design_popup":"design1","mail_function":"form","mail_function_security":"level1","flattr_lang":"sq_AL","style":"59","button_style":"button","counter_pos":"hidden","total_counter_pos":"hidden","fullwidth_align":"left","fullwidth_share_buttons_columns":"1","counter_mode":"360","counter_recover_mode":"unchanged","counter_recover_protocol":"unchanged","counter_recover_prefixdomain":"unchanged","twitter_counters":"self","force_counters_admin_type":"wp","esml_history":"1","esml_access":"manage_options","ga_tracking_mode":"simple","pinterest_template":"32","pinterest_button_style":"button","pinterest_position":"top-left","pinsc_template":"32","pinsc_button_style":"button","pinsc_position":"top-left","opengraph_tags":"true","sso_imagesize":"true","twitter_card_type":"summary","twitter_shareshort":"true","shorturl_type":"wp","shorturl_bitlyapi_version":"previous","affwp_active_mode":"id","user_network_name_facebook":"Facebook","user_network_name_twitter":"Twitter","user_network_name_google":"Google+","user_network_name_pinterest":"Pinterest","user_network_name_linkedin":"LinkedIn","topbar_contentarea_pos":"left","bottombar_contentarea_pos":"left","flyin_position":"right","sis_network_order":["facebook","twitter","google","linkedin","pinterest","tumblr","reddit","digg","delicious","vkontakte","odnoklassniki"],"sis_position":"top-left","sis_style":"tiny","sis_orientation":"horizontal","heroshare_second_type":"top","postbar_button_style":"recommended","postbar_counter_pos":"hidden","point_position":"bottomright","point_open_auto":"no","point_style":"simple","point_shape":"round","point_button_style":"recommended","point_template":"6","point_counter_pos":"inside","mobile_sharebuttonsbar_count":"1","sharebar_counter_pos":"inside","sharebar_total_counter_pos":"before","sharepoint_counter_pos":"inside","sharepoint_total_counter_pos":"before","display_in_types":["post"],"display_excerpt_pos":"top","content_position":"content_both","subscribe_connector":"mailchimp","subscribe_css_always":"true","use_minified_css":"true","use_minified_js":"true","apply_clean_buttons_method":"default","essb_access":"manage_options","turnoff_essb_advanced_box":"true","essb_advanced_token":"680830d28d","_wp_http_referer":"\/work\/essb4\/wp-admin\/admin-ajax.php?settings=features&action=essb_advanced_options&cmd=get&essb_advancedoptions_token=f05b1094c8","deactivate_module_customshare":"true","deactivate_module_translate":"true","deactivate_module_conversions":"true","deactivate_settings_post_type":"true","deactivate_module_natives":"true","deactivate_module_facebookchat":"true","deactivate_module_skypechat":"true","deactivate_module_clicktochat":"true","deactivate_module_aftershare":"true","deactivate_module_message":"true","deactivate_module_metrics":"true","deactivate_module_affiliate":"true","deactivate_module_instagram":"true","deactivate_module_proofnotifications":"true","deactivate_ctt":"true","deactivate_module_shorturl":"true","mail_subject":"Visit this site %%siteurl%%","mail_body":"Hi, this may be interesting you: %%title%%! This is the link: %%permalink%%","force_archive_pages":"true","deactivate_shorturl_preview":"true","float_onsingle_only":"true","use_rel_noopener":"true","limit_editor_fields_access":"manage_options","deactivate_fakecounters":"true","afterclose_active":"false","affs_active":"false","affs_active_shortcode":"false","affwp_active":"false","affwp_active_shortcode":"false","mycred_activate":"false","mycred_activate_custom":"false","mycred_referral_activate":"false","mycred_referral_activate_shortcode":"false","customshare":"false","activate_fake_counters":"false","activate_fake_counters_internal":"false","deactivate_expertcounters":"true","deactivate_stylelibrary":"true","deactivate_method_topbar":"true","deactivate_method_bottombar":"true","deactivate_method_flyin":"true","deactivate_method_heroshare":"true","deactivate_method_postbar":"true","deactivate_method_point":"true","deactivate_method_image":"true","deactivate_method_native":"true","deactivate_method_followme":"true","deactivate_method_corner":"true","deactivate_method_booster":"true","deactivate_method_sharebutton":"true","deactivate_method_except":"true","deactivate_method_widget":"true","deactivate_method_advanced_mobile":"true","deactivate_method_integrations":"true","deactivate_module_google_analytics":"true","share_twitter_icon_type":"x","follow_twitter_icon_type":"x","profile_networks_order":["facebook|Facebook","twitter|Twitter","pinterest|Pinterest","linkedin|LinkedIn","github|GitHub","vimeo|Vimeo","dribbble|Dribbble","envato|Envato","soundcloud|SoundCloud","behance|Behance","foursquare|Foursquare","mailchimp|MailChimp","delicious|Delicious","instgram|Instagram","youtube|YouTube","vk|VK","rss|RSS","tumblr|Tumblr","slideshare|SlideShare","500px|500px","flickr|Flickr","wp_posts|WordPress Posts","wp_comments|WordPress Comments","wp_users|WordPress Users","steamcommunity|Steam","weheartit|WeHeartit","feedly|Feedly","love|Love Counter","mailpoet|MailPoet","mymail|myMail \/ Mailster","spotify|Spotify","twitch|Twitch","mailerlite|MailerLite","itunes|iTunes","deviantart|Deviantart","paypal|PayPal","whatsapp|WhatsApp","tripadvisor|Tripadvisor","snapchat|Snapchat","telegram|Telegram","xing|Xing","medium|Medium","tiktok|TikTok","mixer|Mixer","patreon|Patreon","ok|Odnoklassniki","subscribe_form|Subscribe Form","periscope|Periscope"],"profiles_twitter_icon_type":"x","profile_subscribe_form":"design1","profiles_display_position":"left","profiles_template":"color","profiles_post_align":"left","profiles_post_content_pos":"above","profiles_post_template":"color","deactivate_module_followers":"true","deactivate_module_subscribe":"true","deactivate_module_analytics":"true","deactivate_method_float":"true","deactivate_method_postfloat":"true","deactivate_method_popup":"true","pinpro_followbox_display":"any","pinpro_followbox_header_overlay":"light"}';

		$options = htmlspecialchars_decode ( $options );
		$options = stripslashes ( $options );

		return json_decode ( $options, true );
	}
}
