<?php

/**
 * Import/Export Plugin Setting
 *
 * @package EasySocialShareButtons
 * @since 1.0
 */

if (class_exists('ESSBControlCenter')) {
	ESSBControlCenter::register_sidebar_section_menu('import', 'backup', esc_html__('Export Settings', 'essb'));
	ESSBControlCenter::register_sidebar_section_menu('import', 'backupimport', esc_html__('Import Settings', 'essb'));
	//ESSBControlCenter::register_sidebar_section_menu('import', 'backup2', esc_html__('Export Followers Settings', 'essb'));
	//ESSBControlCenter::register_sidebar_section_menu('import', 'backupimport2', esc_html__('Import Followers Settings', 'essb'));

	if (!essb_option_bool_value('deactivate_module_followers')) {
		ESSBControlCenter::register_sidebar_section_menu('import', 'followers', esc_html__('Followers Counter', 'essb'));
	}

	if (!essb_options_bool_value('deactivate_custompositions')) {
		ESSBControlCenter::register_sidebar_section_menu('import', 'positions', esc_html__('Custom Positions', 'essb'));
	}
	ESSBControlCenter::register_sidebar_section_menu('import', 'reset', esc_html__('Reset Settings & Data', 'essb'));
	ESSBControlCenter::register_sidebar_section_menu('import', 'migrate', esc_html__('Migrate & Update', 'essb'));
}

ESSBOptionsStructureHelper::menu_item('import', 'backup', esc_html__('Export Settings', 'essb'), 'download');
ESSBOptionsStructureHelper::menu_item('import', 'backupimport', esc_html__('Import Settings', 'essb'), 'upload');
ESSBOptionsStructureHelper::menu_item('import', 'reset', esc_html__('Reset Settings & Data', 'essb'), 'upload');

ESSBOptionsStructureHelper::menu_item('import', 'backup2', esc_html__('Export Followers Settings', 'essb'), 'database');
ESSBOptionsStructureHelper::menu_item('import', 'backupimport2', esc_html__('Import Followers Settings', 'essb'), 'database');

ESSBOptionsStructureHelper::help('import', 'import', '', '', array('Help With Settings' => 'https://docs.socialsharingplugin.com/knowledgebase/import-export-plugin-settings-reset-plugin-settings-or-data/'));
ESSBOptionsStructureHelper::field_heading('import', 'import', 'heading5', esc_html__('Export Plugin Settings', 'essb'));
ESSBOptionsStructureHelper::help('import', 'backup', '', '', array('Help With Settings' => 'https://docs.socialsharingplugin.com/knowledgebase/import-export-plugin-settings-reset-plugin-settings-or-data/'));
ESSBOptionsStructureHelper::field_func('import', 'backup', 'essb3_text_backup', esc_html__('Export plugin settings', 'essb'), '');
ESSBOptionsStructureHelper::field_func('import', 'backup', 'essb3_text_backup1', esc_html__('Save plugin settings to file', 'essb'), '');
ESSBOptionsStructureHelper::field_heading('import', 'backupimport', 'heading5', esc_html__('Import Plugin Settings', 'essb'));
ESSBOptionsStructureHelper::field_func('import', 'backupimport', 'essb3_text_backup_import', esc_html__('Import plugin settings', 'essb'), '');
ESSBOptionsStructureHelper::field_func('import', 'backupimport', 'essb3_text_backup_import1', esc_html__('Import plugin settings from file', 'essb'), '');

ESSBOptionsStructureHelper::field_heading('import', 'backup2', 'heading5', esc_html__('Export Followers Counter Settings', 'essb'));
ESSBOptionsStructureHelper::field_func('import', 'backup2', 'essb3_text_backup2', esc_html__('Export Followers Counter Settings', 'essb'), '');
ESSBOptionsStructureHelper::field_heading('import', 'backupimport2', 'heading5', esc_html__('Import Followers Counter Settings', 'essb'));
ESSBOptionsStructureHelper::field_func('import', 'backupimport2', 'essb3_text_backup_import2', esc_html__('Import Followers Counter Settings', 'essb'), '');

ESSBOptionsStructureHelper::help('import', 'reset', '', '', array('Help With Settings' => 'https://docs.socialsharingplugin.com/knowledgebase/import-export-plugin-settings-reset-plugin-settings-or-data/#Reset_Settings_&_Data'));
ESSBOptionsStructureHelper::field_component('import', 'reset', 'essb5_reset_settings_actions');

ESSBOptionsStructureHelper::field_component('import', 'migrate', 'essb_admin_migrate_data_actions');

ESSBOptionsStructureHelper::field_component('import', 'positions', 'essb_admin_positions_export_import');
ESSBOptionsStructureHelper::field_component('import', 'followers', 'essb_admin_followers_export_import');

function essb3_text_backup()
{
	global $essb_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_options);
	}

?>

	<textarea id="essb_options_configuration" name="essb_backup[configuration]" class="input-element stretched" rows="15"><?php echo $backup_string; ?></textarea>
	<a href="<?php echo $goback; ?>" class="essb-ui-btn essb-ui-btn-primary">Export Settings</a>

<?php
}

function essb3_text_backup2()
{
	global $essb_socialfans_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import&section=backup2'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	if (!$essb_socialfans_options) {
		$essb_socialfans_options = get_option(ESSB3_OPTIONS_NAME_FANSCOUNTER);
	}

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_socialfans_options);
	}
?>

	<textarea id="essb_options_configuration" name="essb_backup[configuration]" class="input-element stretched" rows="15"><?php echo $backup_string; ?></textarea>
	<a href="<?php echo $goback; ?>" class="essb-ui-btn essb-ui-btn-primary">Export Settings</a>

<?php
}


function essb3_text_backup_import()
{
	global $essb_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_options);
	}
?>

	<textarea id="essb_options_configuration1" name="essb_backup[configuration1]" class="input-element stretched" rows="15"></textarea>
	<input type="Submit" name="Submit" value="Import Settings" class="essb-ui-btn essb-ui-btn-primary">
<?php
}

function essb3_text_backup_import2()
{
	global $essb_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_options);
	}
?>

	<textarea id="essb_options_configuration1" name="essb_backup2[configuration1]" class="input-element stretched" rows="15"></textarea>
	<input type="Submit" name="Submit" value="Import Settings" class="essb-btn essb-btn-blue">
<?php
}


function essb3_text_backup_import1()
{
	global $essb_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_options);
	}
?>

	<input type="file" name="essb_backup_file" class="essb-btn essb-btn-light" />
	<input type="Submit" name="Submit" value="Import Settings From File" class="essb-ui-btn essb-ui-btn-warning">
<?php
}


function essb3_text_backup1()
{
	global $essb_options;
	$goback = esc_url_raw(add_query_arg(array('backup' => 'true'), 'admin.php?page=essb_redirect_import&tab=import'));
	$is_backup = isset($_REQUEST['backup']) ? $_REQUEST['backup'] : '';

	$backup_string = '';
	if ($is_backup == 'true') {
		$backup_string = json_encode($essb_options);
	}
	$download_settings = "admin-ajax.php?action=essb_settings_save";
?>

	<a href="<?php echo esc_url_raw($download_settings); ?>" class="essb-ui-btn essb-ui-btn-warning">Save Plugin Settings To File</a>&nbsp;
<?php
}

function essb_admin_migrate_data_actions()
{

	essb_admin_options_generate_migrate_block(
		esc_html__('Short URL Cache', 'essb'),
		esc_html__('Clear all cached short URLs generated and used by the plugin.', 'essb'),
		'short_url',
		'shorturl',
		esc_html__('Short URL Cache', 'essb'),
		esc_html__('Clear Old Data', 'essb'),
		'shorturl',
		esc_html__('Migrate', 'essb')
	);
}

function essb_admin_options_generate_migrate_block($title = '', $desc = '', $icon = '', $clear_command = '', $clear_title = '', $clear_text = '', $migate_command = '', $migrate_text = '', $link_url = '', $link_text = '')
{
?>
	<div class="essb-ui-card essb-ui-mb3 essb-reset-feature essb-reset-feature-<?php echo $clear_command; ?>">
		<div class="essb-ui-card-content">

			<div class="essb-ui-flex essb-ui-flex100 essb-ui-align-center essb-ui-justify-between essb-ui-gap-4">

				<div class="essb-ui-flex essb-ui-align-center essb-ui-gap-4">

					<div class="essb-ui-icon-frame64">
						<svg class="essb-ui-svg-frame essb-ui-svg-frame-info" fill="none" height="48" viewBox="0 0 44 48" width="44" xmlns="http://www.w3.org/2000/svg">
							<path d="M16 2.4641C19.7128 0.320509 24.2872 0.320508 28 2.4641L37.6506 8.0359C41.3634 10.1795 43.6506 14.141 43.6506 
			18.4282V29.5718C43.6506 33.859 41.3634 37.8205 37.6506 39.9641L28 45.5359C24.2872 47.6795 19.7128 47.6795 16 45.5359L6.34937 
			39.9641C2.63655 37.8205 0.349365 33.859 0.349365 29.5718V18.4282C0.349365 14.141 2.63655 10.1795 6.34937 8.0359L16 2.4641Z" fill="">
							</path>
							<path d="M16.25 2.89711C19.8081 0.842838 24.1919 0.842837 27.75 2.89711L37.4006 8.46891C40.9587 10.5232 43.1506 14.3196 43.1506 
			18.4282V29.5718C43.1506 33.6804 40.9587 37.4768 37.4006 39.5311L27.75 45.1029C24.1919 47.1572 19.8081 47.1572 16.25 45.1029L6.59937 
			39.5311C3.04125 37.4768 0.849365 33.6803 0.849365 29.5718V18.4282C0.849365 14.3196 3.04125 10.5232 6.59937 8.46891L16.25 2.89711Z" stroke="">
							</path>
						</svg>
						<i class="essb-ui-svg-icon essb-ui-svg-info-icon">
							<?php echo essb_ui_get_svg_icon($icon); ?>
						</i>
					</div>

					<div class="essb-ui-flex essb-ui-flex-col essb-ui-gap-1.5">
						<div class="essb-ui-font-semibold essb-ui-line-height-sm essb-ui-text-lg essb-ui-flex essb-ui-align-center essb-ui-gap-1.5"><?php echo $title; ?></div>
						<div class="essb-ui-line-height-base"><?php echo $desc; ?></div>
						<?php
						if (!empty($link_url)) {
							echo '<div class="essb-ui-line-height-base"><a class="essb-ui-btn essb-ui-btn-link" href="' . esc_url($link_url) . '" target="_blank">' . $link_text . '</a></div>';
						}
						?>
					</div>
				</div>

				<div class="essb-ui-flex essb-ui-align-center essb-ui-gap-2.5">
					<?php if ($migate_command != '') { ?>
						<a class="essb-ui-btn essb-ui-btn-info essb-ui-btn-sm1 essb-migrate-settings essb-ui-text-upper" href="#" data-migrate="<?php echo esc_attr($migate_command); ?>" data-title="<?php echo esc_attr($clear_title); ?>"><?php echo $migrate_text; ?></a>
					<?php } ?>
					<?php if ($clear_command != '') { ?>
						<a class="essb-ui-btn essb-ui-btn-danger essb-ui-btn-sm1 essb-migrate-settings essb-ui-text-upper" href="#" data-migrate-clea="<?php echo esc_attr($clear_command); ?>" data-title="<?php echo esc_attr($clear_title); ?>"><?php echo $clear_text; ?></a>
					<?php } ?>
				</div>
			</div>

		</div>
	</div>

<?php
}

function essb_admin_options_generate_reset_block($title = '', $desc = '', $icon = '', $clear_command = '', $clear_title = '', $clear_text = '', $link_url = '', $link_text = '')
{
?>
	<div class="essb-ui-card essb-ui-mb3 essb-reset-feature essb-reset-feature-<?php echo $clear_command; ?>">
		<div class="essb-ui-card-content">

			<div class="essb-ui-flex essb-ui-flex100 essb-ui-align-center essb-ui-justify-between essb-ui-gap-4">

				<div class="essb-ui-flex essb-ui-align-center essb-ui-gap-4">

					<div class="essb-ui-icon-frame64">
						<svg class="essb-ui-svg-frame essb-ui-svg-frame-danger" fill="none" height="48" viewBox="0 0 44 48" width="44" xmlns="http://www.w3.org/2000/svg">
							<path d="M16 2.4641C19.7128 0.320509 24.2872 0.320508 28 2.4641L37.6506 8.0359C41.3634 10.1795 43.6506 14.141 43.6506 
			18.4282V29.5718C43.6506 33.859 41.3634 37.8205 37.6506 39.9641L28 45.5359C24.2872 47.6795 19.7128 47.6795 16 45.5359L6.34937 
			39.9641C2.63655 37.8205 0.349365 33.859 0.349365 29.5718V18.4282C0.349365 14.141 2.63655 10.1795 6.34937 8.0359L16 2.4641Z" fill="">
							</path>
							<path d="M16.25 2.89711C19.8081 0.842838 24.1919 0.842837 27.75 2.89711L37.4006 8.46891C40.9587 10.5232 43.1506 14.3196 43.1506 
			18.4282V29.5718C43.1506 33.6804 40.9587 37.4768 37.4006 39.5311L27.75 45.1029C24.1919 47.1572 19.8081 47.1572 16.25 45.1029L6.59937 
			39.5311C3.04125 37.4768 0.849365 33.6803 0.849365 29.5718V18.4282C0.849365 14.3196 3.04125 10.5232 6.59937 8.46891L16.25 2.89711Z" stroke="">
							</path>
						</svg>
						<i class="essb-ui-svg-icon essb-ui-svg-danger-icon">
							<?php echo essb_ui_get_svg_icon($icon); ?>
						</i>
					</div>

					<div class="essb-ui-flex essb-ui-flex-col essb-ui-gap-1.5">
						<div class="essb-ui-font-semibold essb-ui-line-height-sm essb-ui-text-lg essb-ui-flex essb-ui-align-center essb-ui-gap-1.5"><?php echo $title; ?></div>
						<div class="essb-ui-line-height-base"><?php echo $desc; ?></div>
						<?php
						if (!empty($link_url)) {
							echo '<div class="essb-ui-line-height-base"><a class="essb-ui-btn essb-ui-btn-link" href="' . esc_url($link_url) . '" target="_blank">' . $link_text . '</a></div>';
						}
						?>
					</div>
				</div>

				<div class="essb-ui-flex essb-ui-align-center essb-ui-gap-2.5">
					<a class="essb-ui-btn essb-ui-btn-danger essb-ui-btn-sm1 essb-reset-settings essb-ui-text-upper" href="#" data-clear="<?php echo esc_attr($clear_command); ?>" data-title="<?php echo esc_attr($clear_title); ?>"><?php echo $clear_text; ?></a>
				</div>
			</div>

		</div>
	</div>

<?php
}

function essb5_reset_settings_actions()
{

	essb_admin_options_generate_reset_block(
		esc_html__('Plugin settings', 'essb'),
		esc_html__('Reset the plugin settings to their original defaults, as they were after installation. Please note that this action will erase any customizations or settings you\'ve made within the plugin, and it cannot be undone. If you are uncertain, we recommend making a backup of the plugin settings using the Export Settings menu.making a copy of the plugin settings via the Export settings menu.', 'essb'),
		'options',
		'resetsettings',
		esc_html__('Plugin Settings', 'essb'),
		esc_html__('Reset', 'essb')
	);

	echo '<div class="essb-ui-mt6">&nbsp;</div>';

	if (!essb_options_bool_value('deactivate_share_counters')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Share Counter Last Update', 'essb'),
			esc_html__('Reset the timestamp of the last share counter update for the entire website. This will settle and immediately share counter updates for all content of the site.', 'essb'),
			'numbers',
			'resetcounter',
			esc_html__('Followers Settings', 'essb'),
			esc_html__('Reset', 'essb')
		);

		essb_admin_options_generate_reset_block(
			esc_html__('All Share Counter Data', 'essb'),
			esc_html__('Delete all plugin stored counter data - internal share counters and cached official share values. This will also remove the share counter\'s last updated parameter.', 'essb'),
			'delete_1',
			'resetcounterall',
			esc_html__('All Share Counter Data', 'essb'),
			esc_html__('Delete', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_share_counters') && !essb_options_bool_value('deactivate_postcount')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Internal Share Counters', 'essb'),
			esc_html__('Erase all stored internal share counters for social sharing networks. If you erase the stored install share counters the share value will start from zero for networks that do not have a counter API.', 'essb'),
			'database_reload',
			'resetinternal',
			esc_html__('Internal Share Counters', 'essb'),
			esc_html__('Clear', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_module_followers')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Followers Settings', 'essb'),
			esc_html__('The function will remove the followers counter setup you have made.', 'essb'),
			'heart',
			'resetfollowerssettings',
			esc_html__('Followers Settings', 'essb'),
			esc_html__('Reset', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_module_analytics')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Plugin Analytics Data', 'essb'),
			esc_html__('Remove all data collected and stored in the database by the plugin analytics functions.', 'essb'),
			'analytics',
			'resetanalytics',
			esc_html__('Plugin Analytics Data', 'essb'),
			esc_html__('Clear', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_module_shorturl')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Short URL Cache', 'essb'),
			esc_html__('Clear all cached short URLs generated and used by the plugin.', 'essb'),
			'short_url',
			'resetshort',
			esc_html__('Short URL Cache', 'essb'),
			esc_html__('Clear', 'essb')
		);
	}
	essb_admin_options_generate_reset_block(
		esc_html__('Sharing Images Cache', 'essb'),
		esc_html__('This function will delete all cached sharing images. For performance improvements, the plugin stores in the post data a cached URL of the shared image instead of reading that data each time.', 'essb'),
		'share_optimization',
		'resetimage',
		esc_html__('Sharing Images Cache', 'essb'),
		esc_html__('Clear', 'essb')
	);

	essb_admin_options_generate_reset_block(
		esc_html__('Love Button Counter', 'essb'),
		esc_html__('Clear the number of loves (likes) generated by the plugin Love button for all the website content.', 'essb'),
		'heart',
		'removelove',
		esc_html__('Love Button Counter', 'essb'),
		esc_html__('Clear', 'essb')
	);

	if (!essb_options_bool_value('deactivate_module_subscribe')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Custom Subscribe Form Designs', 'essb'),
			esc_html__('This will remove any user based designs for subscribe forms you have made. It will not touch the integrated designs and their customizations.', 'essb'),
			'mail',
			'removeforms',
			esc_html__('Custom Subscribe Form Designs', 'essb'),
			esc_html__('Remove', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_module_instagram')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Remove Instagram Cached Data', 'essb'),
			esc_html__('Remove all stored data for Instagram feeds. This will force all feeds used on the website to make an immediate update.', 'essb'),
			'instagram',
			'instagramtransients',
			esc_html__('Remove Instagram Cached Data', 'essb'),
			esc_html__('Remove', 'essb')
		);
	}

	if (!essb_options_bool_value('deactivate_module_conversions')) {
		essb_admin_options_generate_reset_block(
			esc_html__('Sharing Conversions Data', 'essb'),
			esc_html__('Delete all stored by the plugin conversions data for the share buttons.', 'essb'),
			'dashboard',
			'conversionsshare',
			esc_html__('Sharing Conversions Data', 'essb'),
			esc_html__('Remove', 'essb')
		);

		essb_admin_options_generate_reset_block(
			esc_html__('Subscribe Forms Conversions Data', 'essb'),
			esc_html__('Delete all stored by the plugin conversions data for the subscribe forms.', 'essb'),
			'dashboard',
			'conversionssubscribe',
			esc_html__('Subscribe Forms Conversions Data', 'essb'),
			esc_html__('Remove', 'essb')
		);
	}
}

function essb_admin_positions_export_import()
{
?>

	<div class="essb-flex-grid-r pb0">
		<div class="essb-flex-grid-c c12 essb-heading sub7">
			<span class="icon"><i class="ti-cloud-down"></i></span>
			<div><em>Export</em></div>
		</div>
	</div>

	<div class="essb-related-heading7">
		<div>
			<textarea id="essb-exporting-custompositions-area" class="essb-textarea-medium"></textarea>
			<a class="essb-ui-btn essb-ui-btn-dark essb-ui-btn-outline" href="#" id="essb-advanced-export-custompositions">Export</a>
		</div>
	</div>

	<div class="essb-flex-grid-r pb0 mt40">
		<div class="essb-flex-grid-c c12 essb-heading sub7">
			<span class="icon"><i class="ti-cloud-up"></i></span>
			<div><em>Import</em></div>
		</div>
	</div>

	<div class="essb-related-heading7">
		<div class="essb-options-hint essb-options-hint-glowhint">
			<div class="essb-options-hint-desc">The import won't overwrite all of your existing positions. It will add the positions from the fields to the existing (it may change the name only if the key is the same).</div>
		</div>
		<div class="mt25">
			<textarea id="essb-importing-custompositions-area" class="essb-textarea-medium"></textarea>
			<a class="essb-ui-btn essb-ui-btn-primary" href="#" id="essb-advanced-import-custompositions">Import</a>
		</div>
	</div>

<?php
}

function essb_admin_followers_export_import()
{
?>

	<div class="essb-flex-grid-r pb0">
		<div class="essb-flex-grid-c c12 essb-heading sub7">
			<span class="icon"><i class="ti-cloud-down"></i></span>
			<div><em>Export</em></div>
		</div>
	</div>

	<div class="essb-related-heading7">
		<div>
			<textarea id="essb-exporting-followersettings-area" class="essb-textarea-medium"></textarea>
			<button class="essb-ui-btn essb-ui-btn-dark essb-ui-btn-outline" href="#" id="essb-advanced-export-followersettings">Export</button>
		</div>
	</div>

	<div class="essb-flex-grid-r pb0 mt40">
		<div class="essb-flex-grid-c c12 essb-heading sub7">
			<span class="icon"><i class="ti-cloud-up"></i></span>
			<div><em>Import</em></div>
		</div>
	</div>

	<div class="essb-related-heading7">
		<div class="essb-options-hint essb-options-hint-glowhint">
			<div class="essb-options-hint-desc">When doing import all your existing settings will be overwritten.</div>
		</div>
		<div class="mt25">
			<textarea id="essb-importing-followersettings-area" class="essb-textarea-medium"></textarea>
			<button class="essb-ui-btn essb-ui-btn-primary" href="#" id="essb-advanced-import-followersettings">Import</button>
		</div>
	</div>

	<div class="essb-flex-grid-r pb0 mt40">
		<div class="essb-flex-grid-c c12 essb-heading sub7">
			<span class="icon"><i class="ti-na"></i></span>
			<div><em>Reset</em></div>
		</div>
	</div>

	<div class="essb-related-heading7">
		<div class="essb-options-hint essb-options-hint-glowhint essb-options-hint-danger">
			<div class="essb-options-hint-desc">When doing import all your existing settings will be overwritten.</div>
		</div>
		<div class="mt25">
			<button class="essb-ui-btn essb-ui-btn-danger" href="#" id="essb-advanced-reset-followersettings">Reset</button>
		</div>
	</div>

<?php
}
