document.addEventListener("DOMContentLoaded", function () {
	if (typeof (essbPinAdvancedDisable) != "undefined") {
		if (!essbPinAdvancedDisable["min_width"] && !essbPinAdvancedDisable["min_height"] && !essbPinAdvancedDisable["hideon"] && essbPinAdvancedDisable["files"].length == 0) return;

		if (essbPinAdvancedDisable["hideon"]) {
			document.querySelectorAll(essbPinAdvancedDisable["hideon"]).forEach(image => {
				image.setAttribute("nopin", "nopin");
				image.setAttribute("data-pin-nopin", "true");
				image.classList.add("no_pin");
				image.classList.add("essb_no_pin");
				image.setAttribute("data-pin-no-hover", "true");
			});
		}

		if (Number(essbPinAdvancedDisable["min_height"] || 0) > 0 || Number(essbPinAdvancedDisable["min_width"] || 0) > 0) {
			document.querySelectorAll("img").forEach(image => {
				if (image.outerWidth() < Number(essbPinImages.min_width || 0) || image.outerHeight() < Number(essbPinImages.min_height || 0)) {
					image.setAttribute("nopin", "nopin");
					image.setAttribute("data-pin-nopin", "true");
					image.classList.add("no_pin");
					image.classList.add("essb_no_pin");
					image.setAttribute("data-pin-no-hover", "true");
				}
			});
		}

		if (essbPinAdvancedDisable["files"].length > 0) {
			document.querySelectorAll("img").forEach(image => {
				let imagePath = (image.getAttribute('src') || '').toLowerCase(),
					disablePin = false;

				for (let filePart of essbPinAdvancedDisable["files"]) {
					if (imagePath.indexOf(filePart.toLowerCase()) > -1) {
						disablePin = true;
						break;
					}
				}

				if (disablePin) {
					image.setAttribute("nopin", "nopin");
					image.setAttribute("data-pin-nopin", "true");
					image.classList.add("no_pin");
					image.classList.add("essb_no_pin");
					image.setAttribute("data-pin-no-hover", "true");
				}
			});
		}
	}
});

document.addEventListener("DOMContentLoaded", function () {
	let relativePath = "", defaultTrigger = false;

	if (document.querySelector(".essb-pinterest-pro-content-marker")) {
		relativePath = ".essb-pinterest-pro-content-marker";
		defaultTrigger = true;
	}
	else if (document.querySelector(".post img")) relativePath = ".post img";
	else relativePath = ".single-post img";

	document.querySelectorAll(relativePath).forEach(element => {
		if (defaultTrigger) {
			element.parentNode.querySelectorAll("img").forEach(image => {
				let existDescription = image.getAttribute("data-pin-description") || "";
				if (existDescription == '') image.setAttribute("data-pin-description", "$pinterest_description");
			});
		}
		else {
			let existDescription = element.getAttribute("data-pin-description") || "";
			if (existDescription == '') element.setAttribute("data-pin-description", "$pinterest_description");
		}
	});
});

document.addEventListener("DOMContentLoaded", function () {
	document.querySelectorAll('img:not(.essb-pinterest-hidden-image)').forEach(image => {
		image.setAttribute('nopin', 'nopin');
		image.setAttribute('data-pin-nopin', 'true');
		image.classList.add('no_pin');
		image.classList.add("essb_no_pin");
		image.setAttribute('data-pin-no-hover', 'true');
	});

	document.querySelectorAll('.essb-pinterest-hidden-image').forEach(image => {
		image.setAttribute('data-pin-me-only', 'true');
	});
});

//#region More Popup
function essb_open_morepopup_window(salt = '') {
	if (essb['essb_morepopup_opened']) {
		essb_close_morepopup_window(salt);
		return;
	}

	let el = document.querySelector('.essb-morepop-' + salt);
	if (el) el.classList.add('essb-morepop-active');
	essb['essb_morepopup_opened'] = true;
}

function essb_close_morepopup_window(salt = '') {
	let el = document.querySelector('.essb-morepop-' + salt);
	if (el) el.classList.remove('essb-morepop-active');
	essb['essb_morepopup_opened'] = false;
}

document.addEventListener("DOMContentLoaded", function () {
	document.querySelectorAll('.essb-morepop-window-h-close').forEach(element => {
		element.onclick = function (e) {
			e.preventDefault();
			let salt = this.getAttribute('data-salt') || '';
			if (salt != '') essb_close_morepopup_window(salt);
		}
	});

	document.querySelectorAll('.essb-morepop-overlay').forEach(element => {
		element.onclick = function (e) {
			e.preventDefault();
			let salt = this.getAttribute('data-salt') || '';
			if (salt != '') essb_close_morepopup_window(salt);
		}
	});

	document.querySelectorAll('.essb-morepop-window').forEach(element => {
		element.onclick = function (e) {
			e.preventDefault();
			e.stopPropagation();
		}
	});
});
//#endregion

//#region Love this button
function essb_execute_love_this(instance = '') {
	let disableMessageDisplay = { loved: false, thankyou: false },
		messages = {
			loved: 'You already love this today',
			thankyou: 'Thank you for loving this'
		};


	if (document.querySelector('.essb_' + instance)) {
		let post_id = document.querySelector('.essb_' + instance).getAttribute('data-essb-postid') || '';
		if (!post_id || post_id == '') return;

		//data-love-trigger
		if ((document.querySelector('.essb_' + instance).getAttribute('data-love-trigger') || '') == 'true') {
			if (!disableMessageDisplay.loved) alert(messages.loved);
			return;
		}

		let loveCookieSet = essb.getCookie("essb_love_" + post_id);
		if (loveCookieSet) {
			if (!disableMessageDisplay.loved) alert(messages.loved);
			return;
		}

		if (typeof (essb_settings) != "undefined") {
			fetch(essb_settings.ajax_url, {
				method: 'POST',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded',
					'Accept': '*/*'
				},
				body: new URLSearchParams({
					'action': 'essb_love_action',
					'post_id': post_id,
					'service': 'love',
					'nonce': essb_settings.essb3_nonce
				})
			}).then(response => response.text())
				.then(data => {
					console.log(data)
				});

			$.post(essb_settings.ajax_url, {
				'action': 'essb_love_action',
				'post_id': instance_post_id,
				'service': 'love',
				'nonce': essb_settings.essb3_nonce
			}, function (data) {
				if (data) {
					if (!disableMessageDisplay.thankyou) alert(messages.thankyou);
					document.querySelector('.essb_' + instance).setAttribute('data-love-trigger', 'true');
				}
			}, 'json');
		}

		essb.tracking_only('', 'love', instance, true);
	}
}

//#endregion

//#region Copy Link
function essb_open_copy_link_window(instance_id, user_href) {
	let currentLocation = window.location.href;

	if (instance_id && document.querySelector('.essb_' + instance_id)) {
		let instance_url = document.querySelector('.essb_' + instance_id).getAttribute('data-essb-url') || '';
		if (instance_url != '') currentLocation = instance_url;
	}

	if (user_href && user_href != '') currentLocation = user_href;

	if (essb_settings && essb_settings.copybutton_direct) {
		essb.copy_link_direct(currentLocation);
		return;
	}

	if (document.querySelector('.essb-copylink-window')) {
		if (document.querySelector('#essb_copy_link_field')) document.querySelector('#essb_copy_link_field').value = currentLocation;
		document.querySelector('.essb-copylink-window').style.display = 'flex';
		document.querySelector('.essb-copylink-shadow').style.display = 'flex';

		if (document.querySelector('.essb-copylink-window-close')) {
			document.querySelector('.essb-copylink-window-close').onclick = function (e) {
				e.preventDefault();
				document.querySelector('.essb-copylink-window').style.display = 'none';
				document.querySelector('.essb-copylink-shadow').style.display = 'none';
			}
		}

		if (document.querySelector('.essb-copylink-window .essb-copy-link')) {
			document.querySelector('.essb-copylink-window .essb-copy-link').onclick = function (e) {
				e.preventDefault();

				let copyText = document.querySelector("#essb_copy_link_field");
				try {
					copyText.focus();
					copyText.select();
					copyText.setSelectionRange(0, 99999); /*For mobile devices*/
					document.execCommand("copy");
					navigator.clipboard.writeText(copyText.value);
					document.querySelector('.essb-copylink-window .essb-copylink-window-header span').innerHTML = essb_settings.translate_copy_message2 ? essb_settings.translate_copy_message2 : 'Copied to clipboard.';
					setTimeout(function () {
						document.querySelector('.essb-copylink-window .essb-copylink-window-header span').innerHTML = '&nbsp;';
					}, 2000);
				}
				catch (e) {
					console.log(e.stack);
					document.querySelector('.essb-copylink-window .essb-copylink-window-header span').innerHTML = essb_settings.translate_copy_message3 ? essb_settings.translate_copy_message3 : 'Please use Ctrl/Cmd+C to copy the URL.';
					setTimeout(function () {
						document.querySelector('.essb-copylink-window .essb-copylink-window-header span').innerHTML = '&nbsp;';
					}, 2000);
				}
			}
		}

	}
}

function essb_copy_link_direct(currentLocation) {
	if (document.querySelector('#essb_direct_copy_link_field')) {
		document.querySelector('#essb_direct_copy_link_field').value = currentLocation;

		setTimeout(function () {
			var copyText = document.querySelector("#essb_direct_copy_link_field");
			try {
				copyText.focus();
				copyText.select();
				copyText.setSelectionRange(0, 99999); /*For mobile devices*/
				document.execCommand("copy");
				navigator.clipboard.writeText(copyText.value);
				document.querySelector('#essb_direct_copy_link_message').style.display = 'flex';
				setTimeout(function () {
					document.querySelector('#essb_direct_copy_link_message').style.display = 'none';
				}, 2000);
			}
			catch (e) {
				console.log('Error link copy to clipboard!');
			}
		}, 100);
	}
}
//#endregion