<?php

/**
 * Array of countries with known regions.
 */
return array(
	'US' => include EDD_PLUGIN_DIR . 'i18n/states-us.php',
	'CA' => array(
		''   => '',
		'AB' => __( 'Alberta', 'easy-digital-downloads' ),
		'BC' => __( 'British Columbia', 'easy-digital-downloads' ),
		'MB' => __( 'Manitoba', 'easy-digital-downloads' ),
		'NB' => __( 'New Brunswick', 'easy-digital-downloads' ),
		'NL' => __( 'Newfoundland and Labrador', 'easy-digital-downloads' ),
		'NS' => __( 'Nova Scotia', 'easy-digital-downloads' ),
		'NT' => __( 'Northwest Territories', 'easy-digital-downloads' ),
		'NU' => __( 'Nunavut', 'easy-digital-downloads' ),
		'ON' => __( 'Ontario', 'easy-digital-downloads' ),
		'PE' => __( 'Prince Edward Island', 'easy-digital-downloads' ),
		'QC' => __( 'Quebec', 'easy-digital-downloads' ),
		'SK' => __( 'Saskatchewan', 'easy-digital-downloads' ),
		'YT' => __( 'Yukon', 'easy-digital-downloads' ),
	),
	'GB' => include EDD_PLUGIN_DIR . 'i18n/states-gb.php',
	'AO' => array(
		''    => '',
		'BGO' => __( 'Bengo', 'easy-digital-downloads' ),
		'BGU' => __( 'Benguela', 'easy-digital-downloads' ),
		'BIE' => __( 'Bié', 'easy-digital-downloads' ),
		'CAB' => __( 'Cabinda', 'easy-digital-downloads' ),
		'CNN' => __( 'Cunene', 'easy-digital-downloads' ),
		'HUA' => __( 'Huambo', 'easy-digital-downloads' ),
		'HUI' => __( 'Huíla', 'easy-digital-downloads' ),
		'CCU' => __( 'Kuando Kubango', 'easy-digital-downloads' ), // Cuando Cubango
		'CNO' => __( 'Kwanza-Norte', 'easy-digital-downloads' ), // Cuanza Norte
		'CUS' => __( 'Kwanza-Sul', 'easy-digital-downloads' ), // Cuanza Sul
		'LUA' => __( 'Luanda', 'easy-digital-downloads' ),
		'LNO' => __( 'Lunda-Norte', 'easy-digital-downloads' ), // Lunda Norte
		'LSU' => __( 'Lunda-Sul', 'easy-digital-downloads' ), // Lunda Sul
		'MAL' => __( 'Malanje', 'easy-digital-downloads' ), // Malanje
		'MOX' => __( 'Moxico', 'easy-digital-downloads' ),
		'NAM' => __( 'Namibe', 'easy-digital-downloads' ),
		'UIG' => __( 'Uíge', 'easy-digital-downloads' ),
		'ZAI' => __( 'Zaire', 'easy-digital-downloads' ),
	),
	'AU' => array(
		''    => '',
		'ACT' => __( 'Australian Capital Territory', 'easy-digital-downloads' ),
		'NSW' => __( 'New South Wales', 'easy-digital-downloads' ),
		'NT'  => __( 'Northern Territory', 'easy-digital-downloads' ),
		'QLD' => __( 'Queensland', 'easy-digital-downloads' ),
		'SA'  => __( 'South Australia', 'easy-digital-downloads' ),
		'TAS' => __( 'Tasmania', 'easy-digital-downloads' ),
		'VIC' => __( 'Victoria', 'easy-digital-downloads' ),
		'WA'  => __( 'Western Australia', 'easy-digital-downloads' ),
	),
	'BD' => include EDD_PLUGIN_DIR . 'i18n/states-bd.php',
	'BJ' => include EDD_PLUGIN_DIR . 'i18n/states-bj.php',
	'BR' => array(
		''   => '',
		'AC' => __( 'Acre', 'easy-digital-downloads' ),
		'AL' => __( 'Alagoas', 'easy-digital-downloads' ),
		'AP' => __( 'Amap&aacute;', 'easy-digital-downloads' ),
		'AM' => __( 'Amazonas', 'easy-digital-downloads' ),
		'BA' => __( 'Bahia', 'easy-digital-downloads' ),
		'CE' => __( 'Cear&aacute;', 'easy-digital-downloads' ),
		'DF' => __( 'Distrito Federal', 'easy-digital-downloads' ),
		'ES' => __( 'Esp&iacute;rito Santo', 'easy-digital-downloads' ),
		'GO' => __( 'Goi&aacute;s', 'easy-digital-downloads' ),
		'MA' => __( 'Maranh&atilde;o', 'easy-digital-downloads' ),
		'MT' => __( 'Mato Grosso', 'easy-digital-downloads' ),
		'MS' => __( 'Mato Grosso do Sul', 'easy-digital-downloads' ),
		'MG' => __( 'Minas Gerais', 'easy-digital-downloads' ),
		'PA' => __( 'Par&aacute;', 'easy-digital-downloads' ),
		'PB' => __( 'Para&iacute;ba', 'easy-digital-downloads' ),
		'PR' => __( 'Paran&aacute;', 'easy-digital-downloads' ),
		'PE' => __( 'Pernambuco', 'easy-digital-downloads' ),
		'PI' => __( 'Piau&iacute;', 'easy-digital-downloads' ),
		'RJ' => __( 'Rio de Janeiro', 'easy-digital-downloads' ),
		'RN' => __( 'Rio Grande do Norte', 'easy-digital-downloads' ),
		'RS' => __( 'Rio Grande do Sul', 'easy-digital-downloads' ),
		'RO' => __( 'Rond&ocirc;nia', 'easy-digital-downloads' ),
		'RR' => __( 'Roraima', 'easy-digital-downloads' ),
		'SC' => __( 'Santa Catarina', 'easy-digital-downloads' ),
		'SP' => __( 'S&atilde;o Paulo', 'easy-digital-downloads' ),
		'SE' => __( 'Sergipe', 'easy-digital-downloads' ),
		'TO' => __( 'Tocantins', 'easy-digital-downloads' ),
	),
	'BG' => array(
		''      => '',
		'BG-01' => __( 'Blagoevgrad', 'easy-digital-downloads' ),
		'BG-02' => __( 'Burgas', 'easy-digital-downloads' ),
		'BG-08' => __( 'Dobrich', 'easy-digital-downloads' ),
		'BG-07' => __( 'Gabrovo', 'easy-digital-downloads' ),
		'BG-26' => __( 'Haskovo', 'easy-digital-downloads' ),
		'BG-09' => __( 'Kardzhali', 'easy-digital-downloads' ),
		'BG-10' => __( 'Kyustendil', 'easy-digital-downloads' ),
		'BG-11' => __( 'Lovech', 'easy-digital-downloads' ),
		'BG-12' => __( 'Montana', 'easy-digital-downloads' ),
		'BG-13' => __( 'Pazardzhik', 'easy-digital-downloads' ),
		'BG-14' => __( 'Pernik', 'easy-digital-downloads' ),
		'BG-15' => __( 'Pleven', 'easy-digital-downloads' ),
		'BG-16' => __( 'Plovdiv', 'easy-digital-downloads' ),
		'BG-17' => __( 'Razgrad', 'easy-digital-downloads' ),
		'BG-18' => __( 'Ruse', 'easy-digital-downloads' ),
		'BG-27' => __( 'Shumen', 'easy-digital-downloads' ),
		'BG-19' => __( 'Silistra', 'easy-digital-downloads' ),
		'BG-20' => __( 'Sliven', 'easy-digital-downloads' ),
		'BG-21' => __( 'Smolyan', 'easy-digital-downloads' ),
		'BG-23' => __( 'Sofia', 'easy-digital-downloads' ),
		'BG-22' => __( 'Sofia-Grad', 'easy-digital-downloads' ),
		'BG-24' => __( 'Stara Zagora', 'easy-digital-downloads' ),
		'BG-25' => __( 'Targovishte', 'easy-digital-downloads' ),
		'BG-03' => __( 'Varna', 'easy-digital-downloads' ),
		'BG-04' => __( 'Veliko Tarnovo', 'easy-digital-downloads' ),
		'BG-05' => __( 'Vidin', 'easy-digital-downloads' ),
		'BG-06' => __( 'Vratsa', 'easy-digital-downloads' ),
		'BG-28' => __( 'Yambol', 'easy-digital-downloads' ),
	),
	'CN' => array(
		''     => '',
		'CN1'  => __( 'Yunnan / &#20113;&#21335;', 'easy-digital-downloads' ),
		'CN2'  => __( 'Beijing / &#21271;&#20140;', 'easy-digital-downloads' ),
		'CN3'  => __( 'Tianjin / &#22825;&#27941;', 'easy-digital-downloads' ),
		'CN4'  => __( 'Hebei / &#27827;&#21271;', 'easy-digital-downloads' ),
		'CN5'  => __( 'Shanxi / &#23665;&#35199;', 'easy-digital-downloads' ),
		'CN6'  => __( 'Inner Mongolia / &#20839;&#33945;&#21476;', 'easy-digital-downloads' ),
		'CN7'  => __( 'Liaoning / &#36797;&#23425;', 'easy-digital-downloads' ),
		'CN8'  => __( 'Jilin / &#21513;&#26519;', 'easy-digital-downloads' ),
		'CN9'  => __( 'Heilongjiang / &#40657;&#40857;&#27743;', 'easy-digital-downloads' ),
		'CN10' => __( 'Shanghai / &#19978;&#28023;', 'easy-digital-downloads' ),
		'CN11' => __( 'Jiangsu / &#27743;&#33487;', 'easy-digital-downloads' ),
		'CN12' => __( 'Zhejiang / &#27993;&#27743;', 'easy-digital-downloads' ),
		'CN13' => __( 'Anhui / &#23433;&#24509;', 'easy-digital-downloads' ),
		'CN14' => __( 'Fujian / &#31119;&#24314;', 'easy-digital-downloads' ),
		'CN15' => __( 'Jiangxi / &#27743;&#35199;', 'easy-digital-downloads' ),
		'CN16' => __( 'Shandong / &#23665;&#19996;', 'easy-digital-downloads' ),
		'CN17' => __( 'Henan / &#27827;&#21335;', 'easy-digital-downloads' ),
		'CN18' => __( 'Hubei / &#28246;&#21271;', 'easy-digital-downloads' ),
		'CN19' => __( 'Hunan / &#28246;&#21335;', 'easy-digital-downloads' ),
		'CN20' => __( 'Guangdong / &#24191;&#19996;', 'easy-digital-downloads' ),
		'CN21' => __( 'Guangxi Zhuang / &#24191;&#35199;&#22766;&#26063;', 'easy-digital-downloads' ),
		'CN22' => __( 'Hainan / &#28023;&#21335;', 'easy-digital-downloads' ),
		'CN23' => __( 'Chongqing / &#37325;&#24198;', 'easy-digital-downloads' ),
		'CN24' => __( 'Sichuan / &#22235;&#24029;', 'easy-digital-downloads' ),
		'CN25' => __( 'Guizhou / &#36149;&#24030;', 'easy-digital-downloads' ),
		'CN26' => __( 'Shaanxi / &#38485;&#35199;', 'easy-digital-downloads' ),
		'CN27' => __( 'Gansu / &#29976;&#32899;', 'easy-digital-downloads' ),
		'CN28' => __( 'Qinghai / &#38738;&#28023;', 'easy-digital-downloads' ),
		'CN29' => __( 'Ningxia Hui / &#23425;&#22799;', 'easy-digital-downloads' ),
		'CN30' => __( 'Macau / &#28595;&#38376;', 'easy-digital-downloads' ),
		'CN31' => __( 'Tibet / &#35199;&#34255;', 'easy-digital-downloads' ),
		'CN32' => __( 'Xinjiang / &#26032;&#30086;', 'easy-digital-downloads' ),
	),
	'HK' => array(
		''                => '',
		'HONG KONG'       => __( 'Hong Kong Island', 'easy-digital-downloads' ),
		'KOWLOON'         => __( 'Kowloon', 'easy-digital-downloads' ),
		'NEW TERRITORIES' => __( 'New Territories', 'easy-digital-downloads' ),
	),
	'HU' => array(
		''   => '',
		'BK' => __( 'Bács-Kiskun', 'easy-digital-downloads' ),
		'BE' => __( 'Békés', 'easy-digital-downloads' ),
		'BA' => __( 'Baranya', 'easy-digital-downloads' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'easy-digital-downloads' ),
		'BU' => __( 'Budapest', 'easy-digital-downloads' ),
		'CS' => __( 'Csongrád', 'easy-digital-downloads' ),
		'FE' => __( 'Fejér', 'easy-digital-downloads' ),
		'GS' => __( 'Győr-Moson-Sopron', 'easy-digital-downloads' ),
		'HB' => __( 'Hajdú-Bihar', 'easy-digital-downloads' ),
		'HE' => __( 'Heves', 'easy-digital-downloads' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'easy-digital-downloads' ),
		'KE' => __( 'Komárom-Esztergom', 'easy-digital-downloads' ),
		'NO' => __( 'Nógrád', 'easy-digital-downloads' ),
		'PE' => __( 'Pest', 'easy-digital-downloads' ),
		'SO' => __( 'Somogy', 'easy-digital-downloads' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'easy-digital-downloads' ),
		'TO' => __( 'Tolna', 'easy-digital-downloads' ),
		'VA' => __( 'Vas', 'easy-digital-downloads' ),
		'VE' => __( 'Veszprém', 'easy-digital-downloads' ),
		'ZA' => __( 'Zala', 'easy-digital-downloads' ),
	),
	'IN' => include EDD_PLUGIN_DIR . 'i18n/states-in.php',
	'ID' => array(
		''   => '',
		'AC' => __( 'Daerah Istimewa Aceh', 'easy-digital-downloads' ),
		'SU' => __( 'Sumatera Utara', 'easy-digital-downloads' ),
		'SB' => __( 'Sumatera Barat', 'easy-digital-downloads' ),
		'RI' => __( 'Riau', 'easy-digital-downloads' ),
		'KR' => __( 'Kepulauan Riau', 'easy-digital-downloads' ),
		'JA' => __( 'Jambi', 'easy-digital-downloads' ),
		'SS' => __( 'Sumatera Selatan', 'easy-digital-downloads' ),
		'BB' => __( 'Bangka Belitung', 'easy-digital-downloads' ),
		'BE' => __( 'Bengkulu', 'easy-digital-downloads' ),
		'LA' => __( 'Lampung', 'easy-digital-downloads' ),
		'JK' => __( 'DKI Jakarta', 'easy-digital-downloads' ),
		'JB' => __( 'Jawa Barat', 'easy-digital-downloads' ),
		'BT' => __( 'Banten', 'easy-digital-downloads' ),
		'JT' => __( 'Jawa Tengah', 'easy-digital-downloads' ),
		'JI' => __( 'Jawa Timur', 'easy-digital-downloads' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'easy-digital-downloads' ),
		'BA' => __( 'Bali', 'easy-digital-downloads' ),
		'NB' => __( 'Nusa Tenggara Barat', 'easy-digital-downloads' ),
		'NT' => __( 'Nusa Tenggara Timur', 'easy-digital-downloads' ),
		'KB' => __( 'Kalimantan Barat', 'easy-digital-downloads' ),
		'KT' => __( 'Kalimantan Tengah', 'easy-digital-downloads' ),
		'KI' => __( 'Kalimantan Timur', 'easy-digital-downloads' ),
		'KS' => __( 'Kalimantan Selatan', 'easy-digital-downloads' ),
		'KU' => __( 'Kalimantan Utara', 'easy-digital-downloads' ),
		'SA' => __( 'Sulawesi Utara', 'easy-digital-downloads' ),
		'ST' => __( 'Sulawesi Tengah', 'easy-digital-downloads' ),
		'SG' => __( 'Sulawesi Tenggara', 'easy-digital-downloads' ),
		'SR' => __( 'Sulawesi Barat', 'easy-digital-downloads' ),
		'SN' => __( 'Sulawesi Selatan', 'easy-digital-downloads' ),
		'GO' => __( 'Gorontalo', 'easy-digital-downloads' ),
		'MA' => __( 'Maluku', 'easy-digital-downloads' ),
		'MU' => __( 'Maluku Utara', 'easy-digital-downloads' ),
		'PA' => __( 'Papua', 'easy-digital-downloads' ),
		'PB' => __( 'Papua Barat', 'easy-digital-downloads' ),
	),
	'IR' => array(
		''    => '',
		'KHZ' => __( 'Khuzestan', 'easy-digital-downloads' ),
		'THR' => __( 'Tehran', 'easy-digital-downloads' ),
		'ILM' => __( 'Ilaam', 'easy-digital-downloads' ),
		'BHR' => __( 'Bushehr', 'easy-digital-downloads' ),
		'ADL' => __( 'Ardabil', 'easy-digital-downloads' ),
		'ESF' => __( 'Isfahan', 'easy-digital-downloads' ),
		'YZD' => __( 'Yazd', 'easy-digital-downloads' ),
		'KRH' => __( 'Kermanshah', 'easy-digital-downloads' ),
		'KRN' => __( 'Kerman', 'easy-digital-downloads' ),
		'HDN' => __( 'Hamadan', 'easy-digital-downloads' ),
		'GZN' => __( 'Ghazvin', 'easy-digital-downloads' ),
		'ZJN' => __( 'Zanjan', 'easy-digital-downloads' ),
		'LRS' => __( 'Luristan', 'easy-digital-downloads' ),
		'ABZ' => __( 'Alborz', 'easy-digital-downloads' ),
		'EAZ' => __( 'East Azerbaijan', 'easy-digital-downloads' ),
		'WAZ' => __( 'West Azerbaijan', 'easy-digital-downloads' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari', 'easy-digital-downloads' ),
		'SKH' => __( 'South Khorasan', 'easy-digital-downloads' ),
		'RKH' => __( 'Razavi Khorasan', 'easy-digital-downloads' ),
		'NKH' => __( 'North Khorasan', 'easy-digital-downloads' ),
		'SMN' => __( 'Semnan', 'easy-digital-downloads' ),
		'FRS' => __( 'Fars', 'easy-digital-downloads' ),
		'QHM' => __( 'Qom', 'easy-digital-downloads' ),
		'KRD' => __( 'Kurdistan', 'easy-digital-downloads' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad', 'easy-digital-downloads' ),
		'GLS' => __( 'Golestan', 'easy-digital-downloads' ),
		'GIL' => __( 'Gilan', 'easy-digital-downloads' ),
		'MZN' => __( 'Mazandaran', 'easy-digital-downloads' ),
		'MKZ' => __( 'Markazi', 'easy-digital-downloads' ),
		'HRZ' => __( 'Hormozgan', 'easy-digital-downloads' ),
		'SBN' => __( 'Sistan and Baluchestan', 'easy-digital-downloads' ),
	),
	'IT' => include EDD_PLUGIN_DIR . 'i18n/states-it.php',
	'JP' => include EDD_PLUGIN_DIR . 'i18n/states-jp.php',
	'MY' => array(
		''    => '',
		'JHR' => __( 'Johor', 'easy-digital-downloads' ),
		'KDH' => __( 'Kedah', 'easy-digital-downloads' ),
		'KTN' => __( 'Kelantan', 'easy-digital-downloads' ),
		'MLK' => __( 'Melaka', 'easy-digital-downloads' ),
		'NSN' => __( 'Negeri Sembilan', 'easy-digital-downloads' ),
		'PHG' => __( 'Pahang', 'easy-digital-downloads' ),
		'PRK' => __( 'Perak', 'easy-digital-downloads' ),
		'PLS' => __( 'Perlis', 'easy-digital-downloads' ),
		'PNG' => __( 'Pulau Pinang', 'easy-digital-downloads' ),
		'SBH' => __( 'Sabah', 'easy-digital-downloads' ),
		'SWK' => __( 'Sarawak', 'easy-digital-downloads' ),
		'SGR' => __( 'Selangor', 'easy-digital-downloads' ),
		'TRG' => __( 'Terengganu', 'easy-digital-downloads' ),
		'KUL' => __( 'W.P. Kuala Lumpur', 'easy-digital-downloads' ),
		'LBN' => __( 'W.P. Labuan', 'easy-digital-downloads' ),
		'PJY' => __( 'W.P. Putrajaya', 'easy-digital-downloads' ),
	),
	'MX' => array(
		''    => '',
		'DIF' => __( 'Distrito Federal', 'easy-digital-downloads' ),
		'JAL' => __( 'Jalisco', 'easy-digital-downloads' ),
		'NLE' => __( 'Nuevo Le&oacute;n', 'easy-digital-downloads' ),
		'AGU' => __( 'Aguascalientes', 'easy-digital-downloads' ),
		'BCN' => __( 'Baja California Norte', 'easy-digital-downloads' ),
		'BCS' => __( 'Baja California Sur', 'easy-digital-downloads' ),
		'CAM' => __( 'Campeche', 'easy-digital-downloads' ),
		'CHP' => __( 'Chiapas', 'easy-digital-downloads' ),
		'CHH' => __( 'Chihuahua', 'easy-digital-downloads' ),
		'COA' => __( 'Coahuila', 'easy-digital-downloads' ),
		'COL' => __( 'Colima', 'easy-digital-downloads' ),
		'DUR' => __( 'Durango', 'easy-digital-downloads' ),
		'GUA' => __( 'Guanajuato', 'easy-digital-downloads' ),
		'GRO' => __( 'Guerrero', 'easy-digital-downloads' ),
		'HID' => __( 'Hidalgo', 'easy-digital-downloads' ),
		'MEX' => __( 'Edo. de M&eacute;xico', 'easy-digital-downloads' ),
		'MIC' => __( 'Michoac&aacute;n', 'easy-digital-downloads' ),
		'MOR' => __( 'Morelos', 'easy-digital-downloads' ),
		'NAY' => __( 'Nayarit', 'easy-digital-downloads' ),
		'OAX' => __( 'Oaxaca', 'easy-digital-downloads' ),
		'PUE' => __( 'Puebla', 'easy-digital-downloads' ),
		'QUE' => __( 'Quer&eacute;taro', 'easy-digital-downloads' ),
		'ROO' => __( 'Quintana Roo', 'easy-digital-downloads' ),
		'SLP' => __( 'San Luis Potos&iacute;', 'easy-digital-downloads' ),
		'SIN' => __( 'Sinaloa', 'easy-digital-downloads' ),
		'SON' => __( 'Sonora', 'easy-digital-downloads' ),
		'TAB' => __( 'Tabasco', 'easy-digital-downloads' ),
		'TAM' => __( 'Tamaulipas', 'easy-digital-downloads' ),
		'TLA' => __( 'Tlaxcala', 'easy-digital-downloads' ),
		'VER' => __( 'Veracruz', 'easy-digital-downloads' ),
		'YUC' => __( 'Yucat&aacute;n', 'easy-digital-downloads' ),
		'ZAC' => __( 'Zacatecas', 'easy-digital-downloads' ),
	),
	'NP' => include EDD_PLUGIN_DIR . 'i18n/states-np.php',
	'NL' => array(
		''   => '',
		'DR' => __( 'Drenthe', 'easy-digital-downloads' ),
		'FL' => __( 'Flevoland', 'easy-digital-downloads' ),
		'FR' => __( 'Friesland', 'easy-digital-downloads' ),
		'GE' => __( 'Gelderland', 'easy-digital-downloads' ),
		'GR' => __( 'Groningen', 'easy-digital-downloads' ),
		'LI' => __( 'Limburg', 'easy-digital-downloads' ),
		'NB' => __( 'North Brabant', 'easy-digital-downloads' ),
		'NH' => __( 'North Holland', 'easy-digital-downloads' ),
		'OV' => __( 'Overijssel', 'easy-digital-downloads' ),
		'ZH' => __( 'South Holland', 'easy-digital-downloads' ),
		'UT' => __( 'Utrecht', 'easy-digital-downloads' ),
		'ZE' => __( 'Zeeland', 'easy-digital-downloads' ),

		// Caribbean Netherland
		'BO' => __( 'Bonaire', 'easy-digital-downloads' ),
		'SA' => __( 'Saba', 'easy-digital-downloads' ),
		'SE' => __( 'Sint Eustatius', 'easy-digital-downloads' ),
	),
	'NZ' => array(
		''   => '',
		'AK' => __( 'Auckland', 'easy-digital-downloads' ),
		'BP' => __( 'Bay of Plenty', 'easy-digital-downloads' ),
		'CT' => __( 'Canterbury', 'easy-digital-downloads' ),
		'HB' => __( 'Hawke&rsquo;s Bay', 'easy-digital-downloads' ),
		'MW' => __( 'Manawatu-Wanganui', 'easy-digital-downloads' ),
		'MB' => __( 'Marlborough', 'easy-digital-downloads' ),
		'NS' => __( 'Nelson', 'easy-digital-downloads' ),
		'NL' => __( 'Northland', 'easy-digital-downloads' ),
		'OT' => __( 'Otago', 'easy-digital-downloads' ),
		'SL' => __( 'Southland', 'easy-digital-downloads' ),
		'TK' => __( 'Taranaki', 'easy-digital-downloads' ),
		'TM' => __( 'Tasman', 'easy-digital-downloads' ),
		'WA' => __( 'Waikato', 'easy-digital-downloads' ),
		'WR' => __( 'Wairarapa', 'easy-digital-downloads' ),
		'WE' => __( 'Wellington', 'easy-digital-downloads' ),
		'WC' => __( 'West Coast', 'easy-digital-downloads' ),
	),
	'PE' => array(
		''    => '',
		'CAL' => __( 'El Callao', 'easy-digital-downloads' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'easy-digital-downloads' ),
		'AMA' => __( 'Amazonas', 'easy-digital-downloads' ),
		'ANC' => __( 'Ancash', 'easy-digital-downloads' ),
		'APU' => __( 'Apur&iacute;mac', 'easy-digital-downloads' ),
		'ARE' => __( 'Arequipa', 'easy-digital-downloads' ),
		'AYA' => __( 'Ayacucho', 'easy-digital-downloads' ),
		'CAJ' => __( 'Cajamarca', 'easy-digital-downloads' ),
		'CUS' => __( 'Cusco', 'easy-digital-downloads' ),
		'HUV' => __( 'Huancavelica', 'easy-digital-downloads' ),
		'HUC' => __( 'Hu&aacute;nuco', 'easy-digital-downloads' ),
		'ICA' => __( 'Ica', 'easy-digital-downloads' ),
		'JUN' => __( 'Jun&iacute;n', 'easy-digital-downloads' ),
		'LAL' => __( 'La Libertad', 'easy-digital-downloads' ),
		'LAM' => __( 'Lambayeque', 'easy-digital-downloads' ),
		'LIM' => __( 'Lima', 'easy-digital-downloads' ),
		'LOR' => __( 'Loreto', 'easy-digital-downloads' ),
		'MDD' => __( 'Madre de Dios', 'easy-digital-downloads' ),
		'MOQ' => __( 'Moquegua', 'easy-digital-downloads' ),
		'PAS' => __( 'Pasco', 'easy-digital-downloads' ),
		'PIU' => __( 'Piura', 'easy-digital-downloads' ),
		'PUN' => __( 'Puno', 'easy-digital-downloads' ),
		'SAM' => __( 'San Mart&iacute;n', 'easy-digital-downloads' ),
		'TAC' => __( 'Tacna', 'easy-digital-downloads' ),
		'TUM' => __( 'Tumbes', 'easy-digital-downloads' ),
		'UCA' => __( 'Ucayali', 'easy-digital-downloads' ),
	),
	'ZA' => array(
		''    => '',
		'EC'  => __( 'Eastern Cape', 'easy-digital-downloads' ),
		'FS'  => __( 'Free State', 'easy-digital-downloads' ),
		'GP'  => __( 'Gauteng', 'easy-digital-downloads' ),
		'KZN' => __( 'KwaZulu-Natal', 'easy-digital-downloads' ),
		'LP'  => __( 'Limpopo', 'easy-digital-downloads' ),
		'MP'  => __( 'Mpumalanga', 'easy-digital-downloads' ),
		'NC'  => __( 'Northern Cape', 'easy-digital-downloads' ),
		'NW'  => __( 'North West', 'easy-digital-downloads' ),
		'WC'  => __( 'Western Cape', 'easy-digital-downloads' ),
	),
	'ES' => include EDD_PLUGIN_DIR . 'i18n/states-es.php',
	'TH' => include EDD_PLUGIN_DIR . 'i18n/states-th.php',
	'TR' => include EDD_PLUGIN_DIR . 'i18n/states-tr.php',
);
