<?php
/**
 * Stripe payment method class.
 *
 * @since 3.3.5
 * @package EDD\Gateways\Stripe\PaymentMethods
 */

namespace EDD\Gateways\Stripe\PaymentMethods;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * BacsDebit class.
 */
class BacsDebit extends Method {

	/**
	 * The ID of the payment method.
	 *
	 * @since 3.3.5
	 * @var string
	 */
	protected static $id = 'bacs_debit';

	/**
	 * The supported currencies for the payment method.
	 *
	 * @since 3.3.5
	 * @var array
	 */
	public static $currencies = array( 'GBP' );

	/**
	 * The supported countries for the payment method.
	 *
	 * @since 3.3.5
	 * @var array
	 */
	public static $countries = array( 'gb' );

	/**
	 * Gets the label for the payment method.
	 *
	 * @since 3.3.5
	 * @return string
	 */
	public static function get_label() {
		return __( 'Bacs Debit', 'easy-digital-downloads' );
	}

	/**
	 * Gets the icon for the payment method.
	 *
	 * @since 3.3.5
	 * @return string
	 */
	public static function get_icon(): string {
		return '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><g fill="none" fill-rule="evenodd"><path fill="#FFF" d="M0 0h32v32H0z"></path><path fill="#32325D" fill-rule="nonzero" d="M25.138 22.728c-.455.265-.907.539-1.382.768a10.6 10.6 0 0 1-1.891.719c-.596.156-1.185.33-1.788.46a10.87 10.87 0 0 1-1.337.19c-.627.056-1.259.095-1.89.121-.439.019-.88.019-1.32-.002-.464-.02-.926-.056-1.385-.12a17.503 17.503 0 0 1-1.537-.285 24.083 24.083 0 0 1-1.734-.473 8.55 8.55 0 0 1-1.146-.457c-.541-.262-1.086-.524-1.596-.838-.49-.3-.953-.647-1.392-1.014a9.364 9.364 0 0 1-1.03-1.019 7.012 7.012 0 0 1-1.147-1.774 6.115 6.115 0 0 1-.446-1.39c-.097-.526-.162-1.062-.08-1.602.059-.385.091-.776.164-1.16.05-.254.139-.503.227-.748a6.819 6.819 0 0 1 .954-1.745 8.27 8.27 0 0 1 1.184-1.261 9.053 9.053 0 0 1 1.646-1.142 12.832 12.832 0 0 1 1.528-.71 21.378 21.378 0 0 1 1.913-.615c.475-.13.967-.206 1.452-.297a23.84 23.84 0 0 1 1.091-.176c.235-.033.471-.052.707-.066.431-.026.86-.042 1.29-.064.017-.001.032-.019.048-.028h.94v6.118c-.06.003-.111.007-.16.007-.486-.01-.971-.04-1.454-.025-.59.019-1.178.053-1.762.121-.615.073-1.225.186-1.832.297a13.19 13.19 0 0 0-2.654.795 9.154 9.154 0 0 0-1.692.89c-.513.352-.963.759-1.253 1.307-.227.433-.259.892-.152 1.36.159.694.54 1.27 1.02 1.797.444.49.95.909 1.51 1.26.473.298.972.56 1.472.816.806.413 1.67.69 2.55.907.52.128 1.053.212 1.585.28.511.064 1.028.103 1.542.12.49.016.985.02 1.471-.033a8.425 8.425 0 0 0 2.64-.726 7.584 7.584 0 0 0 1.687-1.06 7.561 7.561 0 0 0 1.391-1.497 6.982 6.982 0 0 0 1.111-2.507c.09-.41.154-.827.188-1.244.035-.449.048-.902.029-1.351-.017-.39-.084-.777-.148-1.162a5.835 5.835 0 0 0-.208-.936 12.423 12.423 0 0 0-.52-1.286c-.202-.441-.496-.837-.806-1.218-.531-.65-1.19-1.166-1.921-1.583a11.036 11.036 0 0 0-1.603-.731c-.445-.168-.918-.264-1.382-.38-.205-.051-.074-.192-.137-.312.283.015.529.02.776.044.291.029.582.063.869.118.626.12 1.254.233 1.87.388.51.13 1.012.302 1.508.481a12.03 12.03 0 0 1 2.54 1.298c.661.437 1.25.955 1.792 1.52a7.722 7.722 0 0 1 1.192 1.664c.321.594.55 1.228.662 1.89.071.419.111.852.094 1.276a6.443 6.443 0 0 1-.35 1.87 6.988 6.988 0 0 1-.805 1.617c-.2.298-.437.574-.674.846a8.54 8.54 0 0 1-.59.6 8.212 8.212 0 0 1-1.44 1.092zm-8-8.273V23.4c-.207-.023-.403-.035-.593-.074a24.72 24.72 0 0 1-.996-.235 5.93 5.93 0 0 1-1.648-.7 7.185 7.185 0 0 1-.928-.657 4.066 4.066 0 0 1-.88-1.083 2.866 2.866 0 0 1-.352-.983c-.048-.332-.022-.674-.021-1.011 0-.357.123-.687.247-1.017.157-.415.395-.785.68-1.129.471-.567 1.057-1.003 1.717-1.342a6.247 6.247 0 0 1 1.56-.552c.334-.07.682-.086 1.023-.129.06-.006.12-.02.19-.033z"></path></g></svg>';
	}
}
