<?php

declare(strict_types=1);

namespace EDD\Vendor\Square\Models\Builders;

use EDD\Vendor\Core\Utils\CoreHelper;
use EDD\Vendor\Square\Models\CustomAttributeDefinition;
use EDD\Vendor\Square\Models\UpdateMerchantCustomAttributeDefinitionRequest;

/**
 * Builder for model UpdateMerchantCustomAttributeDefinitionRequest
 *
 * @see UpdateMerchantCustomAttributeDefinitionRequest
 */
class UpdateMerchantCustomAttributeDefinitionRequestBuilder
{
    /**
     * @var UpdateMerchantCustomAttributeDefinitionRequest
     */
    private $instance;

    private function __construct(UpdateMerchantCustomAttributeDefinitionRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Update Merchant Custom EDD_EDD_Attribute Definition Request Builder object.
     *
     * @param CustomAttributeDefinition $customAttributeDefinition
     */
    public static function init(CustomAttributeDefinition $customAttributeDefinition): self
    {
        return new self(new UpdateMerchantCustomAttributeDefinitionRequest($customAttributeDefinition));
    }

    /**
     * Sets idempotency key field.
     *
     * @param string|null $value
     */
    public function idempotencyKey(?string $value): self
    {
        $this->instance->setIdempotencyKey($value);
        return $this;
    }

    /**
     * Unsets idempotency key field.
     */
    public function unsetIdempotencyKey(): self
    {
        $this->instance->unsetIdempotencyKey();
        return $this;
    }

    /**
     * Initializes a new Update Merchant Custom EDD_EDD_Attribute Definition Request object.
     */
    public function build(): UpdateMerchantCustomAttributeDefinitionRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
