<?php
/**
 * Pro templates manager.
 *
 * @package     EDD\Pro
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Class Templates
 *
 * @since 3.5.0
 */
class Templates implements SubscriberInterface {

	/**
	 * Get the events to subscribe to.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	public static function get_subscribed_events() {
		return array(
			'edd_template_paths' => array( 'add_templates', 100 ),
		);
	}

	/**
	 * Add the templates.
	 *
	 * @since 3.5.0
	 * @param array $templates The template paths.
	 * @return array
	 */
	public function add_templates( $templates ) {
		// Use priority 20 but auto-increment if there's a conflict.
		$priority = 20;
		while ( isset( $templates[ $priority ] ) ) {
			++$priority;
		}

		$templates[ $priority ] = EDD_PLUGIN_DIR . 'pro/templates/';

		return $templates;
	}
}
