<?php
/**
 * Invoice element.
 *
 * @since 1.4.0
 * @package EDD\Invoices\XML\Elements
 */

namespace EDD\Pro\Invoices\XML\Elements;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Invoice class.
 */
class Invoice extends Element {

	protected function get_data(): array {
		return array(
			'name'       => 'Invoice',
			'attributes' => array(
				'xmlns'     => 'urn:oasis:names:specification:ubl:schema:xsd:Invoice-2',
				'xmlns:cac' => 'urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2',
				'xmlns:cbc' => 'urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2',
			),
			'children'   => array(
				array(
					'name'  => 'cbc:UBLVersionID',
					'value' => '2.1',
				),
				array(
					'name'  => 'cbc:ID',
					'value' => $this->order->customer_id,
				),
				array(
					'name'  => 'cbc:IssueDate',
					'value' => edd_date_i18n( $this->order->date_completed ?: $this->order->date_created, 'Y-m-d' ),
				),
				array(
					'name'       => 'cbc:InvoiceTypeCode',
					'attributes' => array(
						'listID'       => 'UNCL1001',
						'listAgencyID' => '6',
						'value'        => '380',
					),
				),
				array(
					'name'       => 'cbc:DocumentCurrencyCode',
					'value'      => $this->order->currency,
					'attributes' => array(
						'listID'       => 'ISO4217',
						'listAgencyID' => '6',
					),
				),
				array(
					'name'     => 'cac:OrderReference',
					'children' => array(
						array(
							'name'  => 'cbc:ID',
							'value' => $this->order->get_number(),
						),
					),
				),
			),
		);
	}
}
