<?php
/**
 * Invoice Form Template
 *
 * To modify this template, create a folder called `edd_templates` inside of your active theme's directory.
 * Copy this file into that new folder.
 *
 * @version 1.0
 *
 * @var \EDD\Orders\Order|EDD_Payment $order In EDD 3.0, this is the order object; in 2.x, it's the payment object.
 */
$address = edd_invoices_get_order_address( $order );
$vat     = edd_invoices_get_custom_order_meta( $order, 'invoices_vat' );
$notes   = edd_invoices_get_custom_order_meta( $order, 'invoices_notes' );
$company = edd_invoices_get_custom_order_meta( $order, 'invoices_company' );

// Generate form URL.
$url = esc_url( add_query_arg( array(
	'payment_id' => urlencode( $order->ID ),
) ), get_permalink( edd_get_option( 'edd-invoices-page' ) ) );
?>
<style>
	.edd-invoices-div { display: flex; flex-wrap: wrap; margin: 2em 0; }
	.edd-invoices-div label { flex: 0 0 250px; };
</style>
<form action="" method="post" id="edd-invoices">
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__company">
		<label class="edd-invoices-field edd-invoices-custom-field" for="company"><?php esc_html_e( 'Company:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-company" value="<?php echo esc_attr( $company ); ?>" id="company" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__name">
		<label class="edd-invoices-field edd-invoices-custom-field" for="name"><?php esc_html_e( 'Billing Name:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-user-name" value="<?php echo ! empty( $address['name'] ) ? esc_attr( $address['name'] ) : ''; ?>" id="name" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__address1">
		<label class="edd-invoices-field edd-invoices-custom-field" for="address1"><?php esc_html_e( 'Billing Address:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-address[line1]" value="<?php echo( ! empty( $address['line1'] ) ? esc_attr( $address['line1'] ) : '' ); ?>" id="address1" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__address2">
		<label class="edd-invoices-field edd-invoices-custom-field" for="address2"><?php esc_html_e( 'Line 2:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-address[line2]" value="<?php echo( ! empty( $address['line2'] ) ? esc_attr( $address['line2'] ) : '' ); ?>" id="address2" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__city">
		<label class="edd-invoices-field edd-invoices-custom-field" for="city"><?php esc_html_e( 'City:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-address[city]" value="<?php echo( ! empty( $address['city'] ) ? esc_attr( $address['city'] ) : '' ); ?>" id="city" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__zip">
		<label class="edd-invoices-field edd-invoices-custom-field" for="zip"><?php esc_html_e( 'Zip / Postal Code:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-address[zip]" value="<?php echo( ! empty( $address['zip'] ) ? esc_attr( $address['zip'] ) : '' ); ?>" id="zip" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__country">
		<label class="edd-invoices-field edd-invoices-custom-field" for="country"><?php esc_html_e( 'Country:', 'easy-digital-downloads' ); ?></label>
		<select name="edd-payment-address[country]" id="country">
			<?php
			$users_country = ! empty( $address['country'] ) ? $address['country'] : '';
			foreach ( edd_get_country_list() as $key => $value ) {
				?>
				<option value="<?php echo esc_attr( $key ); ?>"<?php selected( $users_country, $key ); ?>><?php echo esc_html( $value ); ?></option>
				<?php
			}
			?>
		</select>
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__state">
		<label class="edd-invoices-field edd-invoices-custom-field" for="state"><?php esc_html_e( 'County / State:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-address[state]" value="<?php echo( ! empty( $address['state'] ) ? esc_attr( $address['state'] ) : '' ); ?>" id="state" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__vat">
		<label class="edd-invoices-field edd-invoices-custom-field" for="vat"><?php esc_html_e( 'Tax/VAT Number:', 'easy-digital-downloads' ); ?></label>
		<input type="text" name="edd-payment-vat" value="<?php echo esc_attr( $vat ); ?>" id="vat" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__notes">
		<label class="edd-invoices-field edd-invoices-custom-field" for="notes"><?php esc_html_e( 'Custom Notes:', 'easy-digital-downloads' ); ?></label>
		<textarea name="edd-payment-notes"><?php echo esc_textarea( $notes ); ?></textarea>
	</div>
	<?php
	if ( ! empty( $address['id'] ) ) {
		?>
		<input name="address-id" type="hidden" value="<?php echo esc_attr( $address['id'] ); ?>" />
		<?php
	}
	?>
	<div class="edd-invoices-div edd-invoices-custom-div edd-invoices-div__generate">
		<?php wp_nonce_field( 'edd-invoices-generate-invoice', 'edd-invoices-nonce' ); ?>
		<input type="submit" formtarget="_blank" class="edd-invoices-generate-invoice-button edd_submit button button-secondary" value="<?php echo esc_attr( apply_filters( 'edd_invoices_generate_invoice_button_text', __( 'Save Billing Details &amp; Generate Invoice', 'easy-digital-downloads' ) ) ); ?>" />
	</div>
</form>
