<?php
/**
 * Invoice Customer Template
 *
 * To modify this template, create a folder called `edd_templates` inside of your active theme's directory.
 * Copy this file into that new folder.
 *
 * @version 1.0
 *
 * @var \EDD\Orders\Order|EDD_Payment $order
 */
?>

<div class="customer">
	<header><?php esc_html_e( 'Invoice To:', 'easy-digital-downloads' ); ?></header>

	<article>
		<?php edd_invoices_do_invoice_edit_button( $order ); ?>

		<div class="address">
			<?php
			$address = edd_invoices_get_order_address( $order );
			$company = edd_invoices_get_custom_order_meta( $order, 'invoices_company' );
			if ( ! empty( $company ) ) {
				?>
				<div class="invoice-label"><?php echo esc_html( $company ); ?></div>
				<?php
			}
			if ( ! empty( $address['name'] ) ) {
				?>
				<div class="invoice-label"><?php echo esc_html( $address['name'] ); ?></div>
				<?php
			}
			$keys = array( 'line1', 'line2', 'city', 'zip', 'state', 'country' );
			foreach ( $keys as $key ) {
				if ( ! empty( $address[ $key ] ) ) {
					echo esc_html( $address[ $key ] ) . '<br />';
				}
			}
			?>
		</div>
		<?php
		// Customer Tax/VAT #
		$vat = edd_invoices_get_custom_order_meta( $order, 'invoices_vat' );
		if ( $vat ) {
			?>
			<!-- Customer Tax/VAT # -->
			<div class="customer-vat">
				<span class="invoice-label"><?php esc_html_e( 'Tax/VAT:', 'easy-digital-downloads' ); ?></span> <?php echo esc_html( $vat ); ?>
			</div>
			<?php
		}

		/**
		 * Fires at the end of the customer details.
		 *
		 * @since 1.3.2
		 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
		 */
		do_action( 'edd_invoices_after_customer_details', $order );
		?>
	</article>
</div>
