<?php
/**
 * Bulk Invoice Template
 *
 * To modify this template, create a folder called `edd_templates` inside of your active theme's directory.
 * Copy this file into that new folder.
 *
 * @version 1.0
 *
 * @var \EDD\Orders\Order|EDD_Payment $order In EDD 3.0, this is the order object; in 2.x, it's the payment object.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
?>
<div class="edd-invoice-multiple <?php echo esc_attr( edd_invoices_get_invoice_body_class( $order ) ); ?>">
	<section class="invoice">
		<header class="invoice-header">
			<?php
			/**
			 * Fires in the invoice header of the invoice template.
			 *
			 * @since 1.2
			 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
			 */
			do_action( 'edd_invoices_invoice_header', $order );
			?>
		</header>
		<main class="invoice-main">
			<section class="contacts">
				<?php
				/**
				 * Fires in the contacts section of the invoice template.
				 *
				 * @since 1.2
				 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
				 */
				do_action( 'edd_invoices_invoice_contacts', $order );
				?>
			</section>
			<section class="items">
				<?php
				/**
				 * Fires in the items section of the invoice template.
				 *
				 * @since 1.2
				 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
				 */
				do_action( 'edd_invoices_invoice_items_table', $order );
				?>
			</section>
			<section class="additional-info">
				<?php
				/**
				 * Fires in the additional info section of the invoice template.
				 *
				 * @since 1.2
				 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
				 */
				do_action( 'edd_invoices_invoice_additional_info', $order );
				?>
			</section>
		</main>
		<footer class="invoice-footer">
			<?php
			/**
			 * Fires in the `footer` of the invoice template.
			 *
			 * @since 1.2
			 * @param \EDD\Orders\Order|EDD_Payment $order The order/payment object.
			 */
			do_action( 'edd_invoices_invoice_footer', $order );
			?>
		</footer>
	</section>
</div>