<?php
/**
 * Invoices admin actions.
 *
 * @package     EDD\Pro\Admin\Invoices
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

/**
 * Adds a "View Invoice" link to the order row actions.
 *
 * @since 3.5.0
 * @param array             $row_actions The array of actions links for the order.
 * @param \EDD\Orders\Order $order       The order object.
 * @return array
 */
function edd_invoices_row_actions( $row_actions, $order ) {

	if ( ! edd_invoices_order_has_invoice( $order->id ) ) {
		return $row_actions;
	}

	$row_actions['invoices'] = sprintf(
		'<a href="%s" target="_blank">%s</a>',
		esc_url( edd_invoices_get_invoice_url( $order->id, true ) ),
		__( 'View Invoice', 'easy-digital-downloads' )
	);

	return $row_actions;
}
add_filter( 'edd_order_row_actions', 'edd_invoices_row_actions', 10, 2 );

/**
 * Adds a "View Invoice" link to the payment/order details screen, after the "Resend Receipt" button.
 *
 * @since 3.5.0
 * @param int $order_id The order ID.
 * @return void
 */
function edd_invoices_show_invoice_link_payment_details( $order_id ) {

	if ( ! edd_invoices_order_has_invoice( $order_id ) ) {
		return;
	}
	?>
	<div class="edd-invoices-actions" style="display:flex;gap:4px">
		<?php
		printf(
			'<a href="%s" class="button button-secondary" target="_blank">%s</a>',
			esc_url( edd_invoices_get_invoice_url( $order_id, true ) ),
			esc_html__( 'View Invoice', 'easy-digital-downloads' )
		);
		printf(
			'<a class="button button-secondary" href="%s">%s</a>',
			esc_url(
				add_query_arg( 'edd_action', 'invoices_generate_xml' )
			),
			esc_html__( 'Generate XML', 'easy-digital-downloads' )
		);
		?>
	</div>
	<?php
}
add_action( 'edd_view_order_details_resend_receipt_after', 'edd_invoices_show_invoice_link_payment_details' );
