<?php
/**
 * VAT Loader class.
 *
 * @package     EDD\Pro\Taxes
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro\Taxes;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\MiniManager;

/**
 * Class Loader
 *
 * @since 3.5.0
 * @package EDD\Upgrades
 */
class Loader extends MiniManager {

	/**
	 * Get the event classes.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	protected function get_event_classes(): array {
		$event_classes = array(
			new \EDD\Pro\Admin\Settings\Taxes(),
		);

		if ( ! $this->can_show_vat() ) {
			return $event_classes;
		}

		$cart            = new VAT\Cart();
		$event_classes[] = $cart;
		$event_classes[] = new VAT\Checkout( $cart );
		$event_classes[] = new VAT\Invoices();
		$event_classes[] = new VAT\Receipt();
		$event_classes[] = new \EDD\Pro\Admin\Orders\Taxes();
		$event_classes[] = new \EDD\Pro\Admin\Settings\VAT();
		$event_classes[] = new \EDD\Pro\Admin\Exports\VAT();
		$event_classes[] = new VAT\Recurring( $cart );

		return $event_classes;
	}

	/**
	 * Check if the VAT section should be shown.
	 *
	 * @since 3.5.0
	 * @return bool
	 */
	private function can_show_vat(): bool {
		if ( function_exists( '\Barn2\Plugin\EDD_VAT\edd_eu_vat' ) ) {
			edd_delete_option( 'vat_enable' );

			return false;
		}

		return edd_get_option( 'vat_enable' ) && edd_is_pro() && ! edd_is_inactive_pro();
	}
}
