<?php
/**
 * Supplier class to get the supplier data.
 *
 * @since 1.4.0
 * @package EDD\Invoices\XML\Elements
 */

namespace EDD\Pro\Invoices\XML\Elements;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Supplier class.
 */
class Supplier extends Element {

	/**
	 * Get the data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	protected function get_data(): array {
		return array(
			'name'     => 'cac:AccountingSupplierParty',
			'children' => array(
				array(
					'name' => 'cbc:CustomerAssignedAccountID',
				),
				array(
					'name'     => 'cac:Party',
					'children' => $this->get_party_data(),
				),
			),
		);
	}

	/**
	 * Get the party data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_party_data() {
		return array(
			array(
				'name'     => 'cac:PartyName',
				'children' => array(
					array(
						'name'  => 'cac:Name',
						'value' => edd_get_option(
							'edd-invoices-company-name',
							edd_get_option( 'entity_name', get_bloginfo( 'name' ) )
						),
					),
				),
			),
			array(
				'name'     => 'cac:PartyTaxScheme',
				'children' => array(
					array(
						'name'  => 'cbc:CompanyID',
						'value' => edd_get_option( 'edd-invoices-tax' ),
					),
				),
			),
			array(
				'name'     => 'cac:PostalAddress',
				'children' => $this->get_address_data(),
			),
			array(
				'name'     => 'cac:Contact',
				'children' => array(
					array(
						'name'  => 'cbc:ElectronicMail',
						'value' => edd_get_option( 'from_email', get_bloginfo( 'admin_email' ) ),
					),
				),
			),
		);
	}

	/**
	 * Get the address data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_address_data() {
		return array(
			array(
				'name'  => 'cbc:StreetName',
				'value' => edd_get_option( 'business_address' ),
			),
			array(
				'name'  => 'cbc:AdditionalStreetName',
				'value' => edd_get_option( 'business_address_2' ),
			),
			array(
				'name'  => 'cbc:CityName',
				'value' => edd_get_option( 'business_city' ),
			),
			array(
				'name'  => 'cbc:PostalZone',
				'value' => edd_get_option( 'business_postal_code' ),
			),
			array(
				'name'     => 'cac:Country',
				'children' => array(
					array(
						'name'       => 'cbc:IdentificationCode',
						'value'      => edd_get_option( 'base_country' ) . ':' . edd_get_option( 'base_state' ),
						'attributes' => array(
							'listID'       => 'ISO3166-1:Alpha2',
							'listAgencyID' => '6',
						),
					),
				),
			),
		);
	}
}
