<?php
/**
 * InvoiceLine class to get the order item data.
 *
 * @since 1.4.0
 * @package EDD\Invoices\XML\Elements
 */

namespace EDD\Pro\Invoices\XML\Elements;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * InvoiceLine class.
 */
class InvoiceLine extends Element {

	/**
	 * Gets the data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	protected function get_data(): array {
		return array(
			'name'     => 'cac:InvoiceLine',
			'children' => $this->get_item_data(),
		);
	}

	/**
	 * Get the item data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_item_data() {
		$item = $this->item;

		return array(
			array(
				'name'  => 'cbc:ID',
				'value' => uniqid(),
			),
			array(
				'name'  => 'cbc:InvoicedQuantity',
				'value' => $item->quantity,
			),
			array(
				'name'       => 'cbc:LineExtensionAmount',
				'value'      => $this->format_number( $item->quantity * $item->subtotal ),
				'attributes' => array(
					'currencyID' => $this->order->currency,
				),
			),
			array(
				'name'     => 'cac:TaxTotal',
				'children' => array(
					array(
						'name'       => 'cbc:TaxAmount',
						'value'      => $this->format_number( $item->tax ),
						'attributes' => array(
							'currencyID' => $this->order->currency,
						),
					),
				),
			),
			array(
				'name'     => 'cac:Item',
				'children' => array(
					array(
						'name'  => 'cbc:Description',
						'value' => $item->product_name,
					),
				),
			),
		);
	}
}
