<?php
/**
 * Cron loader.
 *
 * @package     EDD\Pro\Cron
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro\Cron;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Cron loader.
 *
 * @since 3.5.0
 */
class Loader implements SubscriberInterface {

	/**
	 * Get the subscribed events.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	public static function get_subscribed_events(): array {
		return array(
			'edd_cron_components' => 'load_components',
		);
	}

	/**
	 * Load the components.
	 *
	 * @since 3.5.0
	 * @param array $components The components.
	 * @return array
	 */
	public function load_components( $components ): array {
		if ( ! function_exists( '\Barn2\Plugin\EDD_VAT\edd_eu_vat' ) ) {
			$components[] = Components\VATRates::class;
		}

		return $components;
	}
}
