<?php
/**
 * Pro Settings Loader.
 *
 * @package     EDD\Pro\Invoices
 * @copyright   Copyright (c) 2024, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro\Admin\Settings;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\EventManagement\SubscriberInterface;
use EDD\EventManagement\EventManager;

/**
 * Class Handler
 *
 * @since 3.2.8
 */
class Handler implements SubscriberInterface {

	/**
	 * Returns an array of events that this subscriber wants to listen to.
	 *
	 * @return array
	 */
	public static function get_subscribed_events() {
		return array(
			'plugins_loaded'        => 'add_events',
			'edd_settings_gateways' => 'add_geoip_settings',
		);
	}

	/**
	 * Add the events.
	 *
	 * @since 3.5.0
	 * @return void
	 */
	public function add_events() {
		$settings_classes = array(
			new Invoices(),
		);
		$events           = new EventManager();
		foreach ( $settings_classes as $settings_class ) {
			$events->add_subscriber( $settings_class );
		}
	}

	/**
	 * Update the GeoIP settings in the settings array.
	 *
	 * @param array $settings The settings array.
	 * @return array
	 */
	public function add_geoip_settings( $settings ) {
		if ( edd_is_inactive_pro() || empty( $settings['checkout']['geolocation'] ) ) {
			return $settings;
		}

		$settings['checkout']['geolocation']['options']  = array(
			'disabled'   => __( 'Disabled', 'easy-digital-downloads' ),
			'enabled'    => __( 'Always Enabled', 'easy-digital-downloads' ),
			'logged_out' => __( 'Enabled for logged out users only', 'easy-digital-downloads' ),
		);
		$settings['checkout']['geolocation']['desc']     = __( 'Increase conversions by auto-detecting the country and region for customers at checkout.', 'easy-digital-downloads' );
		$settings['checkout']['geolocation']['std']      = 'enabled';
		$settings['checkout']['geolocation']['disabled'] = false;

		return $settings;
	}
}
