<?php
/**
 * Invoice Company Template
 *
 * @package EDD\Pro\Templates\Invoice
 * @copyright (c) 2025, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 *
 * @var \EDD\Orders\Order $order
 */

use EDD\Pro\Taxes\VAT\Company;

$company     = Company::get();
$vat_numbers = Company::get_numbers();

?>

<div class="storefront">
	<header>
		<?php esc_html_e( 'Invoice From:', 'easy-digital-downloads' ); ?>
	</header>

	<article>
		<div class="address">
			<?php
			// Company Name.
			if ( $company->name ) {
				?>
				<div class="invoice-label"><?php echo esc_html( $company->name ); ?></div>
				<?php
			}

			// Address + Company Details.
			echo wp_kses_post( nl2br( $company->formatted_address ) );
			?>
		</div>
		<?php

		// Vendor Company Registration.
		$company_reg = edd_get_option( 'edd-invoices-number' );
		if ( $company_reg ) {
			?>
			<!-- Vendor Company Registration # -->
			<div class="storefront__registration">
				<span class="invoice-label"><?php esc_html_e( 'Registration:', 'easy-digital-downloads' ); ?></span> <?php echo esc_html( $company_reg ); ?>
			</div>
			<?php
		}

		// Vendor Tax/VAT numbers.
		if ( $vat_numbers ) {
			?>
			<!-- Vendor Tax/VAT # -->
			<div class="storefront__vat">
				<span class="invoice-label"><?php esc_html_e( 'Tax/VAT:', 'easy-digital-downloads' ); ?></span> <?php echo esc_html( $vat_numbers ); ?>
			</div>
			<?php
		}

		/**
		 * Fires at the end of the company details.
		 *
		 * @since 3.5.0
		 * @param \EDD\Orders\Order $order The order/payment object.
		 */
		do_action( 'edd_invoices_after_company_details', $order );
		?>
	</article>
</div>
