<?php
/**
 * Invoice Functions.
 *
 * @package     EDD\Pro\Invoices
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

/**
 * Shows the form to allow the user to enter their billing information, before seeing an on-screen
 * HTML invoice.
 *
 * @param array  $atts    The shortcode attributes.
 * @param string $content The post content.
 *
 * @since 3.5.0
 * @return string
 */
function edd_invoices_shortcode( $atts, $content = '' ) {
	if ( ! edd_get_option( 'edd-invoices-page' ) ) {
		return '';
	}

	$generator = new EDD\Pro\Invoices\Generator();
	$generator->validate_request();

	if ( ! $generator->is_valid_request() ) {
		return implode( '<br>', $generator->get_error_messages() );
	}

	if ( ! edd_invoices_can_user_edit_invoice_data( get_current_user_id() ) ) {
		return __( 'You do not have permission to update this invoice.', 'easy-digital-downloads' );
	}
	set_query_var( 'order', $generator->order );

	ob_start();
	edd_get_template_part( 'invoice/invoice-form' );

	return ob_get_clean();
}
add_shortcode( 'edd_invoices', 'edd_invoices_shortcode' );
