<?php
/**
 * Invoices email tags.
 *
 * @package     EDD\Pro\Admin\Invoices
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

/**
 * Register an email tag to view an invoice.
 *
 * @since 3.5.0
 * @return void
 */
function edd_invoices_register_email_tag() {
	edd_add_email_tag(
		'edd_invoice',
		__( 'Creates a link to a printable invoice.', 'easy-digital-downloads' ),
		'edd_invoices_get_email_invoice_link',
		__( 'Invoice', 'easy-digital-downloads' ),
		array( 'order' )
	);
}
add_action( 'edd_add_email_tags', 'edd_invoices_register_email_tag' );

/**
 * Gets the invoice URL to include in an email.
 *
 * @since 3.5.0
 * @param int $order_id The order ID.
 * @return string
 */
function edd_invoices_get_email_invoice_link( $order_id ) {
	if ( ! edd_invoices_order_has_invoice( $order_id ) ) {
		return '';
	}

	return sprintf(
		'<a href="%s">%s</a>',
		esc_url( edd_invoices_get_invoice_url( $order_id, true ) ),
		__( 'View Invoice', 'easy-digital-downloads' )
	);
}
