document.addEventListener( 'DOMContentLoaded', function () {

	// Adds a listener to the "Download PDF" button on the HTML invoice.
	const button = document.querySelector( '.button.pdf' );
	if ( button ) {
		button.addEventListener( 'click', function () {
			edd_invoices_do_html2pdf( document.body, button.getAttribute( 'data-name' ) );
		} );
	}
} );

/**
 * Initializes `html2pdf` to create and save the PDF file.
 * @param {string} source   The data/HTML for the PDF.
 * @param {string} filename The filename to use for saving the PDF.
 */
function edd_invoices_do_html2pdf ( source, filename ) {
	html2pdf( source, edd_invoices_html2pdf_options( filename ) );
}

/**
 * Gets the options for the `html2pdf` function.
 *
 * @param {string} filename
 * @returns {array}
 */
function edd_invoices_html2pdf_options ( filename ) {
	let options = eddInvoicesPDF.html2pdf;
	options.filename = filename;

	return options;
}
