document.addEventListener( 'DOMContentLoaded', function () {

	const actions = document.querySelector( '.edd-invoices-bulk__actions' );
	if ( actions ) {
		// move the button to be immediately after #doaction button
		const doaction = document.querySelector( '#doaction' );
		if ( doaction ) {
			doaction.insertAdjacentElement( 'afterend', actions );
			actions.classList.remove( 'edd-hidden' );
		}

		const checkboxes = document.querySelectorAll( 'th.check-column input' );
		const checkAll = document.querySelector( '#cb-select-all-1' );
		const button = document.querySelector( '.edd-invoices-bulk' );

		function toggleActionButton () {
			const anyChecked = Array.from( checkboxes ).some( checkbox => checkbox.checked );
			button.disabled = !anyChecked;

			// if the button is disabled, remove the button-primary class and add button-secondary
			if ( button.disabled ) {
				button.classList.remove( 'button-primary' );
				button.classList.add( 'button-secondary' );
			} else {
				button.classList.remove( 'button-secondary' );
				button.classList.add( 'button-primary' );
			}
		}

		checkAll.addEventListener( 'change', function () {
			checkboxes.forEach( checkbox => {
				checkbox.dispatchEvent( new Event( 'change' ) ); // Manually trigger change event
			} );
		} );

		checkboxes.forEach( checkbox => {
			checkbox.addEventListener( 'change', toggleActionButton );
		} );

		button.addEventListener( 'click', function ( e ) {
			e.preventDefault();
			// Remove the help tip once the button is clicked.
			const helpTip = button.nextElementSibling;
			if ( helpTip && helpTip.classList.contains( 'edd-help-tip' ) ) {
				helpTip.remove();
			}
			button.classList.add( 'updating-message' );
			button.classList.add( 'button-secondary' );
			button.classList.remove( 'button-primary' );
			button.setAttribute( 'disabled', true );
			button.textContent = EDDInvoices.running;
			const checkedCheckboxes = document.querySelectorAll( 'th.check-column input:checked' );
			let ids = [];
			checkedCheckboxes.forEach( function ( input ) {
				ids.push( input.value );
			} );
			if ( ids.length === 0 ) {
				button.classList.remove( 'updating-message' );
				button.textContent = EDDInvoices.text;
				return;
			}

			const formData = new FormData();
			formData.append( 'action', 'edd_invoices_bulk' );
			formData.append( 'ids', ids );
			formData.append( 'nonce', EDDInvoices.nonce );
			fetch( EDDInvoices.ajaxurl, {
				method: 'POST',
				body: formData
			} ).then( function ( response ) {
				return response.json();
			} ).then( function ( responseData ) {
				var bulkInvoices = window.open( "", "_blank", "popup=yes,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=1024,height=768" );
				bulkInvoices.document.write( responseData.data );
				setTimeout( function() {
					bulkInvoices.window.print();
				}, 500 );
			} ).then( function () {
				complete( button, checkboxes, checkAll );
			} );
		} );
	}

	function complete ( button, checkboxes, checkAll ) {
		button.classList.remove( 'updating-message' );
		button.classList.add( 'updated-message' );
		setTimeout( function () {
			button.classList.remove( 'updated-message' );
			button.textContent = EDDInvoices.text;
			checkboxes.forEach( checkbox => {
				checkbox.checked = false;
			} );
			checkAll.checked = false;
		}, 2000 );
	}
} );
