<?php
/**
 * Pro templates manager.
 *
 * @package     EDD\Pro
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Class Templates
 *
 * @since 3.5.0
 */
class Templates implements SubscriberInterface {

	/**
	 * Get the events to subscribe to.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	public static function get_subscribed_events() {
		return array(
			'edd_template_paths' => 'add_templates',
		);
	}

	/**
	 * Add the templates.
	 *
	 * @since 3.5.0
	 * @param array $templates The template paths.
	 * @return array
	 */
	public function add_templates( $templates ) {
		$templates[20] = EDD_PLUGIN_DIR . 'pro/templates/';

		return $templates;
	}
}
