<?php
/**
 * Custom VAT service.
 *
 * @package     EDD\Pro\Taxes\Services
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro\Taxes\Services;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Pro\Taxes\VAT\Result;

/**
 * Custom VAT service.
 *
 * @since 3.5.0
 */
class Custom extends Service {

	/**
	 * Checks if the service is available.
	 *
	 * @since 3.5.0
	 * @return bool
	 */
	public function requirements_met(): bool {
		return has_filter( 'edd_vat_custom_request_result' );
	}

	/**
	 * Handles the request and returns the result.
	 *
	 * @since 3.5.0
	 * @return void
	 */
	protected function validate(): void {
		/**
		 * Filter: allows developers to return a customized response.
		 * Useful when wanting to use third party services to validate the VAT number.
		 *
		 * @param Result $result
		 * @param string $vat_number
		 * @param string $country_code
		 * @return Result
		 */
		$this->result = apply_filters( 'edd_vat_custom_request_result', $this->result, $this->vat_number, $this->country_code );
	}

	/**
	 * Gets the endpoint.
	 *
	 * @since 3.5.0
	 * @return string
	 */
	protected function get_endpoint(): string {
		return '';
	}
}
