<?php

namespace EDD\Pro\Invoices\XML\Elements;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

class TaxTotal extends Element {

	/**
	 * Get the data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	protected function get_data(): array {
		return array(
			'name'     => 'cac:TaxTotal',
			'children' => array(
				array(
					'name'       => 'cbc:TaxAmount',
					'value'      => $this->format_number( $this->order->tax ),
					'attributes' => array(
						'currencyID' => $this->order->currency,
					),
				),
			),
		);
	}
}
