<?php
/**
 * Buyer class to get the buyer data.
 *
 * @since 1.4.0
 * @package EDD\Invoices\XML\Elements
 */

namespace EDD\Pro\Invoices\XML\Elements;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Buyer class.
 */
class Buyer extends Element {

	/**
	 * Get the data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	protected function get_data(): array {
		return array(
			'name'     => 'cac:AccountingCustomerParty',
			'children' => $this->get_buyer_data(),
		);
	}

	/**
	 * Get the supplier data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_buyer_data() {
		return array(
			array(
				'name'  => 'cbc:CustomerAssignedAccountID',
				'value' => $this->order->customer_id,
			),
			array(
				'name'     => 'cac:Party',
				'children' => $this->get_party_data(),
			),
		);
	}

	/**
	 * Get the party data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_party_data() {
		$customer = edd_get_customer( $this->order->customer_id );

		return array(
			array(
				'name'     => 'cac:PartyName',
				'children' => array(
					array(
						'name'  => 'cbc:Name',
						'value' => $customer->name,
					),
				),
			),
			array(
				'name'     => 'cac:PartyTaxScheme',
				'children' => array(
					array(
						'name'  => 'cbc:CompanyID',
						'value' => edd_invoices_get_custom_order_meta( $this->order, 'invoices_vat' ),
					),
					array(
						'name'     => 'cac:TaxScheme',
						'children' => array(
							array(
								'name'       => 'cbc:ID',
								'value'      => 'VAT',
								'attributes' => array(
									'schemeID'       => 'UN/ECE 5153',
									'schemeAgencyID' => '6',
								),
							),
						),
					),
				),
			),
			array(
				'name'     => 'cac:PostalAddress',
				'children' => $this->get_address_data(),
			),
			array(
				'name'     => 'cac:Contact',
				'children' => array(
					array(
						'name'  => 'cbc:Name',
						'value' => $customer->name,
					),
					array(
						'name'  => 'cbc:ElectronicMail',
						'value' => $customer->email,
					),
				),
			),
		);
	}

	/**
	 * Get the address data.
	 *
	 * @since 1.4.0
	 * @return array
	 */
	private function get_address_data() {
		$address = edd_invoices_get_order_address( $this->order );

		return array(
			array(
				'name'  => 'cbc:StreetName',
				'value' => $address['line1'],
			),
			array(
				'name'  => 'cbc:AdditionalStreetName',
				'value' => $address['line2'],
			),
			array(
				'name'  => 'cbc:CityName',
				'value' => $address['city'],
			),
			array(
				'name'  => 'cbc:PostalZone',
				'value' => $address['zip'],
			),
			array(
				'name'  => 'cbc:CountrySubentity',
				'value' => $address['state'],
			),
			array(
				'name'     => 'cac:Country',
				'children' => array(
					array(
						'name'       => 'cbc:IdentificationCode',
						'value'      => $address['country'],
						'attributes' => array(
							'listID'       => 'ISO3166-1:Alpha2',
							'listAgencyID' => '6',
						),
					),
				),
			),
		);
	}
}
