<?php
/**
 * Settings handling for taxes.
 *
 * @package     EDD\Pro\Admin\Settings
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.0
 */

namespace EDD\Pro\Admin\Settings;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Settings handling for taxes.
 *
 * @since 3.5.0
 */
class Taxes implements SubscriberInterface {

	/**
	 * Get the subscribed events.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	public static function get_subscribed_events(): array {
		return array(
			'edd_settings_taxes' => 'add_settings',
		);
	}

	/**
	 * Update the settings.
	 *
	 * @since 3.5.0
	 * @param array $settings The settings array.
	 * @return array
	 */
	public function add_settings( $settings ): array {
		if ( empty( $settings['main']['vat_enable'] ) ) {
			return $settings;
		}

		if ( edd_is_inactive_pro() ) {
			$description = __( 'Activate your EDD Pro license to enable EU VAT functionality.', 'easy-digital-downloads' );
			if ( empty( $settings['main']['vat_enable']['desc'] ) ) {
				$settings['main']['vat_enable']['desc'] = $description;
			} else {
				$settings['main']['vat_enable']['desc'] .= '<br />' . $description;
			}
		} else {
			$settings['main']['vat_enable']['options']['disabled'] = false;
		}

		return $settings;
	}
}
