<?php
/**
 * Bulk Invoice Template - Header
 *
 * To modify this template, create a folder called `edd_templates` inside of your active theme's directory.
 * Copy this file into that new folder.
 *
 * @version 1.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php esc_html_e( 'Bulk Invoices Export', 'easy-digital-downloads' ); ?></title>
		<?php edd_invoices_load_stylesheet(); ?>
	</head>
	<body class="bulk-invoices">
		<div id="bulk-invoices-print-notice">
			<p>
				<?php esc_html_e( 'A print dialog should open automatically where you can use the Print dialog to save the invoices as a PDF.', 'easy-digital-downloads' ); ?>
				<?php
				printf(
					/* translators: %s: the URL to the PDF invoices documentation */
					__( 'View the <a href="%s" target="_blank">documentation</a> for more information on how to export invoices as a PDF.', 'easy-digital-downloads' ),
					edd_link_helper(
						'https://easydigitaldownloads.com/docs/edd-invoices---installation/',
						array(
							'utm_medium'  => 'bulk-invoices',
							'utm_content' => 'documentation',
						)
					)
				);
				?>
				<?php esc_html_e( 'If the print dialog does not open, click the button below.', 'easy-digital-downloads' ); ?>
			</p>
			<p>
				<button class="button button-primary" id="bulk-invoices-print-button" onclick="window.print()">
					<?php esc_html_e( 'Print Invoices', 'easy-digital-downloads' ); ?>
				</button>
			</p>
		</div>
