<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://coderockz.com
 * @since             1.0.0
 * @package           Coderockz_Woo_Delivery
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce Delivery & Pickup Date Time Pro
 * Plugin URI:        https://coderockz.com
 * Description:       WooCommerce Delivery & Pickup Date Time is a WooCommerce plugin extension that gives the facility of selecting delivery/pickup date and time on order checkout page. Moreover, you don't need to worry about the styling because the plugin adjusts with your WordPress theme.
 * Version:           1.4.66
 * Author:            CodeRockz
 * Author URI:        https://coderockz.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       coderockz-woo-delivery
 * Domain Path:       /languages
 * WC tested up to:   10.1.2
 * Requires Plugins:  woocommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

add_filter( 'doing_it_wrong_trigger_error', function( $status, $function_name ) {
    if ( '_load_textdomain_just_in_time' === $function_name ) {
        return false;
    }
    return $status;
}, 10, 2 );

/**
 * Current plugin version.
 * Rename this for your plugin and update it as you release new versions.
*/
define( 'CODEROCKZ_WOO_DELIVERY_VERSION', '1.4.66' );


if( ! class_exists( 'coderockzWooDeliveryPluginUpdateChecker' ) ) {

	class coderockzWooDeliveryPluginUpdateChecker{

		public $plugin_slug;
		public $version;
		public $cache_key;
		public $cache_allowed;

		public function __construct() {

			$this->plugin_slug = plugin_basename( __DIR__ );
			$this->version = CODEROCKZ_WOO_DELIVERY_VERSION;
			$this->cache_key = 'coderockz_woo_delivery_plugin_update';
			$this->cache_allowed = true;
				
			add_filter( 'plugins_api', array( $this, 'info' ), 20, 3 );

			add_filter( 'site_transient_update_plugins', array( $this, 'update' ) );
		
			add_action( 'upgrader_process_complete', array( $this, 'purge' ), 10, 2 );
		}

		public function request(){

			$remote = get_transient( $this->cache_key );

			if(get_option('coderockz_woo_delivery_last_failed_update_check') !== false && time() >= (int)get_option('coderockz_woo_delivery_last_failed_update_check') ) {
				delete_option('coderockz_woo_delivery_last_failed_update_check');
			}

			if( (false === $remote && get_option('coderockz_woo_delivery_last_failed_update_check') === false) || ! $this->cache_allowed ) {

				$remote = wp_remote_post(
					'https://coderockz.com/plugin-update-server/woo-delivery/info.php', 
					array(
						'timeout' => 45,
                    	'sslverify' => false,
                    	'body' => array(
							'license_key' => get_option( 'coderockz-woo-delivery-license-key' ),
							'download_id' => 9630,
							'site_url' => home_url(),
							'current_version' => $this->version
						),
						'headers' => array(
							'Accept' => 'application/json'
						)
					)
				);

				if(
					is_wp_error( $remote )
					|| 200 !== wp_remote_retrieve_response_code( $remote )
					|| empty( wp_remote_retrieve_body( $remote ) )
				) {
					update_option('coderockz_woo_delivery_last_failed_update_check', time() + 60*60*24 );
					return false;
				}

				set_transient( $this->cache_key, $remote, 60*60*24 );
			}

			$remote = json_decode( wp_remote_retrieve_body( $remote ) );

			return $remote;

		}


		function info( $res, $action, $args ) {

			// do nothing if you're not getting plugin information right now
			if( 'plugin_information' !== $action ) {
				return $res;
			}

			// do nothing if it is not our plugin
			if( $this->plugin_slug !== $args->slug ) {
				return $res;
			}

			// get updates
			$remote = $this->request();

			if( ! $remote ) {
				return $res;
			}

			$res = new stdClass();

			$res->name = $remote->name;
			$res->slug = $remote->slug;
			$res->version = $remote->version;
			$res->tested = $remote->tested;
			$res->requires = $remote->requires;
			$res->author = $remote->author;
			$res->author_profile = $remote->author_homepage;
			$res->download_link = $remote->download_url;
			$res->trunk = $remote->download_url;
			$res->last_updated = $remote->last_updated;

			$res->sections = array(
				'description' => $remote->sections->description,
				'installation' => $remote->sections->installation,
				'changelog' => $remote->sections->changelog
			);

			if( ! empty( $remote->banners ) ) {
				$res->banners = array(
					'low' => $remote->banners->low,
					'high' => $remote->banners->high
				);
			}

			if( ! empty( $remote->icons ) ) {
			    $res->icons = array(
			        'default' => $remote->icons->default
			    );
			}

			return $res;

		}

		public function update( $transient ) {

			if ( empty($transient->checked ) ) {
				return $transient;
			}

			$remote = $this->request();

			if( ! $remote ) {
				return $transient;
			}

			if(
				$remote
				&& version_compare( $this->version, $remote->version, '<' )
				&& version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
			) {
				$res = new stdClass();
				$res->slug = $this->plugin_slug;
				$res->plugin = plugin_basename( __FILE__ );
				$res->new_version = $remote->version;
				$res->tested = $remote->tested;
				$res->package = $remote->download_url;

				if( isset( $remote->icons ) ) {
				    $res->icons = json_decode(json_encode($remote->icons), true);
				}

				$transient->response[ $res->plugin ] = $res;

	    }

			return $transient;

		}

		public function purge( $upgrader, $options ){

			if (
				$this->cache_allowed
				&& 'update' === $options['action']
				&& 'plugin' === $options[ 'type' ]
			) {
				// just clean the cache when new plugin version is installed
				delete_transient( $this->cache_key );
			}

		}


	}

	new coderockzWooDeliveryPluginUpdateChecker();
}

add_action( 'in_plugin_update_message-coderockz-woocommerce-delivery-date-time-pro/coderockz-woo-delivery.php', 'coderockz_woo_delivery_additional_update_message', 10, 2 );
function coderockz_woo_delivery_additional_update_message( $plugin_info_array, $plugin_info_object ) {
	if( empty( $plugin_info_array[ 'package' ] ) ) {
		echo '<i> '.__( 'Your license key is expired or invalid or inactive.', 'coderockz-woo-delivery' ).'</i>';
	}
}

if ( function_exists('is_plugin_active') && is_plugin_active('woo-delivery/coderockz-woo-delivery.php') ) {
    $current_page_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] .  $_SERVER['REQUEST_URI'];
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
   	deactivate_plugins('woo-delivery/coderockz-woo-delivery.php');
   	wp_redirect( $current_page_url );
	exit;
}

if ( true ) {

    if(!defined("CODEROCKZ_WOO_DELIVERY_DIR"))
	    define("CODEROCKZ_WOO_DELIVERY_DIR",plugin_dir_path(__FILE__));
	if(!defined("CODEROCKZ_WOO_DELIVERY_URL"))
	    define("CODEROCKZ_WOO_DELIVERY_URL",plugin_dir_url(__FILE__));
	if(!defined("CODEROCKZ_WOO_DELIVERY"))
	    define("CODEROCKZ_WOO_DELIVERY",plugin_basename(__FILE__));

	/**
	 * The code that runs during plugin activation.
	 * This action is documented in includes/class-coderockz-woo-delivery-activator.php
	 */
	function activate_coderockz_woo_delivery() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-coderockz-woo-delivery-activator.php';
		Coderockz_Woo_Delivery_Activator::activate();
	}

	/**
	 * The code that runs during plugin deactivation.
	 * This action is documented in includes/class-coderockz-woo-delivery-deactivator.php
	 */
	function deactivate_coderockz_woo_delivery() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-coderockz-woo-delivery-deactivator.php';
		Coderockz_Woo_Delivery_Deactivator::deactivate();
	}

	register_activation_hook( __FILE__, 'activate_coderockz_woo_delivery' );
	register_deactivation_hook( __FILE__, 'deactivate_coderockz_woo_delivery' );

	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require plugin_dir_path( __FILE__ ) . 'includes/class-coderockz-woo-delivery.php';

	/**
	 * Begins execution of the plugin.
	 *
	 * Since everything within the plugin is registered via hooks,
	 * then kicking off the plugin from this point in the file does
	 * not affect the page life cycle.
	 *
	 * @since    1.0.0
	 */
	function run_coderockz_woo_delivery() {

		$plugin = new Coderockz_Woo_Delivery();
		$plugin->run();

	}
	run_coderockz_woo_delivery();

	add_action( 'before_woocommerce_init', function() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	} );

	require_once CODEROCKZ_WOO_DELIVERY_DIR . 'includes/class-coderockz-woo-delivery-licenseing-manager.php';
	new Coderockz_Woo_Delivery_Licensing_Manager();

	if(isset($_COOKIE['coderockz_woo_delivery_available_shipping_methods'])) {
	    unset($_COOKIE["coderockz_woo_delivery_available_shipping_methods"]);
		//setcookie("coderockz_woo_delivery_available_shipping_methods", null, -1, '/');
	}

}