<?php
	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\IOFactory;
	use PhpOffice\PhpSpreadsheet\Style\Alignment;
	use PhpOffice\PhpSpreadsheet\Style\Fill;
	use Automattic\WooCommerce\Utilities\OrderUtil;
	

	if ( isset($_REQUEST['_wpnonce']) && wp_verify_nonce($_REQUEST['_wpnonce'], 'coderockz_woo_delivery_nonce' ) && isset($_POST['coderockz-woo-delivery-export-excel-quantity-btn']) ) {

		$helper = new Coderockz_Woo_Delivery_Helper();

		$other_settings = get_option('coderockz_woo_delivery_other_settings');
		$hide_metadata_reports_calendar = (isset($other_settings['hide_metadata_reports_calendar']) && !empty($other_settings['hide_metadata_reports_calendar'])) ? $other_settings['hide_metadata_reports_calendar'] : false;

		$filtered_date = sanitize_text_field($_POST['coderockz-woo-delivery-export-excel-quantity-date']);
    	$filtered_delivery_type = sanitize_text_field($_POST[ 'coderockz-woo-delivery-export-excel-quantity-type' ]);
    	$filtered_order_status = $helper->coderockz_woo_delivery_array_sanitize(explode(",",$_POST[ 'coderockz-woo-delivery-export-excel-quantity-order-status' ]));

    	if(isset($_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ])) {
    		$filtered_pickup_location = [];
    		if($this->hpos){
    			$filtered_pickup_location_before = $helper->coderockz_woo_delivery_array_sanitize(explode(",",$_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ]));
    		} else {
    			$filtered_pickup_location_before = $helper->coderockz_woo_delivery_array_sanitize(explode(",",str_replace("\\","", $_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ])));
    		}
    		foreach($filtered_pickup_location_before as $location) {
    			$filtered_pickup_location[] = str_replace("c-w-d",",", $location);
    		}
    		$filtered_pickup_location = array_filter($filtered_pickup_location, 'strlen');
    	} else {
    		$filtered_pickup_location = [];
    	}

		$orders = [];
		$delivery_orders = [];
		$pickup_orders = [];
		if(strpos($filtered_date, ' - ') !== false) {
			$filtered_dates = explode(' - ', $filtered_date);
			
			/*$period = new DatePeriod(new DateTime($filtered_dates[0]), new DateInterval('P1D'), new DateTime($filtered_dates[1].' +1 day'));
		    foreach ($period as $date) {
		        $dates[] = $date->format("Y-m-d");
		    }*/

		    $dates = [];
			$period = $helper->get_date_from_range($filtered_dates[0],$filtered_dates[1]);
			$dates = array_merge($dates, $period);

		    foreach ($dates as $date) {
		    	if($filtered_delivery_type == "delivery"){
		    		if($this->hpos) {
				    	$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'delivery_date',
				                'value'   => date("Y-m-d", strtotime($date)),
				                'compare' => '==',
				            ),
				            array(
				                'key'     => 'delivery_type',
				                'value'   => 'delivery',
				                'compare' => '==',
				            ),
				        ),
				    );
			    } else {
			    	$args = array(
				        'limit' => -1,
				        'delivery_date' => date("Y-m-d", strtotime($date)),
				        'delivery_type' => "delivery",
				        'status' => $filtered_order_status
				    );
			    }
			    $orders_array = wc_get_orders( $args );
			    foreach ($orders_array as $order) {
			    	$orders[] = $order;
			    }
		    	} elseif($filtered_delivery_type == "pickup") {

		    		if(!empty($filtered_pickup_location)) {
		    			foreach($filtered_pickup_location as $location) {
		    				if($this->hpos) {
							$args = array(
						        'limit' => -1,
								'type' => array( 'shop_order' ),
								'status' => $filtered_order_status,
								'meta_query' => array(
						            array(
						                'key'     => 'pickup_date',
						                'value'   => date("Y-m-d", strtotime($date)),
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'pickup_location',
						                'value'   => $location,
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'delivery_type',
						                'value'   => "pickup",
						                'compare' => '==',
						            ),
						        ),
						    );
						} else {
							$args = array(
						        'limit' => -1,
						        'pickup_date' => date("Y-m-d", strtotime($date)),
						        'delivery_type' => "pickup",
						        'status' => $filtered_order_status,
						        'meta_key' => 'pickup_location',
	        					'meta_value' => $location,
						    );
						}
					    $orders_array = wc_get_orders( $args );
					    foreach ($orders_array as $order) {
					    	$orders[] = $order;
					    }
		    			}
			    		
		    		} else {
		    			if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					            array(
					                'key'     => 'delivery_type',
					                'value'   => "pickup",
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($date)),
					        'delivery_type' => "pickup",
					        'status' => $filtered_order_status
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$orders[] = $order;
				    }
		    		}

		    	} else {
		    		if($this->hpos) {
				    	$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'delivery_date',
				                'value'   => date("Y-m-d", strtotime($date)),
				                'compare' => '==',
				            ),
				        ),
				    );
			    } else {
			    	$args = array(
				        'limit' => -1,
				        'delivery_date' => date("Y-m-d", strtotime($date)),
				        'status' => $filtered_order_status
				    );
			    }

			    $orders_array = wc_get_orders( $args );
			    foreach ($orders_array as $order) {
			    	$delivery_orders[] = $order;
			    }

			    
			    if(!empty($filtered_pickup_location)) {
			    	foreach($filtered_pickup_location as $location) {
				    if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					            array(
					                'key'     => 'pickup_location',
					                'value'   => $location,
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($date)),
					        'status' => $filtered_order_status,
					        'meta_key' => 'pickup_location',
	        				'meta_value' => $location,
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$pickup_orders[] = $order;
				    }
				}
		    		} else {
		    			if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($date)),
					        'status' => $filtered_order_status
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$pickup_orders[] = $order;
				    }
		    		}

				    $orders = array_merge($delivery_orders, $pickup_orders);
		    	}
		    	
			    
		    }
			

		} else {

		    if($filtered_delivery_type == "delivery"){
	    		if($this->hpos) {
			    	$args = array(
			        'limit' => -1,
					'type' => array( 'shop_order' ),
					'status' => $filtered_order_status,
					'meta_query' => array(
			            array(
			                'key'     => 'delivery_date',
			                'value'   => date("Y-m-d", strtotime($filtered_date)),
			                'compare' => '==',
			            ),
			            array(
			                'key'     => 'delivery_type',
			                'value'   => 'delivery',
			                'compare' => '==',
			            ),
			        ),
			    );
		    } else {
		    	$args = array(
			        'limit' => -1,
			        'delivery_date' => date("Y-m-d", strtotime($filtered_date)),
			        'delivery_type' => "delivery",
			        'status' => $filtered_order_status
			    );
		    }
		    $orders = wc_get_orders( $args );
	    	} elseif($filtered_delivery_type == "pickup") {

	    		if(!empty($filtered_pickup_location)) {
	    			foreach($filtered_pickup_location as $location) {
				    if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($filtered_date)),
					                'compare' => '==',
					            ),
					            array(
					                'key'     => 'pickup_location',
					                'value'   => $location,
					                'compare' => '==',
					            ),
					            array(
					                'key'     => 'delivery_type',
					                'value'   => "pickup",
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
					        'delivery_type' => "pickup",
					        'status' => $filtered_order_status,
					        'meta_key' => 'pickup_location',
	        				'meta_value' => $location,
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$orders[] = $order;
				    }
				}
	    		} else {
	    			if($this->hpos) {
					$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'pickup_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				            array(
				                'key'     => 'delivery_type',
				                'value'   => "pickup",
				                'compare' => '==',
				            ),
				        ),
				    );
				} else {
					$args = array(
				        'limit' => -1,
				        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
				        'delivery_type' => "pickup",
				        'status' => $filtered_order_status
				    );
				}

			    $orders = wc_get_orders( $args );
	    		}

	    	} else {
	    		if($this->hpos) {
			    	$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'delivery_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				        ),
				    );
			    } else {
			    	$args = array(
				        'limit' => -1,
				        'delivery_date' => date("Y-m-d", strtotime($filtered_date)),
				        'status' => $filtered_order_status
				    );
			    }
			    $delivery_orders = wc_get_orders( $args );

			    if(!empty($filtered_pickup_location)) {
			    	foreach($filtered_pickup_location as $location) {
					    if($this->hpos) {
							$args = array(
						        'limit' => -1,
								'type' => array( 'shop_order' ),
								'status' => $filtered_order_status,
								'meta_query' => array(
						            array(
						                'key'     => 'pickup_date',
						                'value'   => date("Y-m-d", strtotime($filtered_date)),
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'pickup_location',
						                'value'   => $location,
						                'compare' => '==',
						            ),
						        ),
						    );
						} else {
							$args = array(
						        'limit' => -1,
						        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
						        'status' => $filtered_order_status,
						        'meta_key' => 'pickup_location',
	        					'meta_value' => $location,
						    );
						}

					    $orders_array = wc_get_orders( $args );
					    foreach ($orders_array as $order) {
					    	$pickup_orders[] = $order;
					    }
					}
	    		} else {
	    			if($this->hpos) {
					$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'pickup_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				        ),
				    );
				} else {
					$args = array(
				        'limit' => -1,
				        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
				        'status' => $filtered_order_status
				    );
				}

			    $pickup_orders = wc_get_orders( $args );
	    		}

			    $orders = array_merge($delivery_orders, $pickup_orders);
	    	}
		    
		}

		$tableHead = [
			'font'=>[
				'color'=>[
					'rgb'=>'FFFFFF'
				],
				'bold'=>true,
				'size'=>10
			],
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => '538ED5'
				]
			],
		];
		//even row
		$evenRow = [
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => 'ffffff'
				]
			]
		];
		//odd row
		$oddRow = [
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => 'eeeeee'
				]
			]
		];

		//make a new spreadsheet object
		$spreadsheet = new Spreadsheet();
		//get current active sheet (first sheet)
		$sheet = $spreadsheet->getActiveSheet();

		//set default font
		$spreadsheet->getDefaultStyle()
			->getFont()
			->setName('Arial')
			->setSize(10);

		$spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(40);
		$spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(10);

		$spreadsheet->getActiveSheet()
			->setCellValue('A1',__("Product Name","coderockz-woo-delivery"))
			->setCellValue('B1',__("Quantity","coderockz-woo-delivery"));

		$spreadsheet->getActiveSheet()->getStyle('A1:B1')->applyFromArray($tableHead);

		$row=2;
		$product_name = [];
		$product_quantity = [];
		foreach($orders as $order) {
			foreach ( $order->get_items() as $item_id => $item ) {
			   if($item->get_variation_id() == 0) {

			   		$item_name = $item->get_name();
					$item_meta_data = $item->get_formatted_meta_data();
					if(!empty($item_meta_data)) {
						foreach ( $item_meta_data as $meta_id => $meta ) {
							$item_name .= ', '.wp_kses_post( strip_tags($meta->value) );
						}
					}


			   	   if(array_key_exists($item_name,$product_quantity)) {
				   		$product_quantity[$item_name] = $product_quantity[$item_name]+$item->get_quantity();
				   } else {
				   		$product_quantity[$item_name] = $item->get_quantity();
				   }
				   if(!array_key_exists($item_name,$product_name)) {
				   		$product_name[$item_name] = $item_name;
				   }
			   } else {
		   	 	   $variation = new WC_Product_Variation($item->get_variation_id());
				   $item_meta_data = $item->get_formatted_meta_data();
				   $item_name_with_meta = $variation->get_title();
				   
				   if(array_filter($variation->get_variation_attributes())) {
						$item_name_with_meta .= " - ".strip_tags(implode(", ", array_filter($variation->get_variation_attributes(), 'strlen')));   	
					}

					if(!empty($item_meta_data) && !$hide_metadata_reports_calendar) {
				        foreach ( $item_meta_data as $meta_id => $meta ) {
				        	if (!array_key_exists("attribute_".$meta->key,$variation->get_variation_attributes()) || (array_key_exists("attribute_".$meta->key,$variation->get_variation_attributes()) && $variation->get_variation_attributes()["attribute_".$meta->key] == "") )
				            	$item_name_with_meta .= ', '.wp_kses_post( strip_tags($meta->display_value) );

				        }
				    }


				    if(!array_key_exists($item_name_with_meta,$product_name)) {
				   		$product_name[$item_name_with_meta] = $item_name_with_meta;
				    }

				    if(array_key_exists($item_name_with_meta,$product_quantity)) {
				   		$product_quantity[$item_name_with_meta] = $product_quantity[$item_name_with_meta]+$item->get_quantity();
				   } else {
				   		$product_quantity[$item_name_with_meta] = $item->get_quantity();
				   }  
			   }

			}
		}

		foreach ($product_name as $id => $name) {
			
			$spreadsheet->getActiveSheet()
				->setCellValue('A'.$row , $name)
				->setCellValue('B'.$row , $product_quantity[$id]);
			
			if( $row % 2 == 0 ){

				$spreadsheet->getActiveSheet()->getStyle('A'.$row.':B'.$row)->applyFromArray($evenRow)->getAlignment()->setWrapText(true)->setVertical(Alignment::VERTICAL_CENTER);
			}else{

				$spreadsheet->getActiveSheet()->getStyle('A'.$row.':B'.$row)->applyFromArray($oddRow)->getAlignment()->setWrapText(true)->setVertical(Alignment::VERTICAL_CENTER);
			}
			
			$row++;
		}
		$firstRow=1;
		$lastRow=$row-1;
 		$filename = "quantity_sheet(".$filtered_date.").xlsx";
 		ob_end_clean();
		header('Content-disposition: attachment; filename="'.$filename.'"');
		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		ob_clean();
		flush();

 		$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
		$writer->save('php://output');
		exit;

	}

	if ( isset($_REQUEST['_wpnonce']) && wp_verify_nonce($_REQUEST['_wpnonce'], 'coderockz_woo_delivery_nonce' ) && isset($_POST['coderockz-woo-delivery-export-excel-btn']) ) {

		$helper = new Coderockz_Woo_Delivery_Helper();

		$filtered_date = sanitize_text_field($_POST['coderockz-woo-delivery-export-excel-date']);
    	$filtered_delivery_type = sanitize_text_field($_POST[ 'coderockz-woo-delivery-export-excel-type' ]);

    	$filtered_order_status = $helper->coderockz_woo_delivery_array_sanitize(explode(",",$_POST[ 'coderockz-woo-delivery-export-excel-order-status' ]));
    	if(isset($_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ])) {
    		$filtered_pickup_location = [];
    		if($this->hpos){
    			$filtered_pickup_location_before = $helper->coderockz_woo_delivery_array_sanitize(explode(",",$_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ]));
    		} else {
    			$filtered_pickup_location_before = $helper->coderockz_woo_delivery_array_sanitize(explode(",",str_replace("\\","", $_POST[ 'coderockz-woo-delivery-export-excel-quantity-pickup-location' ])));
    		}
    		foreach($filtered_pickup_location_before as $location) {
    			$filtered_pickup_location[] = str_replace("c-w-d",",", $location);
    		}
    		$filtered_pickup_location = array_filter($filtered_pickup_location, 'strlen');
    	} else {
    		$filtered_pickup_location = [];
    	}

    	$delivery_date_settings = get_option('coderockz_woo_delivery_date_settings');			
    	$pickup_date_settings = get_option('coderockz_woo_delivery_pickup_date_settings');			
		$delivery_time_settings = get_option('coderockz_woo_delivery_time_settings');
		$pickup_time_settings = get_option('coderockz_woo_delivery_pickup_time_settings');
		$delivery_pickup_settings = get_option('coderockz_woo_delivery_pickup_location_settings');
		$additional_field_settings = get_option('coderockz_woo_delivery_additional_field_settings');
		$delivery_date_format = (isset($delivery_date_settings['date_format']) && !empty($delivery_date_settings['date_format'])) ? $delivery_date_settings['date_format'] : "F j, Y";
		
		$add_weekday_name = (isset($delivery_date_settings['add_weekday_name']) && !empty($delivery_date_settings['add_weekday_name'])) ? $delivery_date_settings['add_weekday_name'] : false;

		if($add_weekday_name) {
			$delivery_date_format = "l ".$delivery_date_format;
		}

		$pickup_date_format = (isset($pickup_date_settings['date_format']) && !empty($pickup_date_settings['date_format'])) ? $pickup_date_settings['date_format'] : "F j, Y";

		$pickup_add_weekday_name = (isset($pickup_date_settings['add_weekday_name']) && !empty($pickup_date_settings['add_weekday_name'])) ? $pickup_date_settings['add_weekday_name'] : false;

		if($pickup_add_weekday_name) {
			$pickup_date_format = "l ".$pickup_date_format;
		}

		$time_format = (isset($delivery_time_settings['time_format']) && !empty($delivery_time_settings['time_format']))?$delivery_time_settings['time_format']:"12";
		if($time_format == 12) {
			$time_format = "h:i A";
		} elseif ($time_format == 24) {
			$time_format = "H:i";
		}

		$pickup_time_format = (isset($pickup_time_settings['time_format']) && !empty($pickup_time_settings['time_format']))?$pickup_time_settings['time_format']:"12";
		if($pickup_time_format == 12) {
			$pickup_time_format = "h:i A";
		} elseif ($pickup_time_format == 24) {
			$pickup_time_format = "H:i";
		}

		$delivery_date_field_label = (isset($delivery_date_settings['field_label']) && !empty($delivery_date_settings['field_label'])) ? stripslashes($delivery_date_settings['field_label']) : __("Delivery Date","coderockz-woo-delivery");
		$pickup_date_field_label = (isset($pickup_date_settings['pickup_field_label']) && !empty($pickup_date_settings['pickup_field_label'])) ? stripslashes($pickup_date_settings['pickup_field_label']) : __("Pickup Date","coderockz-woo-delivery");
		$delivery_time_field_label = (isset($delivery_time_settings['field_label']) && !empty($delivery_time_settings['field_label'])) ? stripslashes($delivery_time_settings['field_label']) : __("Delivery Time","coderockz-woo-delivery");
		$pickup_time_field_label = (isset($pickup_time_settings['field_label']) && !empty($pickup_time_settings['field_label'])) ? stripslashes($pickup_time_settings['field_label']) : __("Pickup Time","coderockz-woo-delivery");
		$pickup_location_field_label = (isset($pickup_location_settings['field_label']) && !empty($pickup_location_settings['field_label'])) ? stripslashes($pickup_location_settings['field_label']) : __("Pickup Location","coderockz-woo-delivery");
		$additional_field_label = (isset($additional_field_settings['field_label']) && !empty($additional_field_settings['field_label'])) ? $additional_field_settings['field_label'] : __("Special Note for Delivery","coderockz-woo-delivery");
		$other_settings = get_option('coderockz_woo_delivery_other_settings');
		$hide_metadata_reports_calendar = (isset($other_settings['hide_metadata_reports_calendar']) && !empty($other_settings['hide_metadata_reports_calendar'])) ? $other_settings['hide_metadata_reports_calendar'] : false;


		$localization_settings = get_option('coderockz_woo_delivery_localization_settings');
		$delivery_status_not_delivered_text = (isset($localization_settings['delivery_status_not_delivered_text']) && !empty($localization_settings['delivery_status_not_delivered_text'])) ? stripslashes($localization_settings['delivery_status_not_delivered_text']) : __("Not Delivered","coderockz-woo-delivery");
		$delivery_status_delivered_text = (isset($localization_settings['delivery_status_delivered_text']) && !empty($localization_settings['delivery_status_delivered_text'])) ? stripslashes($localization_settings['delivery_status_delivered_text']) : __("Delivery Completed","coderockz-woo-delivery");
		$pickup_status_not_picked_text = (isset($localization_settings['pickup_status_not_picked_text']) && !empty($localization_settings['pickup_status_not_picked_text'])) ? stripslashes($localization_settings['pickup_status_not_picked_text']) : __("Not Picked","coderockz-woo-delivery");
		$pickup_status_picked_text = (isset($localization_settings['pickup_status_picked_text']) && !empty($localization_settings['pickup_status_picked_text'])) ? stripslashes($localization_settings['pickup_status_picked_text']) : __("Pickup Completed","coderockz-woo-delivery");
		$orders = [];
		$delivery_orders = [];
		$pickup_orders = [];

		if(strpos($filtered_date, ' - ') !== false) {
			$filtered_dates = explode(' - ', $filtered_date);
			
			/*$period = new DatePeriod(new DateTime($filtered_dates[0]), new DateInterval('P1D'), new DateTime($filtered_dates[1].' +1 day'));
		    foreach ($period as $date) {
		        $dates[] = $date->format("Y-m-d");
		    }*/

		    $dates = [];
			$period = $helper->get_date_from_range($filtered_dates[0],$filtered_dates[1]);
			$dates = array_merge($dates, $period);

		    foreach ($dates as $date) {
		    	if($filtered_delivery_type == "delivery"){
		    		if($this->hpos) {
				    	$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'delivery_date',
				                'value'   => date("Y-m-d", strtotime($date)),
				                'compare' => '==',
				            ),
				            array(
				                'key'     => 'delivery_type',
				                'value'   => 'delivery',
				                'compare' => '==',
				            ),
				        ),
				    );
			    } else {
			    	$args = array(
				        'limit' => -1,
				        'delivery_date' => date("Y-m-d", strtotime($date)),
				        'delivery_type' => "delivery",
				        'status' => $filtered_order_status
				    );
			    }
			    $orders_array = wc_get_orders( $args );
			    foreach ($orders_array as $order) {
			    	$orders[] = $order;
			    }
		    	} elseif($filtered_delivery_type == "pickup") {

		    		if(!empty($filtered_pickup_location)) {
		    			foreach($filtered_pickup_location as $location) {
		    				if($this->hpos) {
							$args = array(
						        'limit' => -1,
								'type' => array( 'shop_order' ),
								'status' => $filtered_order_status,
								'meta_query' => array(
						            array(
						                'key'     => 'pickup_date',
						                'value'   => date("Y-m-d", strtotime($date)),
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'pickup_location',
						                'value'   => $location,
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'delivery_type',
						                'value'   => "pickup",
						                'compare' => '==',
						            ),
						        ),
						    );
						} else {
							$args = array(
						        'limit' => -1,
						        'pickup_date' => date("Y-m-d", strtotime($date)),
						        'delivery_type' => "pickup",
						        'status' => $filtered_order_status,
						        'meta_key' => 'pickup_location',
	        					'meta_value' => $location,
						    );
						}
					    $orders_array = wc_get_orders( $args );
					    foreach ($orders_array as $order) {
					    	$orders[] = $order;
					    }
		    			}
			    		
		    		} else {
		    			if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					            array(
					                'key'     => 'delivery_type',
					                'value'   => "pickup",
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($date)),
					        'delivery_type' => "pickup",
					        'status' => $filtered_order_status
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$orders[] = $order;
				    }
		    		}

		    	} else {
		    		if($this->hpos) {
				    	$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'delivery_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					        ),
					    );
				    } else {
				    	$args = array(
					        'limit' => -1,
					        'delivery_date' => date("Y-m-d", strtotime($date)),
					        'status' => $filtered_order_status
					    );
				    }

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$delivery_orders[] = $order;
				    }

				    
				    if(!empty($filtered_pickup_location)) {
				    	foreach($filtered_pickup_location as $location) {
						    if($this->hpos) {
								$args = array(
							        'limit' => -1,
									'type' => array( 'shop_order' ),
									'status' => $filtered_order_status,
									'meta_query' => array(
							            array(
							                'key'     => 'pickup_date',
							                'value'   => date("Y-m-d", strtotime($date)),
							                'compare' => '==',
							            ),
							            array(
							                'key'     => 'pickup_location',
							                'value'   => $location,
							                'compare' => '==',
							            ),
							        ),
							    );
							} else {
								$args = array(
							        'limit' => -1,
							        'pickup_date' => date("Y-m-d", strtotime($date)),
							        'status' => $filtered_order_status,
							        'meta_key' => 'pickup_location',
	        						'meta_value' => $location,
							    );
							}

						    $orders_array = wc_get_orders( $args );
						    foreach ($orders_array as $order) {
						    	$pickup_orders[] = $order;
						    }
						}
		    		} else {
		    			if($this->hpos) {
						$args = array(
					        'limit' => -1,
							'type' => array( 'shop_order' ),
							'status' => $filtered_order_status,
							'meta_query' => array(
					            array(
					                'key'     => 'pickup_date',
					                'value'   => date("Y-m-d", strtotime($date)),
					                'compare' => '==',
					            ),
					        ),
					    );
					} else {
						$args = array(
					        'limit' => -1,
					        'pickup_date' => date("Y-m-d", strtotime($date)),
					        'status' => $filtered_order_status
					    );
					}

				    $orders_array = wc_get_orders( $args );
				    foreach ($orders_array as $order) {
				    	$pickup_orders[] = $order;
				    }
		    		}

				    $orders = array_merge($delivery_orders, $pickup_orders);
		    	}
		    	
			    
		    }
			

		} else {

		    if($filtered_delivery_type == "delivery"){
	    		if($this->hpos) {
			    	$args = array(
			        'limit' => -1,
					'type' => array( 'shop_order' ),
					'status' => $filtered_order_status,
					'meta_query' => array(
			            array(
			                'key'     => 'delivery_date',
			                'value'   => date("Y-m-d", strtotime($filtered_date)),
			                'compare' => '==',
			            ),
			            array(
			                'key'     => 'delivery_type',
			                'value'   => 'delivery',
			                'compare' => '==',
			            ),
			        ),
			    );
		    } else {
		    	$args = array(
		        'limit' => -1,
		        'delivery_date' => date("Y-m-d", strtotime($filtered_date)),
		        'delivery_type' => "delivery",
		        'status' => $filtered_order_status
		    	);
		    }
		    $orders = wc_get_orders( $args );
	    	} elseif($filtered_delivery_type == "pickup") {

	    		if(!empty($filtered_pickup_location)) {

	    			foreach($filtered_pickup_location as $location) {

					    if($this->hpos) {
							$args = array(
						        'limit' => -1,
								'type' => array( 'shop_order' ),
								'status' => $filtered_order_status,
								'meta_query' => array(
						            array(
						                'key'     => 'pickup_date',
						                'value'   => date("Y-m-d", strtotime($filtered_date)),
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'pickup_location',
						                'value'   => $location,
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'delivery_type',
						                'value'   => "pickup",
						                'compare' => '==',
						            ),
						        ),
						    );
						} else {
							$args = array(
						        'limit' => -1,
						        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
						        'delivery_type' => "pickup",
						        'status' => $filtered_order_status,
						        'meta_key' => 'pickup_location',
	        					'meta_value' => $location,
						    );
						}

					    $orders_array = wc_get_orders( $args );
					    foreach ($orders_array as $order) {
					    	$orders[] = $order;
					    }
					}
	    		} else {
	    			if($this->hpos) {
					$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'pickup_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				            array(
				                'key'     => 'delivery_type',
				                'value'   => "pickup",
				                'compare' => '==',
				            ),
				        ),
				    );
				} else {
					$args = array(
				        'limit' => -1,
				        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
				        'delivery_type' => "pickup",
				        'status' => $filtered_order_status
				    );
				}

			    $orders = wc_get_orders( $args );
	    		}

	    	} else {
	    		if($this->hpos) {
			    	$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'delivery_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				        ),
				    );
			    } else {
			    	$args = array(
				        'limit' => -1,
				        'delivery_date' => date("Y-m-d", strtotime($filtered_date)),
				        'status' => $filtered_order_status
				    );
			    }
			    $delivery_orders = wc_get_orders( $args );
			    if(!empty($filtered_pickup_location)) {
			    	foreach($filtered_pickup_location as $location) {
					    if($this->hpos) {
							$args = array(
						        'limit' => -1,
								'type' => array( 'shop_order' ),
								'status' => $filtered_order_status,
								'meta_query' => array(
						            array(
						                'key'     => 'pickup_date',
						                'value'   => date("Y-m-d", strtotime($filtered_date)),
						                'compare' => '==',
						            ),
						            array(
						                'key'     => 'pickup_location',
						                'value'   => $location,
						                'compare' => '==',
						            ),
						        ),
						    );
						} else {
							$args = array(
						        'limit' => -1,
						        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
						        'status' => $filtered_order_status,
						        'meta_key' => 'pickup_location',
	        					'meta_value' => $location,
						    );
						}

					    $orders_array = wc_get_orders( $args );
					    foreach ($orders_array as $order) {
					    	$pickup_orders[] = $order;
					    }
					}
	    		} else {
	    			if($this->hpos) {
					$args = array(
				        'limit' => -1,
						'type' => array( 'shop_order' ),
						'status' => $filtered_order_status,
						'meta_query' => array(
				            array(
				                'key'     => 'pickup_date',
				                'value'   => date("Y-m-d", strtotime($filtered_date)),
				                'compare' => '==',
				            ),
				        ),
				    );
				} else {
					$args = array(
				        'limit' => -1,
				        'pickup_date' => date("Y-m-d", strtotime($filtered_date)),
				        'status' => $filtered_order_status
				    );
				}

			    $pickup_orders = wc_get_orders( $args );
	    		}

			    $orders = array_merge($delivery_orders, $pickup_orders);
	    	}
		    
		}

		$tableHead = [
			'font'=>[
				'color'=>[
					'rgb'=>'FFFFFF'
				],
				'bold'=>true,
				'size'=>10
			],
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => '538ED5'
				]
			],
		];
		//even row
		$evenRow = [
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => 'ffffff'
				]
			]
		];
		//odd row
		$oddRow = [
			'fill'=>[
				'fillType' => Fill::FILL_SOLID,
				'startColor' => [
					'rgb' => 'eeeeee'
				]
			]
		];

		//make a new spreadsheet object
		$spreadsheet = new Spreadsheet();
		//get current active sheet (first sheet)
		$sheet = $spreadsheet->getActiveSheet();

		//set default font
		$spreadsheet->getDefaultStyle()
			->getFont()
			->setName('Arial')
			->setSize(10);

		$spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(10);
		$spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(15);
		$spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(15);
		$spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$spreadsheet->getActiveSheet()->getColumnDimension('F')->setWidth(30);
		$spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(30);
		$spreadsheet->getActiveSheet()->getColumnDimension('H')->setWidth(30);
		$spreadsheet->getActiveSheet()->getColumnDimension('I')->setWidth(30);
		$spreadsheet->getActiveSheet()->getColumnDimension('J')->setWidth(10);
		$spreadsheet->getActiveSheet()->getColumnDimension('K')->setWidth(20);
		$spreadsheet->getActiveSheet()->getColumnDimension('L')->setWidth(20);
		$spreadsheet->getActiveSheet()->getColumnDimension('M')->setWidth(20);


		$spreadsheet->getActiveSheet()
			->setCellValue('A1',__("Order No","coderockz-woo-delivery"))
			->setCellValue('B1',__("Order Date","coderockz-woo-delivery"))
			->setCellValue('C1',__("Order Status","coderockz-woo-delivery"))
			->setCellValue('D1',__("Delivery Details","coderockz-woo-delivery"))
			->setCellValue('F1',__("Billing Address","coderockz-woo-delivery"))
			->setCellValue('G1',__("Shipping Address","coderockz-woo-delivery"))
			->setCellValue('H1',__("Contact Details","coderockz-woo-delivery"))
			->setCellValue('I1',__("Products","coderockz-woo-delivery"))
			->setCellValue('J1',__("Total","coderockz-woo-delivery"))
			->setCellValue('K1',__("Payment Method","coderockz-woo-delivery"))
			->setCellValue('L1',__("Shipping Method","coderockz-woo-delivery"))
			->setCellValue('M1',__("Customer Note","coderockz-woo-delivery"));

		$spreadsheet->getActiveSheet()->getStyle('A1:M1')->applyFromArray($tableHead);

		$row=2;
		$unsorted_orders = [];
		foreach($orders as $order) {
		if( version_compare( get_option( 'woocommerce_version' ), '3.0.0', ">=" ) ) {            
	        $order_id = $order->get_id();
	    	} else {
	        $order_id = $order->id;
	    	}

		$delivery_date_timestamp = 0;
	    	$delivery_time_start = 0;
	    	$delivery_time_end = 0;



		if ( class_exists( OrderUtil::class ) ) {
			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {	
				$hpos = true;
			} else {
				$hpos = false;
			}
		}


	    	if((metadata_exists('post', $order_id, 'delivery_date') && get_post_meta( $order_id, 'delivery_date', true ) != "") || ($order->meta_exists('delivery_date') && $order->get_meta( 'delivery_date', true ) != "")) {
		    	if($hpos) {
				$delivery_date_timestamp = strtotime($order->get_meta( 'delivery_date', true ));
			} else {
				$delivery_date_timestamp = strtotime(get_post_meta( $order_id, 'delivery_date', true ));
			}
	    } elseif((metadata_exists('post', $order_id, 'pickup_date') && get_post_meta( $order_id, 'pickup_date', true ) != "") || ($order->meta_exists('pickup_date') && $order->get_meta( 'pickup_date', true ) != "")) {
		    	if($hpos) {
				$delivery_date_timestamp = strtotime($order->get_meta( 'pickup_date', true ));
			} else {
				$delivery_date_timestamp = strtotime(get_post_meta( $order_id, 'pickup_date', true ));
			}
	    }

	    	if((metadata_exists('post', $order_id, 'delivery_time') && get_post_meta($order_id, 'delivery_time', true) !="") || ($order->meta_exists('delivery_time') && $order->get_meta( 'delivery_time', true ) != "")) {
	    		if(get_post_meta($order_id,"delivery_time",true) != "as-soon-as-possible" && $order->get_meta( 'delivery_time', true ) != "as-soon-as-possible") {
	    			if($hpos) {
					$minutes = $order->get_meta( 'delivery_time', true );
				} else {
					$minutes = get_post_meta($order_id,"delivery_time",true);
				}

			    	$slot_key = explode(' - ', $minutes);
					$slot_key_one = explode(':', $slot_key[0]);
					$delivery_time_start = ((int)$slot_key_one[0]*60+(int)$slot_key_one[1]);

			    	if(!isset($slot_key[1])) {
			    		$delivery_time_end = 0;
			    	} else {
			    		$slot_key_two = explode(':', $slot_key[1]);
			    		$delivery_time_end = ((int)$slot_key_two[0]*60+(int)$slot_key_two[1]);
			    	}
	    		} else {
	    			$delivery_time_end = 0;
	    		}
		    	
		    	
		    } elseif((metadata_exists('post', $order_id, 'pickup_time') && get_post_meta($order_id, 'pickup_time', true) !="") || ($order->meta_exists('pickup_time') && $order->get_meta( 'pickup_time', true ) != "")) {
		    	if($hpos) {
				$minutes = $order->get_meta( 'pickup_time', true );
			} else {
				$minutes = get_post_meta($order_id,"pickup_time",true);
			}
		    	$slot_key = explode(' - ', $minutes);
				$slot_key_one = explode(':', $slot_key[0]);
				$delivery_time_start = ((int)$slot_key_one[0]*60+(int)$slot_key_one[1]);
		    	if(!isset($slot_key[1])) {
		    		$delivery_time_end = 0;
		    	} else {
		    		$slot_key_two = explode(':', $slot_key[1]);
			    	$delivery_time_end = ((int)$slot_key_two[0]*60+(int)$slot_key_two[1]);
		    	}
		    }

	    	$delivery_details_in_timestamp = (int)$delivery_date_timestamp+(int)$delivery_time_start+(int)$delivery_time_end;

	    	$unsorted_orders[$order_id] = $delivery_details_in_timestamp;
		}

		asort($unsorted_orders);

		$delivery_tips_settings = get_option('coderockz_woo_delivery_delivery_tips_settings');
		$delivery_tips_field_label = (isset($delivery_tips_settings['delivery_tips_field_label']) && !empty($delivery_tips_settings['delivery_tips_field_label'])) ? stripslashes($delivery_tips_settings['delivery_tips_field_label']) : __( "Tips to Delivery Person", 'coderockz-woo-delivery' );
		

		foreach ($unsorted_orders as $order_id => $value) {
			
			$order = wc_get_order($order_id);

		    $order_created_obj= $order->get_date_created();

			$delivery_details = "";
		    if((metadata_exists('post', $order_id, 'delivery_date') && get_post_meta($order_id, 'delivery_date', true) !="") || ($order->meta_exists('delivery_date') && $order->get_meta( 'delivery_date', true ) != "")) {

			    if($hpos) {
		    		$delivery_date = $helper->weekday_conversion_to_locale($helper->date_conversion_to_locale(date($delivery_date_format, strtotime($order->get_meta( 'delivery_date', true ))),"delivery"),"delivery");
					$delivery_details .= $delivery_date_field_label.': ' . $delivery_date . "\r";
				} else {

					$delivery_date = $helper->weekday_conversion_to_locale($helper->date_conversion_to_locale(date($delivery_date_format, strtotime(get_post_meta( $order_id, 'delivery_date', true ))),"delivery"),"delivery");
					$delivery_details .= $delivery_date_field_label.': ' . $delivery_date . "\r";
				}

		    }

		    if((metadata_exists('post', $order_id, 'pickup_date') && get_post_meta($order_id, 'pickup_date', true) !="") || ($order->meta_exists('pickup_date') && $order->get_meta( 'pickup_date', true ) != "")) {

			    if($hpos) {
			    	$pickup_date = $helper->weekday_conversion_to_locale($helper->date_conversion_to_locale(date($pickup_date_format, strtotime($order->get_meta( 'pickup_date', true ))),"pickup"),"pickup");
					$delivery_details .= $pickup_date_field_label.': ' . $pickup_date . "\r";
				} else {
					$pickup_date = $helper->weekday_conversion_to_locale($helper->date_conversion_to_locale(date($pickup_date_format, strtotime(get_post_meta( $order_id, 'pickup_date', true ))),"pickup"),"pickup");
					$delivery_details .= $pickup_date_field_label.': ' . $pickup_date . "\r";
				}


		    }

		    if((metadata_exists('post', $order_id, 'delivery_time') && get_post_meta($order_id, 'delivery_time', true) !="") || ($order->meta_exists('delivery_time') && $order->get_meta( 'delivery_time', true ) != "")) {

		    	if(get_post_meta($order_id,"delivery_time",true) != "as-soon-as-possible" && $order->get_meta( 'delivery_time', true ) != "as-soon-as-possible") {
			    	if($hpos) {
					$minutes = $order->get_meta( 'delivery_time', true );
				} else {
					$minutes = get_post_meta($order_id,"delivery_time",true);
				}
			    	$minutes = explode(' - ', $minutes);

		    		if(!isset($minutes[1])) {
		    			$delivery_details .= $delivery_time_field_label.': ' . date($time_format, strtotime($minutes[0])) . "\r";
		    		} else {

		    			$delivery_details .= $delivery_time_field_label.': ' . date($time_format, strtotime($minutes[0])) . ' - ' . date($time_format, strtotime($minutes[1])) . "\r";  			
		    		}
	    		} else {
	    			$as_soon_as_possible_text = (isset($delivery_time_settings['as_soon_as_possible_text']) && !empty($delivery_time_settings['as_soon_as_possible_text'])) ? stripslashes($delivery_time_settings['as_soon_as_possible_text']) : "As Soon As Possible";
	    			$delivery_details .= $delivery_time_field_label.': ' . $as_soon_as_possible_text . "\r";
	    		}
		    	
		    }

		    if((metadata_exists('post', $order_id, 'pickup_time') && get_post_meta($order_id, 'pickup_time', true) !="") || ($order->meta_exists('pickup_time') && $order->get_meta( 'pickup_time', true ) != "")) {
		    	if($hpos) {
				$pickup_minutes = $order->get_meta( 'pickup_time', true );
			} else {
				$pickup_minutes = get_post_meta($order_id,"pickup_time",true);
			}
		    	$pickup_minutes = explode(' - ', $pickup_minutes);

	    		if(!isset($pickup_minutes[1])) {
	    			$delivery_details .= $pickup_time_field_label.': ' . date($pickup_time_format, strtotime($pickup_minutes[0])) . "\r";
	    		} else {

	    			$delivery_details .= $pickup_time_field_label.': ' . date($pickup_time_format, strtotime($pickup_minutes[0])) . ' - ' . date($pickup_time_format, strtotime($pickup_minutes[1])) . "\r";  			
	    		}
		    	
		    }

		    if((metadata_exists('post', $order_id, 'pickup_location') && get_post_meta($order_id, 'pickup_location', true) !="") || ($order->meta_exists('pickup_location') && $order->get_meta( 'pickup_location', true ) != "")) {
		    		if($hpos) {
					$pickup_location = $order->get_meta( 'pickup_location', true );
				} else {
					$pickup_location = get_post_meta($order_id, 'pickup_location', true);
				}
				$delivery_details .= $pickup_location_field_label.': ' . stripslashes(html_entity_decode($pickup_location, ENT_QUOTES)) . "\r";
			}

			if((metadata_exists('post', $order_id, 'additional_note') && get_post_meta($order_id, 'additional_note', true) !="") || ($order->meta_exists('additional_note') && $order->get_meta( 'additional_note', true ) != "")) {
				if($hpos) {
					$additional_note = $order->get_meta( 'additional_note', true );
				} else {
					$additional_note = get_post_meta($order_id, 'additional_note', true);
				}
				$delivery_details .= $additional_field_label.': ' . stripslashes(html_entity_decode($additional_note, ENT_QUOTES)) . "\r";
			}


			$tips_fee = 0;
			foreach( $order->get_items('fee') as $item_id => $item_fee ){
			    if( $item_fee['name'] == $delivery_tips_field_label ) {
			    	$tips_fee = $item_fee['total'] + $item_fee['total_tax'];
			    	break;
			    }
			}

			if($tips_fee != 0) {

				$delivery_details .= $delivery_tips_field_label.': ' . $order->get_currency(). $tips_fee . "\r";

			}


			if((metadata_exists('post', $order_id, 'delivery_status') && get_post_meta($order_id, 'delivery_status', true) !="" && get_post_meta($order_id, 'delivery_status', true) =="delivered") || ($order->meta_exists('delivery_status') && $order->get_meta( 'delivery_status', true ) != "" && $order->get_meta( 'delivery_status', true ) == "delivered")) {
				if((metadata_exists('post', $order_id, 'delivery_type') && get_post_meta($order_id, 'delivery_type', true) !="" && get_post_meta($order_id, 'delivery_type', true) == "pickup") || ($order->meta_exists('delivery_type') && $order->get_meta( 'delivery_type', true ) != "" && $order->get_meta( 'delivery_type', true ) == "pickup")) {
					$delivery_status = $pickup_status_picked_text;
				} else {
					$delivery_status = $delivery_status_delivered_text;
				}
				
			} else {

				if((metadata_exists('post', $order_id, 'delivery_type') && get_post_meta($order_id, 'delivery_type', true) !="" && get_post_meta($order_id, 'delivery_type', true) =="pickup") || ($order->meta_exists('delivery_type') && $order->get_meta( 'delivery_type', true ) != "" && $order->get_meta( 'delivery_type', true ) == "pickup")) {
					$delivery_status = $pickup_status_not_picked_text;
				} else {
					$delivery_status = $delivery_status_not_delivered_text;
				}
			}

			$i=1;
			$product_details = "";
			foreach ($order->get_items() as $item) {
				$product_details .= $i.'. ';
				if($item->get_variation_id() == 0) {
				   	$product_name = $item->get_name();
					$item_meta_data = $item->get_formatted_meta_data();
					if(!empty($item_meta_data) && !$hide_metadata_reports_calendar) {
						foreach ( $item_meta_data as $meta_id => $meta ) {
							$product_name .= ', '.wp_kses_post( strip_tags($meta->value) );
						}
					}
			    } else {
					$variation = new WC_Product_Variation($item->get_variation_id());
					$item_meta_data = $item->get_formatted_meta_data();
					$product_name = $variation->get_title();
					if(array_filter($variation->get_variation_attributes())) {
						$product_name .= " - ".strip_tags(implode(", ", array_filter($variation->get_variation_attributes(), 'strlen')));	
					}
					if(!empty($item_meta_data) && !$hide_metadata_reports_calendar) {
						foreach ( $item_meta_data as $meta_id => $meta ) {
							if (!array_key_exists("attribute_".$meta->key,$variation->get_variation_attributes()) || (array_key_exists("attribute_".$meta->key,$variation->get_variation_attributes()) && $variation->get_variation_attributes()["attribute_".$meta->key] == "") )
								$product_name .= ', '.wp_kses_post( strip_tags($meta->display_value) );

						}
					}
					
			    }
				$product_details .= $product_name;
				$product_details .= '   '.str_replace("&nbsp;","",$helper->format_price($order->get_item_total( $item,true ),$order->get_id())).'x';
				$product_details .= $item->get_quantity().'=';
				$product_details .= str_replace("&nbsp;","",$helper->format_price(number_format($item->get_total(),2) + number_format($item->get_subtotal_tax(),2),$order->get_id()));
				$product_details .= "\r";
				$i = $i+1;
			}

			$order_billing_address = str_replace("<br/>","\r",html_entity_decode($order->get_formatted_billing_address()));
			$order_shipping_address = str_replace("<br/>","\r",html_entity_decode($order->get_formatted_shipping_address()));
			$order_contact_details = 'Billing Phone: '.$order->get_billing_phone()."\r".'Billing Email: '.$order->get_billing_email();
			if($order->get_shipping_phone() != "") {
				$order_contact_details .= "\r" . 'Shipping Phone: '. $order->get_shipping_phone();
			}

			include_once(ABSPATH.'wp-admin/includes/plugin.php');

			if((metadata_exists('post', $order_id, '_wcj_order_number') && get_post_meta($order_id, '_wcj_order_number', true) !="") || ($order->meta_exists('_wcj_order_number') && $order->get_meta( '_wcj_order_number', true ) != "")) {
				if($hpos) {
					$order_id_with_custom = '#'.$order->get_meta( '_wcj_order_number', true );
				} else {
					$order_id_with_custom = '#'.get_post_meta($order_id, '_wcj_order_number', true);
				}

			} elseif(is_plugin_active('wt-woocommerce-sequential-order-numbers-pro/wt-advanced-order-number-pro.php') || is_plugin_active('wt-woocommerce-sequential-order-numbers/wt-advanced-order-number.php') || is_plugin_active('custom-order-numbers-for-woocommerce/custom-order-numbers-for-woocommerce.php') || is_plugin_active('yith-woocommerce-sequential-order-number-premium/init.php')) {
				$order_id_with_custom = $order->get_order_number();
			} else {
				$order_id_with_custom = '#'.$order->get_id();
			}

			$shipping_method = $order->get_shipping_method() != null && $order->get_shipping_method() != "" ? $order->get_shipping_method() : "";
	        $shipping_method_amount = $order->get_shipping_total() != null && $order->get_shipping_total() != "" && $order->get_shipping_total() != 0 ? " - ".$order->get_currency().$order->get_shipping_total(): "";

			$spreadsheet->getActiveSheet()
				->setCellValue('A'.$row , $order_id_with_custom)
				->setCellValue('B'.$row , $helper->date_conversion_to_locale($order_created_obj->format("F j, Y"), 'delivery'))
				->setCellValue('C'.$row , $order->get_status())
				->setCellValue('D'.$row , $delivery_details)
				->setCellValue('F'.$row , $order_billing_address)
				->setCellValue('G'.$row , $order_shipping_address)
				->setCellValue('H'.$row , $order_contact_details)
				->setCellValue('I'.$row , $product_details)
				->setCellValue('J'.$row , $order->get_currency() . $order->get_total())
				->setCellValue('K'.$row , $order->get_payment_method_title())
				->setCellValue('L'.$row , $shipping_method . $shipping_method_amount)
				->setCellValue('M'.$row , $order->get_customer_note());
			
			if( $row % 2 == 0 ){

				$spreadsheet->getActiveSheet()->getStyle('A'.$row.':M'.$row)->applyFromArray($evenRow)->getAlignment()->setWrapText(true)->setVertical(Alignment::VERTICAL_CENTER);
			}else{

				$spreadsheet->getActiveSheet()->getStyle('A'.$row.':M'.$row)->applyFromArray($oddRow)->getAlignment()->setWrapText(true)->setVertical(Alignment::VERTICAL_CENTER);
			}
			
			$row++;
		}
		$firstRow=1;
		$lastRow=$row-1;
 		$filename = "delivery_sheet(".$filtered_date.").xlsx";
 		ob_end_clean();
		header('Content-disposition: attachment; filename="'.$filename.'"');
		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		ob_clean();
		flush();

 		$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
		$writer->save('php://output');
		exit;

	}

	$helper = new Coderockz_Woo_Delivery_Helper();

	$delivery_date_settings = get_option('coderockz_woo_delivery_date_settings');
	$pickup_date_settings = get_option('coderockz_woo_delivery_pickup_date_settings');	
	if(isset($delivery_date_settings['date_format']) && !empty($delivery_date_settings['date_format'])) {
		$date_format = $delivery_date_settings['date_format'];
	} elseif(isset($pickup_date_settings['date_format']) && !empty($pickup_date_settings['date_format'])) {
		$date_format = $pickup_date_settings['date_format'];

	} else {
		$date_format = "F j, Y";
	}

	if(isset($delivery_date_settings['week_starts_from']) && !empty($delivery_date_settings['week_starts_from'])) {
		$week_starts_from = $delivery_date_settings['week_starts_from'];
	} elseif(isset($pickup_date_settings['week_starts_from']) && !empty($pickup_date_settings['week_starts_from'])) {
		$week_starts_from = $pickup_date_settings['week_starts_from'];

	} else {
		$week_starts_from = "0";
	}

	/*This week range*/	

	//$delivery_date = $helper->date_conversion_to_locale(wp_date('F j, Y', $this_week_array['end']-86400),"delivery");

	$week_starts_from = (isset($delivery_date_settings['week_starts_from']) && !empty($delivery_date_settings['week_starts_from'])) ? $delivery_date_settings['week_starts_from']:"0";
	$this_week_array = get_weekstartend( wp_date('Y-m-d',current_time( 'timestamp', 1 )), $week_starts_from );
	$this_week = $helper->date_conversion_to_locale(wp_date('F j, Y', $this_week_array['start']),"delivery")." - ".$helper->date_conversion_to_locale(wp_date('F j, Y', $this_week_array['end']-86400),"delivery");

	$this_week_value = wp_date('Y-m-d', $this_week_array['start'])." - ".wp_date('Y-m-d', $this_week_array['end']-86400);

	/*This week range*/

    /*This Month range*/

    $day_today = wp_date('F j, Y',current_time( 'timestamp', 1 ));
    $this_month_first_day = $helper->date_conversion_to_locale(current_datetime($day_today )->modify('first day of this month')->format('F j, Y'),"delivery");
    $this_month_last_day = $helper->date_conversion_to_locale(current_datetime($day_today )->modify('last day of this month')->format('F j, Y'),"delivery");

    $this_month_first_day_value = current_datetime($day_today )->modify('first day of this month')->format('Y-m-d');
    $this_month_last_day_value = current_datetime($day_today )->modify('last day of this month')->format('Y-m-d');

    $this_month = $this_month_first_day." - ".$this_month_last_day;
    $this_month_value = $this_month_first_day_value." - ".$this_month_last_day_value;


	/*This Month range*/

	$today = $helper->date_conversion_to_locale(wp_date('F j, Y',current_time( 'timestamp', 1 )),"delivery");
	$today_value = wp_date('Y-m-d',current_time( 'timestamp', 1 ));
	$tomorrow = $helper->date_conversion_to_locale(wp_date("F j, Y", current_time( 'timestamp', 1 )+86400),"delivery");
	$tomorrow_value = wp_date("Y-m-d", current_time( 'timestamp', 1 )+86400);
	$order_details_html = '';

?>
<div class="coderockz-woo-delivery-card">
	<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Reports', 'coderockz-woo-delivery'); ?></p>
	<div class="coderockz-woo-delivery-card-body">
		<div class="coderockz-woo-delivery-current-filter-section">
			
			<div style="float:left;">
				<span class="coderockz-woo-delivery-current-filter" data-filter_text="Today <span style='color:#bbb'> (<?php echo $today; ?>)</span>"><?php _e('Select Date', 'coderockz-woo-delivery'); ?></span>
				<span class="coderockz-woo-delivery-filter-change-btn dashicons dashicons-arrow-down-alt2"></span>
			</div>
			<div style="float:right;">
				
			</div>
		</div>
		<div class="coderockz_woo_delivery_report_filter_modal" id="coderockz_woo_delivery_report_filter_modal">
			<div class="coderockz_woo_delivery_report_filter_modal_wrap">
				<div class="coderockz_woo_delivery_report_filter_modal_header">
					<p class="coderockz_woo_delivery_report_filter_modal_header_text" style="margin:0;"><?php _e('Today', 'coderockz-woo-delivery'); ?> <span style="color:#bbb"> (<?php echo $today; ?>)</span></p>
				</div>

				<div class="coderockz_woo_delivery_report_filter_modal_body">
					<div class="coderockz-woo-delivery-report-header-wrapper">    
						<div class="coderockz-woo-delivery-report-header-delivery-type">
						<label style="margin-right: 5px;">
						    <input type="radio" name="coderockz-woo-delivery-report-filter-delivery-type" value="all" checked/><?php _e('All', 'coderockz-woo-delivery'); ?>
						</label>
						<label style="margin-right: 5px;">
						    <input type="radio" name="coderockz-woo-delivery-report-filter-delivery-type" value="delivery"/><?php _e('Delivery', 'coderockz-woo-delivery'); ?>
						</label>
						<label>
						    <input type="radio" name="coderockz-woo-delivery-report-filter-delivery-type" value="pickup"/><?php _e('Pickup', 'coderockz-woo-delivery'); ?>
						</label>
						</div>
						<div class="coderockz-woo-delivery-report-header-radio-btn">
							<input type="radio" id="coderockz-woo-delivery-report-header-radio-btn-1" name="coderockz-woo-delivery-report-filter-value" value="<?php echo $today_value; ?>" checked/>
							<label for="coderockz-woo-delivery-report-header-radio-btn-1"></label>
							<span><?php _e('Today', 'coderockz-woo-delivery'); ?> <span style="color:#bbb"> (<?php echo $today; ?>)</span></span>
						</div>

						<div class="coderockz-woo-delivery-report-header-radio-btn">
							<input type="radio" id="coderockz-woo-delivery-report-header-radio-btn-2" name="coderockz-woo-delivery-report-filter-value" value="<?php echo $tomorrow_value; ?>"/>
							<label for="coderockz-woo-delivery-report-header-radio-btn-2"></label>
							<span><?php _e('Tomorrow', 'coderockz-woo-delivery'); ?> <span style="color:#bbb"> (<?php echo $tomorrow; ?>)</span></span>
						</div>

						<div class="coderockz-woo-delivery-report-header-radio-btn">
							<input type="radio" id="coderockz-woo-delivery-report-header-radio-btn-3" name="coderockz-woo-delivery-report-filter-value" value="<?php echo $this_week_value; ?>"/>
							<label for="coderockz-woo-delivery-report-header-radio-btn-3"></label>
							<span><?php _e('This Week', 'coderockz-woo-delivery'); ?> <span style="color:#bbb"> (<?php echo $this_week; ?>)</span></span>
						</div>

						<div class="coderockz-woo-delivery-report-header-radio-btn">
							<input type="radio" id="coderockz-woo-delivery-report-header-radio-btn-4" name="coderockz-woo-delivery-report-filter-value" value="<?php echo $this_month_value; ?>"/>
							<label for="coderockz-woo-delivery-report-header-radio-btn-4"></label>
							<span><?php _e('This Month', 'coderockz-woo-delivery'); ?> <span style="color:#bbb"> (<?php echo $this_month; ?>)</span>
						</div>
						<div class="coderockz-woo-delivery-report-header-radio-btn">
							<input data-custom_range_text="<?php _e('Custom Date Range', 'coderockz-woo-delivery'); ?>" type="radio" id="coderockz-woo-delivery-report-header-radio-btn-5" name="coderockz-woo-delivery-report-filter-value" value=""/>
							<label for="coderockz-woo-delivery-report-header-radio-btn-5"></label>
							<span><?php _e('Custom Date Range', 'coderockz-woo-delivery'); ?><span style="color:#bbb"> <?php _e('(Max 30 Days)', 'coderockz-woo-delivery'); ?></span></span>
						</div>
					</div>
					<div class="coderockz-woo-delivery-date-range-wrapper">

					</div>
					<div>
						<select data-filter_order_status_text="<?php _e('Filter by Order Status', 'coderockz-woo-delivery'); ?>" id="coderockz_woo_delivery_calendar_order_status_filter_report" class="coderockz_woo_delivery_calendar_order_status_filter_report" multiple>
							<?php 
							foreach(wc_get_order_statuses() as $key => $value) {
								echo "<option value='".substr($key, 3)."'>".$value."</option>";
							}
							?>
							<option value="partially-paid">Partially Paid</option>
						</select>
					</div>
					<div>
						<select data-filter_pickup_location_text="<?php _e('Filter by Pickup Location', 'coderockz-woo-delivery'); ?>" id="coderockz_woo_delivery_calendar_pickup_location_filter_report" class="coderockz_woo_delivery_calendar_pickup_location_filter_report" multiple>
							<?php 
							$pickup_location_settings = get_option('coderockz_woo_delivery_pickup_location_settings');
							if(isset($pickup_location_settings['pickup_location']) && !empty($pickup_location_settings['pickup_location'])) {
									foreach($pickup_location_settings['pickup_location'] as $location => $location_details) {
	                                    echo '<option value="'.stripslashes($location).'">'.stripslashes($location).'</option>';
	                                }
                            	}
							?>
						</select>
					</div>
				</div>

				<div class="coderockz_woo_delivery_report_filter_modal_footer" style="overflow:hidden">
					<?php
					$order_status_keys = array_keys(wc_get_order_statuses());
					$order_status = ['partially-paid'];
					foreach($order_status_keys as $order_status_key) {
						$order_status[] = substr($order_status_key,3);
					}
					$order_status = array_diff($order_status,['cancelled','failed','refunded']);
					$order_status = implode(",",$order_status);
					?>



					<?php 
					$pickup_location_settings = get_option('coderockz_woo_delivery_pickup_location_settings');
					$pickup_location = [];
					$enable_pickup_location = (isset($pickup_location_settings['enable_pickup_location']) && !empty($pickup_location_settings['enable_pickup_location'])) ? $pickup_location_settings['enable_pickup_location'] : false;
					if($enable_pickup_location && isset($pickup_location_settings['pickup_location']) && !empty($pickup_location_settings['pickup_location'])) {
						foreach($pickup_location_settings['pickup_location'] as $location => $location_details) {
							/*if($this->hpos) {
								$pickup_location[] = str_replace(",","c-w-d",$location);
							} else {
								$pickup_location[] = stripslashes(str_replace(",","c-w-d",$location));
							}
*/
							$pickup_location[] = str_replace(",","c-w-d",$location);
                            
                        }
                	}

                	$pickup_location = implode(",",$pickup_location);
                	
					?>


					<form style="float: left;margin-right: 2px;" action="" method="post" id ="coderockz_woo_delivery_export_quantity_form_submit">
                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

                        <input style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-quantity-type" value="all" />
                        <input style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-quantity-date" value="<?php echo $today_value; ?>" />

                        <input data-order_status="<?php echo $order_status; ?>" style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-quantity-order-status" value="<?php echo $order_status; ?>" />

                        <input data-pickup_location="<?php echo $pickup_location; ?>" style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-quantity-pickup-location" value="<?php echo $pickup_location; ?>" />


                        <input class="button-primary" type="submit" name="coderockz-woo-delivery-export-excel-quantity-btn" value="<?php _e('Export(Quantity)', 'coderockz-woo-delivery'); ?>" />
                    </form>

                    <form style="float: left;margin-right: 2px;" action="" method="post" id ="coderockz_woo_delivery_export_form_submit">
                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

                        <input style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-type" value="all" />
                        <input style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-date" value="<?php echo $today_value; ?>" />

                        <input data-order_status="<?php echo $order_status; ?>" style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-order-status" value="<?php echo $order_status; ?>" />

                        <input data-pickup_location="<?php echo $pickup_location; ?>" style="display:none;visibility:hidden;" class="button-primary" type="text" name="coderockz-woo-delivery-export-excel-quantity-pickup-location" value="<?php echo $pickup_location; ?>" />

                        <input class="button-primary" type="submit" name="coderockz-woo-delivery-export-excel-btn" value="<?php _e('Export(Details)', 'coderockz-woo-delivery'); ?>" />
                    </form>

					<button data-processing_text="<?php _e('Processing', 'coderockz-woo-delivery'); ?>" style="float: left;margin-right: 2px;" class="coderockz-woo-delivery-report-product-quantity-button button-primary"><?php _e('Quantity', 'coderockz-woo-delivery'); ?></button>
					<button data-processing_text="<?php _e('Processing', 'coderockz-woo-delivery'); ?>" style="float: left;margin-right: 2px;" class="coderockz-woo-delivery-report-filter-apply-button button-primary"><?php _e('Details', 'coderockz-woo-delivery'); ?></button>
					<button style="float: left;" class="coderockz-woo-delivery-report-filter-cancel-button button-secondary"><?php _e('Cancel', 'coderockz-woo-delivery'); ?></button>
				</div>
			</div>
		</div>
		<p data-get_delivery_report="<?php if(get_option('coderockz-woo-delivery-'.$helper->coderockz_woo_deivery_report_special_text('JM!VL6e-1Ub', true))!=false){
			echo get_option('coderockz-woo-delivery-'.$helper->coderockz_woo_deivery_report_special_text('JM!VL6e-1Ub', true));
		} ?>" class="coderockz_woo_deivery_total_sales_text" style="display:none;font-weight:700"><?php _e('Total Sales: ', 'coderockz-woo-delivery'); ?><span style="color:#3e1a90"></span></p>
		<div class="coderockz_woo_delivery_report_result">
			<table id="coderockz_woo_delivery_report_table" class="display" style="width:100%">
		        <thead>
		            <tr>
		                <th class="details-control sorting_disabled"></th>
		                <th><?php _e('Order No', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Order Date', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Delivery Details', 'coderockz-woo-delivery'); ?></th>
		                <?php 
		                $other_settings = get_option('coderockz_woo_delivery_other_settings');
		                $remove_delivery_status_column = (isset($other_settings['remove_delivery_status_column']) && !empty($other_settings['remove_delivery_status_column'])) ? $other_settings['remove_delivery_status_column'] : false;

		                if(!$remove_delivery_status_column) {
		                ?>
		                <th><?php _e('Delivery Status', 'coderockz-woo-delivery'); ?></th>
		            	<?php } ?>
		                <th><?php _e('Order Status', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Total', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Action', 'coderockz-woo-delivery'); ?></th>
		            </tr>
		        </thead>
		        <tbody>
		        	<?php echo $order_details_html; ?>
	        	</tbody>
		        <tfoot>
		            <tr>
		                <th class="details-control sorting_disabled"></th>
		                <th><?php _e('Order No', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Order Date', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Delivery Details', 'coderockz-woo-delivery'); ?></th>
		                <?php 
		                $other_settings = get_option('coderockz_woo_delivery_other_settings');
		                $remove_delivery_status_column = (isset($other_settings['remove_delivery_status_column']) && !empty($other_settings['remove_delivery_status_column'])) ? $other_settings['remove_delivery_status_column'] : false;

		                if(!$remove_delivery_status_column) {
		                ?>
		                <th><?php _e('Delivery Status', 'coderockz-woo-delivery'); ?></th>
		            	<?php } ?>
		                <th><?php _e('Order Status', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Total', 'coderockz-woo-delivery'); ?></th>
		                <th><?php _e('Action', 'coderockz-woo-delivery'); ?></th>
		            </tr>
		        </tfoot>
		    </table>
		</div>
	</div>
</div>