<?php

/**

 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://coderockz.com
 * @since      1.0.0
 *
 * @package    Coderockz_Woo_Delivery
 * @subpackage Coderockz_Woo_Delivery/admin/partials

**/

/*public function is_checkout_block() {
    return WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' );
}

if(is_checkout_block() && is_checkout() && ! ( is_wc_endpoint_url( 'order-pay' ) || is_wc_endpoint_url( 'order-received' ))){
	
}
*/

$delivery_zones = WC_Shipping_Zones::get_zones();
$zone_regions = [];
$zone_post_code = [];
$zone_name = [];
$shipping_methods = [];
$shipping_methods_with_pickup = [];
$shipping_methods_for_offdays = [];
$discount_coupons = [];

if(get_option('coderockz_woo_delivery_large_coupons_list') == false || get_option('coderockz_woo_delivery_large_coupons_list') == 'no') {
	$args = array(
	    'posts_per_page'   => -1,
	    'orderby'          => 'title',
	    'order'            => 'asc',
	    'post_type'        => 'shop_coupon',
	    'post_status'      => 'publish',
	);
	$coupons = get_posts( $args );

	$coupon_names = array();
	foreach ( $coupons as $coupon ) {
	    $coupon_name = $coupon->post_name;
	    array_push( $discount_coupons, $coupon_name );
	}
}

foreach ((array) $delivery_zones as $key => $the_zone ) {
	$zone_state_code = [];
	$zone = new WC_Shipping_Zone($the_zone['id']);
	$zone_name[$the_zone['id']] = $zone->get_zone_name();
	$zone_shipping_methods = $zone->get_shipping_methods( true, 'values' );
	foreach ( $zone_shipping_methods as $instance_id => $shipping_method ) 
    {
        if($shipping_method->id != 'local_pickup') {
        	$shipping_methods[] = $shipping_method->get_title();
        	$shipping_methods_with_pickup[] = $shipping_method->get_title();
        	$shipping_methods_for_offdays[$shipping_method->id.":".$instance_id] = $shipping_method->get_title()." (Zone: ".$zone->get_zone_name().")";
        }
        	
        if($shipping_method->id == 'local_pickup'){
        	$shipping_methods_with_pickup[] = $shipping_method->get_title();
        	$shipping_methods_for_offdays[$shipping_method->id.":".$instance_id] = $shipping_method->get_title()." (Zone: ".$zone->get_zone_name().")";
        }
        	
    }

    $zones_not_covered = new WC_Shipping_Zone( 0 );
    $zones_not_covered_methods = $zones_not_covered->get_shipping_methods( true, 'values' );
    foreach ( $zones_not_covered_methods as $instance_id => $shipping_method ) 
    {
    	$shipping_methods_with_pickup[] = $shipping_method->get_title();
        $shipping_methods_for_offdays[$shipping_method->id.":".$instance_id] = $shipping_method->get_title()." (Zone: ".$zones_not_covered->get_zone_name().")";
    }

	$zone_string = $zone->get_formatted_location(50000);
	if(isset($zone_string) && $zone_string != ''){
		$zone_array = explode(", ",$zone_string);
	}
	$zone_locations = $zone->get_zone_locations();
	$helper = new Coderockz_Woo_Delivery_Helper();
	$zone_locations = $helper->objectToArray($zone_locations);
	foreach($zone_locations as $zone_location) {
		if($zone_location['type'] == "state") {
			$position = strpos($zone_location['code'],':');
			$zone_state_code[] = substr($zone_location['code'],($position+1));
		} else if($zone_location['type'] == "postcode") {
			$zone_post_code[] = $zone_location['code'];
		}
	}

	foreach($zone_state_code as $key => $code) {
		$zone_regions[$code] = $zone_array[$key];
	}

}
$shipping_methods = array_unique($shipping_methods, false);
$shipping_methods = array_values($shipping_methods);
$shipping_methods_with_pickup = array_unique($shipping_methods_with_pickup, false);
$shipping_methods_with_pickup = array_values($shipping_methods_with_pickup);
$store_products = [];
// NO NEED TO DELETE THIS CODE MANUALLY FROM NOW. JUST CONTACT support@coderockz.com
if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {
	$args = array(
	    'post_type' => 'product',
	    'numberposts' => -1,
	);
	$products = get_posts( $args );
	foreach($products as $product) {
		$product_s = wc_get_product( $product->ID );
		if ($product_s->get_type() == 'variable' || $product_s->get_type() == 'pw-gift-card') {
			$store_products[$product->ID] = $product_s->get_name();
		    $args = array(
		        'post_parent' => $product->ID,
		        'post_type'   => 'product_variation',
		        'numberposts' => -1,
		    );
		    $variations = $product_s->get_available_variations();
		    foreach($variations as $variation) {
		    	
			    $variation_id = $variation['variation_id'];
			    $variation = new WC_Product_Variation($variation_id);
				$store_products[$variation_id] = $variation->get_title()." - ".implode(", ", $variation->get_variation_attributes());
			    
			    /*$variation = wc_get_product($variation_id);
				$store_products[$variation_id] = $variation->get_formatted_name();*/
		    }
		    
		} else {
			$store_products[$product->ID] = $product_s->get_name();
			/*$store_products[$product->ID] = $product_s->get_formatted_name();*/
		}
	}

}

global $wp_roles;

if ( ! isset( $wp_roles ) )
    $wp_roles = new WP_Roles();
$user_roles = $wp_roles->get_names();


$all_categories = get_categories( ['taxonomy' => 'product_cat', 'orderby' => 'name', 'hide_empty' => '0'] );
$date_settings = get_option('coderockz_woo_delivery_date_settings');
if($date_settings != false && isset($date_settings['delivery_days']) && $date_settings['delivery_days'] != "" ) {
	$selected_delivery_day = explode(',', $date_settings['delivery_days']);
} else {
	$selected_delivery_day = [];
}

$pickup_date_settings = get_option('coderockz_woo_delivery_pickup_date_settings');
if($pickup_date_settings != false && isset($pickup_date_settings['pickup_days']) && $pickup_date_settings['pickup_days'] != "" ) {
	$selected_pickup_day = explode(',', $pickup_date_settings['pickup_days']);
} else {
	$selected_pickup_day = [];
}
$open_date_settings = get_option('coderockz_woo_delivery_open_days_settings');
$delivery_fee_settings = get_option('coderockz_woo_delivery_fee_settings');
$time_settings = get_option('coderockz_woo_delivery_time_settings');
$delivery_option_settings = get_option('coderockz_woo_delivery_option_delivery_settings');
$pickup_time_settings = get_option('coderockz_woo_delivery_pickup_time_settings');
$time_slot_settings = get_option('coderockz_woo_delivery_time_slot_settings');
$pickup_slot_settings = get_option('coderockz_woo_delivery_pickup_slot_settings');
$offdays_settings = get_option('coderockz_woo_delivery_off_days_settings');
$processing_days_settings = get_option('coderockz_woo_delivery_processing_days_settings');
$processing_time_settings = get_option('coderockz_woo_delivery_processing_time_settings');
$notify_email_settings = get_option('coderockz_woo_delivery_notify_email_settings');
$pickup_location_settings = get_option('coderockz_woo_delivery_pickup_location_settings');
$localization_settings = get_option('coderockz_woo_delivery_localization_settings');
$exclude_settings = get_option('coderockz_woo_delivery_exclude_settings');
$google_calendar_settings = get_option('coderockz_woo_delivery_google_calendar_settings');
$other_settings = get_option('coderockz_woo_delivery_other_settings');
$additional_field_settings = get_option('coderockz_woo_delivery_additional_field_settings');
$delivery_tips_settings = get_option('coderockz_woo_delivery_delivery_tips_settings');
$laundry_store_settings = get_option('coderockz_woo_delivery_laundry_store_settings');
$currency_code = get_woocommerce_currency();
$store_location_timezone = isset($time_settings['store_location_timezone']) && $time_settings['store_location_timezone'] != ""? $time_settings['store_location_timezone'] : "";

function stdClassObjectToArray($d) {
    if (is_object($d)) {
        // Gets the properties of the given object
        // with get_object_vars function
        $d = get_object_vars($d);
    }

    if (is_array($d)) {
        /*
        * Return array converted to object
        * Using __FUNCTION__ (Magic constant)
        * for recursive call
        */
        return array_map(__FUNCTION__, $d);
    } else {
        // Return array
        return $d;
    }
}


?>
<div class="coderockz-woo-delivery-wrap">
<div class="coderockz-woo-delivery-container">		
	<div class="coderockz-woo-delivery-container-header">
		<img style="max-width: 75px;float: left;display: block;padding-bottom: 2px;" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL; ?>admin/images/woo-delivery-logo.png" alt="coderockz-woo-delivery">
		<div style="float:left;margin-left:15px;">
		<p style="margin: 0!important;text-transform:uppercase;border-bottom:2px solid #1F9E60;padding-bottom:3px;font-size: 20px;font-weight: 700;color: #654C29;">WooCommerce</p>
		<p style="margin: 0!important;text-transform:uppercase;padding-top:3px;font-size: 11px;color: #654C29;font-weight: 600;">Delivery & Pickup Date Time</p>
		</div>
		<p style="float: right;margin-top: 20px;color: #bbb"><?php _e('Current Version', 'coderockz-woo-delivery'); ?> <?php echo CODEROCKZ_WOO_DELIVERY_VERSION; ?></p>
	</div>
	<div class="coderockz-woo-delivery-vertical-tabs">
		<div class="coderockz-woo-delivery-tabs">
			<button data-tab="tab1"><i class="dashicons dashicons-unlock" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Activation', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab2"><i class="dashicons dashicons-clipboard" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Delivery Reports', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab3"><i class="dashicons dashicons-plugins-checked" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Order Settings', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab4"><i class="dashicons dashicons-calendar-alt" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Delivery Date', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab8"><i class="dashicons dashicons-clock" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Delivery Time', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab5"><i class="dashicons dashicons-calendar" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Pickup Date', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab9"><i class="dashicons dashicons-cart" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Pickup Time', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab10"><i class="dashicons dashicons-location" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Pickup Location', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab6"><i class="dashicons dashicons-hidden" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Off Days', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab7"><i class="dashicons dashicons-smiley" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Special Open Days', 'coderockz-woo-delivery'); ?></button>			
			<button data-tab="tab11"><i class="dashicons dashicons-money-alt" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Delivery Tips', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab12"><i class="dashicons dashicons-welcome-comments" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Cutoff Time', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab13"><i class="dashicons dashicons-update" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Processing Days', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab14"><i class="dashicons dashicons-backup" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Processing Time', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab15"><i class="dashicons dashicons-images-alt2" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Additional Fees', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab16"><i class="dashicons dashicons-email-alt" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Email Settings', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab17"><i class="dashicons dashicons-admin-page" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Additional Field', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab18"><i class="dashicons dashicons-translation" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Localization', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab19"><i class="dashicons dashicons-dismiss" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Exclusion', 'coderockz-woo-delivery'); ?></button>	
			<button data-tab="tab20"><i class="dashicons dashicons-calendar-alt" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Google Calendar', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab21"><i class="dashicons dashicons-superhero" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Laundry Service', 'coderockz-woo-delivery'); ?></button>
			<button data-tab="tab22"><i class="dashicons dashicons-admin-settings" style="margin-bottom: 3px;margin-right: 10px;"></i><?php _e('Others', 'coderockz-woo-delivery'); ?></button>
		</div>
		<div class="coderockz-woo-delivery-maincontent">

			<div data-tab="tab1" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Plugin Activation', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<?php 
				  		$license = get_option( 'coderockz-woo-delivery-license-key' );
			            $status = get_option( 'coderockz-woo-delivery-license-status' );
			            ?>
			            <form method="post" action="options.php">

			                <?php settings_fields( 'coderockz-woo-delivery-license' ); ?>

			    	        <?php if ( 'valid' != get_option( 'coderockz-woo-delivery-license-status' ) ): ?>
			                    <p style="font-weight:700;font-size:14px;"><?php echo esc_html( sprintf( __( 'Thank you for purchasing %s!  Please enter your license key below.', 'coderockz-woo-delivery' ), 'Woocommerce Delivery Date Time' ) ); ?></p>
			                <?php endif; ?>

			                <table class="form-table">
			                    <tbody>
			    	                <tr valign="top">
			    	                    <th scope="row" valign="top">
			    	                        <?php _e( 'License Key', 'coderockz-woo-delivery' ); ?>
			    	                    </th>
			    	                    <td>
			    	                        <input id="coderockz-woo-delivery-license-key" name="coderockz-woo-delivery-license-key" type="password" class="regular-text coderockz-woo-delivery-input-field" value="<?php esc_attr_e( $license ); ?>" placeholder="<?php _e( 'Enter your license key', 'coderockz-woo-delivery' ); ?>"/>
			    	                    </td>
			    	                </tr>
			    	                <tr valign="top">
			    	                    <th scope="row" valign="top">
			    	                    </th>
			    	                    <td>
			    	                        <?php if ( $status !== false && $status == 'valid' ) { ?>
			    	                            <p style="color:green;display:inline-block;margin-right:10px;font-weight:bold;"><span class="dashicons dashicons-yes"></span><?php _e( ' active', 'coderockz-woo-delivery' ); ?></p>
			    	                            <?php wp_nonce_field( 'coderockz-woo-delivery-license_nonce', 'coderockz-woo-delivery-license_nonce' ); ?>
			    	                            <input type="submit" class="button-primary" name="coderockz-woo-delivery-license_deactivate" value="<?php _e('Deactivate License', 'coderockz-woo-delivery'); ?>"/>
			    	                        <?php } else {
			    	                            wp_nonce_field( 'coderockz-woo-delivery-license_nonce', 'coderockz-woo-delivery-license_nonce' ); ?>
			    	                            <input type="submit" class="button-primary" name="coderockz-woo-delivery-license_activate" value="<?php _e('Activate License', 'coderockz-woo-delivery'); ?>"/>
			    	                        <?php } ?>
			    	                    </td>
			    	                </tr>
			                    </tbody>
			                </table>

			                <p style="font-weight:700;font-size:14px;"><?php echo sprintf( esc_html( __( 'Any questions or problems with your license? %sContact us%s!', 'coderockz-woo-delivery' ) ), '<a href="https://coderockz.com/support">', '</a>' ); ?></p>
			            </form>
			        </div>
			    </div>
			</div>
			<div data-tab="tab2" class="coderockz-woo-delivery-tabcontent">
				<?php include_once CODEROCKZ_WOO_DELIVERY_DIR . 'admin/includes/coderockz-woo-delivery-reports-tab.php';?>
			</div>
			<div data-tab="tab3" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Order Type Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-delivery-option-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_delivery_option_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:426px!important"><?php _e('Give Option to choose from Delivery or Pickup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to give the freedom to customer whether he wants Home delivery or he picks the ordered products from a pickup location. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_option_time_pickup">
							       <input type="checkbox" name="coderockz_enable_option_time_pickup" id="coderockz_enable_option_time_pickup" <?php echo (isset($delivery_option_settings['enable_option_time_pickup']) && !empty($delivery_option_settings['enable_option_time_pickup'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_option_label"><?php _e('Order Type Field Label', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Order Type field label. Default is Order Type.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_option_label" name="coderockz_woo_delivery_delivery_option_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['delivery_option_label']) && !empty($delivery_option_settings['delivery_option_label'])) ? stripslashes($delivery_option_settings['delivery_option_label']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_option_placeholder"><?php _e('Order Type Field Placeholder', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Order Type field label. Default is Select order type.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_option_placeholder" name="coderockz_woo_delivery_delivery_option_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['delivery_option_placeholder']) && !empty($delivery_option_settings['delivery_option_placeholder'])) ? stripslashes($delivery_option_settings['delivery_option_placeholder']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_option_delivery_label"><?php _e('Delivery Option Label', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Order Type's Home Delivery option label. Default is Delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_option_delivery_label" name="coderockz_woo_delivery_option_delivery_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['delivery_label']) && !empty($delivery_option_settings['delivery_label'])) ? stripslashes($delivery_option_settings['delivery_label']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_option_pickup_label"><?php _e('Self Pickup Option Label', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Order Type's Self Pickup option label. Default is Pickup.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_option_pickup_label" name="coderockz_woo_delivery_option_pickup_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['pickup_label']) && !empty($delivery_option_settings['pickup_label'])) ? stripslashes($delivery_option_settings['pickup_label']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pre_selected_order_type"><?php _e('Pre Selected Order Type', 'coderockz-woo-delivery'); ?><span style="font-size: 11px;font-style: italic;color: lightseagreen;display:block;"><?php _e('(Only working when no WooCommerce shipping)', 'coderockz-woo-delivery'); ?></span></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to give preselected value on the checkout page, specifiy it here", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_pre_selected_order_type">
	                    			<option value="" <?php if(isset($delivery_option_settings['pre_selected_order_type']) && $delivery_option_settings['pre_selected_order_type'] == ""){ echo "selected"; } ?>><?php _e('Select Pre Selected Order Type', 'coderockz-woo-delivery'); ?></option>
									<option value="delivery" <?php if(isset($delivery_option_settings['pre_selected_order_type']) && $delivery_option_settings['pre_selected_order_type'] == "delivery"){ echo "selected"; } ?>>Delivery</option>
									<option value="pickup" <?php if(isset($delivery_option_settings['pre_selected_order_type']) && $delivery_option_settings['pre_selected_order_type'] == "pickup"){ echo "selected"; } ?>>Pickup</option>
									
								</select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_option_no_result_notice"><?php _e('No Delivery or Pickup Message', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If a certain day has no pickup or delivery then the text is appears in the order type box. Default is No Delivery or Pickup Today.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_option_no_result_notice" name="coderockz_woo_delivery_option_no_result_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['no_result_notice']) && !empty($delivery_option_settings['no_result_notice'])) ? stripslashes($delivery_option_settings['no_result_notice']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_maximum_delivery_pickup_per_day"><?php _e('Maximum (Delivery+Pickup) Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your order per day wether it is delivery or pickup, put the quantity here. Keep blank for unlimited order.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_maximum_delivery_pickup_per_day" name="coderockz_woo_delivery_maximum_delivery_pickup_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($delivery_option_settings['maximum_delivery_pickup_per_day']) && !empty($delivery_option_settings['maximum_delivery_pickup_per_day'])) ? stripslashes(esc_attr($delivery_option_settings['maximum_delivery_pickup_per_day'])) : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_maximum_product_delivery_pickup_per_day"><?php _e('Maximum Products(Delivery+Pickup) Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your product per day whether it is delivery or pickup, put the quantity here. Keep blank for unlimited products.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_maximum_product_delivery_pickup_per_day" name="coderockz_woo_delivery_maximum_product_delivery_pickup_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($delivery_option_settings['maximum_product_delivery_pickup_per_day']) && !empty($delivery_option_settings['maximum_product_delivery_pickup_per_day'])) ? stripslashes(esc_attr($delivery_option_settings['maximum_product_delivery_pickup_per_day'])) : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Dynamically Enable/Disable Delivery/Pickup Based on WooCommerce Shipping', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to see the delivery or pickup option based on your WoCommerce Shipping. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_dynamic_order_type">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_dynamic_order_type" id="coderockz_woo_delivery_enable_dynamic_order_type" <?php echo (isset($delivery_option_settings['enable_dynamic_order_type']) && !empty($delivery_option_settings['enable_dynamic_order_type'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz_woo_delivery_dynamic_order_type_notice" style="display:none">
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_dynamic_order_type_no_delivery"><?php _e('No Delivery Notice For Given Address', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show a notice under the order type selection box about no delivery for the address that customer given. Default is not showing any notice.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_dynamic_order_type_no_delivery" name="coderockz_woo_delivery_dynamic_order_type_no_delivery" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['dynamic_order_type_no_delivery']) && !empty($delivery_option_settings['dynamic_order_type_no_delivery'])) ? stripslashes($delivery_option_settings['dynamic_order_type_no_delivery']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_dynamic_order_type_no_pickup"><?php _e('No Pickup Notice For Given Address', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show a notice under the order type selection box about no pickup for the address that customer given. Default is not showing any notice.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_dynamic_order_type_no_pickup" name="coderockz_woo_delivery_dynamic_order_type_no_pickup" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['dynamic_order_type_no_pickup']) && !empty($delivery_option_settings['dynamic_order_type_no_pickup'])) ? stripslashes($delivery_option_settings['dynamic_order_type_no_pickup']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_dynamic_order_type_no_delivery_pickup"><?php _e('No Delivery Or Pickup Notice For Given Address', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show a notice under the order type selection box about no delivery or pickup for the address that customer given. Default is not showing any notice.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_dynamic_order_type_no_delivery_pickup" name="coderockz_woo_delivery_dynamic_order_type_no_delivery_pickup" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['dynamic_order_type_no_delivery_pickup']) && !empty($delivery_option_settings['dynamic_order_type_no_delivery_pickup'])) ? stripslashes($delivery_option_settings['dynamic_order_type_no_delivery_pickup']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_delivery_option_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Restriction', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-delivery-restriction-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_delivery_restriction_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div style="border:1px solid #ddd;border-radius: 4px;margin-bottom:10px;">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Enable Delivery Restriction', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to restrict the delivery option until a certain amount is not in the cart. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_delivery_restriction">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_delivery_restriction" id="coderockz_woo_delivery_enable_delivery_restriction" <?php echo (isset($delivery_option_settings['enable_delivery_restriction']) && !empty($delivery_option_settings['enable_delivery_restriction'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_minimum_amount_cart_restriction"><?php _e('Minimum Amount in Cart to Show Delivey Option', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need minimum amount in the cart to show Delivery option the checkout page or Order type dropdown. Default is no restriction.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:100px!important;" id="coderockz_woo_delivery_minimum_amount_cart_restriction" name="coderockz_woo_delivery_minimum_amount_cart_restriction" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['minimum_amount_cart_restriction']) && !empty($delivery_option_settings['minimum_amount_cart_restriction'])) ? esc_attr($delivery_option_settings['minimum_amount_cart_restriction']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Discount', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including discount. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_discount">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_discount" id="coderockz_woo_delivery_calculating_include_discount" <?php echo (isset($delivery_option_settings['calculating_include_discount']) && !empty($delivery_option_settings['calculating_include_discount'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Tax', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including tax. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_tax">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_tax" id="coderockz_woo_delivery_calculating_include_tax" <?php echo (isset($delivery_option_settings['calculating_include_tax']) && !empty($delivery_option_settings['calculating_include_tax'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_restriction_notice"><?php _e('Minimum Cart Amount Notice', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If the cart total not reach the certain amount then the notice appears in top. Default is Your cart amount must have 'X' to get the Delivery Option", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_restriction_notice" name="coderockz_woo_delivery_delivery_restriction_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['delivery_restriction_notice']) && !empty($delivery_option_settings['delivery_restriction_notice'])) ? $delivery_option_settings['delivery_restriction_notice'] : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	</div>
	                    	<div style="border:1px solid #ddd;border-radius: 4px;margin-bottom:10px;">
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery for User Role', 'coderockz-woo-delivery'); ?><br/><span style="font-size: 11px;font-style: italic;color: lightseagreen;"><?php _e('(User must be Logged in)', 'coderockz-woo-delivery'); ?></span></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the user role for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_hide_delivery_user_roles" name="coderockz_woo_delivery_hide_delivery_user_roles[]" class="coderockz_woo_delivery_hide_delivery_user_roles" multiple>
                                
                                <?php
                                $hide_delivery_user_roles = [];
								if(isset($delivery_option_settings['hide_delivery_user_roles']) && !empty($delivery_option_settings['hide_delivery_user_roles'])) {
									foreach ($delivery_option_settings['hide_delivery_user_roles'] as $hide_role) {
										$hide_delivery_user_roles[] = stripslashes($hide_role);
									}
								}
								
                                foreach ($user_roles as $key => $value) {

                                	$selected = isset($delivery_option_settings['hide_delivery_user_roles']) && !empty($delivery_option_settings['hide_delivery_user_roles']) && in_array($key,$hide_delivery_user_roles) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>


	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery for Non Logged in User', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show delivery only for logged in user, enable this option.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_hide_delivery_non_logged_in_user">
							       <input type="checkbox" name="coderockz_delivery_hide_delivery_non_logged_in_user" id="coderockz_delivery_hide_delivery_non_logged_in_user" <?php echo (isset($delivery_option_settings['hide_delivery_non_logged_in_user']) && !empty($delivery_option_settings['hide_delivery_non_logged_in_user'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_delivery_restriction_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Pickup Restriction', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-pickup-restriction-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
						
	                    <form action="" method="post" id ="coderockz_delivery_pickup_restriction_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div style="border:1px solid #ddd;border-radius: 4px;margin-bottom:10px;">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Enable Pickup Restriction', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to restrict the pickup option until a certain amount is not in the cart. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_pickup_restriction">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_pickup_restriction" id="coderockz_woo_delivery_enable_pickup_restriction" <?php echo (isset($delivery_option_settings['enable_pickup_restriction']) && !empty($delivery_option_settings['enable_pickup_restriction'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_minimum_amount_cart_restriction_pickup"><?php _e('Minimum Amount in Cart to Show Pickup Option', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need minimum amount in the cart to show Pickup option the checkout page or Order type dropdown. Default is no restriction.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:100px!important;" id="coderockz_woo_delivery_minimum_amount_cart_restriction_pickup" name="coderockz_woo_delivery_minimum_amount_cart_restriction_pickup" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['minimum_amount_cart_restriction_pickup']) && !empty($delivery_option_settings['minimum_amount_cart_restriction_pickup'])) ? esc_attr($delivery_option_settings['minimum_amount_cart_restriction_pickup']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Discount', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including discount. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_discount_pickup">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_discount_pickup" id="coderockz_woo_delivery_calculating_include_discount_pickup" <?php echo (isset($delivery_option_settings['calculating_include_discount_pickup']) && !empty($delivery_option_settings['calculating_include_discount_pickup'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Tax', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including tax. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_tax_pickup">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_tax_pickup" id="coderockz_woo_delivery_calculating_include_tax_pickup" <?php echo (isset($delivery_option_settings['calculating_include_tax_pickup']) && !empty($delivery_option_settings['calculating_include_tax_pickup'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_restriction_notice"><?php _e('Minimum Cart Amount Notice', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If the cart total not reach the certain amount then the notice appears in top. Default is Your cart amount must have 'X' to get the Pickup Option", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_restriction_notice" name="coderockz_woo_delivery_pickup_restriction_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['pickup_restriction_notice']) && !empty($delivery_option_settings['pickup_restriction_notice'])) ? $delivery_option_settings['pickup_restriction_notice'] : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	</div>
	                    	<div style="border:1px solid #ddd;border-radius: 4px;margin-bottom:10px;">
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery for User Role', 'coderockz-woo-delivery'); ?><br/><span style="font-size: 11px;font-style: italic;color: lightseagreen;"><?php _e('(User must be Logged in)', 'coderockz-woo-delivery'); ?></span></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the user role for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_hide_pickup_user_roles" name="coderockz_woo_delivery_hide_pickup_user_roles[]" class="coderockz_woo_delivery_hide_pickup_user_roles" multiple>
                                
                                <?php
                                $hide_pickup_user_roles = [];
								if(isset($delivery_option_settings['hide_pickup_user_roles']) && !empty($delivery_option_settings['hide_pickup_user_roles'])) {
									foreach ($delivery_option_settings['hide_pickup_user_roles'] as $hide_role) {
										$hide_pickup_user_roles[] = stripslashes($hide_role);
									}
								}
								
                                foreach ($user_roles as $key => $value) {

                                	$selected = isset($delivery_option_settings['hide_pickup_user_roles']) && !empty($delivery_option_settings['hide_pickup_user_roles']) && in_array($key,$hide_pickup_user_roles) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>


	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Pickup for Non Logged in User', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show pickup only for logged in user, enable this option.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_hide_pickup_non_logged_in_user">
							       <input type="checkbox" name="coderockz_delivery_hide_pickup_non_logged_in_user" id="coderockz_delivery_hide_pickup_non_logged_in_user" <?php echo (isset($delivery_option_settings['hide_pickup_non_logged_in_user']) && !empty($delivery_option_settings['hide_pickup_non_logged_in_user'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_pickup_restriction_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category/Product Wise Delivery Restriction', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else {?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('In Hide Delivery For Individual Product option, if product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-category-product-delivery-restriction-settings-notice"></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_category_product_delivery_restriction_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery For Product Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product categories for which you don't want to give the facility of delivery. So only pickup option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_restrict_delivery_categories" name="coderockz_woo_delivery_restrict_delivery_categories[]" class="coderockz_woo_delivery_restrict_delivery_categories" multiple>
                                
                                <?php

                                $restrict_delivery_categories = [];

								if(isset($delivery_option_settings['restrict_delivery_categories']) && !empty($delivery_option_settings['restrict_delivery_categories'])) {
									foreach ($delivery_option_settings['restrict_delivery_categories'] as $hide_cat) {
										$restrict_delivery_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($delivery_option_settings['restrict_delivery_categories']) && !empty($delivery_option_settings['restrict_delivery_categories']) && in_array(htmlspecialchars_decode($cat->name),$restrict_delivery_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery For Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to give the facility of delivery. So only pickup option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_restrict_delivery_individual_product" name="coderockz_woo_delivery_restrict_delivery_individual_product[]" class="coderockz_woo_delivery_restrict_delivery_individual_product" multiple>
                                
                                <?php
                                foreach ($store_products as $key=>$value) {

                                	$selected = isset($delivery_option_settings['restrict_delivery_products']) && !empty($delivery_option_settings['restrict_delivery_products']) && in_array($key,$delivery_option_settings['restrict_delivery_products']) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery For Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to give the facility of delivery. So only pickup option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$restrict_delivery_individual_product = isset($delivery_option_settings['restrict_delivery_products']) && !empty($delivery_option_settings['restrict_delivery_products']) ? $delivery_option_settings['restrict_delivery_products'] : array();
	                        	$restrict_delivery_individual_product = implode(",",$restrict_delivery_individual_product);
	                        	?>
	                    		<input id="coderockz_woo_delivery_restrict_delivery_individual_product_input" name="coderockz_woo_delivery_restrict_delivery_individual_product_input" type="text" class="coderockz_woo_delivery_restrict_delivery_individual_product_input coderockz-woo-delivery-input-field" value="<?php echo $restrict_delivery_individual_product; ?>" placeholder="<?php _e('Comma(,) separated Product/Variation ID', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show Also If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is delivery restriction category's products or delivery restriction products in the cart then whatever there are other category's products or other products, the Delivery option is hidden. Enable it if you want to reverse it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_restrict_delivery_reverse_current_condition">
							       <input type="checkbox" name="coderockz_delivery_restrict_delivery_reverse_current_condition" id="coderockz_delivery_restrict_delivery_reverse_current_condition" <?php echo (isset($delivery_option_settings['restrict_delivery_reverse_current_condition']) && !empty($delivery_option_settings['restrict_delivery_reverse_current_condition'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_category_product_delivery_restriction_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>


                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category/Product Wise Pickup Restriction', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('In Hide Delivery For Individual Product option, if product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-category-product-pickup-restriction-settings-notice"></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_category_product_pickup_restriction_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Pickup For Product Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product categories for which you don't want to give the facility of pickup. So only delivery option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_restrict_pickup_categories" name="coderockz_woo_delivery_restrict_pickup_categories[]" class="coderockz_woo_delivery_restrict_pickup_categories" multiple>
                                
                                <?php

                                $restrict_pickup_categories = [];
								if(isset($delivery_option_settings['restrict_pickup_categories']) && !empty($delivery_option_settings['restrict_pickup_categories'])) {
									foreach ($delivery_option_settings['restrict_pickup_categories'] as $hide_cat) {
										$restrict_pickup_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($delivery_option_settings['restrict_pickup_categories']) && !empty($delivery_option_settings['restrict_pickup_categories']) && in_array(htmlspecialchars_decode($cat->name),$restrict_pickup_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Pickup For Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to give the facility of delivery. So only pickup option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_restrict_pickup_individual_product" name="coderockz_woo_delivery_restrict_pickup_individual_product[]" class="coderockz_woo_delivery_restrict_pickup_individual_product" multiple>
                                
                                <?php
                                foreach ($store_products as $key=>$value) {

                                	$selected = isset($delivery_option_settings['restrict_pickup_products']) && !empty($delivery_option_settings['restrict_pickup_products']) && in_array($key,$delivery_option_settings['restrict_pickup_products']) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery For Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to give the facility of delivery. So only pickup option is showing in the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$restrict_pickup_individual_product = isset($delivery_option_settings['restrict_pickup_products']) && !empty($delivery_option_settings['restrict_pickup_products']) ? $delivery_option_settings['restrict_pickup_products'] : array();
	                        	$restrict_pickup_individual_product = implode(",",$restrict_pickup_individual_product);
	                        	?>
	                    		<input id="coderockz_woo_delivery_restrict_pickup_individual_product_input" name="coderockz_woo_delivery_restrict_pickup_individual_product_input" type="text" class="coderockz_woo_delivery_restrict_pickup_individual_product_input coderockz-woo-delivery-input-field" value="<?php echo $restrict_pickup_individual_product; ?>" placeholder="<?php _e('Comma(,) separated Product/Variation ID', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>

	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show Also If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is pickup restriction category's products or pickup restriction products in the cart then whatever there are other category's products or other products, the Delivery option is hidden. Enable it if you want to reverse it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_restrict_pickup_reverse_current_condition">
							       <input type="checkbox" name="coderockz_delivery_restrict_pickup_reverse_current_condition" id="coderockz_delivery_restrict_pickup_reverse_current_condition" <?php echo (isset($delivery_option_settings['restrict_pickup_reverse_current_condition']) && !empty($delivery_option_settings['restrict_pickup_reverse_current_condition'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_category_product_pickup_restriction_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>


                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Free Shipping Restriction', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body" style="padding-top: 0;">
						<p class="coderockz-woo-delivery-free-shipping-restriction-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_free_shipping_restriction_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div style="border:1px solid #ddd;border-radius: 4px;">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Enable Free Shipping Restriction', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to restrict the free shipping method until a certain amount is not in the cart. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_free_shipping_restriction">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_free_shipping_restriction" id="coderockz_woo_delivery_enable_free_shipping_restriction" <?php echo (isset($delivery_option_settings['enable_free_shipping_restriction']) && !empty($delivery_option_settings['enable_free_shipping_restriction'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_minimum_amount_shipping_restriction"><?php _e('Minimum Amount in Cart to Show Free Shipping', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need minimum amout in the cart to show free shipping method in the checkout page or Order type dropdown. Default is no restriction.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:100px!important;" id="coderockz_woo_delivery_minimum_amount_shipping_restriction" name="coderockz_woo_delivery_minimum_amount_shipping_restriction" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['minimum_amount_shipping_restriction']) && !empty($delivery_option_settings['minimum_amount_shipping_restriction'])) ? esc_attr($delivery_option_settings['minimum_amount_shipping_restriction']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Discount', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including discount. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_discount_free_shipping">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_discount_free_shipping" id="coderockz_woo_delivery_calculating_include_discount_free_shipping" <?php echo (isset($delivery_option_settings['calculating_include_discount_free_shipping']) && !empty($delivery_option_settings['calculating_include_discount_free_shipping'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Tax', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including tax. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_tax_free_shipping">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_tax_free_shipping" id="coderockz_woo_delivery_calculating_include_tax_free_shipping" <?php echo (isset($delivery_option_settings['calculating_include_tax_free_shipping']) && !empty($delivery_option_settings['calculating_include_tax_free_shipping'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_free_shipping_restriction_notice"><?php _e('Minimum Cart Amount Notice For Free Shipping', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If the cart total not reach the certain amount then the notice appears in top. Default is Your cart amount must have 'X' to get the Free Shipping", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_free_shipping_restriction_notice" name="coderockz_woo_delivery_free_shipping_restriction_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_option_settings['free_shipping_restriction_notice']) && !empty($delivery_option_settings['free_shipping_restriction_notice'])) ? $delivery_option_settings['free_shipping_restriction_notice'] : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	</div>

	                    	<div style="border:1px solid #ddd;border-radius: 4px;margin: 10px 0;">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Enable Free Shipping Only For Current Day Delivery', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to see the free shipping only for current day delivery. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_free_shipping_current_day">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_free_shipping_current_day" id="coderockz_woo_delivery_enable_free_shipping_current_day" <?php echo (isset($delivery_option_settings['enable_free_shipping_current_day']) && !empty($delivery_option_settings['enable_free_shipping_current_day'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Disable Free Shipping For Current Day Delivery', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to see the free shipping for other's day delivery that means disable free shipping for current day delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_disable_free_shipping_current_day">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_free_shipping_current_day" id="coderockz_woo_delivery_disable_free_shipping_current_day" <?php echo (isset($delivery_option_settings['disable_free_shipping_current_day']) && !empty($delivery_option_settings['disable_free_shipping_current_day'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Free Shipping For Weekdays', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to give your customers the free shipping facility for specific weekday, input those weekdays here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_hide_free_shipping_weekday" name="coderockz_woo_delivery_hide_free_shipping_weekday[]" class="coderockz_woo_delivery_hide_free_shipping_weekday" multiple>
                                <?php
                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($delivery_option_settings['hide_free_shipping_weekday']) && !empty($delivery_option_settings['hide_free_shipping_weekday']) && in_array($key,$delivery_option_settings['hide_free_shipping_weekday']) ? "selected" : "";
	                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }
                                ?>
                                </select>
	                    	</div>
	                    	
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show Free Shipping Only At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
		                        <input style="width:430px!important;" type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_show_free_shipping_only_at" value="<?php echo (isset($delivery_option_settings['show_free_shipping_only_at_string']) && $delivery_option_settings['show_free_shipping_only_at_string'] != "") ? $delivery_option_settings['show_free_shipping_only_at_string'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Free Shipping At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
		                        <input style="width:430px!important;" type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_hide_free_shipping_at" value="<?php echo (isset($delivery_option_settings['hide_free_shipping_at_string']) && $delivery_option_settings['hide_free_shipping_at_string'] != "") ? $delivery_option_settings['hide_free_shipping_at_string'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<?php if(!WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"  style = "width: 365px!important;"><?php _e('Hide Other Shipping Methods If Free Shipping Available', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide other shipping methods when free shipping available. Default is showing all shipping methods.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_hide_other_shipping_method">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_hide_other_shipping_method" id="coderockz_woo_delivery_enable_hide_other_shipping_method" <?php echo (isset($delivery_option_settings['enable_hide_other_shipping_method']) && !empty($delivery_option_settings['enable_hide_other_shipping_method'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php } ?>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_free_shipping_restriction_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Hide Delivery Option', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-disable-delivery-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('If you put weekdays here, your customers are not showing the Delivery option for those weekdays. So they can\'t place a order as delivery for those weekdays. It\'s totally hidden the Delivery Option from your Order Type Dropdown for those weekdays. It\'s not as a weekend in delivery date calendar.', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Be carefull: If a day is in both Disable Delivery Option & Disable Pickup Option, then no one can order that day because he can\'t select any option from order type and he can\'t place any order that day', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_disable_delivery_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery Option From Order Type for Weekdays', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to give your customers the delivery facility for specific days, input those days here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_disable_delivery_facility_days" name="coderockz_woo_delivery_disable_delivery_facility_days[]" class="coderockz_woo_delivery_disable_delivery_facility_days" multiple>
                                <?php
                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($delivery_option_settings['disable_delivery_facility']) && !empty($delivery_option_settings['disable_delivery_facility']) && in_array($key,$delivery_option_settings['disable_delivery_facility']) ? "selected" : "";
	                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }
                                ?>
                                </select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Delivery Option From Order Type for Specific Dates', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
		                        <input style="width:430px!important;" type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_disable_delivery_facility_dates" value="<?php echo (isset($delivery_option_settings['disable_delivery_facility_dates_string']) && $delivery_option_settings['disable_delivery_facility_dates_string'] != "") ? $delivery_option_settings['disable_delivery_facility_dates_string'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_disable_delivery_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Hide Pickup Option', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-disable-pickup-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('If you put weekdays here, your customers are not showing the Pickup option for those weekdays. So they can\'t place a order as pickup for those weekdays. It\'s totally hidden the Pickup Option from your Order Type Dropdown for those weekdays. It\'s not as a weekend in pickup date calendar.', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Only working if Order Type is Enabled', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Be carefull: If a day is in both Disable Delivery Option & Disable Pickup Option, then no one can order that day because he can\'t select any option from order type and he can\'t place any order that day', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_disable_pickup_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Pickup Option From Order Type', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to give your customers the pickup facility for specific days, input those days here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_disable_pickup_facility_days" name="coderockz_woo_delivery_disable_pickup_facility_days[]" class="coderockz_woo_delivery_disable_pickup_facility_days" multiple>
                                <?php
                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($delivery_option_settings['disable_pickup_facility']) && !empty($delivery_option_settings['disable_pickup_facility']) && in_array($key,$delivery_option_settings['disable_pickup_facility']) ? "selected" : "";
	                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }
                                ?>
                                </select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Pickup Option From Order Type for Specific Dates', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
		                        <input style="width:430px!important;" type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_disable_pickup_facility_dates" value="<?php echo (isset($delivery_option_settings['disable_pickup_facility_dates_string']) && $delivery_option_settings['disable_pickup_facility_dates_string'] != "") ? $delivery_option_settings['disable_pickup_facility_dates_string'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_disable_pickup_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
			</div>
			<div data-tab="tab4" class="coderockz-woo-delivery-tabcontent">
				
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('General Delivery Date Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body coderockz-woo-delivery-date-card-body">
						<p class="coderockz-woo-delivery-date-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_date_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Delivery Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Delivery Date input field in woocommerce order checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_delivery_date">
							       <input type="checkbox" name="coderockz_enable_delivery_date" id="coderockz_enable_delivery_date" <?php echo (isset($date_settings['enable_delivery_date']) && !empty($date_settings['enable_delivery_date'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Delivery Date Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Delivery Date input field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_mandatory">
							       <input type="checkbox" name="coderockz_delivery_date_mandatory" id="coderockz_delivery_date_mandatory" <?php echo (isset($date_settings['delivery_date_mandatory']) && !empty($date_settings['delivery_date_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_field_label"><?php _e('Date Field Heading for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Date input field heading. Default is Delivery Date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_date_field_label" name="coderockz_delivery_date_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($date_settings['field_label']) && !empty($date_settings['field_label'])) ? stripslashes(esc_attr($date_settings['field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_field_placeholder"><?php _e('Date Field Placeholder for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Date input field placeholder. Default is Select delivery date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_date_field_placeholder" name="coderockz_delivery_date_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($date_settings['field_placeholder']) && !empty($date_settings['field_placeholder'])) ? stripslashes(esc_attr($date_settings['field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_selectable_date"><?php _e('Allow Delivery in Next Available Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("User can only select the number of date from calander that is specified Here. Other dates are disabled. Only numerical value is excepted. Default is 365 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_date_selectable_date" name="coderockz_delivery_date_selectable_date" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($date_settings['selectable_date']) && !empty($date_settings['selectable_date'])) ? stripslashes(esc_attr($date_settings['selectable_date'])) : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_selectable_date"><?php _e('Allow Delivery Until Date', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("User can only select a date until the date that is specified Here. Input date format YYYY-MM-DD.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_date_selectable_date_until" name="coderockz_delivery_date_selectable_date_until" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($date_settings['selectable_date_until']) && !empty($date_settings['selectable_date_until'])) ? stripslashes(esc_attr($date_settings['selectable_date_until'])) : ""; ?>" placeholder="<?php _e(' Format is YYYY-MM-DD', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_maximum_order_per_day"><?php _e('Maximum Delivery Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your delivery per day, put the delivery quantity here. Keep blank for unlimited delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_date_maximum_order_per_day" name="coderockz_delivery_date_maximum_order_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($date_settings['maximum_order_per_day']) && !empty($date_settings['maximum_order_per_day'])) ? stripslashes(esc_attr($date_settings['maximum_order_per_day'])) : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_maximum_order_product_per_day"><?php _e('Maximum Delivery Products Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your delivery products per day, put the delivery products quantity here. Keep blank for unlimited delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_date_maximum_order_product_per_day" name="coderockz_delivery_date_maximum_order_product_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($date_settings['maximum_order_product_per_day']) && !empty($date_settings['maximum_order_product_per_day'])) ? stripslashes(esc_attr($date_settings['maximum_order_product_per_day'])) : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group" id="coderockz_delivery_date_calendar_locale">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_calendar_locale"><?php _e('Calendar Locale', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Date's calendar will showing in selected language. Default is English.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_date_calendar_locale">
	                    			<option value="default" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "default"){ echo "selected"; } ?>>English</option>
									<option value="ar" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ar"){ echo "selected"; } ?>>Arabic</option>
									<option value="at" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "at"){ echo "selected"; } ?>>Austria</option>
									<option value="az" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "az"){ echo "selected"; } ?>>Azerbaijan</option>
									<option value="be" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "be"){ echo "selected"; } ?>>Belarusian</option>
									<option value="bg" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "bg"){ echo "selected"; } ?>>Bulgarian</option>
									<option value="bn" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "bn"){ echo "selected"; } ?>>Bangla</option>
									<option value="bs" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "bs"){ echo "selected"; } ?>>Bosnian</option>
									<option value="cat" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "cat"){ echo "selected"; } ?>>Catalan</option>
									<option value="cs" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "cs"){ echo "selected"; } ?>>Czech</option>
									<option value="cy" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "cy"){ echo "selected"; } ?>>Welsh</option>
									<option value="da" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "da"){ echo "selected"; } ?>>Danish</option>
									<option value="de" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "de"){ echo "selected"; } ?>>German</option>
									<option value="eo" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "eo"){ echo "selected"; } ?>>Esperanto</option>
									<option value="es" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "es"){ echo "selected"; } ?>>Spanish</option>
									<option value="et" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "et"){ echo "selected"; } ?>>Estonian</option>
									<option value="fi" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "fi"){ echo "selected"; } ?>>Finnish</option>
									<option value="fr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "fr"){ echo "selected"; } ?>>French</option>
									<option value="fo" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "fo"){ echo "selected"; } ?>>Faroese</option>
									<option value="fa" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "fa"){ echo "selected"; } ?>>Farsi (Persian)</option>
									<option value="ga" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ga"){ echo "selected"; } ?>>Gaelic Irish</option>
									<option value="gr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "gr"){ echo "selected"; } ?>>Greek</option>
									<option value="he" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "he"){ echo "selected"; } ?>>Hebrew</option>
									<option value="hi" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "hi"){ echo "selected"; } ?>>Hindi</option>
									<option value="hr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "hr"){ echo "selected"; } ?>>Croatian</option>
									<option value="hu" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "hu"){ echo "selected"; } ?>>Hungarian</option>
									<option value="id" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "id"){ echo "selected"; } ?>>Indonesian</option>
									<option value="is" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "is"){ echo "selected"; } ?>>Icelandic</option>
									<option value="it" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "it"){ echo "selected"; } ?>>Italian</option>
									<option value="ja" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ja"){ echo "selected"; } ?>>Japanese</option>
									<option value="ka" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ka"){ echo "selected"; } ?>>Georgian</option>
									<option value="km" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "km"){ echo "selected"; } ?>>Khmer</option>
									<option value="ko" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ko"){ echo "selected"; } ?>>Republic of Korea</option>
									<option value="kz" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "kz"){ echo "selected"; } ?>>Kazakh</option>
									<option value="lt" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "lt"){ echo "selected"; } ?>>Lithuanian</option>
									<option value="lv" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "lv"){ echo "selected"; } ?>>Latvian</option>
									<option value="mk" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "mk"){ echo "selected"; } ?>>Macedonian</option>
									<option value="mn" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "mn"){ echo "selected"; } ?>>Mongolian</option>
									<option value="ms" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ms"){ echo "selected"; } ?>>Malaysian</option>
									<option value="my" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "my"){ echo "selected"; } ?>>Burmese</option>
									<option value="nl" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "nl"){ echo "selected"; } ?>>Dutch</option>
									<option value="no" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "no"){ echo "selected"; } ?>>Norwegian</option>
									<option value="pa" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "pa"){ echo "selected"; } ?>>Punjabi</option>
									<option value="pl" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "pl"){ echo "selected"; } ?>>Polish</option>
									<option value="pt" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "pt"){ echo "selected"; } ?>>Portuguese</option>
									<option value="ro" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ro"){ echo "selected"; } ?>>Romanian</option>
									<option value="ru" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "ru"){ echo "selected"; } ?>>Russian</option>
									<option value="sk" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sk"){ echo "selected"; } ?>>Slovak</option>
									<option value="sl" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sl"){ echo "selected"; } ?>>Slovenian</option>
									<option value="si" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "si"){ echo "selected"; } ?>>Sinhala</option>
									<option value="sq" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sq"){ echo "selected"; } ?>>Albanian</option>
									<option value="sr-cyr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sr-cyr"){ echo "selected"; } ?>>Serbian Cyrillic</option>
									<option value="sr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sr"){ echo "selected"; } ?>>Serbian</option>
									<option value="sv" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "sv"){ echo "selected"; } ?>>Swedish</option>
									<option value="th" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "th"){ echo "selected"; } ?>>Thai</option>
									<option value="tr" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "tr"){ echo "selected"; } ?>>Turkish</option>
									<option value="uk" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "uk"){ echo "selected"; } ?>>Ukrainian</option>
									<option value="uz" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "uz"){ echo "selected"; } ?>>Uzbek</option>
									<option value="vn" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "vn"){ echo "selected"; } ?>>Vietnamese</option>
									<option value="zh" <?php if(isset($date_settings['calendar_locale']) && $date_settings['calendar_locale'] == "zh"){ echo "selected"; } ?>>Mandarin</option>
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_calendar_theme"><?php _e('Calendar Theme', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to change the calendar theme, select your desire theme from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_calendar_theme">
								    <option value="" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == ""){ echo "selected"; } ?>><?php _e('Default','coderockz-woo-delivery'); ?></option>
									<option value="dark" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "dark"){ echo "selected"; } ?>>Dark</option>
									<option value="material_blue" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_blue"){ echo "selected"; } ?>>Material Blue</option>
									<option value="material_green" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_green"){ echo "selected"; } ?>>Material Green</option>
									<option value="material_red" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_red"){ echo "selected"; } ?>>Material Red</option>
									<option value="material_orange" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_orange"){ echo "selected"; } ?>>Material Orange</option>
									<option value="airbnb" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "airbnb"){ echo "selected"; } ?>>Airbnb</option>
									<option value="confetti" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "confetti"){ echo "selected"; } ?>>Confetti</option>
								</select>
	                    		
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_week_starts_from"><?php _e('Week Starts From', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Date's calendar will start from the day that is selected Here. Default is Sunday.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_date_week_starts_from">
	                    			<option value="" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == ""){ echo "selected"; } ?>><?php _e('Select Day', 'coderockz-woo-delivery'); ?></option>
									<option value="0" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "0"){ echo "selected"; } ?>><?php _e('Sunday', 'coderockz-woo-delivery'); ?></option>
									<option value="1" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "1"){ echo "selected"; } ?>><?php _e('Monday', 'coderockz-woo-delivery'); ?></option>
									<option value="2" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "2"){ echo "selected"; } ?>><?php _e('Tuesday', 'coderockz-woo-delivery'); ?></option>
									<option value="3" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "3"){ echo "selected"; } ?>><?php _e('Wednesday', 'coderockz-woo-delivery'); ?></option>
									<option value="4" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "4"){ echo "selected"; } ?>><?php _e('Thursday', 'coderockz-woo-delivery'); ?></option>
									<option value="5" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "5"){ echo "selected"; } ?>><?php _e('Friday', 'coderockz-woo-delivery'); ?></option>
									<option value="6" <?php if(isset($date_settings['week_starts_from']) && $date_settings['week_starts_from'] == "6"){ echo "selected"; } ?>><?php _e('Saturday', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_format"><?php _e('Delivery Date Format', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Date format that is used in everywhere which is available by this plugin. Default is F j, Y ( ex. March 6, 2011 ).", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_date_format">
	                    			<option value="F j, Y" <?php if(isset($date_settings['date_format']) && $date_settings['date_format'] == "F j, Y"){ echo "selected"; } ?>>F j, Y ( ex. <?php _e('March','coderockz-woo-delivery'); ?> 6, 2011 )</option>
									<option value="d-m-Y" <?php if(isset($date_settings['date_format']) && $date_settings['date_format'] == "d-m-Y"){ echo "selected"; } ?>>d-m-Y ( ex. 29-03-2011 )</option>
									<option value="m/d/Y" <?php if(isset($date_settings['date_format']) && $date_settings['date_format'] == "m/d/Y"){ echo "selected"; } ?>>m/d/Y ( ex. 03/29/2011 )</option>
									<option value="d.m.Y" <?php if(isset($date_settings['date_format']) && $date_settings['date_format'] == "d.m.Y"){ echo "selected"; } ?>>d.m.Y ( ex. 29.03.2011 )</option>
									
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Weekday Name in Delivery Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add the weekday name in the delivery date then enable it. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_add_weekday_name">
							       <input type="checkbox" name="coderockz_woo_delivery_add_weekday_name" id="coderockz_woo_delivery_add_weekday_name" <?php echo (isset($date_settings['add_weekday_name']) && !empty($date_settings['add_weekday_name'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label" for="coderockz_delivery_date_delivery_days"><?php _e('Delivery Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("Delivery is only available in those days that are checked. Other dates corresponding to the unchecked days are disabled in the calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_delivery_date_delivery_days" style="display:inline-block">
	                    		<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="6" <?php echo in_array("6",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="0" <?php echo in_array("0",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="1" <?php echo in_array("1",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="2" <?php echo in_array("2",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="3" <?php echo in_array("3",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="4" <?php echo in_array("4",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_delivery_date_delivery_days[]" value="5" <?php echo in_array("5",$selected_delivery_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
								</div>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Same Day Delivery', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Disable same day delivery according to your timezone. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_disable_same_day_delivery">
							       <input type="checkbox" name="coderockz_disable_same_day_delivery" id="coderockz_disable_same_day_delivery" <?php echo (isset($date_settings['disable_same_day_delivery']) && !empty($date_settings['disable_same_day_delivery'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Auto Select 1st Available Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the option if you want to select the first available date automatically and shown in the delivery date field. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_auto_select_first_date">
							       <input type="checkbox" name="coderockz_auto_select_first_date" id="coderockz_auto_select_first_date" <?php echo (isset($date_settings['auto_select_first_date']) && !empty($date_settings['auto_select_first_date'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_date_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

			</div>
			<div data-tab="tab8" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('General Time Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_time_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Delivery Time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Delivery Time select field in woocommerce order checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_delivery_time">
							       <input type="checkbox" name="coderockz_enable_delivery_time" id="coderockz_enable_delivery_time" <?php echo (isset($time_settings['enable_delivery_time']) && !empty($time_settings['enable_delivery_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Delivery Time Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Delivery Time select field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_time_mandatory">
							       <input type="checkbox" name="coderockz_delivery_time_mandatory" id="coderockz_delivery_time_mandatory" <?php echo (isset($time_settings['delivery_time_mandatory']) && !empty($time_settings['delivery_time_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_field_label"><?php _e('Delivery Time Field Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time select field heading. Default is Delivery Time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_time_field_label" name="coderockz_delivery_time_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($time_settings['field_label']) && !empty($time_settings['field_label'])) ? stripslashes(esc_attr($time_settings['field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_field_placeholder"><?php _e('Delivery Time Field Placeholder', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time select field label and placeholder. Default is Select delivery time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_time_field_placeholder" name="coderockz_delivery_time_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($time_settings['field_placeholder']) && !empty($time_settings['field_placeholder'])) ? stripslashes(esc_attr($time_settings['field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_format"><?php _e('Delivery Time format', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Time format that is used in everywhere which is available by this plugin. Default is 12 Hours.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_time_format">

	                    			<option value="" <?php if(isset($time_settings['time_format']) && $time_settings['time_format'] == ""){ echo "selected"; } ?>><?php _e('Select Time Format', 'coderockz-woo-delivery'); ?></option>
									<option value="12" <?php if(isset($time_settings['time_format']) && $time_settings['time_format'] == "12"){ echo "selected"; } ?>><?php _e('12 Hours', 'coderockz-woo-delivery'); ?></option>
									<option value="24" <?php if(isset($time_settings['time_format']) && $time_settings['time_format'] == "24"){ echo "selected"; } ?>><?php _e('24 Hours', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add an Option As Soon As Possible', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the option if you want to show an option As Soon As Possible in the delivery time field.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivry_as_soon_as_possible_option">
							       <input type="checkbox" name="coderockz_woo_delivry_as_soon_as_possible_option" id="coderockz_woo_delivry_as_soon_as_possible_option" <?php echo (isset($time_settings['enable_as_soon_as_possible_option']) && !empty($time_settings['enable_as_soon_as_possible_option'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_as_soon_as_possible_text"><?php _e('Text for As Soon As Possible Option', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("As Soon As Possible text. Default is As Soon As Possible.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_as_soon_as_possible_text" name="coderockz_woo_delivery_as_soon_as_possible_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($time_settings['as_soon_as_possible_text']) && !empty($time_settings['as_soon_as_possible_text'])) ? stripslashes(esc_attr($time_settings['as_soon_as_possible_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_as_soon_as_possible_fee"><?php _e('As Soon As Possible Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("As Soon As Possible fee. Default is no fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:250px!important;" id="coderockz_woo_delivery_as_soon_as_possible_fee" name="coderockz_woo_delivery_as_soon_as_possible_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo isset($time_settings['as_soon_as_possible_fee']) && !empty($time_settings['as_soon_as_possible_fee']) ? esc_attr($time_settings['as_soon_as_possible_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Don\'t Consider Order for Maximum Limit if Delivery Status Completed ' , 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("if you want to free up a slot by making the delivery status completed that is already reached for maximum limit then enable the option.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_free_up_slot_for_delivery_completed">
							       <input type="checkbox" name="coderockz_delivery_free_up_slot_for_delivery_completed" id="coderockz_delivery_free_up_slot_for_delivery_completed" <?php echo (isset($time_settings['free_up_slot_for_delivery_completed']) && !empty($time_settings['free_up_slot_for_delivery_completed'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Current Time Slot', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make the time slot disabled that has the current time. In default, the time slot isn't disabled that has the current time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_time_disable_current_time_slot">
							       <input type="checkbox" name="coderockz_delivery_time_disable_current_time_slot" id="coderockz_delivery_time_disable_current_time_slot" <?php echo (isset($time_settings['disabled_current_time_slot']) && !empty($time_settings['disabled_current_time_slot'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Auto Select 1st Available Time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the option if you want to select the first available time based on date automatically and shown in the delivery time field. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_auto_select_first_time">
							       <input type="checkbox" name="coderockz_auto_select_first_time" id="coderockz_auto_select_first_time" <?php echo (isset($time_settings['auto_select_first_time']) && !empty($time_settings['auto_select_first_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php if(!WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Searchbox From Time Field Dropdown', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the searchbox from delivery time field dropdown, enable it. Default is Showing searhbox.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_hide_searchbox_time_field_dropdown">
							       <input type="checkbox" name="coderockz_hide_searchbox_time_field_dropdown" id="coderockz_hide_searchbox_time_field_dropdown" <?php echo (isset($time_settings['hide_searchbox']) && !empty($time_settings['hide_searchbox'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php } ?>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_time_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Add Delivery Time Slot', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
                    	<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' To know how to make your custom timeslots perfectly ', 'coderockz-woo-delivery'); ?><a href="https://coderockz.com/documentations/make-custom-timeslots-perfectly" target="_blank"><?php _e('click here', 'coderockz-woo-delivery'); ?></a></p>
                    	<input class="coderockz-woo-delivery-add-time-slot-btn" type="button" value="<?php _e('Add New Time Slot', 'coderockz-woo-delivery'); ?>">
	                    <div id="coderockz-woo-delivery-time-slot-accordion">
                    	  <div class="coderockz-woo-delivery-time-slot-accordion-header" style="display:none;">
                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><span class="coderockz-woo-delivery-slot-start-hour">Start Time</span><span class="coderockz-woo-delivery-slot-start-min"></span><span class="coderockz-woo-delivery-slot-start-format"></span> - <span class="coderockz-woo-delivery-slot-end-hour">End Time</span><span class="coderockz-woo-delivery-slot-end-min"></span><span class="coderockz-woo-delivery-slot-end-format"></span></p>
                    	  </div>
						  <div data-plugin-url="<?php echo CODEROCKZ_WOO_DELIVERY_URL; ?>" class="coderockz-woo-delivery-time-slot-accordion-content" style="display:none;">
						  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz-woo-delivery-enable-custom-time-slot"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
                    		</div>
                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-time-slot-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
                    		<p class="coderockz-woo-delivery-custom-time-slot-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Custom Timeslot Name', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you give a name of the timeslot, it will show along with the time on the checkout page", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="text" class="coderockz-woo-delivery-custom-time-slot-name coderockz-woo-delivery-input-field" value="" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_slot_starts"><?php _e('Time Slot Starts From', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time Slot starts from the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz_delivery_time_slot_starts coderockz_woo_delivery_custom_time_slot_starts">
	                    			
	                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_starts_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_starts_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz_woo_delivery_custom_time_slot_starts_format coderockz-woo-delivery-select-field">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Time Slot Ends At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time Slot ends at the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz_delivery_time_slot_ends coderockz_woo_delivery_custom_time_slot_ends">
	                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_ends_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_ends_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz_woo_delivery_custom_time_slot_ends_format coderockz-woo-delivery-select-field" name="coderockz_delivery_time_slot_ends_format">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                        	<p class="coderockz_custom_end_time_greater_notice">End Time Must after Start Time</p>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Want to split the timeslot?', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to split the timeslot in several timeslot according a fixed interval. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_time_slot_split"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-split-time-duration-section">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Each splited Time Slot Duration', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each splited delivery time slot duration that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                    		<div class="coderockz_split_time_slot_duration">
			                        	<input type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field coderockz_split_time_slot_duration_time" value="" placeholder="" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field coderockz_split_time_slot_duration_format">
											<option value="min"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
											<option value="hour"><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
										</select>
		                        	</div>
		                        	<p class="coderockz_split_time_slot_duration_notice">Time slot duration is required</p>
		                    	</div>

		                    	<div class="coderockz-woo-delivery-form-group">
		                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make each timeslot single', 'coderockz-woo-delivery'); ?></span>
		                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every timeslot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								    <label class="coderockz-woo-delivery-toogle-switch">
								       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_splited_time_slot_single"/>
								       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
								    </label>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-single-time-section">
	                    		<div class="coderockz-woo-delivery-form-group">
		                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make each timeslot single', 'coderockz-woo-delivery'); ?></span>
		                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every timeslot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								    <label class="coderockz-woo-delivery-toogle-switch">
								       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_time_slot_single"/>
								       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
								    </label>
		                    	</div>
		                    </div>
		                    <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Current Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot current date. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_hide_time_slot_current_date"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Next Day', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot for next day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_hide_time_slot_next_day"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_timeslot_closing_time"><?php _e('Hide this timeslot at', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show the timeslot after a certain time if the current date is selected as delivery date, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_timeslot_closing_time" class="coderockz_woo_delivery_timeslot_closing_time">
	                    			
	                        	<input name="coderockz_woo_delivery_timeslot_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_timeslot_closing_time_hour" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_woo_delivery_timeslot_closing_time_min" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_timeslot_closing_time_min" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_timeslot_closing_time_format" name="coderockz_woo_delivery_timeslot_closing_time_format">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Delivery Per Time Slot', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each time slot take maximum number of orders that is specified here. After reaching the maximum order, the time slot is disabled automaticaly. Only numerical value is accepted. Blank this field means each time slot takes unlimited order.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="number" class="coderockz-woo-delivery-custom-time-slot-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Timeslot Only At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the timeslot only at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-time-slot-specific-date coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-time-slot-specific-date-close coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Time Slot Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this time slot, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	
	                        	<input type="text" class="coderockz-woo-delivery-custom-time-slot-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This time slot will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz-woo-delivery-slot-enable-for" style="display:inline-block">
	                    		<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="6"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="0"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="1"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="2"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="3"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="4"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="5"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
								</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable the timeslot for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_timeslot_hide_categories" name="coderockz_woo_delivery_timeslot_hide_categories[]" class="coderockz_woo_delivery_timeslot_hide_categories" multiple>
                                
                                <?php
                                foreach ($all_categories as $cat) {

                                    echo '<option value="'.$cat->name.'">'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_timeslot_hide_products" name="coderockz_woo_delivery_timeslot_hide_products[]" class="coderockz_woo_delivery_timeslot_hide_products" multiple>
                                
                                <?php
                                foreach ($store_products as $key=>$value) {
                                    echo '<option value="'.$key.'">'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>

	                    		<input name="coderockz_woo_delivery_timeslot_hide_products_input" type="text" class="coderockz_woo_delivery_timeslot_hide_products_input coderockz-woo-delivery-input-field" value="" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, the timeslot is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_time_slot_shown_other_categories_products"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_custom_time_slot_more_settings"><?php _e('Want More Settings Based On', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you select 'Shipping State' then you can get more settings based on shipping state and if you select 'Shipping Postcode/ZIP' then you can get more settings based on shipping postcode", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_custom_time_slot_more_settings" name="coderockz_woo_delivery_custom_time_slot_more_settings">
									<option value=""><?php _e('Select your choice', 'coderockz-woo-delivery'); ?></option>
									<option value="zone"><?php _e('Shipping Zone', 'coderockz-woo-delivery'); ?></option>
									<option value="state"><?php _e('Shipping State', 'coderockz-woo-delivery'); ?></option>
									<option value="postcode"><?php _e('Shipping Postcode/ZIP', 'coderockz-woo-delivery'); ?></option>
									<option value="shipping_method"><?php _e('Shipping Method', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_timeslot-more-zone">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_time_disable_zone" name="coderockz_woo_delivery_custom_time_disable_zone[]" class="coderockz_woo_delivery_custom_time_disable_zone" multiple>
	                                <?php
	                                foreach ($zone_name as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';
	                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_timeslot-more-state">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone Regions', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone regions.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_time_disable_regions" name="coderockz_woo_delivery_custom_time_disable_regions[]" class="coderockz_woo_delivery_custom_time_disable_regions" multiple>
	                                <?php
	                                foreach ($zone_regions as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';
	                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_timeslot-more-postcode">
	                    		<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone PostCode/Zip', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone postcode/zip.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_time_disable_postcode" name="coderockz_woo_delivery_custom_time_disable_postcode[]" class="coderockz_woo_delivery_custom_time_disable_postcode" multiple>
	                                <?php
	                                foreach ($zone_post_code as $key => $value) {
	                                    echo '<option value="'.$value.'">'.$value.'</option>';		                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_timeslot-more-shipping-method">
	                    		<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Method', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_time_disable_shipping_method" name="coderockz_woo_delivery_custom_time_disable_shipping_method[]" class="coderockz_woo_delivery_custom_time_disable_shipping_method" multiple>
	                                <?php
	                                foreach ($shipping_methods_for_offdays as $key => $value) {
							        	echo '<option value="'.$key.'">'.$value.'</option>';
							            
							        }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
						    <button class="coderockz-woo-delivery-custom-time-slot-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
						  </div>
						  <?php
						  	
						  	if(isset($time_slot_settings['time_slot']) && count($time_slot_settings['time_slot'])>0){
						  		$helper = new Coderockz_Woo_Delivery_Helper();
								$sorted_custom_slot = $helper->array_sort_by_column($time_slot_settings['time_slot'],'start');
						  		foreach($sorted_custom_slot as $individual_time_slot) {
						  			$start_hour = "";
			    					$start_min = "";
			    					$start_format= "am";
			            			
			            			if(isset($individual_time_slot['start']) && $individual_time_slot['start'] !='') {
			            				$delivery_time_starts = (int)$individual_time_slot['start'];

			            				if($delivery_time_starts == 0) {
			            					$start_hour = "12";
			            					$start_min = "00";
			            					$start_format= "am";
			            				} elseif($delivery_time_starts > 0 && $delivery_time_starts <= 59) {

			            					$start_hour = "12";
			            					$start_min = sprintf("%02d", $delivery_time_starts);
			            					$start_format= "am";
			            				} elseif($delivery_time_starts > 59 && $delivery_time_starts <= 719) {
											$start_min = sprintf("%02d", (int)$delivery_time_starts%60);
											$start_hour = sprintf("%02d", ((int)$delivery_time_starts-$start_min)/60);
											$start_format= "am";
											
			            				} elseif($delivery_time_starts > 719 && $delivery_time_starts <= 1439) {
											$start_min = sprintf("%02d", (int)$delivery_time_starts%60);
											$start_hour = sprintf("%02d", ((int)$delivery_time_starts-$start_min)/60);
											if($start_hour>12) {
												$start_hour = sprintf("%02d", $start_hour-12);
											}
											$start_format= "pm";
			            				} elseif($delivery_time_starts == 1440) {
			            					$start_hour = "12";
			    							$start_min = "00";
			    							$start_format= "am";
			            				}

			            			}

			            			$end_hour = "";
	            					$end_min = "";
	            					$end_format= "am";
	                    			
	                    			if(isset($individual_time_slot['end']) && $individual_time_slot['end'] !='') {
	                    				$delivery_time_ends = (int)$individual_time_slot['end'];
	                    				if($delivery_time_ends == 0) {
			            					$end_hour = "12";
			            					$end_min = "00";
			            					$end_format= "am";
			            				} elseif($delivery_time_ends > 0 && $delivery_time_ends <= 59) {
	                    					$end_hour = "12";
	                    					$end_min = sprintf("%02d", $delivery_time_ends);
	                    					$end_format= "am";
	                    				} elseif($delivery_time_ends > 59 && $delivery_time_ends <= 719) {
											$end_min = sprintf("%02d", (int)$delivery_time_ends%60);
											$end_hour = sprintf("%02d", ((int)$delivery_time_ends-$end_min)/60);
											$end_format= "am";
											
	                    				} elseif ($delivery_time_ends > 719 && $delivery_time_ends <= 1439) {
											$end_min = sprintf("%02d", (int)$delivery_time_ends%60);
											$end_hour = sprintf("%02d", ((int)$delivery_time_ends-$end_min)/60);
											if($end_hour>12) {
												$end_hour = sprintf("%02d", $end_hour-12);
											}
											$end_format= "pm";

	                    				} elseif($delivery_time_ends == 1440) {
											$end_min = "00";
											$end_hour = "12";
											$end_format= "am";
											
	                    				} 

	                    			}

	                    			?>

	                    			<div class="coderockz-woo-delivery-time-slot-accordion-header">
		                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><span class="coderockz-woo-delivery-slot-start-hour"><?php echo $start_hour; ?></span><span class="coderockz-woo-delivery-slot-start-min">:<?php echo $start_min; ?></span><span class="coderockz-woo-delivery-slot-start-format"> <?php echo strtoupper($start_format); ?></span> - <span class="coderockz-woo-delivery-slot-end-hour"><?php echo $end_hour; ?></span><span class="coderockz-woo-delivery-slot-end-min">:<?php echo $end_min; ?></span><span class="coderockz-woo-delivery-slot-end-format"> <?php echo strtoupper($end_format); ?></span></p>
		                    	  </div>
								  <div class="coderockz-woo-delivery-time-slot-accordion-content">
								  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz-woo-delivery-enable-custom-time-slot" <?php echo isset($individual_time_slot['enable']) && !empty($individual_time_slot['enable'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
		                    		</div>
		                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-time-slot-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
		                    		<p class="coderockz-woo-delivery-custom-time-slot-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
		                    		<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Custom Timeslot Name', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you give a name of the timeslot, it will show along with the time on the checkout page", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="text" class="coderockz-woo-delivery-custom-time-slot-name coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot['name']) && $individual_time_slot['name'] !='' ? stripslashes(htmlentities($individual_time_slot['name'])) : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_slot_starts"><?php _e('Time Slot Starts From', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time Slot starts from the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz_delivery_time_slot_starts coderockz_woo_delivery_custom_time_slot_starts">
			                    			
			                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_starts_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $start_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_starts_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $start_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz_woo_delivery_custom_time_slot_starts_format coderockz-woo-delivery-select-field">
											<option value="am" <?php echo $start_format == "am"? " selected" : ""; ?>>AM</option>
											<option value="pm" <?php echo $start_format == "pm"? " selected" : ""; ?>>PM</option>
										</select>
			                        	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Time Slot Ends At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time Slot ends at the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz_delivery_time_slot_ends coderockz_woo_delivery_custom_time_slot_ends">
			                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_ends_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $end_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input type="number" class="coderockz_woo_delivery_custom_time_slot_ends_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $end_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz_woo_delivery_custom_time_slot_ends_format coderockz-woo-delivery-select-field" name="coderockz_delivery_time_slot_ends_format">
											<option value="am" <?php echo $end_format == "am"? " selected" : ""; ?>>AM</option>
											<option value="pm" <?php echo $end_format == "pm"? " selected" : ""; ?>>PM</option>
										</select>
			                        	</div>
			                        	<p class="coderockz_custom_end_time_greater_notice">End Time Must after Start Time</p>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Want to split the timeslot?', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to split the timeslot in several timeslot according a fixed interval. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_time_slot_split" <?php echo isset($individual_time_slot['enable_split']) && !empty($individual_time_slot['enable_split'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>

			                    	<?php
		                    		$split_slot_duration = ""; 
		                    		$split_slot_identity = "min";
	                    			if(isset($individual_time_slot['split_slot_duration']) && !empty($individual_time_slot['split_slot_duration'])) {
	                    				$split_time_slot_duration = (int)$individual_time_slot['split_slot_duration'];
	                    				if($split_time_slot_duration <= 59) {
	                    					$split_slot_duration = $split_time_slot_duration;
	                    				} else {
	                    					$split_time_slot_duration = $split_time_slot_duration/60;
	                    					$helper = new Coderockz_Woo_Delivery_Helper();
	                    					if($helper->containsDecimal($split_time_slot_duration)){
	                    						$split_slot_duration = $split_time_slot_duration*60;
	                    						$split_slot_identity = "min";
	                    					} else {
	                    						$split_slot_duration = $split_time_slot_duration;
	                    						$split_slot_identity = "hour";
	                    					}
	                    				}
	                    			}
			                    	?>
			                    	<div class="coderockz-woo-delivery-split-time-duration-section">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_split_time_slot_duration"><?php _e('Each splited Time Slot Duration', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each splited delivery time slot duration that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                    		<div id="coderockz_split_time_slot_duration" class="coderockz_split_time_slot_duration">
					                        	<input class="coderockz_split_time_slot_duration_time coderockz-woo-delivery-number-field" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="<?php echo $split_slot_duration; ?>" placeholder="" autocomplete="off"/>
					                        	<select class="coderockz-woo-delivery-select-field coderockz_split_time_slot_duration_format" name="coderockz_split_time_slot_duration_format">
													<option value="min" <?php selected($split_slot_identity,"min",true); ?>><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
													<option value="hour" <?php selected($split_slot_identity,"hour",true); ?>><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
												</select>
				                        	</div>
				                        	<p class="coderockz_split_time_slot_duration_notice">Time slot duration is required</p>
				                    	</div>


				                    	<div class="coderockz-woo-delivery-form-group">
				                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make each splited timeslot single', 'coderockz-woo-delivery'); ?></span>
				                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every timeslot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
										    <label class="coderockz-woo-delivery-toogle-switch">
										       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_splited_time_slot_single" <?php echo isset($individual_time_slot['enable_single_splited_slot']) && !empty($individual_time_slot['enable_single_splited_slot'])  ? "checked" : "";?>/>
										       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
										    </label>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-single-time-section">
			                    		<div class="coderockz-woo-delivery-form-group">
				                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make this timeslot single', 'coderockz-woo-delivery'); ?></span>
				                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make this timeslot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
										    <label class="coderockz-woo-delivery-toogle-switch">
										       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_time_slot_single" <?php echo isset($individual_time_slot['enable_single_slot']) && !empty($individual_time_slot['enable_single_slot'])  ? "checked" : "";?>/>
										       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
										    </label>
				                    	</div>
			                    	</div>
		                    		<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Current Date', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot current date. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_hide_time_slot_current_date" <?php echo isset($individual_time_slot['hide_time_slot_current_date']) && !empty($individual_time_slot['hide_time_slot_current_date'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Next Day', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot for next day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_hide_time_slot_next_day" <?php echo isset($individual_time_slot['hide_time_slot_next_day']) && !empty($individual_time_slot['hide_time_slot_next_day'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>

			                    	<?php 
	                    			$timeslot_closing_hour = "";
	            					$timeslot_closing_min = "";
	            					$timeslot_closing_format= "am";
	                    			
	                    			if(isset($individual_time_slot['timeslot_closing_time']) && $individual_time_slot['timeslot_closing_time'] !='') {
	                    				$timeslot_closing_time = (int)$individual_time_slot['timeslot_closing_time'];

	                    				if($timeslot_closing_time > 0 && $timeslot_closing_time <= 59) {

	                    					$timeslot_closing_hour = "12";
	                    					$timeslot_closing_min = sprintf("%02d", $timeslot_closing_time);
	                    					$timeslot_closing_format= "am";
	                    				} elseif($timeslot_closing_time > 59 && $timeslot_closing_time <= 719) {
											$timeslot_closing_min = sprintf("%02d", (int)$timeslot_closing_time%60);
											$timeslot_closing_hour = sprintf("%02d", ((int)$timeslot_closing_time-$timeslot_closing_min)/60);
											$timeslot_closing_format= "am";
											
	                    				} elseif($timeslot_closing_time > 719 && $timeslot_closing_time <= 1439) {
											$timeslot_closing_min = sprintf("%02d", (int)$timeslot_closing_time%60);
											$timeslot_closing_hour = sprintf("%02d", ((int)$timeslot_closing_time-$timeslot_closing_min)/60);
											if($timeslot_closing_hour>12) {
												$timeslot_closing_hour = sprintf("%02d", $timeslot_closing_hour-12);
											}
											$timeslot_closing_format= "pm";
	                    				} elseif($timeslot_closing_time === 0) {
											$timeslot_closing_min = "00";
											$timeslot_closing_hour = "12";
											$timeslot_closing_format= "am";
	                    				}

	                    			}
		                    		?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_timeslot_closing_time"><?php _e('Hide this timeslot at', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show the timeslot after a certain time if the current date is selected as delivery date, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div id="coderockz_woo_delivery_timeslot_closing_time" class="coderockz_woo_delivery_timeslot_closing_time">
			                    			
			                        	<input name="coderockz_woo_delivery_timeslot_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_timeslot_closing_time_hour" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $timeslot_closing_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input name="coderockz_woo_delivery_timeslot_closing_time_min" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_timeslot_closing_time_min" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $timeslot_closing_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_timeslot_closing_time_format" name="coderockz_woo_delivery_timeslot_closing_time_format">
											<option value="am" <?php selected($timeslot_closing_format,"am",true); ?>>AM</option>
											<option value="pm" <?php selected($timeslot_closing_format,"pm",true); ?>>PM</option>
										</select>
			                        	</div>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Timeslot Only At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the timeslot only at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-time-slot-specific-date coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot['only_specific_date']) && $individual_time_slot['only_specific_date'] !='' ? $individual_time_slot['only_specific_date'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot only at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-time-slot-specific-date-close coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot['only_specific_date_close']) && $individual_time_slot['only_specific_date_close'] !='' ? $individual_time_slot['only_specific_date_close'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Delivery Per Time Slot', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each time slot take maximum number of orders that is specified here. After reaching the maximum order, the time slot is disabled automatically. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="number" class="coderockz-woo-delivery-custom-time-slot-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="<?php echo isset($individual_time_slot['max_order']) && $individual_time_slot['max_order'] !='' ? $individual_time_slot['max_order'] : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Time Slot Fee', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this time slot, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	
			                        	<input type="text" class="coderockz-woo-delivery-custom-time-slot-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="<?php echo isset($individual_time_slot['fee']) && $individual_time_slot['fee'] !='' ? $individual_time_slot['fee'] : ""; ?>" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This time slot will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz-woo-delivery-slot-enable-for" style="display:inline-block">
			                    		<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="6" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("6",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="0" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("0",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="1" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("1",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="2" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("2",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="3" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("3",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="4" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("4",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_time_slot_disable" value="5" <?php echo isset($individual_time_slot['disable_for']) && !empty($individual_time_slot['disable_for']) && in_array("5",$individual_time_slot['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
										</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Categories', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_timeslot_hide_categories2" name="coderockz_woo_delivery_timeslot_hide_categories[]" class="coderockz_woo_delivery_timeslot_hide_categories2" multiple>
		                                
		                                <?php
		                                $timeslot_hide_categories = [];
		                                if(isset($individual_time_slot['hide_categories']) && !empty($individual_time_slot['hide_categories'])) {
			                                foreach ($individual_time_slot['hide_categories'] as $hide_cat) {
			                                	$timeslot_hide_categories[] = stripslashes($hide_cat);
			                                }
		                            	}

		                                foreach ($all_categories as $cat) {
		                                	$selected = isset($individual_time_slot['hide_categories']) && !empty($individual_time_slot['hide_categories']) && in_array(htmlspecialchars_decode($cat->name),$timeslot_hide_categories) ? "selected" : "";
		                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_timeslot_hide_products2" name="coderockz_woo_delivery_timeslot_hide_products[]" class="coderockz_woo_delivery_timeslot_hide_products2" multiple>
		                                
		                                <?php
		                                foreach ($store_products as $key=>$value) {

		                                	$selected = isset($individual_time_slot['hide_products']) && !empty($individual_time_slot['hide_products']) && in_array($key,$individual_time_slot['hide_products']) ? "selected" : "";
		                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php } else { ?>

		                    		<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<?php 
			                        	$hide_products_input = isset($individual_time_slot['hide_products']) && !empty($individual_time_slot['hide_products']) ? $individual_time_slot['hide_products'] : array();
			                        	$hide_products_input = implode(",",$hide_products_input);
			                        	?>
			                    		<input name="coderockz_woo_delivery_restrict_delivery_individual_product_input" type="text" class="coderockz_woo_delivery_timeslot_hide_products2_input coderockz-woo-delivery-input-field" value="<?php echo $hide_products_input; ?>" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
			                    	</div>

			                    	<?php } ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, th timeslot is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_time_slot_shown_other_categories_products" <?php echo isset($individual_time_slot['time_slot_shown_other_categories_products']) && !empty($individual_time_slot['time_slot_shown_other_categories_products'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_custom_time_slot_more_settings"><?php _e('Want More Settings Based On', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you select 'Shipping State' then you can get more settings based on shipping state and if you select 'Shipping Postcode/ZIP' then you can get more settings based on shipping postcode", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_custom_time_slot_more_settings" name="coderockz_woo_delivery_custom_time_slot_more_settings">
											<option value="" <?php if(isset($individual_time_slot['more_settings']) && $individual_time_slot['more_settings'] == ""){ echo "selected"; } ?>><?php _e('Select your choice', 'coderockz-woo-delivery'); ?></option>
											<option value="zone" <?php if(isset($individual_time_slot['more_settings']) && $individual_time_slot['more_settings'] == "zone"){ echo "selected"; } ?>><?php _e('Shipping Zone', 'coderockz-woo-delivery'); ?></option>
											<option value="state" <?php if(isset($individual_time_slot['more_settings']) && $individual_time_slot['more_settings'] == "state"){ echo "selected"; } ?>><?php _e('Shipping State', 'coderockz-woo-delivery'); ?></option>
											<option value="postcode" <?php if(isset($individual_time_slot['more_settings']) && $individual_time_slot['more_settings'] == "postcode"){ echo "selected"; } ?>><?php _e('Shipping Postcode/ZIP', 'coderockz-woo-delivery'); ?></option>
											<option value="shipping_method" <?php if(isset($individual_time_slot['more_settings']) && $individual_time_slot['more_settings'] == "shipping_method"){ echo "selected"; } ?>><?php _e('Shipping Method', 'coderockz-woo-delivery'); ?></option>
										</select>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_timeslot-more-zone">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_time_disable_zone2" name="coderockz_woo_delivery_custom_time_disable_zone[]" class="coderockz_woo_delivery_custom_time_disable_zone2" multiple>
			                                <?php
			                                foreach ($zone_name as $key => $value) {
			                                	$selected = isset($individual_time_slot['disable_zone']) && !empty($individual_time_slot['disable_zone']) && in_array($key,$individual_time_slot['disable_zone']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
			                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_timeslot-more-state">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone Regions', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone regions.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_time_disable_regions2" name="coderockz_woo_delivery_custom_time_disable_regions[]" class="coderockz_woo_delivery_custom_time_disable_regions2" multiple>
			                                <?php
			                                foreach ($zone_regions as $key => $value) {
			                                	$selected = isset($individual_time_slot['disable_state']) && !empty($individual_time_slot['disable_state']) && in_array($key,$individual_time_slot['disable_state']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
			                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
		                    		
			                    	<div class="coderockz-woo-delivery-custom_timeslot-more-postcode">	
			                    		<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone PostCode/Zip', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping zone postcode/zip.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_time_disable_postcode2" name="coderockz_woo_delivery_custom_time_disable_postcode[]" class="coderockz_woo_delivery_custom_time_disable_postcode2" multiple>
			                                <?php
			                                foreach ($zone_post_code as $key => $value) {
			                                	$selected = isset($individual_time_slot['disable_postcode']) && !empty($individual_time_slot['disable_postcode']) && in_array($value,$individual_time_slot['disable_postcode']) ? "selected" : "";
			                                    echo '<option value="'.$value.'" '.$selected.'>'.$value.'</option>';		                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_timeslot-more-shipping-method">	
			                    		<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Method', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Timeslot is hidden for the selected shipping method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_time_disable_shipping_method2" name="coderockz_woo_delivery_custom_time_disable_shipping_method[]" class="coderockz_woo_delivery_custom_time_disable_shipping_method2" multiple>
			                                <?php
			                                foreach ($shipping_methods_for_offdays as $key => $value) {
			                                	$selected = isset($individual_time_slot['disable_shipping_method']) && !empty($individual_time_slot['disable_shipping_method']) && in_array($key,$individual_time_slot['disable_shipping_method']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
								    <button class="coderockz-woo-delivery-custom-time-slot-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
								  </div>

	                    		<?php
						  		}
						  		
						  	}
						  	
						  ?>
	                	</div>
                	</div>

                </div>
			</div>
			<div data-tab="tab5" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('General Pickup Date Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-pickup-date-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_pickup_date_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Pickup Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Pickup Date input field in woocommerce order checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_pickup_date">
							       <input type="checkbox" name="coderockz_enable_pickup_date" id="coderockz_enable_pickup_date" <?php echo (isset($pickup_date_settings['enable_pickup_date']) && !empty($pickup_date_settings['enable_pickup_date'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Pickup Date Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Pickup Date input field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_pickup_date_mandatory">
							       <input type="checkbox" name="coderockz_pickup_date_mandatory" id="coderockz_pickup_date_mandatory" <?php echo (isset($pickup_date_settings['pickup_date_mandatory']) && !empty($pickup_date_settings['pickup_date_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_field_label"><?php _e('Date Field Heading for Pickup', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Date input field heading. Default is Pickup Date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_date_field_label" name="coderockz_pickup_date_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_date_settings['pickup_field_label']) && !empty($pickup_date_settings['pickup_field_label'])) ? stripslashes(esc_attr($pickup_date_settings['pickup_field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_pickup_field_placeholder"><?php _e('Date Field Placeholder for Pickup', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Date input field placeholder. Default is Select pickup date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_delivery_pickup_field_placeholder" name="coderockz_delivery_pickup_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_date_settings['pickup_field_placeholder']) && !empty($pickup_date_settings['pickup_field_placeholder'])) ? stripslashes(esc_attr($pickup_date_settings['pickup_field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_selectable_date"><?php _e('Allow Pickup in Next Available Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("User can only select the number of date from calander that is specified Here. Other dates are disabled. Only numerical value is excepted. Default is 365 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_pickup_date_selectable_date" name="coderockz_pickup_date_selectable_date" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_date_settings['selectable_date']) && !empty($pickup_date_settings['selectable_date'])) ? stripslashes(esc_attr($pickup_date_settings['selectable_date'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_selectable_date"><?php _e('Allow Pickup Until Date', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("User can only select a date until the date that is specified Here. Input date format YYYY-MM-DD.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_date_selectable_date_until" name="coderockz_pickup_date_selectable_date_until" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_date_settings['selectable_date_until']) && !empty($pickup_date_settings['selectable_date_until'])) ? stripslashes(esc_attr($pickup_date_settings['selectable_date_until'])) : ""; ?>" placeholder="<?php _e('Format is YYYY-MM-DD', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_maximum_pickup_per_day"><?php _e('Maximum Pickup Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your pickup per day, put the pickup quantity here. Keep blank for unlimited pickup.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_date_maximum_pickup_per_day" name="coderockz_delivery_date_maximum_pickup_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_date_settings['maximum_pickup_per_day']) && !empty($pickup_date_settings['maximum_pickup_per_day'])) ? stripslashes(esc_attr($pickup_date_settings['maximum_pickup_per_day'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_maximum_pickup_product_per_day"><?php _e('Maximum Pickup Products Per Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to limit your pickup product per day, put the pickup product quantity here. Keep blank for unlimited pickup.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_date_maximum_pickup_product_per_day" name="coderockz_delivery_date_maximum_pickup_product_per_day" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_date_settings['maximum_pickup_product_per_day']) && !empty($pickup_date_settings['maximum_pickup_product_per_day'])) ? stripslashes(esc_attr($pickup_date_settings['maximum_pickup_product_per_day'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group" id="coderockz_pickup_date_calendar_locale">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_calendar_locale"><?php _e('Calendar Locale', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Date's calendar will showing in selected language. Default is English.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_pickup_date_calendar_locale">
	                    			<option value="default" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "default"){ echo "selected"; } ?>>English</option>
									<option value="ar" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ar"){ echo "selected"; } ?>>Arabic</option>
									<option value="at" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "at"){ echo "selected"; } ?>>Austria</option>
									<option value="az" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "az"){ echo "selected"; } ?>>Azerbaijan</option>
									<option value="be" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "be"){ echo "selected"; } ?>>Belarusian</option>
									<option value="bg" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "bg"){ echo "selected"; } ?>>Bulgarian</option>
									<option value="bn" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "bn"){ echo "selected"; } ?>>Bangla</option>
									<option value="bs" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "bs"){ echo "selected"; } ?>>Bosnian</option>
									<option value="cat" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "cat"){ echo "selected"; } ?>>Catalan</option>
									<option value="cs" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "cs"){ echo "selected"; } ?>>Czech</option>
									<option value="cy" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "cy"){ echo "selected"; } ?>>Welsh</option>
									<option value="da" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "da"){ echo "selected"; } ?>>Danish</option>
									<option value="de" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "de"){ echo "selected"; } ?>>German</option>
									<option value="eo" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "eo"){ echo "selected"; } ?>>Esperanto</option>
									<option value="es" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "es"){ echo "selected"; } ?>>Spanish</option>
									<option value="et" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "et"){ echo "selected"; } ?>>Estonian</option>
									<option value="fi" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "fi"){ echo "selected"; } ?>>Finnish</option>
									<option value="fr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "fr"){ echo "selected"; } ?>>French</option>
									<option value="fo" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "fo"){ echo "selected"; } ?>>Faroese</option>
									<option value="fa" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "fa"){ echo "selected"; } ?>>Farsi (Persian)</option>
									<option value="ga" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ga"){ echo "selected"; } ?>>Gaelic Irish</option>
									<option value="gr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "gr"){ echo "selected"; } ?>>Greek</option>
									<option value="he" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "he"){ echo "selected"; } ?>>Hebrew</option>
									<option value="hi" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "hi"){ echo "selected"; } ?>>Hindi</option>
									<option value="hr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "hr"){ echo "selected"; } ?>>Croatian</option>
									<option value="hu" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "hu"){ echo "selected"; } ?>>Hungarian</option>
									<option value="id" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "id"){ echo "selected"; } ?>>Indonesian</option>
									<option value="is" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "is"){ echo "selected"; } ?>>Icelandic</option>
									<option value="it" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "it"){ echo "selected"; } ?>>Italian</option>
									<option value="ja" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ja"){ echo "selected"; } ?>>Japanese</option>
									<option value="ka" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ka"){ echo "selected"; } ?>>Georgian</option>
									<option value="km" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "km"){ echo "selected"; } ?>>Khmer</option>
									<option value="ko" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ko"){ echo "selected"; } ?>>Republic of Korea</option>
									<option value="kz" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "kz"){ echo "selected"; } ?>>Kazakh</option>
									<option value="lt" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "lt"){ echo "selected"; } ?>>Lithuanian</option>
									<option value="lv" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "lv"){ echo "selected"; } ?>>Latvian</option>
									<option value="mk" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "mk"){ echo "selected"; } ?>>Macedonian</option>
									<option value="mn" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "mn"){ echo "selected"; } ?>>Mongolian</option>
									<option value="ms" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ms"){ echo "selected"; } ?>>Malaysian</option>
									<option value="my" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "my"){ echo "selected"; } ?>>Burmese</option>
									<option value="nl" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "nl"){ echo "selected"; } ?>>Dutch</option>
									<option value="no" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "no"){ echo "selected"; } ?>>Norwegian</option>
									<option value="pa" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "pa"){ echo "selected"; } ?>>Punjabi</option>
									<option value="pl" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "pl"){ echo "selected"; } ?>>Polish</option>
									<option value="pt" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "pt"){ echo "selected"; } ?>>Portuguese</option>
									<option value="ro" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ro"){ echo "selected"; } ?>>Romanian</option>
									<option value="ru" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "ru"){ echo "selected"; } ?>>Russian</option>
									<option value="sk" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sk"){ echo "selected"; } ?>>Slovak</option>
									<option value="sl" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sl"){ echo "selected"; } ?>>Slovenian</option>
									<option value="si" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "si"){ echo "selected"; } ?>>Sinhala</option>
									<option value="sq" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sq"){ echo "selected"; } ?>>Albanian</option>
									<option value="sr-cyr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sr-cyr"){ echo "selected"; } ?>>Serbian Cyrillic</option>
									<option value="sr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sr"){ echo "selected"; } ?>>Serbian</option>
									<option value="sv" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "sv"){ echo "selected"; } ?>>Swedish</option>
									<option value="th" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "th"){ echo "selected"; } ?>>Thai</option>
									<option value="tr" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "tr"){ echo "selected"; } ?>>Turkish</option>
									<option value="uk" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "uk"){ echo "selected"; } ?>>Ukrainian</option>
									<option value="uz" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "uz"){ echo "selected"; } ?>>Uzbek</option>
									<option value="vn" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "vn"){ echo "selected"; } ?>>Vietnamese</option>
									<option value="zh" <?php if(isset($pickup_date_settings['calendar_locale']) && $pickup_date_settings['calendar_locale'] == "zh"){ echo "selected"; } ?>>Mandarin</option>
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_calendar_theme"><?php _e('Calendar Theme', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to change the calendar theme, select your desire theme from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_pickup_calendar_theme">
								    <option value="" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == ""){ echo "selected"; } ?>><?php _e('Default','coderockz-woo-delivery'); ?></option>
									<option value="dark" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "dark"){ echo "selected"; } ?>>Dark</option>
									<option value="material_blue" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_blue"){ echo "selected"; } ?>>Material Blue</option>
									<option value="material_green" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_green"){ echo "selected"; } ?>>Material Green</option>
									<option value="material_red" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_red"){ echo "selected"; } ?>>Material Red</option>
									<option value="material_orange" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "material_orange"){ echo "selected"; } ?>>Material Orange</option>
									<option value="airbnb" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "airbnb"){ echo "selected"; } ?>>Airbnb</option>
									<option value="confetti" <?php if(isset($date_settings['calendar_theme']) && $date_settings['calendar_theme'] == "confetti"){ echo "selected"; } ?>>Confetti</option>
								</select>
	                    		
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_week_starts_from"><?php _e('Week Starts From', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Date's calendar will start from the day that is selected Here. Default is Sunday.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_pickup_date_week_starts_from">
	                    			<option value="" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == ""){ echo "selected"; } ?>><?php _e('Select Day', 'coderockz-woo-delivery'); ?></option>
									<option value="0" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "0"){ echo "selected"; } ?>><?php _e('Sunday', 'coderockz-woo-delivery'); ?></option>
									<option value="1" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "1"){ echo "selected"; } ?>><?php _e('Monday', 'coderockz-woo-delivery'); ?></option>
									<option value="2" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "2"){ echo "selected"; } ?>><?php _e('Tuesday', 'coderockz-woo-delivery'); ?></option>
									<option value="3" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "3"){ echo "selected"; } ?>><?php _e('Wednesday', 'coderockz-woo-delivery'); ?></option>
									<option value="4" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "4"){ echo "selected"; } ?>><?php _e('Thursday', 'coderockz-woo-delivery'); ?></option>
									<option value="5" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "5"){ echo "selected"; } ?>><?php _e('Friday', 'coderockz-woo-delivery'); ?></option>
									<option value="6" <?php if(isset($pickup_date_settings['week_starts_from']) && $pickup_date_settings['week_starts_from'] == "6"){ echo "selected"; } ?>><?php _e('Saturday', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_date_format"><?php _e('Pickup Date Format', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Date format that is used in everywhere which is available by this plugin. Default is F j, Y ( ex. March 6, 2011 ).", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_pickup_date_format">
	                    			<option value="F j, Y" <?php if(isset($pickup_date_settings['date_format']) && $pickup_date_settings['date_format'] == "F j, Y"){ echo "selected"; } ?>>F j, Y ( ex. <?php _e('March','coderockz-woo-delivery'); ?> 6, 2011 )</option>
									<option value="d-m-Y" <?php if(isset($pickup_date_settings['date_format']) && $pickup_date_settings['date_format'] == "d-m-Y"){ echo "selected"; } ?>>d-m-Y ( ex. 29-03-2011 )</option>
									<option value="m/d/Y" <?php if(isset($pickup_date_settings['date_format']) && $pickup_date_settings['date_format'] == "m/d/Y"){ echo "selected"; } ?>>m/d/Y ( ex. 03/29/2011 )</option>
									<option value="d.m.Y" <?php if(isset($pickup_date_settings['date_format']) && $pickup_date_settings['date_format'] == "d.m.Y"){ echo "selected"; } ?>>d.m.Y ( ex. 29.03.2011 )</option>
									
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Weekday Name in Pickup Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add the weekday name in the pickup date then enable it. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_pickup_add_weekday_name">
							       <input type="checkbox" name="coderockz_woo_delivery_pickup_add_weekday_name" id="coderockz_woo_delivery_pickup_add_weekday_name" <?php echo (isset($pickup_date_settings['add_weekday_name']) && !empty($pickup_date_settings['add_weekday_name'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label" for="coderockz_pickup_date_delivery_days"><?php _e('Pickup Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("Pickup is only available in those days that are checked. Other dates corresponding to the unchecked days are disabled in the calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_pickup_date_delivery_days" style="display:inline-block">
	                    		<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="6" <?php echo in_array("6",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="0" <?php echo in_array("0",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="1" <?php echo in_array("1",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="2" <?php echo in_array("2",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="3" <?php echo in_array("3",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="4" <?php echo in_array("4",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_pickup_date_delivery_days[]" value="5" <?php echo in_array("5",$selected_pickup_day) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
								</div>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Same Day Pickup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Disable same day pickup according to your timezone. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_disable_same_day_pickup">
							       <input type="checkbox" name="coderockz_disable_same_day_pickup" id="coderockz_disable_same_day_pickup" <?php echo (isset($pickup_date_settings['disable_same_day_pickup']) && !empty($pickup_date_settings['disable_same_day_pickup'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Auto Select 1st Available Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the option if you want to select the first available date automatically and shown in the pickup date field. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_auto_select_first_pickup_date">
							       <input type="checkbox" name="coderockz_auto_select_first_pickup_date" id="coderockz_auto_select_first_pickup_date" <?php echo (isset($pickup_date_settings['auto_select_first_pickup_date']) && !empty($pickup_date_settings['auto_select_first_pickup_date'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_pickup_date_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

			</div>
			<div data-tab="tab9" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('General Pickup Time Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-pickup-time-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_pickup_time_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Pickup Time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Pickup Time select field in woocommerce order checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_pickup_time">
							       <input type="checkbox" name="coderockz_enable_pickup_time" id="coderockz_enable_pickup_time" <?php echo (isset($pickup_time_settings['enable_pickup_time']) && !empty($pickup_time_settings['enable_pickup_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Pickup Time Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Pickup Time select field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_pickup_time_mandatory">
							       <input type="checkbox" name="coderockz_pickup_time_mandatory" id="coderockz_pickup_time_mandatory" <?php echo (isset($pickup_time_settings['pickup_time_mandatory']) && !empty($pickup_time_settings['pickup_time_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_time_field_label"><?php _e('Pickup Time Field Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Time select field heading. Default is Pickup Time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_time_field_label" name="coderockz_pickup_time_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_time_settings['field_label']) && !empty($pickup_time_settings['field_label'])) ? stripslashes(esc_attr($pickup_time_settings['field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_time_field_placeholder"><?php _e('Pickup Time Field Placeholder', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Time select field label and placeholder. Default is Select pickup time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_time_field_placeholder" name="coderockz_pickup_time_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_time_settings['field_placeholder']) && !empty($pickup_time_settings['field_placeholder'])) ? stripslashes(esc_attr($pickup_time_settings['field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Individual Location (If Pickup Location Enabled) Wise Max Pickup Per Time Slot ' , 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("if you want Maximum pickup per slot working for every individual Location then enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_max_pickup_consider_location">
							       <input type="checkbox" name="coderockz_woo_delivery_max_pickup_consider_location" id="coderockz_woo_delivery_max_pickup_consider_location" <?php echo (isset($pickup_time_settings['max_pickup_consider_location']) && !empty($pickup_time_settings['max_pickup_consider_location'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_time_format"><?php _e('Pickup Time format', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Time format that is used in everywhere which is available by this plugin. Default is 12 Hours.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_pickup_time_format">

	                    			<option value="" <?php if(isset($pickup_time_settings['time_format']) && $pickup_time_settings['time_format'] == ""){ echo "selected"; } ?>><?php _e('Select Time Format', 'coderockz-woo-delivery'); ?></option>
									<option value="12" <?php if(isset($pickup_time_settings['time_format']) && $pickup_time_settings['time_format'] == "12"){ echo "selected"; } ?>><?php _e('12 Hours', 'coderockz-woo-delivery'); ?></option>
									<option value="24" <?php if(isset($pickup_time_settings['time_format']) && $pickup_time_settings['time_format'] == "24"){ echo "selected"; } ?>><?php _e('24 Hours', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Don\'t Consider Order for Maximum Limit if Pickup Status Completed ' , 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("if you want to free up a slot by making the pickup status completed that is already reached for maximum limit then enable the option. This feature is auto disabled if the option named 'Remove Delivery/Pickup Status Column & Functionality' from the others tab", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_free_up_slot_for_pickup_completed">
							       <input type="checkbox" name="coderockz_delivery_free_up_slot_for_pickup_completed" id="coderockz_delivery_free_up_slot_for_pickup_completed" <?php echo (isset($pickup_time_settings['free_up_slot_for_pickup_completed']) && !empty($pickup_time_settings['free_up_slot_for_pickup_completed'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Current Time Slot', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make the time slot disabled that has the current time. In default, the time slot isn't disabled that has the current time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_pickup_time_disable_current_time_slot">
							       <input type="checkbox" name="coderockz_pickup_time_disable_current_time_slot" id="coderockz_pickup_time_disable_current_time_slot" <?php echo (isset($pickup_time_settings['disabled_current_pickup_time_slot']) && !empty($pickup_time_settings['disabled_current_pickup_time_slot'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Auto Select 1st Available Time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the option if you want to select the first available time based on date automatically and shown in the pickup time field. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_auto_select_first_pickup_time">
							       <input type="checkbox" name="coderockz_auto_select_first_pickup_time" id="coderockz_auto_select_first_pickup_time" <?php echo (isset(get_option('coderockz_woo_delivery_pickup_time_settings')['auto_select_first_time']) && !empty(get_option('coderockz_woo_delivery_pickup_time_settings')['auto_select_first_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php if(!WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Searchbox From Time Field Dropdown', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the searchbox from pickup time field dropdown, enable it. Default is Showing searhbox.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_hide_searchbox_pickup_field_dropdown">
							       <input type="checkbox" name="coderockz_hide_searchbox_pickup_field_dropdown" id="coderockz_hide_searchbox_pickup_field_dropdown" <?php echo (isset(get_option('coderockz_woo_delivery_pickup_time_settings')['hide_searchbox']) && !empty(get_option('coderockz_woo_delivery_pickup_time_settings')['hide_searchbox'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php } ?>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_pickup_time_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Add Pickup Time Slot', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' To know how to make your custom timeslots perfectly ', 'coderockz-woo-delivery'); ?><a href="https://coderockz.com/documentations/make-custom-timeslots-perfectly" target="_blank"><?php _e('click here', 'coderockz-woo-delivery'); ?></a></p>
                    	<input class="coderockz-woo-delivery-add-pickup-slot-btn" type="button" value="<?php _e('Add New Pickup Slot', 'coderockz-woo-delivery'); ?>">
	                    <div id="coderockz-woo-delivery-pickup-slot-accordion">
                    	  <div class="coderockz-woo-delivery-pickup-slot-accordion-header" style="display:none;">
                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><span class="coderockz-woo-delivery-pickup-slot-start-hour">Start Time</span><span class="coderockz-woo-delivery-pickup-slot-start-min"></span><span class="coderockz-woo-delivery-pickup-slot-start-format"></span> - <span class="coderockz-woo-delivery-pickup-slot-end-hour">End Time</span><span class="coderockz-woo-delivery-pickup-slot-end-min"></span><span class="coderockz-woo-delivery-pickup-slot-end-format"></span></p>
                    	  </div>
						  <div data-plugin-url="<?php echo CODEROCKZ_WOO_DELIVERY_URL; ?>" class="coderockz-woo-delivery-pickup-slot-accordion-content" style="display:none;">
						  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz-woo-delivery-enable-custom-pickup-slot"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
                    		</div>
                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-pickup-slot-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
                    		<p class="coderockz-woo-delivery-custom-pickup-slot-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
                    		<div class="coderockz-woo-delivery-form-group">
								<label class="coderockz-woo-delivery-form-label"><?php _e('Custom Pickup Timeslot Name', 'coderockz-woo-delivery'); ?></label>
								<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you give a name of the timeslot, it will show along with the time on the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								<input type="text" class="coderockz-woo-delivery-custom-pickup-slot-name coderockz-woo-delivery-input-field" value="" placeholder="" autocomplete="off"/>
							</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_pickup_slot_starts"><?php _e('Pickup Slot Starts From', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Time Slot starts from the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz_delivery_pickup_slot_starts coderockz_woo_delivery_custom_pickup_slot_starts">
	                    			
	                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_starts_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_starts_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz_woo_delivery_custom_pickup_slot_starts_format coderockz-woo-delivery-select-field">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Slot Ends At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Time Slot ends at the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz_delivery_pickup_slot_ends coderockz_woo_delivery_custom_pickup_slot_ends">
	                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_ends_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_ends_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz_woo_delivery_custom_pickup_slot_ends_format coderockz-woo-delivery-select-field" name="coderockz_delivery_pickup_slot_ends_format">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                        	<p class="coderockz_custom_end_pickup_greater_notice">End Time Must after Start Time</p>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Want to split the timeslot?', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to split the timeslot in several timeslot according a fixed interval. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_pickup_slot_split"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-split-pickup-duration-section">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Each splited Pickup Slot Duration', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each splited Pickup Slot Duration that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                    		<div class="coderockz_split_pickup_slot_duration">
			                        	<input type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field coderockz_split_pickup_slot_duration_time" value="" placeholder="" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field coderockz_split_pickup_slot_duration_format">
											<option value="min"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
											<option value="hour"><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
										</select>
		                        	</div>
		                        	<p class="coderockz_split_pickup_slot_duration_notice">Time slot duration is required</p>
		                    	</div>

		                    	<div class="coderockz-woo-delivery-form-group">
		                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Each Pickup Slot Single', 'coderockz-woo-delivery'); ?></span>
		                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every pickup slot single as the pickup slot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								    <label class="coderockz-woo-delivery-toogle-switch">
								       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_splited_pickup_slot_single"/>
								       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
								    </label>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-single-pickup-section">
	                    		<div class="coderockz-woo-delivery-form-group">
		                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Each Pickup Slot Single', 'coderockz-woo-delivery'); ?></span>
		                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every pickup slot single as the pickup slot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								    <label class="coderockz-woo-delivery-toogle-switch">
								       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_pickup_slot_single"/>
								       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
								    </label>
		                    	</div>
		                    </div>
		                    <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Current Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot current date. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_hide_custom_pickup_slot_current_date" />
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Next Day', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot for next day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_hide_custom_pickup_slot_next_day" />
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickupslot_closing_time"><?php _e('Hide this timeslot at', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show the timeslot after a certain time if the current date is selected as delivery date, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_pickupslot_closing_time" class="coderockz_woo_delivery_pickupslot_closing_time">
	                    			
	                        	<input name="coderockz_woo_delivery_pickupslot_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_pickupslot_closing_time_hour" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_woo_delivery_pickupslot_closing_time_min" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_pickupslot_closing_time_min" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_pickupslot_closing_time_format" name="coderockz_woo_delivery_pickupslot_closing_time_format">
									<option value="am">AM</option>
									<option value="pm">PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Timeslot Only At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the timeslot only at specific date then specify here the dates.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-pickup-slot-specific-date coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot only at specific date then specify here the dates.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-pickup-slot-specific-date-close coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Pickup Per Time Slot', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each time slot take maximum number of pickups that is specified here. After reaching the maximum pickup, the time slot is disabled automaticaly. Only numerical value is accepted. Blank this field or 0 value means each time slot takes unlimited pickup.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="number" class="coderockz-woo-delivery-custom-pickup-slot-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Slot Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this pickup slot, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	
	                        	<input type="text" class="coderockz-woo-delivery-custom-pickup-slot-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This pickup slot will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz-woo-delivery-pickup-slot-enable-for" style="display:inline-block">
	                    		<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="6"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="0"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="1"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="2"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="3"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="4"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="5"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
								</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot for Pickup Location', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide this timeslot for a specific pickup location then select the pickup location here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_pickup_hide_for_pickup_location" name="coderockz_woo_delivery_pickup_hide_for_pickup_location[]" class="coderockz_woo_delivery_pickup_hide_for_pickup_location" multiple>
                                
                                <?php
                                if(isset($pickup_location_settings['pickup_location']) && !empty($pickup_location_settings['pickup_location'])) {
									foreach($pickup_location_settings['pickup_location'] as $location => $location_details) {
	                                    echo '<option value="'.stripslashes(htmlentities($location)).'">'.stripslashes(htmlentities($location)).'</option>';
	                                }
                            	}
                                ?>
                                </select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable the timeslot for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_pickup_timeslot_hide_categories" name="coderockz_woo_delivery_pickup_timeslot_hide_categories[]" class="coderockz_woo_delivery_pickup_timeslot_hide_categories" multiple>
                                
                                <?php
                                foreach ($all_categories as $cat) {

                                    echo '<option value="'.$cat->name.'">'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_pickup_timeslot_hide_products" name="coderockz_woo_delivery_pickup_timeslot_hide_products[]" class="coderockz_woo_delivery_pickup_timeslot_hide_products" multiple>
                                
                                <?php
                                foreach ($store_products as $key=>$value) {
                                    echo '<option value="'.$key.'">'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<input name="coderockz_woo_delivery_pickup_timeslot_hide_products_input" type="text" class="coderockz_woo_delivery_pickup_timeslot_hide_products_input coderockz-woo-delivery-input-field" value="" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, the timeslot is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_pickup_time_slot_shown_other_categories_products"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_custom_pickup_slot_more_settings"><?php _e('Want More Settings Based On', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you select 'Shipping State' then you can get more settings based on shipping state and if you select 'Shipping Postcode/ZIP' then you can get more settings based on shipping postcode.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_custom_pickup_slot_more_settings" name="coderockz_woo_delivery_custom_pickup_slot_more_settings">
									<option value=""><?php _e('Select your choice', 'coderockz-woo-delivery'); ?></option>
									<option value="zone"><?php _e('Shipping Zone', 'coderockz-woo-delivery'); ?></option>
									<option value="state"><?php _e('Shipping State', 'coderockz-woo-delivery'); ?></option>
									<option value="postcode"><?php _e('Shipping Postcode/ZIP', 'coderockz-woo-delivery'); ?></option>
									<option value="shipping_method"><?php _e('Shipping Method', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-zone">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickupslot is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_pickup_disable_zone" name="coderockz_woo_delivery_custom_pickup_disable_zone[]" class="coderockz_woo_delivery_custom_pickup_disable_zone" multiple>
	                                <?php
	                                foreach ($zone_name as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';
	                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-state">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone Regions', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping zone regions.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_pickup_disable_regions" name="coderockz_woo_delivery_custom_pickup_disable_regions[]" class="coderockz_woo_delivery_custom_pickup_disable_regions" multiple>
	                                <?php
	                                foreach ($zone_regions as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';
	                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-postcode">           	
	                    		<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone PostCode/Zip', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping zone postcode/zip.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_pickup_disable_postcode" name="coderockz_woo_delivery_custom_pickup_disable_postcode[]" class="coderockz_woo_delivery_custom_pickup_disable_postcode" multiple>
	                                <?php
	                                foreach ($zone_post_code as $key => $value) {
	                                    echo '<option value="'.$value.'">'.$value.'</option>';
	                                }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-shipping-method">           	
	                    		<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Method', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        	<select id="coderockz_woo_delivery_custom_pickup_disable_shipping_method" name="coderockz_woo_delivery_custom_pickup_disable_shipping_method[]" class="coderockz_woo_delivery_custom_pickup_disable_shipping_method" multiple>
	                                <?php
	                                foreach ($shipping_methods_for_offdays as $key => $value) {
							        	echo '<option value="'.$key.'">'.$value.'</option>';
							            
							        }
	                                ?>
	                                </select>
		                    	</div>
	                    	</div>
						    <button class="coderockz-woo-delivery-custom-pickup-slot-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
						  </div>
						  <?php
						  	
						  	if(isset($pickup_slot_settings['time_slot']) && count($pickup_slot_settings['time_slot'])>0){
						  		$helper = new Coderockz_Woo_Delivery_Helper();
								$sorted_custom_pickup_slot = $helper->array_sort_by_column($pickup_slot_settings['time_slot'],'start');

						  		foreach($sorted_custom_pickup_slot as $individual_time_slot_pickup) {
						  			$pickup_slot_start_hour = "";
			    					$pickup_slot_start_min = "";
			    					$pickup_slot_start_format= "am";
			            			
			            			if(isset($individual_time_slot_pickup['start']) && $individual_time_slot_pickup['start'] !='') {
			            				$pickup_time_starts = (int)$individual_time_slot_pickup['start'];

			            				if($pickup_time_starts == 0) {
			            					$pickup_slot_start_hour = "12";
			            					$pickup_slot_start_min = "00";
			            					$pickup_slot_start_format= "am";
			            				} elseif($pickup_time_starts > 0 && $pickup_time_starts <= 59) {
			            					$pickup_slot_start_hour = "12";
			            					$pickup_slot_start_min = sprintf("%02d", $pickup_time_starts);
			            					$pickup_slot_start_format= "am";
			            				} elseif($pickup_time_starts > 59 && $pickup_time_starts <= 719) {
											$pickup_slot_start_min = sprintf("%02d", (int)$pickup_time_starts%60);
											$pickup_slot_start_hour = sprintf("%02d", ((int)$pickup_time_starts-$pickup_slot_start_min)/60);
											$pickup_slot_start_format= "am";
											
			            				} elseif ($pickup_time_starts > 719 && $pickup_time_starts <= 1439) {
											$pickup_slot_start_min = sprintf("%02d", (int)$pickup_time_starts%60);
											$pickup_slot_start_hour = sprintf("%02d", ((int)$pickup_time_starts-$pickup_slot_start_min)/60);
											if($pickup_slot_start_hour>12) {
												$pickup_slot_start_hour = sprintf("%02d", $pickup_slot_start_hour-12);
											}
											$pickup_slot_start_format= "pm";
			            				} elseif ($pickup_time_starts == 1440) {
			    							$pickup_slot_start_hour = "12";
			    							$pickup_slot_start_min = "00";
			    							$pickup_slot_start_format= "am";
			            				}

			            			}

			            			$pickup_slot_end_hour = "";
	            					$pickup_slot_end_min = "";
	            					$pickup_slot_end_format= "am";
	                    			
	                    			if(isset($individual_time_slot_pickup['end']) && $individual_time_slot_pickup['end'] !='') {
	                    				$pickup_time_ends = (int)$individual_time_slot_pickup['end'];
	                    				if($pickup_time_ends == 0) {
			            					$pickup_slot_end_hour = "12";
			            					$pickup_slot_end_min = "00";
			            					$pickup_slot_end_format= "am";
			            				} elseif($pickup_time_ends > 0 && $pickup_time_ends <= 59) {
	                    					$pickup_slot_end_hour = "12";
	                    					$pickup_slot_end_min = sprintf("%02d", $pickup_time_ends);
	                    					$pickup_slot_end_format= "am";
	                    				} elseif($pickup_time_ends > 59 && $pickup_time_ends <= 719) {
											$pickup_slot_end_min = sprintf("%02d", (int)$pickup_time_ends%60);
											$pickup_slot_end_hour = sprintf("%02d", ((int)$pickup_time_ends-$pickup_slot_end_min)/60);
											$pickup_slot_end_format= "am";
											
	                    				} elseif ($pickup_time_ends > 719 && $pickup_time_ends <= 1439) {
											$pickup_slot_end_min = sprintf("%02d", (int)$pickup_time_ends%60);
											$pickup_slot_end_hour = sprintf("%02d", ((int)$pickup_time_ends-$pickup_slot_end_min)/60);
											if($pickup_slot_end_hour>12) {
												$pickup_slot_end_hour = sprintf("%02d", $pickup_slot_end_hour-12);
											}
											$pickup_slot_end_format= "pm";

	                    				} elseif($pickup_time_ends == 1440) {
											$pickup_slot_end_min = "00";
											$pickup_slot_end_hour = "12";
											$pickup_slot_end_format= "am";
											
	                    				} 

	                    			}

	                    			?>

	                    			<div class="coderockz-woo-delivery-pickup-slot-accordion-header">
		                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><span class="coderockz-woo-delivery-pickup-slot-start-hour"><?php echo $pickup_slot_start_hour; ?></span><span class="coderockz-woo-delivery-pickup-slot-start-min">:<?php echo $pickup_slot_start_min; ?></span><span class="coderockz-woo-delivery-pickup-slot-start-format"> <?php echo strtoupper($pickup_slot_start_format); ?></span> - <span class="coderockz-woo-delivery-pickup-slot-end-hour"><?php echo $pickup_slot_end_hour; ?></span><span class="coderockz-woo-delivery-pickup-slot-end-min">:<?php echo $pickup_slot_end_min; ?></span><span class="coderockz-woo-delivery-pickup-slot-end-format"> <?php echo strtoupper($pickup_slot_end_format); ?></span></p>
		                    	  </div>
								  <div class="coderockz-woo-delivery-pickup-slot-accordion-content">
								  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz-woo-delivery-enable-custom-pickup-slot" <?php echo isset($individual_time_slot_pickup['enable']) && !empty($individual_time_slot_pickup['enable'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
		                    		</div>
		                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-pickup-slot-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
		                    		<p class="coderockz-woo-delivery-custom-pickup-slot-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
		                    		<div class="coderockz-woo-delivery-form-group">
										<label class="coderockz-woo-delivery-form-label"><?php _e('Custom Pickup Timeslot Name', 'coderockz-woo-delivery'); ?></label>
										<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you give a name of the timeslot, it will show along with the time on the checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
										<input type="text" class="coderockz-woo-delivery-custom-pickup-slot-name coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot_pickup['name']) && $individual_time_slot_pickup['name'] !='' ? stripslashes(htmlentities($individual_time_slot_pickup['name'])) : ""; ?>" placeholder="" autocomplete="off"/>
									</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_pickup_slot_starts"><?php _e('Pickup Slot Starts From', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot starts from the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz_delivery_pickup_slot_starts coderockz_woo_delivery_custom_pickup_slot_starts">
			                    			
			                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_starts_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $pickup_slot_start_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_starts_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $pickup_slot_start_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz_woo_delivery_custom_pickup_slot_starts_format coderockz-woo-delivery-select-field">
											<option value="am" <?php echo $pickup_slot_start_format == "am"? " selected" : ""; ?>>AM</option>
											<option value="pm" <?php echo $pickup_slot_start_format == "pm"? " selected" : ""; ?>>PM</option>
										</select>
			                        	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Slot Ends At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot ends at the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz_delivery_pickup_slot_ends coderockz_woo_delivery_custom_pickup_slot_ends">
			                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_ends_hour coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $pickup_slot_end_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input type="number" class="coderockz_woo_delivery_custom_pickup_slot_ends_min coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $pickup_slot_end_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz_woo_delivery_custom_pickup_slot_ends_format coderockz-woo-delivery-select-field" name="coderockz_delivery_pickup_slot_ends_format">
											<option value="am" <?php echo $pickup_slot_end_format == "am"? " selected" : ""; ?>>AM</option>
											<option value="pm" <?php echo $pickup_slot_end_format == "pm"? " selected" : ""; ?>>PM</option>
										</select>
			                        	</div>
			                        	<p class="coderockz_custom_end_pickup_greater_notice">End Time Must after Start Time</p>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Want to split the timeslot?', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to split the pickup slot in several pickup slot according a fixed interval. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_pickup_slot_split" <?php echo isset($individual_time_slot_pickup['enable_split']) && !empty($individual_time_slot_pickup['enable_split'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>

			                    	<?php
		                    		$pickup_split_slot_duration = ""; 
		                    		$pickup_split_slot_identity = "min";
	                    			if(isset($individual_time_slot_pickup['split_slot_duration']) && !empty($individual_time_slot_pickup['split_slot_duration'])) {
	                    				$pickup_split_time_slot_duration = (int)$individual_time_slot_pickup['split_slot_duration'];
	                    				if($pickup_split_time_slot_duration <= 59) {
	                    					$pickup_split_slot_duration = $pickup_split_time_slot_duration;
	                    				} else {
	                    					$pickup_split_time_slot_duration = $pickup_split_time_slot_duration/60;
	                    					$helper = new Coderockz_Woo_Delivery_Helper();
	                    					if($helper->containsDecimal($pickup_split_time_slot_duration)){
	                    						$pickup_split_slot_duration = $pickup_split_time_slot_duration*60;
	                    						$pickup_split_slot_identity = "min";
	                    					} else {
	                    						$pickup_split_slot_duration = $pickup_split_time_slot_duration;
	                    						$pickup_split_slot_identity = "hour";
	                    					}
	                    				}
	                    			}
			                    	?>
			                    	<div class="coderockz-woo-delivery-split-pickup-duration-section">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_split_pickup_slot_duration"><?php _e('Each splited Pickup Slot Duration', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each splited pickup slot duration that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                    		<div id="coderockz_split_pickup_slot_duration" class="coderockz_split_pickup_slot_duration">
					                        	<input class="coderockz_split_pickup_slot_duration_time coderockz-woo-delivery-number-field" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="<?php echo $pickup_split_slot_duration; ?>" placeholder="" autocomplete="off"/>
					                        	<select class="coderockz-woo-delivery-select-field coderockz_split_pickup_slot_duration_format" name="coderockz_split_pickup_slot_duration_format">
													<option value="min" <?php selected($pickup_split_slot_identity,"min",true); ?>><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
													<option value="hour" <?php selected($pickup_split_slot_identity,"hour",true); ?>><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
												</select>
				                        	</div>
				                        	<p class="coderockz_split_pickup_slot_duration_notice">Time slot duration is required</p>
				                    	</div>


				                    	<div class="coderockz-woo-delivery-form-group">
				                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make each splited pickupslot single', 'coderockz-woo-delivery'); ?></span>
				                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make every pickupslot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
										    <label class="coderockz-woo-delivery-toogle-switch">
										       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_splited_pickup_slot_single" <?php echo isset($individual_time_slot_pickup['enable_single_splited_slot']) && !empty($individual_time_slot_pickup['enable_single_splited_slot'])  ? "checked" : "";?>/>
										       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
										    </label>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-single-pickup-section">
			                    		<div class="coderockz-woo-delivery-form-group">
				                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make This Pickup Slot Single', 'coderockz-woo-delivery'); ?></span>
				                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to make this pickup slot single as the timeslot value is the starting time of the time range. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
										    <label class="coderockz-woo-delivery-toogle-switch">
										       <input type="checkbox" class="coderockz_woo_delivery_enable_custom_pickup_slot_single" <?php echo isset($individual_time_slot_pickup['enable_single_slot']) && !empty($individual_time_slot_pickup['enable_single_slot'])  ? "checked" : "";?>/>
										       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
										    </label>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Current Date', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot current date. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_hide_custom_pickup_slot_current_date" <?php echo isset($individual_time_slot_pickup['hide_time_slot_current_date']) && !empty($individual_time_slot_pickup['hide_time_slot_current_date'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide This TimeSlot for Next Day', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to hide this timeslot for next day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_hide_custom_pickup_slot_next_day" <?php echo isset($individual_time_slot_pickup['hide_time_slot_next_day']) && !empty($individual_time_slot_pickup['hide_time_slot_next_day'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>
			                    	<?php 
	                    			$pickupslot_closing_hour = "";
	            					$pickupslot_closing_min = "";
	            					$pickupslot_closing_format= "am";
	                    			
	                    			if(isset($individual_time_slot_pickup['timeslot_closing_time']) && $individual_time_slot_pickup['timeslot_closing_time'] !='') {
	                    				$pickupslot_closing_time = (int)$individual_time_slot_pickup['timeslot_closing_time'];

	                    				if($pickupslot_closing_time > 0 && $pickupslot_closing_time <= 59) {

	                    					$pickupslot_closing_hour = "12";
	                    					$pickupslot_closing_min = sprintf("%02d", $pickupslot_closing_time);
	                    					$pickupslot_closing_format= "am";
	                    				} elseif($pickupslot_closing_time > 59 && $pickupslot_closing_time <= 719) {
											$pickupslot_closing_min = sprintf("%02d", (int)$pickupslot_closing_time%60);
											$pickupslot_closing_hour = sprintf("%02d", ((int)$pickupslot_closing_time-$pickupslot_closing_min)/60);
											$pickupslot_closing_format= "am";
											
	                    				} elseif($pickupslot_closing_time > 719 && $pickupslot_closing_time <= 1439) {
											$pickupslot_closing_min = sprintf("%02d", (int)$pickupslot_closing_time%60);
											$pickupslot_closing_hour = sprintf("%02d", ((int)$pickupslot_closing_time-$pickupslot_closing_min)/60);
											if($pickupslot_closing_hour>12) {
												$pickupslot_closing_hour = sprintf("%02d", $pickupslot_closing_hour-12);
											}
											$pickupslot_closing_format= "pm";
	                    				} elseif($pickupslot_closing_time === 0) {
											$pickupslot_closing_min = "00";
											$pickupslot_closing_hour = "12";
											$pickupslot_closing_format= "am";
	                    				}

	                    			}
		                    		?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickupslot_closing_time"><?php _e('Hide this timeslot at', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show the timeslot after a certain time if the current date is selected as delivery date, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div id="coderockz_woo_delivery_pickupslot_closing_time" class="coderockz_woo_delivery_pickupslot_closing_time">
			                    			
			                        	<input name="coderockz_woo_delivery_pickupslot_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_pickupslot_closing_time_hour" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $pickupslot_closing_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<input name="coderockz_woo_delivery_pickupslot_closing_time_min" type="number" class="coderockz-woo-delivery-number-field coderockz_woo_delivery_pickupslot_closing_time_min" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $pickupslot_closing_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_pickupslot_closing_time_format" name="coderockz_woo_delivery_pickupslot_closing_time_format">
											<option value="am" <?php selected($pickupslot_closing_format,"am",true); ?>>AM</option>
											<option value="pm" <?php selected($pickupslot_closing_format,"pm",true); ?>>PM</option>
										</select>
			                        	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Timeslot Only At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the timeslot only at specific date then specify here the dates.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-pickup-slot-specific-date coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot_pickup['only_specific_date']) && $individual_time_slot_pickup['only_specific_date'] !='' ? $individual_time_slot_pickup['only_specific_date'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot only at specific date then specify here the dates.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-custom-pickup-slot-specific-date-close coderockz-woo-delivery-input-field" value="<?php echo isset($individual_time_slot_pickup['only_specific_date_close']) && $individual_time_slot_pickup['only_specific_date_close'] !='' ? $individual_time_slot_pickup['only_specific_date_close'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Pickup Per Time Slot', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each time slot take maximum number of pickups that is specified here. After reaching the maximum pickup, the time slot is disabled automatically. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="number" class="coderockz-woo-delivery-custom-pickup-slot-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="<?php echo isset($individual_time_slot_pickup['max_order']) && $individual_time_slot_pickup['max_order'] !='' ? $individual_time_slot_pickup['max_order'] : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Slot Fee', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this pickup slot, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	
			                        	<input type="text" class="coderockz-woo-delivery-custom-pickup-slot-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="<?php echo isset($individual_time_slot_pickup['fee']) && $individual_time_slot_pickup['fee'] !='' ? $individual_time_slot_pickup['fee'] : ""; ?>" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This pickup slot will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz-woo-delivery-pickup-slot-enable-for" style="display:inline-block">
			                    		<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="6" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("6",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="0" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("0",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="1" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("1",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="2" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("2",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="3" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("3",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="4" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("4",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_slot_disable" value="5" <?php echo isset($individual_time_slot_pickup['disable_for']) && !empty($individual_time_slot_pickup['disable_for']) && in_array("5",$individual_time_slot_pickup['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
										</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot for Pickup Location', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide this timeslot for a specific pickup location then select the pickup location here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_pickup_hide_for_pickup_location2" name="coderockz_woo_delivery_pickup_hide_for_pickup_location[]" class="coderockz_woo_delivery_pickup_hide_for_pickup_location2" multiple>
		                                
		                                <?php
		                                if(isset($pickup_location_settings['pickup_location']) && !empty($pickup_location_settings['pickup_location'])) {


		                                	$pickupslot_hide_location = [];

											foreach ($individual_time_slot_pickup['hide_for_pickup_location'] as $hide_location) {
												$pickupslot_hide_location[] = stripslashes(htmlentities($hide_location));
											}

											foreach($pickup_location_settings['pickup_location'] as $location => $location_details) {

			                                	$selected = isset($individual_time_slot_pickup['hide_for_pickup_location']) && !empty($individual_time_slot_pickup['hide_for_pickup_location']) && in_array(stripslashes(htmlentities($location)),$pickupslot_hide_location) ? "selected" : "";
			                                    echo '<option value="'.stripslashes(htmlentities($location)).'" '.$selected.'>'.stripslashes(htmlentities($location)).'</option>';

			                                }
		                            	}
		                                ?>
		                                </select>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Categories', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_pickup_timeslot_hide_categories2" name="coderockz_woo_delivery_pickup_timeslot_hide_categories[]" class="coderockz_woo_delivery_pickup_timeslot_hide_categories2" multiple>
		                                
		                                <?php
		                                $pickupslot_hide_categories = [];
										if(isset($individual_time_slot_pickup['hide_categories']) && !empty($individual_time_slot_pickup['hide_categories'])) {
											foreach ($individual_time_slot_pickup['hide_categories'] as $hide_cat) {
												$pickupslot_hide_categories[] = stripslashes($hide_cat);
											}
										}
		                                foreach ($all_categories as $cat) {

		                                	$selected = isset($individual_time_slot_pickup['hide_categories']) && !empty($individual_time_slot_pickup['hide_categories']) && in_array(htmlspecialchars_decode($cat->name),$pickupslot_hide_categories) ? "selected" : "";
		                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_pickup_timeslot_hide_products2" name="coderockz_woo_delivery_pickup_timeslot_hide_products[]" class="coderockz_woo_delivery_pickup_timeslot_hide_products2" multiple>
		                                
		                                <?php
		                                foreach ($store_products as $key=>$value) {

		                                	$selected = isset($individual_time_slot_pickup['hide_products']) && !empty($individual_time_slot_pickup['hide_products']) && in_array($key,$individual_time_slot_pickup['hide_products']) ? "selected" : "";
		                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php } else { ?>

		                    		<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Timeslot For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<?php 
			                        	$pickup_hide_products_input = isset($individual_time_slot_pickup['hide_products']) && !empty($individual_time_slot_pickup['hide_products']) ? $individual_time_slot_pickup['hide_products'] : array();
			                        	$pickup_hide_products_input = implode(",",$pickup_hide_products_input);
			                        	?>
			                    		<input name="coderockz_woo_delivery_pickup_timeslot_hide_products2_input" type="text" class="coderockz_woo_delivery_pickup_timeslot_hide_products2_input coderockz-woo-delivery-input-field" value="<?php echo $pickup_hide_products_input; ?>" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
			                    	</div>

			                    	<?php } ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, th timeslot is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_pickup_time_slot_shown_other_categories_products" <?php echo isset($individual_time_slot_pickup['time_slot_shown_other_categories_products']) && !empty($individual_time_slot_pickup['time_slot_shown_other_categories_products'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_custom_pickup_slot_more_settings"><?php _e('Want More Settings Based On', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you select 'Shipping State' then you can get more settings based on shipping state and if you select 'Shipping Postcode/ZIP' then you can get more settings based on shipping postcode.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<select class="coderockz-woo-delivery-select-field coderockz_woo_delivery_custom_pickup_slot_more_settings" name="coderockz_woo_delivery_custom_pickup_slot_more_settings">
											<option value="" <?php if(isset($individual_time_slot_pickup['more_settings']) && $individual_time_slot_pickup['more_settings'] == ""){ echo "selected"; } ?>><?php _e('Select your choice', 'coderockz-woo-delivery'); ?></option>
											<option value="zone" <?php if(isset($individual_time_slot_pickup['more_settings']) && $individual_time_slot_pickup['more_settings'] == "zone"){ echo "selected"; } ?>><?php _e('Shipping Zone', 'coderockz-woo-delivery'); ?></option>
											<option value="state" <?php if(isset($individual_time_slot_pickup['more_settings']) && $individual_time_slot_pickup['more_settings'] == "state"){ echo "selected"; } ?>><?php _e('Shipping State', 'coderockz-woo-delivery'); ?></option>
											<option value="postcode" <?php if(isset($individual_time_slot_pickup['more_settings']) && $individual_time_slot_pickup['more_settings'] == "postcode"){ echo "selected"; } ?>><?php _e('Shipping Postcode/ZIP', 'coderockz-woo-delivery'); ?></option>
											<option value="shipping_method" <?php if(isset($individual_time_slot_pickup['more_settings']) && $individual_time_slot_pickup['more_settings'] == "shipping_method"){ echo "selected"; } ?>><?php _e('Shipping Method', 'coderockz-woo-delivery'); ?></option>
										</select>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-zone">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_pickup_disable_zone2" name="coderockz_woo_delivery_custom_pickup_disable_zone[]" class="coderockz_woo_delivery_custom_pickup_disable_zone2" multiple>
			                                <?php
			                                foreach ($zone_name as $key => $value) {
			                                	$selected = isset($individual_time_slot_pickup['disable_zone']) && !empty($individual_time_slot_pickup['disable_zone']) && in_array($key,$individual_time_slot_pickup['disable_zone']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
			                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-state">
				                    	<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone Regions', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping zone regions.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_pickup_disable_regions2" name="coderockz_woo_delivery_custom_pickup_disable_regions[]" class="coderockz_woo_delivery_custom_pickup_disable_regions2" multiple>
			                                <?php
			                                foreach ($zone_regions as $key => $value) {
			                                	$selected = isset($individual_time_slot_pickup['disable_state']) && !empty($individual_time_slot_pickup['disable_state']) && in_array($key,$individual_time_slot_pickup['disable_state']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
			                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-postcode">	
			                    		<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Zone PostCode/Zip', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping zone postcode/zip.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_pickup_disable_postcode2" name="coderockz_woo_delivery_custom_pickup_disable_postcode[]" class="coderockz_woo_delivery_custom_pickup_disable_postcode2" multiple>
			                                <?php
			                                foreach ($zone_post_code as $key => $value) {
			                                	$selected = isset($individual_time_slot_pickup['disable_postcode']) && !empty($individual_time_slot_pickup['disable_postcode']) && in_array($value,$individual_time_slot_pickup['disable_postcode']) ? "selected" : "";
			                                    echo '<option value="'.$value.'" '.$selected.'>'.$value.'</option>';		                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-custom_pickupslot-more-shipping-method">	
			                    		<div class="coderockz-woo-delivery-form-group">
				                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide For Shipping Method', 'coderockz-woo-delivery'); ?></label>
				                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup slot is hidden for the selected shipping method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
				                        	<select id="coderockz_woo_delivery_custom_pickup_disable_shipping_method2" name="coderockz_woo_delivery_custom_pickup_disable_shipping_method[]" class="coderockz_woo_delivery_custom_pickup_disable_shipping_method2" multiple>
			                                <?php
			                                foreach ($shipping_methods_for_offdays as $key => $value) {
			                                	$selected = isset($individual_time_slot_pickup['disable_shipping_method']) && !empty($individual_time_slot_pickup['disable_shipping_method']) && in_array($key,$individual_time_slot_pickup['disable_shipping_method']) ? "selected" : "";
			                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		                                }
			                                ?>
			                                </select>
				                    	</div>
			                    	</div>
								    <button class="coderockz-woo-delivery-custom-pickup-slot-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
								  </div>

	                    		<?php
						  		}
						  		
						  	}
						  	
						  ?>
	                	</div>
                	</div>

                </div>
			</div>
			<div data-tab="tab10" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Pickup Location Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-pickup-location-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_pickup_location_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Pickup Location', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Pickup Location select field in woocommerce order checkout page.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_pickup_location">
							       <input type="checkbox" name="coderockz_enable_pickup_location" id="coderockz_enable_pickup_location" <?php echo (isset($pickup_location_settings['enable_pickup_location']) && !empty($pickup_location_settings['enable_pickup_location'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Pickup Location Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Pickup Location select field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_pickup_location_mandatory">
							       <input type="checkbox" name="coderockz_pickup_location_mandatory" id="coderockz_pickup_location_mandatory" <?php echo (isset($pickup_location_settings['pickup_location_mandatory']) && !empty($pickup_location_settings['pickup_location_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_location_field_label"><?php _e('Pickup Location Field Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Location input field heading. Default is Pickup Location.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_location_field_label" name="coderockz_pickup_location_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_location_settings['field_label']) && !empty($pickup_location_settings['field_label'])) ? stripslashes(esc_attr($pickup_location_settings['field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_pickup_location_field_placeholder"><?php _e('Pickup Location Field Placeholder', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Location input field placeholder. Default is Select pickup location.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_pickup_location_field_placeholder" name="coderockz_pickup_location_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_location_settings['field_placeholder']) && !empty($pickup_location_settings['field_placeholder'])) ? stripslashes(esc_attr($pickup_location_settings['field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Location Wise Pickup Days Popup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When a customer select the pickup as order type, a popup is appeared with the location wise available pickup days. Default is enable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_pickup_location_popup">
							       <input type="checkbox" name="coderockz_woo_delivery_pickup_location_popup" id="coderockz_woo_delivery_pickup_location_popup" <?php echo (isset($pickup_location_settings['pickup_location_popup']) && !empty($pickup_location_settings['pickup_location_popup'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_location_popup_heading"><?php _e('Location Wise Pickup Days Popup Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Location Wise Pickup Days Popup Heading. Default is Location Wise Pickup Days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_location_popup_heading" name="coderockz_woo_delivery_pickup_location_popup_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($pickup_location_settings['pickup_location_popup_heading']) && !empty($pickup_location_settings['pickup_location_popup_heading'])) ? stripslashes(esc_attr($pickup_location_settings['pickup_location_popup_heading'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<?php if(!WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Searchbox From Location Field Dropdown', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the searchbox from pickup location field dropdown, enable it. Default is Showing searhbox.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_hide_searchbox_location_field_dropdown">
							       <input type="checkbox" name="coderockz_hide_searchbox_location_field_dropdown" id="coderockz_hide_searchbox_location_field_dropdown" <?php echo (isset($pickup_location_settings['hide_searchbox']) && !empty($pickup_location_settings['hide_searchbox'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php } ?>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_pickup_location_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Add Pickup Location', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' When you CHANGE a pickup location name and the location name is in the option named "Hide This Timeslot for Pickup Location" from custom pickup slots, please indicate it again in "Hide This Timeslot for Pickup Location" option from those custom pickup slots.', 'coderockz-woo-delivery'); ?></p>
                    	<input class="coderockz-woo-delivery-add-pickup-location-btn" type="button" value="<?php _e('Add New Pickup Location', 'coderockz-woo-delivery'); ?>">
	                    <div id="coderockz-woo-delivery-pickup-location-accordion">
                    	  <div class="coderockz-woo-delivery-pickup-location-accordion-header" style="display:none;">
                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><?php _e('Pickup Location Name', 'coderockz-woo-delivery'); ?></p>
                    	  </div>
						  <div data-plugin-url="<?php echo CODEROCKZ_WOO_DELIVERY_URL; ?>" class="coderockz-woo-delivery-pickup-location-accordion-content" style="display:none;">
						  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz-woo-delivery-enable-pickup-location"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
                    		</div>
                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-pickup-location-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
                    		<p class="coderockz-woo-delivery-add-pickup-location-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Name', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="text" class="coderockz-woo-delivery-pickup-location-name coderockz-woo-delivery-input-field" value="" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Google Map URL', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to give customer a direction after selecting the location under the pickup location field, input the google map url here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="text" class="coderockz-woo-delivery-pickup-location-url coderockz-woo-delivery-input-field" value="" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Admin Email', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The new order email is sent to this email address that you specified here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="text" class="coderockz-woo-delivery-pickup-location-email coderockz-woo-delivery-input-field" value="" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Pickup For This Location', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each pickup location take maximum number of pickups that is specified here. After reaching the maximum pickup, the pickup location is disabled automaticaly. Only numerical value is accepted. Keep blank to takes unlimited pickup.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input type="number" class="coderockz-woo-delivery-pickup-location-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Location Only At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the location only at some specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-pickup-location-specific-date-show coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the location at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-pickup-location-specific-date-close coderockz-woo-delivery-input-field" value="" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this pickup location, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	
	                        	<input type="text" class="coderockz-woo-delivery-custom-pickup-location-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
	                    	</div>


	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This pickup location will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div class="coderockz-woo-delivery-pickup-location-enable-for" style="display:inline-block">
	                    		<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="6"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="0"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="1"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="2"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="3"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="4"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
								<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="5"><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
								</div>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable the location for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_pickup_location_hide_categories" name="coderockz_woo_delivery_pickup_location_hide_categories[]" class="coderockz_woo_delivery_pickup_location_hide_categories" multiple>
                                
                                <?php
                                foreach ($all_categories as $cat) {

                                    echo '<option value="'.$cat->name.'">'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the location for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_pickup_location_hide_products" name="coderockz_woo_delivery_pickup_location_hide_products[]" class="coderockz_woo_delivery_pickup_location_hide_products" multiple>
                                
                                <?php
                                foreach ($store_products as $key=>$value) {
                                    echo '<option value="'.$key.'">'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the location for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<input name="coderockz_woo_delivery_pickup_location_hide_products_input" type="text" class="coderockz_woo_delivery_pickup_location_hide_products_input coderockz-woo-delivery-input-field" value="" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, the location is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" class="coderockz_woo_delivery_pickup_location_shown_other_categories_products"/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>


							<div class="coderockz-woo-delivery-form-group">
								<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
								<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Location is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
						    	<select id="coderockz_woo_delivery_pickup_location_disable_zone" name="coderockz_woo_delivery_pickup_location_disable_zone[]" class="coderockz_woo_delivery_pickup_location_disable_zone" multiple>
						        <?php
						        foreach ($zone_name as $key => $value) {
						            echo '<option value="'.$key.'">'.$value.'</option>';
						        }
						        ?>
						        </select>
							</div>

						    <button class="coderockz-woo-delivery-custom-pickup-location-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
						  </div>
						  <?php
						  	
						  	if(isset($pickup_location_settings['pickup_location']) && count($pickup_location_settings['pickup_location'])>0){


						  		foreach($pickup_location_settings['pickup_location'] as $individual_pickup_location) {
						  			

	                    			?>

	                    			<div class="coderockz-woo-delivery-pickup-location-accordion-header">
		                    	  	<p style="font-size:16px;margin:0;font-weight:700;color:#fff!important;"><?php echo stripslashes($individual_pickup_location['location_name']); ?></p>
		                    	  </div>
								  <div class="coderockz-woo-delivery-pickup-location-accordion-content">
								  	<div class="coderockz-woo-delivery-form-group" style="margin: 0;position: absolute;right: 45px;top: -31px;">
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz-woo-delivery-enable-pickup-location" <?php echo isset($individual_pickup_location['enable']) && !empty($individual_pickup_location['enable'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
		                    		</div>
		                    		<span class="dashicons dashicons-trash coderockz-woo-delivery-pickup-location-accordion-delete" style="margin: 0;position: absolute;right: 5px;top: -30px;color:#fff;cursor: pointer;"></span>
		                    		<p class="coderockz-woo-delivery-add-pickup-location-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>


			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="text" class="coderockz-woo-delivery-pickup-location-name coderockz-woo-delivery-input-field" value="<?php echo isset($individual_pickup_location['location_name']) && $individual_pickup_location['location_name'] !='' ? stripslashes(htmlentities($individual_pickup_location['location_name'])) : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Google Map URL', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to give customer a direction after selecting the location under the pickup location field, input the google map url here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="text" class="coderockz-woo-delivery-pickup-location-url coderockz-woo-delivery-input-field" value="<?php echo isset($individual_pickup_location['map_url']) && $individual_pickup_location['map_url'] !='' ? stripslashes($individual_pickup_location['map_url']) : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Admin Email', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The new order email is sent to this email address that you specified here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="text" class="coderockz-woo-delivery-pickup-location-email coderockz-woo-delivery-input-field" value="<?php echo isset($individual_pickup_location['location_email']) && $individual_pickup_location['location_email'] !='' ? stripslashes($individual_pickup_location['location_email']) : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Maximum Pickup For This Location', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Each pickup location take maximum number of pickups that is specified here. After reaching the maximum pickup, the pickup location is disabled automatically. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input type="number" class="coderockz-woo-delivery-pickup-location-order coderockz-woo-delivery-number-field" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" value="<?php echo isset($individual_pickup_location['max_order']) && $individual_pickup_location['max_order'] !='' ? $individual_pickup_location['max_order'] : ""; ?>" placeholder="" autocomplete="off"/>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Show This Location Only At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show the location only at some specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-pickup-location-specific-date-show coderockz-woo-delivery-input-field" value="<?php echo isset($individual_pickup_location['only_specific_date_show']) && $individual_pickup_location['only_specific_date_show'] !='' ? $individual_pickup_location['only_specific_date_show'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location At', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the location only at specific date then specify here the dates", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<input style="width:495px" type="text" class="coderockz-woo-delivery-pickup-location-specific-date-close coderockz-woo-delivery-input-field" value="<?php echo isset($individual_pickup_location['only_specific_date_close']) && $individual_pickup_location['only_specific_date_close'] !='' ? $individual_pickup_location['only_specific_date_close'] : ""; ?>" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Pickup Location Fee', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If anyone select this pickup location, fee specified here is applied with the total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	
			                        	<input type="text" class="coderockz-woo-delivery-custom-pickup-location-fee coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" value="<?php echo isset($individual_pickup_location['fee']) && $individual_pickup_location['fee'] !='' ? $individual_pickup_location['fee'] : ""; ?>" style="width:245px;border-radius: 3px 0 0 3px;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>"/><span class="coderockz-woo-delivery-currency-code" style="width:40px;"><?php echo $currency_code; ?></span>
			                    	</div>


			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label coderockz-woo-delivery-checkbox-label"><?php _e('Hide For', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip coderockz-woo-delivery-checkbox-tooltip" tooltip="<?php _e("This pickup location will be hidden for the selected days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                    		<div class="coderockz-woo-delivery-pickup-location-enable-for" style="display:inline-block">
			                    		<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="6" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("6",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Saturday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="0" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("0",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Sunday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="1" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("1",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Monday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="2" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("2",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Tuesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="3" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("3",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Wednesday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="4" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("4",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Thursday','coderockz-woo-delivery'); ?></label><br/>
										<input type="checkbox" name="coderockz_woo_delivery_custom_pickup_location_disable" value="5" <?php echo isset($individual_pickup_location['disable_for']) && !empty($individual_pickup_location['disable_for']) && in_array("5",$individual_pickup_location['disable_for']) ? "checked" : "";?>><label class="coderockz-woo-delivery-checkbox-field-text"><?php _e('Friday','coderockz-woo-delivery'); ?></label><br/>
										</div>
			                    	</div>

			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Categories', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the timeslot for a specific category then select the category from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_pickup_location_hide_categories2" name="coderockz_woo_delivery_pickup_location_hide_categories[]" class="coderockz_woo_delivery_pickup_location_hide_categories2" multiple>
		                                
		                                <?php

		                                $pickuplocation_hide_categories = [];
										if(isset($individual_pickup_location['hide_categories']) && !empty($individual_pickup_location['hide_categories'])) {
											foreach ($individual_pickup_location['hide_categories'] as $hide_cat) {
												$pickuplocation_hide_categories[] = stripslashes($hide_cat);
											}
										}


		                                foreach ($all_categories as $cat) {

		                                	$selected = isset($individual_pickup_location['hide_categories']) && !empty($individual_pickup_location['hide_categories']) && in_array(htmlspecialchars_decode($cat->name),$pickuplocation_hide_categories) ? "selected" : "";
		                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the ocation for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<select id="coderockz_woo_delivery_pickup_location_hide_products2" name="coderockz_woo_delivery_pickup_location_hide_products[]" class="coderockz_woo_delivery_pickup_location_hide_products2" multiple>
		                                
		                                <?php
		                                foreach ($store_products as $key=>$value) {

		                                	$selected = isset($individual_pickup_location['hide_products']) && !empty($individual_pickup_location['hide_products']) && in_array($key,$individual_pickup_location['hide_products']) ? "selected" : "";
		                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
		                                }
		                                ?>
		                                </select>
			                    	</div>
			                    	<?php } else { ?>

		                    		<div class="coderockz-woo-delivery-form-group">
			                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Products', 'coderockz-woo-delivery'); ?></label>
			                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the ocation for a specific product then select the product from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
			                        	<?php 
			                        	$location_hide_products_input = isset($individual_pickup_location['hide_products']) && !empty($individual_pickup_location['hide_products']) ? $individual_pickup_location['hide_products'] : array();
			                        	$location_hide_products_input = implode(",",$location_hide_products_input);
			                        	?>
			                    		<input name="coderockz_woo_delivery_pickup_location_hide_products2_input" type="text" class="coderockz_woo_delivery_pickup_location_hide_products2_input coderockz-woo-delivery-input-field" value="<?php echo $location_hide_products_input; ?>" placeholder="Comma separated Product/Variation ID" autocomplete="off"/>
			                    	</div>

			                    	<?php } ?>
			                    	<div class="coderockz-woo-delivery-form-group">
			                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
			                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is hidden category's products or hidden products in the cart then whatever there are other category's products or other products, the location is hidden. If you want to reverse this enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
									    <label class="coderockz-woo-delivery-toogle-switch">
									       <input type="checkbox" class="coderockz_woo_delivery_pickup_location_shown_other_categories_products" <?php echo isset($individual_pickup_location['location_shown_other_categories_products']) && !empty($individual_pickup_location['location_shown_other_categories_products'])  ? "checked" : "";?>/>
									       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
									    </label>
			                    	</div>

			                    
									<div class="coderockz-woo-delivery-form-group">
										<label class="coderockz-woo-delivery-form-label"><?php _e('Hide This Location For Shipping Zone', 'coderockz-woo-delivery'); ?></label>
										<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Location is hidden for the selected shipping zone.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								    	<select id="coderockz_woo_delivery_pickup_location_disable_zone2" name="coderockz_woo_delivery_pickup_location_disable_zone[]" class="coderockz_woo_delivery_pickup_location_disable_zone2" multiple>
								        <?php
								        foreach ($zone_name as $key => $value) {
								        	$selected = isset($individual_pickup_location['disable_zone']) && !empty($individual_pickup_location['disable_zone']) && in_array($key,$individual_pickup_location['disable_zone']) ? "selected" : "";
								            echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
								        }
								        ?>
								        </select>
									</div>



								    <button class="coderockz-woo-delivery-custom-pickup-location-saving coderockz-woo-delivery-submit-btn"><?php _e('Save Changes', 'coderockz-woo-delivery'); ?></button>
								  </div>

	                    		<?php
						  		}
						  		
						  	}
						  	
						  ?>
	                	</div>
                	</div>

                </div>

			</div>
			<div data-tab="tab6" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-date-tab-offdays-notice"></p>
						<input class="coderockz-woo-delivery-add-year-btn" type="button" value="<?php _e('Add New Year', 'coderockz-woo-delivery'); ?>">
	                    <form action="" method="post" id ="coderockz_delivery_date_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div id="coderockz-woo-delivery-offdays" class="coderockz-woo-delivery-offdays">
							    
	                        	<?php
	                        		$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									$offdays_html = "";
									$offdays_years = $date_settings;
									if(isset($offdays_years['off_days']) && !empty($offdays_years['off_days'])) {
										foreach($offdays_years['off_days'] as $year=>$months) {
											
											$offdays_html .= '<div class="coderockz-woo-delivery-add-year-html coderockz-woo-delivery-form-group">';
											if(array_keys($offdays_years['off_days'])[0] == $year) {
												$offdays_html .= '<img class="coderockz-arrow" src="'. CODEROCKZ_WOO_DELIVERY_URL .'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';	

											} else {
												$offdays_html .= '<button class="coderockz-offdays-year-remove"><span class="dashicons dashicons-trash"></span></button>';
											}
											
											$offdays_html .= '<input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_offdays_year" maxlength="4" type="text" value="'.$year.'" placeholder="'.__('Year (ex. 2019)', 'coderockz-woo-delivery').'" style="vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_offdays_year_'.$year.'">';
											$offdays_html .= '<div style="display:inline-block;" class="coderockz_woo_delivery_offdays_another_month coderockz_woo_delivery_offdays_another_month_'.$year.'">';
											foreach($months as $month=>$date) {
												$offdays_html .= '<div class="coderockz_woo_delivery_offdays_add_another_month">';
												$offdays_html .= '<select style="width:125px!important" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_offdays_month_'.$year.'[]">';
												$offdays_html .= '<option value="">'.__('Select Month', 'coderockz-woo-delivery').'</option>';
												foreach($month_array as $single_month => $single_month_name) {
													$single_month == $month ? $selected = "selected" : $selected = "";
													$offdays_html .= '<option value="'.$single_month.'"'.$selected.'>'.ucfirst($single_month_name).'</option>';
												}
												$offdays_html .= '</select>';
												$offdays_html .= '<input id="coderockz_woo_delivery_offdays_dates" type="text" class="coderockz-woo-delivery-input-field" value="'.$date.'" placeholder="'.__('Comma(,) Separated Date', 'coderockz-woo-delivery').'" style="width:200px;vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_offdays_dates_'.$month.'_'.$year.'">';
												if(array_keys($months)[0] != $month) {
													
													$offdays_html .= '<button class="coderockz-offdays-month-remove"><span class="dashicons dashicons-trash"></span></button>';
												}
												$offdays_html .= '</div>';
											}
											$offdays_html .= '</div>';
											$offdays_html .= '<br>
												    	  <span style="position:relative;left:18%">
														    <input class="coderockz-woo-delivery-add-month-btn" type="button" value="'.__('Add Month', 'coderockz-woo-delivery').'">
														    <div class="coderockz-woo-delivery-dummy-btn" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
														  </span>';
											
											$offdays_html .= '</div>';
										}
										echo $offdays_html;
									} else {
	                        	?>

							    <div class="coderockz-woo-delivery-add-year-html coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							        <input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_offdays_year" maxlength="4" type="text" value="<?php  ?>" placeholder="<?php _e('Year (ex. 2019)', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off"/>
							        <div class="coderockz_woo_delivery_offdays_another_month" style="display:inline-block;">
								        <div class="coderockz_woo_delivery_offdays_add_another_month">
									        <select style="width:125px!important" class="coderockz-woo-delivery-select-field" disabled="disabled">
									        	<option value=""><?php _e('Select Month', 'coderockz-woo-delivery'); ?></option>
									        	<?php
									        	$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									        	foreach($month_array as $single_month => $single_month_name) {
													echo '<option value="'.$single_month.'">'.ucfirst($single_month_name).'</option>';
												}
									        	?>
									            
										    </select>
									        <input style="width:200px" id="coderockz_woo_delivery_offdays_dates" type="text" class="coderockz-woo-delivery-input-field" value="<?php  ?>" placeholder="<?php _e('Comma(,) Separated Date', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off" disabled="disabled"/>
								    	</div>
							    	</div>
							    	<br/>
							    	<span style="position:relative;left:18%">
									  <input class="coderockz-woo-delivery-add-month-btn" type="button" value="<?php _e('Add Month', 'coderockz-woo-delivery'); ?>" disabled="disabled">
									  <div class="coderockz-woo-delivery-dummy-btn" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
									</span>


							    </div>
								<?php } ?>
							</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_date_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Pickup Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-date-tab-pickup-offdays-notice"></p>
						<input class="coderockz-woo-delivery-pickup-add-year-btn" type="button" value="<?php _e('Add New Year', 'coderockz-woo-delivery'); ?>">
	                    <form action="" method="post" id ="coderockz_delivery_date_pickup_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div id="coderockz-woo-delivery-pickup-offdays" class="coderockz-woo-delivery-pickup-offdays">
							    
	                        	<?php
	                        		$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									$offdays_html = "";
									$offdays_years = $pickup_date_settings;
									if(isset($offdays_years['pickup_off_days']) && !empty($offdays_years['pickup_off_days'])) {
										foreach($offdays_years['pickup_off_days'] as $year=>$months) {
											
											$offdays_html .= '<div class="coderockz-woo-delivery-pickup-add-year-html coderockz-woo-delivery-form-group">';
											if(array_keys($offdays_years['pickup_off_days'])[0] == $year) {
												$offdays_html .= '<img class="coderockz-arrow" src="'. CODEROCKZ_WOO_DELIVERY_URL .'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';	

											} else {
												$offdays_html .= '<button class="coderockz-pickup-offdays-year-remove"><span class="dashicons dashicons-trash"></span></button>';
											}
											
											$offdays_html .= '<input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_pickup_offdays_year" maxlength="4" type="text" value="'.$year.'" placeholder="'.__('Year (ex. 2019)', 'coderockz-woo-delivery').'" style="vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_pickup_offdays_year_'.$year.'">';
											$offdays_html .= '<div style="display:inline-block;" class="coderockz_woo_delivery_pickup_offdays_another_month coderockz_woo_delivery_pickup_offdays_another_month_'.$year.'">';
											foreach($months as $month=>$date) {
												$offdays_html .= '<div class="coderockz_woo_delivery_pickup_offdays_add_another_month">';
												$offdays_html .= '<select style="width:125px!important" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_pickup_offdays_month_'.$year.'[]">';
												$offdays_html .= '<option value="">'.__('Select Month', 'coderockz-woo-delivery').'</option>';
												foreach($month_array as $single_month => $single_month_name) {
													$single_month == $month ? $selected = "selected" : $selected = "";
													$offdays_html .= '<option value="'.$single_month.'"'.$selected.'>'.ucfirst($single_month_name).'</option>';
												}
												$offdays_html .= '</select>';
												$offdays_html .= '<input id="coderockz_woo_delivery_pickup_offdays_dates" type="text" class="coderockz-woo-delivery-input-field" value="'.$date.'" placeholder="'.__('Comma(,) Separated Date', 'coderockz-woo-delivery').'" style="width:200px;vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_pickup_offdays_dates_'.$month.'_'.$year.'">';
												if(array_keys($months)[0] != $month) {
													
													$offdays_html .= '<button class="coderockz-pickup-offdays-month-remove"><span class="dashicons dashicons-trash"></span></button>';
												}
												$offdays_html .= '</div>';
											}
											$offdays_html .= '</div>';
											$offdays_html .= '<br>
												    	  <span style="position:relative;left:18%">
														    <input class="coderockz-woo-delivery-pickup-add-month-btn" type="button" value="'.__('Add Month', 'coderockz-woo-delivery').'">
														    <div class="coderockz-woo-delivery-pickup-dummy-btn" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
														  </span>';
											
											$offdays_html .= '</div>';
										}
										echo $offdays_html;
									} else {
	                        	?>

							    <div class="coderockz-woo-delivery-pickup-add-year-html coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							        <input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_pickup_offdays_year" maxlength="4" type="text" value="<?php  ?>" placeholder="<?php _e('Year (ex. 2019)', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off"/>
							        <div class="coderockz_woo_delivery_pickup_offdays_another_month" style="display:inline-block;">
								        <div class="coderockz_woo_delivery_pickup_offdays_add_another_month">
									        <select style="width:125px!important" class="coderockz-woo-delivery-select-field" disabled="disabled">
									        	<option value=""><?php _e('Select Month', 'coderockz-woo-delivery'); ?></option>
									        	<?php
									        	$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									        	foreach($month_array as $single_month => $single_month_name) {
													echo '<option value="'.$single_month.'">'.ucfirst($single_month_name).'</option>';
												}
									        	?>
									            
										    </select>
									        <input style="width:200px" id="coderockz_woo_delivery_pickup_offdays_dates" type="text" class="coderockz-woo-delivery-input-field" value="<?php  ?>" placeholder="<?php _e('Comma(,) Separated Date', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off" disabled="disabled"/>
								    	</div>
							    	</div>
							    	<br/>
							    	<span style="position:relative;left:18%">
									  <input class="coderockz-woo-delivery-pickup-add-month-btn" type="button" value="<?php _e('Add Month', 'coderockz-woo-delivery'); ?>" disabled="disabled">
									  <div class="coderockz-woo-delivery-pickup-dummy-btn" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
									</span>


							    </div>
								<?php } ?>
							</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_date_pickup_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Current Week Off', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-current-week-off-settings-notice"></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' "Week Starts From" from the delivery/pickup date tab is count as the first day of the week. Default is Sunday', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_current_week_off_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Current Week Off Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the categories for which you don't want to give the facility of delivery/pickup for the current week. Customer only select next week date as delivery/pickup date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_current_week_off_categories" name="coderockz_woo_delivery_current_week_off_categories[]" class="coderockz_woo_delivery_current_week_off_categories" multiple>
                                
                                <?php

                                $current_week_off_categories = [];
								if(isset($offdays_settings['current_week_off_categories']) && !empty($offdays_settings['current_week_off_categories'])) {
									foreach ($offdays_settings['current_week_off_categories'] as $hide_cat) {
										$current_week_off_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($offdays_settings['current_week_off_categories']) && !empty($offdays_settings['current_week_off_categories']) && in_array(htmlspecialchars_decode($cat->name),$current_week_off_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_current_week_off_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Next Week Off', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-next-week-off-settings-notice"></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' "Week Starts From" from the delivery/pickup date tab is count as the first day of the week. Default is Sunday', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_next_week_off_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Next Week Off Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the categories for which you don't want to give the facility of delivery/pickup for the next week. Customer only select current week date as delivery/pickup date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_next_week_off_categories" name="coderockz_woo_delivery_next_week_off_categories[]" class="coderockz_woo_delivery_next_week_off_categories" multiple>
                                
                                <?php

                                $next_week_off_categories = [];
								if(isset($offdays_settings['next_week_off_categories']) && !empty($offdays_settings['next_week_off_categories'])) {
									foreach ($offdays_settings['next_week_off_categories'] as $hide_cat) {
										$next_week_off_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($offdays_settings['next_week_off_categories']) && !empty($offdays_settings['next_week_off_categories']) && in_array(htmlspecialchars_decode($cat->name),$next_week_off_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_next_week_off_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Next Month Off', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-next-month-off-settings-notice"></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_next_month_off_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Next Month Off Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the categories for which you don't want to give the facility of delivery/pickup for the next month. Customer only select current month date as delivery/pickup date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_next_month_off_categories" name="coderockz_woo_delivery_next_month_off_categories[]" class="coderockz_woo_delivery_next_month_off_categories" multiple>
                                
                                <?php

                                $next_month_off_categories = [];
								if(isset($offdays_settings['next_month_off_categories']) && !empty($offdays_settings['next_month_off_categories'])) {
									foreach ($offdays_settings['next_month_off_categories'] as $hide_cat) {
										$next_month_off_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($offdays_settings['next_month_off_categories']) && !empty($offdays_settings['next_month_off_categories']) && in_array(htmlspecialchars_decode($cat->name),$next_month_off_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_next_month_off_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-category-wise-offdays-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_category_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <?php
	                        $category_wise_offdays_html = "";
							$applicable_for = array("both"=> __("For Both",'coderockz-woo-delivery'), "delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
							$i = 1;
							foreach ($applicable_for as $applicable_key => $applicable_value) {
								if(isset($offdays_settings['category_wise_offdays'][$applicable_key]) && !empty($offdays_settings['category_wise_offdays'][$applicable_key])) {
									foreach($offdays_settings['category_wise_offdays'][$applicable_key] as $category => $days) {
										$category_wise_offdays_html .= '<div class="coderockz-woo-delivery-category-wise-offdays">';
										$category_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
								        $category_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
										$category_wise_offdays_html .= '<select style="width: 175px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_category_wise_offdays_category" name="coderockz_delivery_category_wise_offdays_category[]">
									    <option value="">'.__('Select Category','coderockz-woo-delivery').'</option>';
										foreach ($all_categories as $cat) {
											$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
											$category_wise_offdays_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
										}
										$category_wise_offdays_html .= '</select>';
										$category_wise_offdays_html .= '<select name="coderockz-delivery-category-wise-offdays-category-weekday-'.str_replace(" ","c-w-d",$category).'-'.$applicable_key.'[]" class="coderockz_delivery_category_wise_offdays_category_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple>';

								        $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
								        if(isset($offdays_settings['category_wise_offdays'][$applicable_key][$category]['weekday_offdays']) && $offdays_settings['category_wise_offdays'][$applicable_key][$category]['weekday_offdays'] !="") {
								        	$category_offdays = $offdays_settings['category_wise_offdays'][$applicable_key][$category]['weekday_offdays'];
								        } else {
								        	$category_offdays = array();
								        }
								        
								        foreach ($weekday as $key => $value) {
								        	
								        	if(in_array($key,$category_offdays)) {
								        		$category_wise_offdays_html .= '<option value="'.$key.'" selected>'.$value.'</option>';

								        	} else {
								        		$category_wise_offdays_html .= '<option value="'.$key.'">'.$value.'</option>';
								        	}
								            		
								        }

								        $category_wise_offdays_html .= '</select>';
								        $specific_date_offdays = isset($offdays_settings['category_wise_offdays'][$applicable_key][$category]['specific_date_offdays_string']) && $offdays_settings['category_wise_offdays'][$applicable_key][$category]['specific_date_offdays_string'] != "" ? $offdays_settings['category_wise_offdays'][$applicable_key][$category]['specific_date_offdays_string'] : "";
								        $category_wise_offdays_html .= '<input type="text" class="coderockz_delivery_category_wise_offdays_category_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-category-wise-offdays-category-specific-date-'.str_replace(" ","c-w-d",$category).'-'.$applicable_key.'" value="'.$specific_date_offdays.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';

								        $category_wise_offdays_html .= '<select style="width: 115px!important;vertical-align:top!important" class="coderockz-woo-delivery-select-field coderockz_delivery_category_wise_offdays_applicable_for" name="coderockz_delivery_category_wise_offdays_applicable_for_'.str_replace(" ","c-w-d",$category).'_'.$applicable_key.'" autocomplete="off">';
								        
								        foreach ($applicable_for as $key => $value) {
								        	if($key == $applicable_key) {
								            	$category_wise_offdays_html .= '<option value="'.$key.'" selected='.$selected.'>'.$value.'</option>';
								            } else {
								            	$category_wise_offdays_html .= '<option value="'.$key.'">'.$value.'</option>';
								            }		
								        }
										$category_wise_offdays_html .= '</select>';
										if($i!=1){
											$category_wise_offdays_html .= '<button class="coderockz-woo-delivery-category-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
										}

										$i = $i+1;
										
								        $category_wise_offdays_html .= '</div>';
								        $category_wise_offdays_html .= '</div>';
									}

								}

							}

							if($category_wise_offdays_html != "") {
								echo $category_wise_offdays_html;
							} else {

							?>
							    <div class="coderockz-woo-delivery-category-wise-offdays">
							    <div class="coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select style="width: 175px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_category_wise_offdays_category" name="coderockz_delivery_category_wise_offdays_category[]" autocomplete="off">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
							        foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
							        ?>
									</select>
								    <select id="coderockz_delivery_category_wise_offdays_category_weekday" name="coderockz_delivery_category_wise_offdays_category_weekday[]" class="coderockz_delivery_category_wise_offdays_category_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
							        <?php
							        $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
							        foreach ($weekday as $key => $value) {
							            echo '<option value="'.$key.'">'.$value.'</option>';		
							        }
							        ?>
							        </select>
							        <input type="text" class="coderockz_delivery_category_wise_offdays_category_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-category-wise-offdays-category-specific-date" value="" style="vertical-align:top!important;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>"/>
							        <select style="width: 115px!important;vertical-align:top!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_category_wise_offdays_applicable_for" name="coderockz_delivery_category_wise_offdays_applicable_for[]" autocomplete="off">
									<?php
							        $applicable_for = array("both"=> __("For Both",'coderockz-woo-delivery'), "delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
							        foreach ($applicable_for as $key => $value) {
							            echo '<option value="'.$key.'">'.$value.'</option>';		
							        }
							        ?>
									</select>
								</div>
								</div>
							<?php } ?>
	                    	<button class="coderockz-woo-delivery-add-category-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Product Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else {?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('One ID per line. If product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-product-wise-offdays-notice"></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_product_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                        
	                        <div class="coderockz-woo-delivery-product-wise-offdays">

	                        <?php
	                        $product_wise_offdays_html = "";
							if(isset($offdays_settings['product_wise_offdays']) && !empty($offdays_settings['product_wise_offdays'])) {
								foreach($offdays_settings['product_wise_offdays'] as $product => $days) {
									$product_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_wise_offdays_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_product_wise_offdays_product[]">
								    <option value="">'.__('Select Product', 'coderockz-woo-delivery').'</option>';
									foreach ($store_products as $key=>$value) {
										$selected = ($key == $product) ? "selected" : "";
										$product_wise_offdays_html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
									}
									$product_wise_offdays_html .= '</select>';
									$product_wise_offdays_html .= '<select name="coderockz-delivery-product-wise-offdays-product-weekday-'.str_replace(" ","c-w-d",$product).'[]" class="coderockz_delivery_product_wise_offdays_product_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple>';

	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) && !empty($offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) && in_array($key,$offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) ? "selected" : "";
	                                    $product_wise_offdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }

	                                $product_wise_offdays_html .= '</select>';

	                                $product_specific_date_offdays = isset($offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string']) && $offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string'] != "" ? $offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string'] : "";
	                                $product_wise_offdays_html .= '<input type="text" class="coderockz_delivery_product_wise_offdays_product_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-product-wise-offdays-product-specific-date-'.str_replace(" ","c-w-d",$product).'" value="'.$product_specific_date_offdays.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';

									if(array_keys($offdays_settings['product_wise_offdays'])[0] != $product){
										$product_wise_offdays_html .= '<button class="coderockz-woo-delivery-product-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $product_wise_offdays_html .= '</div>';
								}
								echo $product_wise_offdays_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_product_wise_offdays_product[]" autocomplete="off">
								    <option value=""><?php _e('Select Product', 'coderockz-woo-delivery'); ?></option>
									<?php
	                                foreach ($store_products as $key=>$value) {
										echo '<option value="'.$key.'">'.$value.'</option>';
									}
	                                ?>
									</select>
								    <select name="coderockz_delivery_product_wise_offdays_product_weekday[]" class="coderockz_delivery_product_wise_offdays_product_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
	                                <?php
	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
	                                </select>
	                                <input type="text" class="coderockz-woo-delivery-input-field coderockz_delivery_product_wise_offdays_product_specific_date" name="coderockz_delivery_product_wise_offdays_product_specific_date" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>"/>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<?php } else { ?>


	                    	<div class="coderockz-woo-delivery-product-wise-offdays">

	                        <?php
	                        $product_wise_offdays_html = "";
							if(isset($offdays_settings['product_wise_offdays']) && !empty($offdays_settings['product_wise_offdays'])) {
								foreach($offdays_settings['product_wise_offdays'] as $product => $days) {
									$product_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_wise_offdays_html .= '<input name="coderockz_delivery_product_wise_offdays_product_input" type="text" class="coderockz-woo-delivery-input-field" value="'.$product.'" placeholder="Product/Variation ID" autocomplete="off"/>';
									$product_wise_offdays_html .= '<select name="coderockz-delivery-product-wise-offdays-product-weekday-'.str_replace(" ","c-w-d",$product).'[]" class="coderockz_delivery_product_wise_offdays_product_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple>';

	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) && !empty($offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) && in_array($key,$offdays_settings['product_wise_offdays'][$product]['weekday_offdays']) ? "selected" : "";
	                                    $product_wise_offdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }

	                                $product_wise_offdays_html .= '</select>';

	                                 $product_specific_date_offdays = isset($offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string']) && $offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string'] != "" ? $offdays_settings['product_wise_offdays'][$product]['specific_date_offdays_string'] : "";
	                                $product_wise_offdays_html .= '<input type="text" class="coderockz_delivery_product_wise_offdays_product_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-product-wise-offdays-product-specific-date-'.str_replace(" ","c-w-d",$product).'" value="'.$product_specific_date_offdays.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';
									if(array_keys($offdays_settings['product_wise_offdays'])[0] != $product){
										$product_wise_offdays_html .= '<button class="coderockz-woo-delivery-product-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $product_wise_offdays_html .= '</div>';
								}
								echo $product_wise_offdays_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
									<input name="coderockz_delivery_product_wise_offdays_product_input" type="text" class="coderockz-woo-delivery-input-field" placeholder="Product/Variation ID" autocomplete="off"/>
								    <select name="coderockz_delivery_product_wise_offdays_product_weekday[]" class="coderockz_delivery_product_wise_offdays_product_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
	                                <?php
	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
	                                </select>
	                                <input type="text" class="coderockz-woo-delivery-input-field coderockz_delivery_product_wise_offdays_product_specific_date" name="coderockz_delivery_product_wise_offdays_product_specific_date" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>"/>
		                    	</div>
		                    <?php } ?>
	                    	</div>

	                    	<?php } ?>
	                    	<button class="coderockz-woo-delivery-add-product-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_product_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping Zone Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-zone-wise-offdays-notice"></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_zone_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <!-- <div class="coderockz-woo-delivery-zone-wise-offdays"> -->

	                        <?php
	                        $zone_wise_offdays_html = "";
	                        $applicable_for = array("both"=> __("For Both",'coderockz-woo-delivery'), "delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
	                        $i = 1;
	                        foreach ($applicable_for as $applicable_key => $applicable_value) {
							if(isset($offdays_settings['zone_wise_offdays'][$applicable_key]) && !empty($offdays_settings['zone_wise_offdays'][$applicable_key])) {
								foreach($offdays_settings['zone_wise_offdays'][$applicable_key] as $zone => $days) {
									$zone_wise_offdays_html .= '<div class="coderockz-woo-delivery-zone-wise-offdays">';
									$zone_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $zone_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$zone_wise_offdays_html .= '<select style="width: 175px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_offdays_zone" name="coderockz_delivery_zone_wise_offdays_zone[]">
								    <option value="">'.__('Select Shipping Zone', 'coderockz-woo-delivery').'</option>';
									foreach ($zone_name as $key => $value) {
										$selected = ($key == $zone) ? "selected" : "";
										$zone_wise_offdays_html .= '<option value="'.str_replace(" ","c-w-d",$key).'"'.$selected.'>'.$value.'</option>';
									}
									$zone_wise_offdays_html .= '</select>';
									$zone_wise_offdays_html .= '<select name="coderockz-delivery-zone-wise-offdays-zone-weekday-'.str_replace(" ","c-w-d",$zone).'-'.$applicable_key.'[]" class="coderockz_delivery_zone_wise_offdays_zone_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple>';

	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                if(isset($offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['off_days']) && $offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['off_days'] !="") {
	                                	$zone_offdays = explode(",",$offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['off_days']);
	                                } else {
	                                	$zone_offdays = array();
	                                }
	                                
	                                foreach ($weekday as $key => $value) {
	                                	
	                                	if(in_array($key,$zone_offdays)) {
	                                		$zone_wise_offdays_html .= '<option value="'.$key.'" selected>'.$value.'</option>';

	                                	} else {
	                                		$zone_wise_offdays_html .= '<option value="'.$key.'">'.$value.'</option>';
	                                	}
	                                    		
	                                }

	                                $zone_wise_offdays_html .= '</select>';
	                                $zone_wise_specific_date_offdays = isset($offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['specific_date_offdays_string']) && $offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['specific_date_offdays_string'] != "" ? $offdays_settings['zone_wise_offdays'][$applicable_key][$zone]['specific_date_offdays_string'] : "";
	                                $zone_wise_offdays_html .= '<input type="text" class="coderockz_delivery_zone_wise_offdays_zone_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-zone-wise-offdays-zone-specific-date-'.str_replace(" ","c-w-d",$zone).'-'.$applicable_key.'" value="'.$zone_wise_specific_date_offdays.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';

	                                $zone_wise_offdays_html .= '<select style="vertical-align:top!important;width: 115px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_offdays_applicable_for" name="coderockz_delivery_zone_wise_offdays_applicable_for_'.str_replace(" ","c-w-d",$zone).'_'.$applicable_key.'" autocomplete="off">';
	                                
	                                /*$selected_applicable_for = isset($offdays_settings['zone_wise_offdays'][$zone]['applicable_for']) && $offdays_settings['zone_wise_offdays'][$zone]['applicable_for'] !="" ? $offdays_settings['zone_wise_offdays'][$zone]['applicable_for'] : "both";*/
	                                foreach ($applicable_for as $key => $value) {
	                                	if($key == $applicable_key) {
	                                    	$zone_wise_offdays_html .= '<option value="'.$key.'" selected='.$selected.'>'.$value.'</option>';
	                                    } else {
	                                    	$zone_wise_offdays_html .= '<option value="'.$key.'">'.$value.'</option>';
	                                    }		
	                                }
									$zone_wise_offdays_html .= '</select>';
									if($i!=1){
										$zone_wise_offdays_html .= '<button class="coderockz-woo-delivery-zone-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}

									$i = $i+1;
									
							        $zone_wise_offdays_html .= '</div>';
							        $zone_wise_offdays_html .= '</div>';
								}

							}

							}

							if($zone_wise_offdays_html != "") {
								echo $zone_wise_offdays_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-zone-wise-offdays">
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select style="width: 175px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_offdays_zone" name="coderockz_delivery_zone_wise_offdays_zone[]" autocomplete="off">
								    <option value=""><?php _e('Select Shipping Zone', 'coderockz-woo-delivery'); ?></option>
									<?php
	                                foreach ($zone_name as $key => $value) {
	                                    echo '<option value="'.str_replace(" ","c-w-d",$key).'">'.$value.'</option>';
	                                }
	                                ?>
									</select>
								    <select id="coderockz_delivery_zone_wise_offdays_zone_weekday" name="coderockz_delivery_zone_wise_offdays_zone_weekday[]" class="coderockz_delivery_zone_wise_offdays_zone_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
	                                <?php
	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
	                                </select>
	                                <input type="text" class="coderockz_delivery_zone_wise_offdays_zone_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-zone-wise-offdays-zone-specific-date" value="" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>"/>
	                                <select style="vertical-align:top!important;width: 115px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_offdays_applicable_for" name="coderockz_delivery_zone_wise_offdays_applicable_for[]" autocomplete="off">
									<?php
	                                $applicable_for = array("both"=> __("For Both",'coderockz-woo-delivery'), "delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
	                                foreach ($applicable_for as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
									</select>
		                    	</div>
		                    	</div>
		                    <?php } ?>
	                    	
	                    	<button class="coderockz-woo-delivery-add-zone-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_zone_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping State Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-state-wise-offdays-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_state_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-state-wise-offdays">

	                        <?php
	                        $state_wise_offdays_html = "";
							if(isset($offdays_settings['state_wise_offdays']) && !empty($offdays_settings['state_wise_offdays'])) {
								foreach($offdays_settings['state_wise_offdays'] as $state => $days) {
									$state_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $state_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$state_wise_offdays_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_state_wise_offdays_state[]">
								    <option value="">'.__('Select Shipping State', 'coderockz-woo-delivery').'</option>';
									foreach ($zone_regions as $key => $value) {
										$selected = ($key == $state) ? "selected" : "";
										$state_wise_offdays_html .= '<option value="'.str_replace(" ","c-w-d",$key).'" '.$selected.'>'.$value.'</option>';
									}
									$state_wise_offdays_html .= '</select>';
									$state_wise_offdays_html .= '<select name="coderockz-delivery-state-wise-offdays-state-weekday-'.str_replace(" ","c-w-d",$state).'[]" class="coderockz_delivery_state_wise_offdays_state_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple autocomplete="off">';

	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($offdays_settings['state_wise_offdays']) && !empty($offdays_settings['state_wise_offdays']) && in_array($key,$offdays_settings['state_wise_offdays'][$state]) ? "selected" : "";
	                                    $state_wise_offdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }

	                                $state_wise_offdays_html .= '</select>';
									if(array_keys($offdays_settings['state_wise_offdays'])[0] != $state){
										$state_wise_offdays_html .= '<button class="coderockz-woo-delivery-state-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $state_wise_offdays_html .= '</div>';
								}
								echo $state_wise_offdays_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_state_wise_offdays_state[]" autocomplete="off">
								    <option value=""><?php _e('Select Shipping State', 'coderockz-woo-delivery'); ?></option>
									<?php
	                                foreach ($zone_regions as $key => $value) {
	                                	echo '<option value="'.str_replace(" ","c-w-d",$key).'">'.$value.'</option>';
	                                    
	                                }
	                                ?>
									</select>
								    <select name="coderockz_delivery_state_wise_offdays_state_weekday[]" class="coderockz_delivery_state_wise_offdays_state_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
	                                <?php
	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
	                                </select>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-state-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_state_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping PostCode Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-postcode-wise-offdays-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_postcode_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-postcode-wise-offdays">

	                        <?php
	                        $postcode_wise_offdays_html = "";
	                        
							if(isset($offdays_settings['postcode_wise_offdays']) && !empty($offdays_settings['postcode_wise_offdays'])) {
								foreach($offdays_settings['postcode_wise_offdays'] as $postcode => $days) {
									$postcode_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $postcode_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$postcode_wise_offdays_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_postcode_wise_offdays_postcode[]">
								    <option value="">'.__('Select Shipping Postcode', 'coderockz-woo-delivery').'</option>';
									foreach ($zone_post_code as $key => $value) {
										$selected = ($value == $postcode) ? "selected" : "";
										$postcode_wise_offdays_html .= '<option value="'.str_replace(array(" ","..."),array("--","___"),$value).'" '.$selected.'>'.$value.'</option>';
									}
									$postcode_wise_offdays_html .= '</select>';
									$postcode_wise_offdays_html .= '<select name="coderockz-delivery-postcode-wise-offdays-postcode-weekday-'.str_replace(array(" ","..."),array("--","___"),$postcode).'[]" class="coderockz_delivery_postcode_wise_offdays_postcode_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple autocomplete="off">';

	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                	$selected = isset($offdays_settings['postcode_wise_offdays']) && !empty($offdays_settings['postcode_wise_offdays']) && in_array($key,$offdays_settings['postcode_wise_offdays'][$postcode]) ? "selected" : "";
	                                    $postcode_wise_offdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }

	                                $postcode_wise_offdays_html .= '</select>';
									if(array_keys($offdays_settings['postcode_wise_offdays'])[0] != $postcode){
										$postcode_wise_offdays_html .= '<button class="coderockz-woo-delivery-postcode-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $postcode_wise_offdays_html .= '</div>';
								}
								echo $postcode_wise_offdays_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_postcode_wise_offdays_postcode[]" autocomplete="off">
								    <option value=""><?php _e('Select Shipping Postcode', 'coderockz-woo-delivery'); ?></option>
									<?php

	                                foreach ($zone_post_code as $key => $value) {
	                                	echo '<option value="'.str_replace(array(" ","..."),array("--","___"),$value).'">'.$value.'</option>';
	                                    
	                                }
	                                ?>
									</select>
								    <select name="coderockz_delivery_postcode_wise_offdays_postcode_weekday[]" class="coderockz_delivery_postcode_wise_offdays_postcode_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple autocomplete="off">
	                                <?php
	                                $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                                foreach ($weekday as $key => $value) {
	                                    echo '<option value="'.$key.'">'.$value.'</option>';		
	                                }
	                                ?>
	                                </select>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-postcode-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_postcode_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping Method Wise Off Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-shippingmethod-wise-offdays-notice"></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_shippingmethod_wise_offdays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <?php
	                        $shippingmethod_wise_offdays_html = "";
							$i = 1;
							if(isset($offdays_settings['shippingmethod_wise_offdays']) && !empty($offdays_settings['shippingmethod_wise_offdays'])) {
								foreach($offdays_settings['shippingmethod_wise_offdays'] as $shippingmethod => $days) {
									$shippingmethod_wise_offdays_html .= '<div class="coderockz-woo-delivery-shippingmethod-wise-offdays">';
									$shippingmethod_wise_offdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $shippingmethod_wise_offdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$shippingmethod_wise_offdays_html .= '<select style="vertical-align: top!important;width: 200px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_offdays_shippingmethod" name="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod[]">
								    <option value="">'.__('Select Shipping Method', 'coderockz-woo-delivery').'</option>';
									foreach ($shipping_methods_for_offdays as $key => $value) {
										$selected = ($key == $shippingmethod) ? "selected" : "";
										$shippingmethod_wise_offdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
									}
									$shippingmethod_wise_offdays_html .= '</select>';
									$shippingmethod_wise_offdays_html .= '<select name="coderockz-delivery-shippingmethod-wise-offdays-shippingmethod-weekday-'.$shippingmethod.'[]" class="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_weekday" placeholder="'.__('Disable Days', 'coderockz-woo-delivery').'" multiple>';

							        $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
							        if(isset($offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['weekday_off']) && $offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['weekday_off'] !="") {
							        	$shippingmethod_wise_offdays = $offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['weekday_off'];
							        } else {
							        	$shippingmethod_wise_offdays = array();
							        }
							        
							        foreach ($weekday as $key => $value) {
							        	
							        	if(in_array($key,$shippingmethod_wise_offdays)) {
							        		$shippingmethod_wise_offdays_html .= '<option value="'.$key.'" selected>'.$value.'</option>';

							        	} else {
							        		$shippingmethod_wise_offdays_html .= '<option value="'.$key.'">'.$value.'</option>';
							        	}
							            		
							        }

							        $shippingmethod_wise_offdays_html .= '</select>';
							        $shippingmethod_wise_offdays_specific_date = isset($offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['specific_date_offdays_string']) && $offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['specific_date_offdays_string'] != "" ? $offdays_settings['shippingmethod_wise_offdays'][$shippingmethod]['specific_date_offdays_string'] : "";
	                                $shippingmethod_wise_offdays_html .= '<input type="text" class="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_specific_date coderockz-woo-delivery-input-field" name="coderockz-delivery-shippingmethod-wise-offdays-shippingmethod-specific-date-'.$shippingmethod.'" value="'.$shippingmethod_wise_offdays_specific_date.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';
									if($i!=1){
										$shippingmethod_wise_offdays_html .= '<button class="coderockz-woo-delivery-shippingmethod-wise-offdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}

									$i = $i+1;
									
							        $shippingmethod_wise_offdays_html .= '</div>';
							        $shippingmethod_wise_offdays_html .= '</div>';
								}

							}

							if($shippingmethod_wise_offdays_html != "") {
								echo $shippingmethod_wise_offdays_html;
							} else {

							?>
							    <div class="coderockz-woo-delivery-shippingmethod-wise-offdays">
							    <div class="coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select style="vertical-align: top!important;width: 200px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_offdays_shippingmethod" name="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod[]" autocomplete="off">
								    <option value=""><?php _e('Select Shipping Method', 'coderockz-woo-delivery'); ?></option>
									<?php

							        foreach ($shipping_methods_for_offdays as $key => $value) {
							        	echo '<option value="'.$key.'">'.$value.'</option>';
							            
							        }
							        ?>
									</select>
								    <select id="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_weekday" name="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_weekday[]" class="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_weekday" placeholder="<?php _e('Disable Days', 'coderockz-woo-delivery'); ?>" multiple  autocomplete="off">
							        <?php
							        $weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
							        foreach ($weekday as $key => $value) {
							            echo '<option value="'.$key.'">'.$value.'</option>';		
							        }
							        ?>
							        </select>
							        <input type="text" class="coderockz-woo-delivery-input-field coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_specific_date" name="coderockz_delivery_shippingmethod_wise_offdays_shippingmethod_specific_date" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>"/>
								</div>
								</div>
							<?php } ?>

	                    	<button class="coderockz-woo-delivery-add-shippingmethod-wise-offdays-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_shippingmethod_wise_offdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                
			</div>

			<div data-tab="tab7" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Special Open Days For Delivery', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-date-tab-opendays-notice"></p>
						
						<input class="coderockz-woo-delivery-add-year-btn-delivery-opendays" type="button" value="<?php _e('Add New Year', 'coderockz-woo-delivery'); ?>">
	                    <form action="" method="post" id ="coderockz_delivery_date_delivery_opendays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div id="coderockz-woo-delivery-delivery-opendays" class="coderockz-woo-delivery-delivery-opendays">
							    
	                        	<?php
	                        		$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									$opendays_html = "";
									$opendays_years = $date_settings;
									if(isset($opendays_years['open_days']) && !empty($opendays_years['open_days'])) {
										foreach($opendays_years['open_days'] as $year=>$months) {
											
											$opendays_html .= '<div class="coderockz-woo-delivery-add-year-html-delivery-opendays coderockz-woo-delivery-form-group">';
											if(array_keys($opendays_years['open_days'])[0] == $year) {
												$opendays_html .= '<img class="coderockz-arrow" src="'. CODEROCKZ_WOO_DELIVERY_URL .'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';	

											} else {
												$opendays_html .= '<button class="coderockz-delivery-opendays-year-remove"><span class="dashicons dashicons-trash"></span></button>';
											}
											
											$opendays_html .= '<input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_delivery_opendays_year" maxlength="4" type="text" value="'.$year.'" placeholder="'.__('Year (ex. 2019)', 'coderockz-woo-delivery').'" style="vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_delivery_opendays_year_'.$year.'">';
											$opendays_html .= '<div style="display:inline-block;" class="coderockz_woo_delivery_delivery_opendays_another_month coderockz_woo_delivery_delivery_opendays_another_month_'.$year.'">';
											foreach($months as $month=>$date) {
												$opendays_html .= '<div class="coderockz_woo_delivery_delivery_opendays_add_another_month">';
												$opendays_html .= '<select style="width:125px!important" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_delivery_opendays_month_'.$year.'[]">';
												$opendays_html .= '<option value="">'.__('Select Month', 'coderockz-woo-delivery').'</option>';
												foreach($month_array as $single_month => $single_month_name) {
													$single_month == $month ? $selected = "selected" : $selected = "";
													$opendays_html .= '<option value="'.$single_month.'"'.$selected.'>'.ucfirst($single_month_name).'</option>';
												}
												$opendays_html .= '</select>';
												$opendays_html .= '<input id="coderockz_woo_delivery_delivery_opendays_dates" type="text" class="coderockz-woo-delivery-input-field" value="'.$date.'" placeholder="'.__('Comma(,) Separated Date', 'coderockz-woo-delivery').'" style="width:200px;vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_delivery_opendays_dates_'.$month.'_'.$year.'">';
												if(array_keys($months)[0] != $month) {
													
													$opendays_html .= '<button class="coderockz-delivery-opendays-month-remove"><span class="dashicons dashicons-trash"></span></button>';
												}
												$opendays_html .= '</div>';
											}
											$opendays_html .= '</div>';
											$opendays_html .= '<br>
												    	  <span style="position:relative;left:18%">
														    <input class="coderockz-woo-delivery-add-month-btn-delivery-opendays" type="button" value="'.__('Add Month', 'coderockz-woo-delivery').'">
														    <div class="coderockz-woo-delivery-dummy-btn-delivery-opendays" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
														  </span>';
											
											$opendays_html .= '</div>';
										}
										echo $opendays_html;
									} else {
	                        	?>

							    <div class="coderockz-woo-delivery-add-year-html-delivery-opendays coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							        <input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_delivery_opendays_year" maxlength="4" type="text" value="<?php  ?>" placeholder="<?php _e('Year (ex. 2019)', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off"/>
							        <div class="coderockz_woo_delivery_delivery_opendays_another_month" style="display:inline-block;">
								        <div class="coderockz_woo_delivery_delivery_opendays_add_another_month">
									        <select style="width:125px!important" class="coderockz-woo-delivery-select-field" disabled="disabled">
									        	<option value=""><?php _e('Select Month', 'coderockz-woo-delivery'); ?></option>
									        	<?php
									        	$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									        	foreach($month_array as $single_month => $single_month_name) {
													echo '<option value="'.$single_month.'">'.ucfirst($single_month_name).'</option>';
												}
									        	?>
									            
										    </select>
									        <input style="width:200px" id="coderockz_woo_delivery_delivery_opendays_dates" type="text" class="coderockz-woo-delivery-input-field" value="<?php  ?>" placeholder="<?php _e('Comma(,) Separated Date', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off" disabled="disabled"/>
								    	</div>
							    	</div>
							    	<br/>
							    	<span style="position:relative;left:18%">
									  <input class="coderockz-woo-delivery-add-month-btn-delivery-opendays" type="button" value="<?php _e('Add Month', 'coderockz-woo-delivery'); ?>" disabled="disabled">
									  <div class="coderockz-woo-delivery-dummy-btn-delivery-opendays" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
									</span>


							    </div>
								<?php } ?>
							</div>

							<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_overall_off_before_delivery" style="text-align:left;width:255px;"><?php _e('Disable Special Open Days Before', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable a special open day before X days, mention the X number of days here. Default is 0 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_overall_off_before_delivery" name="coderockz_woo_delivery_overall_off_before_delivery" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($date_settings['overall_off_before']) && $date_settings['overall_off_before'] != "") ? $date_settings['overall_off_before'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
                    		</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_date_delivery_opendays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Special Open Days For Pickup', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-date-tab-pickup-opendays-notice"></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' If you want to enable a date that will  disable in future as a reason of weekends, zone wise offdays, state wise offdays or zip wise offdays, then specifiy the date here.', 'coderockz-woo-delivery'); ?></p>
						<input class="coderockz-woo-delivery-add-year-btn-pickup-opendays" type="button" value="<?php _e('Add New Year', 'coderockz-woo-delivery'); ?>">
	                    <form action="" method="post" id ="coderockz_delivery_date_pickup_opendays_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div id="coderockz-woo-delivery-pickup-opendays" class="coderockz-woo-delivery-pickup-opendays">
							    
	                        	<?php
	                        		$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									$opendays_html = "";
									$opendays_years = $pickup_date_settings;
									if(isset($opendays_years['open_days']) && !empty($opendays_years['open_days'])) {
										foreach($opendays_years['open_days'] as $year=>$months) {
											
											$opendays_html .= '<div class="coderockz-woo-delivery-add-year-html-pickup-opendays coderockz-woo-delivery-form-group">';
											if(array_keys($opendays_years['open_days'])[0] == $year) {
												$opendays_html .= '<img class="coderockz-arrow" src="'. CODEROCKZ_WOO_DELIVERY_URL .'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';	

											} else {
												$opendays_html .= '<button class="coderockz-pickup-opendays-year-remove"><span class="dashicons dashicons-trash"></span></button>';
											}
											
											$opendays_html .= '<input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_pickup_opendays_year" maxlength="4" type="text" value="'.$year.'" placeholder="'.__('Year (ex. 2019)', 'coderockz-woo-delivery').'" style="vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_pickup_opendays_year_'.$year.'">';
											$opendays_html .= '<div style="display:inline-block;" class="coderockz_woo_delivery_pickup_opendays_another_month coderockz_woo_delivery_pickup_opendays_another_month_'.$year.'">';
											foreach($months as $month=>$date) {
												$opendays_html .= '<div class="coderockz_woo_delivery_pickup_opendays_add_another_month">';
												$opendays_html .= '<select style="width:125px!important" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_pickup_opendays_month_'.$year.'[]">';
												$opendays_html .= '<option value="">'.__('Select Month', 'coderockz-woo-delivery').'</option>';
												foreach($month_array as $single_month => $single_month_name) {
													$single_month == $month ? $selected = "selected" : $selected = "";
													$opendays_html .= '<option value="'.$single_month.'"'.$selected.'>'.ucfirst($single_month_name).'</option>';
												}
												$opendays_html .= '</select>';
												$opendays_html .= '<input id="coderockz_woo_delivery_pickup_opendays_dates" type="text" class="coderockz-woo-delivery-input-field" value="'.$date.'" placeholder="'.__('Comma(,) Separated Date', 'coderockz-woo-delivery').'" style="width:200px;vertical-align:top;" autocomplete="off" name="coderockz_woo_delivery_pickup_opendays_dates_'.$month.'_'.$year.'">';
												if(array_keys($months)[0] != $month) {
													
													$opendays_html .= '<button class="coderockz-pickup-opendays-month-remove"><span class="dashicons dashicons-trash"></span></button>';
												}
												$opendays_html .= '</div>';
											}
											$opendays_html .= '</div>';
											$opendays_html .= '<br>
												    	  <span style="position:relative;left:18%">
														    <input class="coderockz-woo-delivery-add-month-btn-pickup-opendays" type="button" value="'.__('Add Month', 'coderockz-woo-delivery').'">
														    <div class="coderockz-woo-delivery-dummy-btn-pickup-opendays" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
														  </span>';
											
											$opendays_html .= '</div>';
										}
										echo $opendays_html;
									} else {
	                        	?>

							    <div class="coderockz-woo-delivery-add-year-html-pickup-opendays coderockz-woo-delivery-form-group">
							    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							        <input style="width:125px" class="coderockz-woo-delivery-input-field coderockz_woo_delivery_pickup_opendays_year" maxlength="4" type="text" value="<?php  ?>" placeholder="<?php _e('Year (ex. 2019)', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off"/>
							        <div class="coderockz_woo_delivery_pickup_opendays_another_month" style="display:inline-block;">
								        <div class="coderockz_woo_delivery_pickup_opendays_add_another_month">
									        <select style="width:125px!important" class="coderockz-woo-delivery-select-field" disabled="disabled">
									        	<option value=""><?php _e('Select Month', 'coderockz-woo-delivery'); ?></option>
									        	<?php
									        	$month_array = array("january"=>__("january",'coderockz-woo-delivery'), "february"=>__("february",'coderockz-woo-delivery'), "march"=>__("march",'coderockz-woo-delivery'), "april"=>__("april",'coderockz-woo-delivery'), "may"=>__("may",'coderockz-woo-delivery'), "june"=>__("june",'coderockz-woo-delivery'), "july"=>__("july",'coderockz-woo-delivery'), "august"=>__("august",'coderockz-woo-delivery'), "september"=>__("september",'coderockz-woo-delivery'), "october"=>__("october",'coderockz-woo-delivery'), "november"=>__("november",'coderockz-woo-delivery'), "december"=>__("december",'coderockz-woo-delivery'));
									        	foreach($month_array as $single_month => $single_month_name) {
													echo '<option value="'.$single_month.'">'.ucfirst($single_month_name).'</option>';
												}
									        	?>
									            
										    </select>
									        <input style="width:200px" id="coderockz_woo_delivery_pickup_opendays_dates" type="text" class="coderockz-woo-delivery-input-field" value="<?php  ?>" placeholder="<?php _e('Comma(,) Separated Date', 'coderockz-woo-delivery'); ?>" style="vertical-align:top;" autocomplete="off" disabled="disabled"/>
								    	</div>
							    	</div>
							    	<br/>
							    	<span style="position:relative;left:18%">
									  <input class="coderockz-woo-delivery-add-month-btn-pickup-opendays" type="button" value="<?php _e('Add Month', 'coderockz-woo-delivery'); ?>" disabled="disabled">
									  <div class="coderockz-woo-delivery-dummy-btn-pickup-opendays" style="position:absolute; left:0; right:0; top:0; bottom:0; cursor: pointer;"></div>
									</span>


							    </div>
								<?php } ?>
							</div>
							<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_overall_off_before_pickup" style="text-align:left;width:255px;"><?php _e('Disable Special Open Days Before', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable a special open day before X days, mention the X number of days here. Default is 0 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_overall_off_before_pickup" name="coderockz_woo_delivery_overall_off_before_pickup" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_date_settings['overall_off_before']) && $pickup_date_settings['overall_off_before'] != "") ? $pickup_date_settings['overall_off_before'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
                    		</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_date_pickup_opendays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Special Open Days for Delivery', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-open-days-notice"></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_category_open_days_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:unset!important;"><?php _e('Disable All the Special Dates if Cart Has Special Category Product + Regular Product', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If cart has regular category product along with special open days category, the special open days are available to select. If you want to disable all the dates, enable this option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_disable_opendays_regular_product">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_opendays_regular_product" id="coderockz_woo_delivery_disable_opendays_regular_product" <?php echo (isset($open_date_settings['disable_opendays_regular_product']) && !empty($open_date_settings['disable_opendays_regular_product'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-category-opendays">

	                        <?php
	                        $category_open_days_html = "";
							if(isset($open_date_settings['category_open_days']) && !empty($open_date_settings['category_open_days'])) {
								foreach($open_date_settings['category_open_days'] as $category => $openday_date) {
									
									$off_before = isset($openday_date['off_before']) && $openday_date['off_before'] != "" ? $openday_date['off_before'] : 0;
									$openday_date = $openday_date['specific_date_open_string'];
									if($off_before == 0) {
										$off_before = "";
									}
								 

									$category_open_days_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_open_days_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_open_days_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_open_days_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_open_days_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_open_days_html .= '</select>';
									$category_open_days_html .= '<input type="text" class="coderockz-woo-delivery-input-field" name="coderockz-woo-delivery-open-days-date-'.str_replace(" ","c-w-d",$category).'" value="'.$openday_date.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';

									$category_open_days_html .= '<input type="number" class="coderockz-woo-delivery-number-field" name="coderockz-woo-delivery-open-days-date-off-before-'.str_replace(" ","c-w-d",$category).'" value="'.$off_before.'" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:middle;width: 110px!important;" autocomplete="off" placeholder="'.__('Off Before', 'coderockz-woo-delivery').'"/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									
									if(array_keys($open_date_settings['category_open_days'])[0] != $category){
										$category_open_days_html .= '<button class="coderockz-woo-delivery-category-opendays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
							        $category_open_days_html .= '</div>';
								}
								echo $category_open_days_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-category-opendays-single">
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_open_days_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
								    <input type="text" class="coderockz-woo-delivery-input-field coderockz-woo-delivery-add-opendays-category-date" value="" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" disabled="disabled"/>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:middle;width: 110px!important;" autocomplete="off" placeholder="<?php _e('Off Before', 'coderockz-woo-delivery'); ?>" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-opendays-category-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_open_days_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Special Open Days for Pickup', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-open-days-pickup-notice"></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_category_open_days_pickup_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:unset!important;"><?php _e('Disable All the Special Dates if Cart Has Special Category Product + Regular Product', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If cart has regular category product along with special open days category, the special open days are available to select. If you want to disable all the dates, enable this option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_disable_opendays_pickup_regular_product">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_opendays_pickup_regular_product" id="coderockz_woo_delivery_disable_opendays_pickup_regular_product" <?php echo (isset($open_date_settings['disable_opendays_pickup_regular_product']) && !empty($open_date_settings['disable_opendays_pickup_regular_product'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-category-opendays-pickup">

	                        <?php
	                        $category_open_days_pickup_html = "";
							if(isset($open_date_settings['category_open_days_pickup']) && !empty($open_date_settings['category_open_days_pickup'])) {
								foreach($open_date_settings['category_open_days_pickup'] as $category => $openday_date) {

									$off_before = isset($openday_date['off_before']) && $openday_date['off_before'] != "" ? $openday_date['off_before'] : 0;
									$openday_date = $openday_date['specific_date_open_string'];
									if($off_before == 0) {
										$off_before = "";
									}

									$category_open_days_pickup_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_open_days_pickup_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_open_days_pickup_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_open_days_pickup_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_open_days_pickup_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_open_days_pickup_html .= '</select>';
									$category_open_days_pickup_html .= '<input type="text" class="coderockz-woo-delivery-input-field" name="coderockz-woo-delivery-open-days-pickup-date-'.str_replace(" ","c-w-d",$category).'" value="'.$openday_date.'" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="'.__('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery').'"/>';
									$category_open_days_pickup_html .= '<input type="number" class="coderockz-woo-delivery-number-field" name="coderockz-woo-delivery-open-days-pickup-date-off-before-'.str_replace(" ","c-w-d",$category).'" value="'.$off_before.'" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:middle;width: 110px!important;" autocomplete="off" placeholder="'.__('Off Before', 'coderockz-woo-delivery').'"/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									
									if(array_keys($open_date_settings['category_open_days_pickup'])[0] != $category){
										$category_open_days_pickup_html .= '<button class="coderockz-woo-delivery-category-opendays-pickup-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
							        $category_open_days_pickup_html .= '</div>';
								}
								echo $category_open_days_pickup_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-category-opendays-pickup-single">
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_open_days_pickup_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
								    <input type="text" class="coderockz-woo-delivery-input-field coderockz-woo-delivery-add-opendays-pickup-category-date" value="" style="vertical-align:top;width: 430px!important;" autocomplete="off" placeholder="<?php _e('Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)', 'coderockz-woo-delivery'); ?>" disabled="disabled"/>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:middle;width: 110px!important;" autocomplete="off" placeholder="<?php _e('Off Before', 'coderockz-woo-delivery'); ?>" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-opendays-pickup-category-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_open_days_pickup_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                
			</div>
			<div data-tab="tab11" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Tips Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-tips-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>	
						<form action="" method="post" id ="coderockz_woo_delivery_tips_settings_submit">
							<?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
		                    <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Delivery Tips Field', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to give customer the opportunity to give a tip amount for the delivery boy. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_delivery_tips">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_delivery_tips" id="coderockz_woo_delivery_enable_delivery_tips" <?php echo (isset($delivery_tips_settings['enable_delivery_tips']) && !empty($delivery_tips_settings['enable_delivery_tips'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Delivery Tips Field Required', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to force customer give a delivery tips. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_delivery_tips_required">
							       <input type="checkbox" name="coderockz_woo_delivery_delivery_tips_required" id="coderockz_woo_delivery_delivery_tips_required" <?php echo (isset($delivery_tips_settings['delivery_tips_required']) && !empty($delivery_tips_settings['delivery_tips_required'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Delivery Tips Field Label', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Tips to Delivery Person.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        <input type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_tips_field_label" value="<?php echo isset($delivery_tips_settings['delivery_tips_field_label']) && $delivery_tips_settings['delivery_tips_field_label'] != "" ? $delivery_tips_settings['delivery_tips_field_label'] : ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Change Delivery Tips Input Field to Dropdown Field', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to give customer some limited option to choose. Default is a input field where customer can put any amount.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_delivery_tips_dropdown" class="coderockz_woo_delivery_enable_delivery_tips_dropdown" <?php echo (isset($delivery_tips_settings['enable_delivery_tips_dropdown']) && !empty($delivery_tips_settings['enable_delivery_tips_dropdown'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz_woo_delivery_tips_dropdown_section">
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Delivery Tips Values for Dropdown', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Comma separarted values. Only fixed numerical value or percentage value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                        <input type="text" class="coderockz-woo-delivery-input-field" name="coderockz_woo_delivery_tips_dropdown_value" value="<?php echo (isset($delivery_tips_settings['delivery_tips_dropdown_value']) && !empty($delivery_tips_settings['delivery_tips_dropdown_value'])) ? implode(',', $delivery_tips_settings['delivery_tips_dropdown_value']) : ""; ?>" placeholder="Comma separarted values. Ex. 2%,5,10,5%" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_tips_precentage_rounding"><?php _e('Delivery Tips Percentage Rounding', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is no rounding. Round up setting will transform $10.55 to $11.00 and Round down will transform $10.55 to $10.00.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_delivery_tips_precentage_rounding">
	                    			<option value="no_round" <?php if(isset($delivery_tips_settings['precentage_rounding']) && $delivery_tips_settings['precentage_rounding'] == "no_round"){ echo "selected"; } ?>>No Rounding</option>
	                    			<option value="up" <?php if(isset($delivery_tips_settings['precentage_rounding']) && $delivery_tips_settings['precentage_rounding'] == "up"){ echo "selected"; } ?>>Round Up</option>
									<option value="down" <?php if(isset($delivery_tips_settings['precentage_rounding']) && $delivery_tips_settings['precentage_rounding'] == "down"){ echo "selected"; } ?>>Round Down</option>			
								</select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Input Field Option to Dropdown', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to give customer a input field option in the dropdown where customer can put any amount.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_input_field_dropdown" class="coderockz_woo_delivery_enable_input_field_dropdown" <?php echo (isset($delivery_tips_settings['enable_input_field_dropdown']) && !empty($delivery_tips_settings['enable_input_field_dropdown'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Percentage Calculation for Order Total Including Discount', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the cart amount including discount for delivery tips percantage calculation. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_tips_percentage_calculate_discount">
							       <input type="checkbox" name="coderockz_woo_delivery_tips_percentage_calculate_discount" id="coderockz_woo_delivery_tips_percentage_calculate_discount" <?php echo (isset($delivery_tips_settings['percentage_calculating_include_discount']) && !empty($delivery_tips_settings['percentage_calculating_include_discount'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Percentage Calculation for Order Total Including Tax', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the cart amount including tax for delivery tips percantage calculation. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_tips_percentage_calculate_tax">
							       <input type="checkbox" name="coderockz_woo_delivery_tips_percentage_calculate_tax" id="coderockz_woo_delivery_tips_percentage_calculate_tax" <?php echo (isset($delivery_tips_settings['percentage_calculating_include_tax']) && !empty($delivery_tips_settings['percentage_calculating_include_tax'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Percentage Calculation for Order Total Including Shipping Cost', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the cart amount including shipping cost for delivery tips percantage calculation. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_tips_percentage_calculate_shipping">
							       <input type="checkbox" name="coderockz_woo_delivery_tips_percentage_calculate_shipping" id="coderockz_woo_delivery_tips_percentage_calculate_shipping" <?php echo (isset($delivery_tips_settings['percentage_calculating_include_shipping_cost']) && !empty($delivery_tips_settings['percentage_calculating_include_shipping_cost'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Percentage Calculation for Order Total Including All Fees', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the cart amount including all fees for delivery tips percantage calculation. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_tips_percentage_fees">
							       <input type="checkbox" name="coderockz_woo_delivery_tips_percentage_fees" id="coderockz_woo_delivery_tips_percentage_fees" <?php echo (isset($delivery_tips_settings['percentage_calculating_include_fees']) && !empty($delivery_tips_settings['percentage_calculating_include_fees'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Tax for Delivery Tips', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add tax for the delivery tips fee, enable it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_tips_add_tax">
							       <input type="checkbox" name="coderockz_woo_delivery_tips_add_tax" id="coderockz_woo_delivery_tips_add_tax" <?php echo (isset($delivery_tips_settings['add_tax']) && !empty($delivery_tips_settings['add_tax'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_tips_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

            </div>
			<div data-tab="tab12" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Store Cutoff/Closing Time For Delivery', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-store-closing-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>

						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('This feature is helpful, if you don\'t want to take an delivery/pickup order after a certain time of the current day.', 'coderockz-woo-delivery'); ?></p>						
						<form action="" method="post" id ="coderockz_woo_delivery_store_closing_settings_submit">
							<?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
		                    <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Store Cutoff/Closing Time for Delivery', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you have an offline shop and you can't take an order after a specific time. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_closing_time">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_closing_time" id="coderockz_woo_delivery_enable_closing_time" <?php echo (isset($time_settings['enable_closing_time']) && !empty($time_settings['enable_closing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php 
                    			$store_closing_hour = "";
            					$store_closing_min = "";
            					$store_closing_format= "am";
            					$enable_closing_time = (isset($time_settings['enable_closing_time']) && !empty($time_settings['enable_closing_time'])) ? $time_settings['enable_closing_time'] : false;
                    			
                    			if(isset($time_settings['store_closing_time']) && $time_settings['store_closing_time'] !='') {
                    				$store_closing_time = (int)$time_settings['store_closing_time'];

                    				if($store_closing_time > 0 && $store_closing_time <= 59) {

                    					$store_closing_hour = "12";
                    					$store_closing_min = sprintf("%02d", $store_closing_time);
                    					$store_closing_format= "am";
                    				} elseif($store_closing_time > 59 && $store_closing_time <= 719) {
										$store_closing_min = sprintf("%02d", (int)$store_closing_time%60);
										$store_closing_hour = sprintf("%02d", ((int)$store_closing_time-$store_closing_min)/60);
										$store_closing_format= "am";
										
                    				} elseif($store_closing_time > 719 && $store_closing_time <= 1439) {
										$store_closing_min = sprintf("%02d", (int)$store_closing_time%60);
										$store_closing_hour = sprintf("%02d", ((int)$store_closing_time-$store_closing_min)/60);
										if($store_closing_hour>12) {
											$store_closing_hour = sprintf("%02d", $store_closing_hour-12);
										}
										$store_closing_format= "pm";
                    				} elseif($store_closing_time === 0) {
										$store_closing_min = "00";
										$store_closing_hour = "12";
										$store_closing_format= "am";
                    				}

                    			}
                    		?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_closing_time"><?php _e('Store Cutoff/Closing Time for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to get an order after a specific time in the same day, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_closing_time" class="coderockz_woo_delivery_closing_time">
	                    			
	                        	<input name="coderockz_woo_delivery_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $store_closing_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_woo_delivery_closing_time_min" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $store_closing_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_closing_time_format">
									<option value="am" <?php selected($store_closing_format,"am",true); ?>>AM</option>
									<option value="pm" <?php selected($store_closing_format,"pm",true); ?>>PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time"><?php _e('Additional Days to Close After Store Closing Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain days after store closed, give the number of days here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 248px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time" name="coderockz_woo_delivery_extend_closing_time" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($time_settings['extended_closing_days']) && !empty($time_settings['extended_closing_days'])) ? $time_settings['extended_closing_days'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time_hour"><?php _e(' Additional Times to Close After Store Closing Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain times after store closed, give the minutes here. This minutes are count from the next day's first minutes.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 229px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time_hour" name="coderockz_woo_delivery_extend_closing_time_hour" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($time_settings['extended_closing_time']) && !empty($time_settings['extended_closing_time'])) ? $time_settings['extended_closing_time'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_store_closing_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Store Cutoff/Closing Time For Pickup', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-store-closing-notice-pickup"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>

						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('This feature is helpful, if you don\'t want to take an pickup order after a certain time of the current day.', 'coderockz-woo-delivery'); ?></p>						
						<form action="" method="post" id ="coderockz_woo_delivery_store_closing_pickup_settings_submit">
							<?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
		                    <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Store Cutoff/Closing Time for Pickup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you have an offline shop and you can't take an order as pickup after a specific time. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_closing_time_pickup">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_closing_time_pickup" id="coderockz_woo_delivery_enable_closing_time_pickup" <?php echo (isset($pickup_time_settings['enable_closing_time']) && !empty($pickup_time_settings['enable_closing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php 
                    			$store_closing_hour_pickup = "";
            					$store_closing_min_pickup = "";
            					$store_closing_format_pickup= "am";
            					$enable_closing_time = (isset($pickup_time_settings['enable_closing_time']) && !empty($pickup_time_settings['enable_closing_time'])) ? $pickup_time_settings['enable_closing_time'] : false;
                    			
                    			if(isset($pickup_time_settings['store_closing_time']) && $pickup_time_settings['store_closing_time'] !='') {
                    				$store_closing_time_pickup = (int)$pickup_time_settings['store_closing_time'];

                    				if($store_closing_time_pickup > 0 && $store_closing_time_pickup <= 59) {

                    					$store_closing_hour_pickup = "12";
                    					$store_closing_min_pickup = sprintf("%02d", $store_closing_time_pickup);
                    					$store_closing_format_pickup= "am";
                    				} elseif($store_closing_time_pickup > 59 && $store_closing_time_pickup <= 719) {
										$store_closing_min_pickup = sprintf("%02d", (int)$store_closing_time_pickup%60);
										$store_closing_hour_pickup = sprintf("%02d", ((int)$store_closing_time_pickup-$store_closing_min_pickup)/60);
										$store_closing_format_pickup= "am";
										
                    				} elseif($store_closing_time_pickup > 719 && $store_closing_time_pickup <= 1439) {
										$store_closing_min_pickup = sprintf("%02d", (int)$store_closing_time_pickup%60);
										$store_closing_hour_pickup = sprintf("%02d", ((int)$store_closing_time_pickup-$store_closing_min_pickup)/60);
										if($store_closing_hour_pickup>12) {
											$store_closing_hour_pickup = sprintf("%02d", $store_closing_hour_pickup-12);
										}
										$store_closing_format_pickup= "pm";
                    				} elseif($store_closing_time_pickup === 0) {
										$store_closing_min_pickup = "00";
										$store_closing_hour_pickup = "12";
										$store_closing_format_pickup= "am";
                    				}

                    			}
                    		?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_closing_time"><?php _e('Store Cutoff/Closing Time for Pickup', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to get an order after a specific time in the same day, put the time here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_closing_time_pickup" class="coderockz_woo_delivery_closing_time_pickup">
	                    			
	                        	<input name="coderockz_woo_delivery_closing_time_hour_pickup" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $store_closing_hour_pickup; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_woo_delivery_closing_time_min_pickup" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $store_closing_min_pickup; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_closing_time_format_pickup">
									<option value="am" <?php selected($store_closing_format_pickup,"am",true); ?>>AM</option>
									<option value="pm" <?php selected($store_closing_format_pickup,"pm",true); ?>>PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time_pickup"><?php _e('Additional Days to Close After Store Closing Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain days after store closed, give the number of days here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 248px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time_pickup" name="coderockz_woo_delivery_extend_closing_time_pickup" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_time_settings['extended_closing_days']) && !empty($pickup_time_settings['extended_closing_days'])) ? $pickup_time_settings['extended_closing_days'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time_hour_pickup"><?php _e(' Additional Times to Close After Store Closing Day', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain times after store closed, give the minutes here. This minutes are count from the next day's first minutes.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 229px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time_hour_pickup" name="coderockz_woo_delivery_extend_closing_time_hour_pickup" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($pickup_time_settings['extended_closing_time']) && !empty($pickup_time_settings['extended_closing_time'])) ? $pickup_time_settings['extended_closing_time'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_store_closing_pickup_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Weekday Wise Cutoff/Closing Time Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-different-store-closing-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Enable Different Closing Time For Different Day, makes the overall Store Cutoff/Closing Time Functionality disabled', 'coderockz-woo-delivery'); ?></p>
						<form action="" method="post" id ="coderockz_woo_delivery_different_closing_settings_submit">
							<?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
		                    
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:365px!important"><?php _e('Enable Different Closing Time For Different Day', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want different closing or cutoff time for different week day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_different_closing_time">
							       <input type="checkbox" class="coderockz_woo_delivery_enable_different_closing_time" name="coderockz_woo_delivery_enable_different_closing_time" id="coderockz_woo_delivery_enable_different_closing_time" <?php echo (isset($time_settings['enable_different_closing_time']) && !empty($time_settings['enable_different_closing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-different-closing-time-section">
	                    	<?php
	                    	$weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                        foreach ($weekday as $key => $value) {

	                        	if(isset($time_settings['different_extended_closing_day'][$key]) && $time_settings['different_extended_closing_day'][$key] != "") {
                    					$different_extended_closing_day_[$key] = $time_settings['different_extended_closing_day'][$key];
                    			}

                    			if(isset($time_settings['different_extended_closing_time'][$key]) && $time_settings['different_extended_closing_time'][$key] != "") {
                    					$different_extended_closing_time_[$key] = $time_settings['different_extended_closing_time'][$key];
                    			}

                    			$store_closing_hour_[$key] = "";
	            				$store_closing_min_[$key] = "";
	            				$store_closing_format_[$key]= "am";

                    			if(isset($time_settings['different_store_closing_time'][$key])) {
                    				
	                				$store_closing_time_[$key] = (int)$time_settings['different_store_closing_time'][$key];

	                				if($store_closing_time_[$key] > 0 && $store_closing_time_[$key] <= 59) {

	                					$store_closing_hour_[$key] = "12";
	                					$store_closing_min_[$key] = sprintf("%02d", $store_closing_time_[$key]);
	                					$store_closing_format_[$key]= "am";
	                				} elseif($store_closing_time_[$key] > 59 && $store_closing_time_[$key] <= 719) {
										$store_closing_min_[$key] = sprintf("%02d", (int)$store_closing_time_[$key]%60);
										$store_closing_hour_[$key] = sprintf("%02d", ((int)$store_closing_time_[$key]-$store_closing_min_[$key])/60);
										$store_closing_format_[$key]= "am";
										
	                				} elseif($store_closing_time_[$key] > 719 && $store_closing_time_[$key] <= 1439) {
										$store_closing_min_[$key] = sprintf("%02d", (int)$store_closing_time_[$key]%60);
										$store_closing_hour_[$key] = sprintf("%02d", ((int)$store_closing_time_[$key]-$store_closing_min_[$key])/60);
										if($store_closing_hour_[$key]>12) {
											$store_closing_hour_[$key] = sprintf("%02d", $store_closing_hour_[$key]-12);
										}
										$store_closing_format_[$key]= "pm";
	                				} elseif($store_closing_time_[$key] === 0) {
										$store_closing_min_[$key] = "00";
										$store_closing_hour_[$key] = "12";
										$store_closing_format_[$key]= "am";
	                				}

                				}

                				

                				?>
                				<div class="coderockz-woo-delivery-different-closing">
	                			<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_closing_time_<?php echo $key; ?>"><?php echo $value; ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                    		<div id="coderockz_woo_delivery_closing_time_<?php echo $key; ?>" class="coderockz_woo_delivery_closing_time_<?php echo $key; ?>" style="width: 300px!important;display: inline-flex!important;">
		                    			
		                        	<input style="width: 33.33%!important;" name="coderockz_woo_delivery_closing_time_hour_<?php echo $key; ?>" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $store_closing_hour_[$key]; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
		                        	<input style="width: 33.33%!important;" name="coderockz_woo_delivery_closing_time_min_<?php echo $key; ?>" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $store_closing_min_[$key]; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
		                        	<select style="width: 33.33%!important;" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_closing_time_format_<?php echo $key; ?>">
										<option value="am" <?php selected($store_closing_format_[$key],"am",true); ?>>AM</option>
										<option value="pm" <?php selected($store_closing_format_[$key],"pm",true); ?>>PM</option>
									</select>
		                        	</div>
		                    	</div>


		                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time_<?php echo $key; ?>"><?php _e(' Additional Days to Close After Store Closing Day', 'coderockz-woo-delivery'); ?> (<?php echo $value?>)</label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain days after store closed, give the number of days here. This days are count from the next day.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 248px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time_<?php echo $key; ?>" name="coderockz_woo_delivery_extend_closing_time_<?php echo $key; ?>" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($different_extended_closing_day_[$key]) && !empty($different_extended_closing_day_[$key])) ? $different_extended_closing_day_[$key] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    		</div>



	                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_extend_closing_time_hour_<?php echo $key; ?>"><?php _e(' Additional Times to Close After Store Closing Day', 'coderockz-woo-delivery'); ?> (<?php echo $value?>)</label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Need to extend the closing time of your store? If you don't want to take order for certain times after store closed, give the minutes here. This minutes are count from the next day's first minutes.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 229px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_extend_closing_time_hour_<?php echo $key; ?>" name="coderockz_woo_delivery_extend_closing_time_hour_<?php echo $key; ?>" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($different_extended_closing_time_[$key]) && !empty($different_extended_closing_time_[$key])) ? $different_extended_closing_time_[$key] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></span>
	                    		</div>


		                    	</div>

                				<?php
	                        }
	                        ?>
	                    	</div>
	                    	
	                    	<input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_different_closing_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Cutoff Time', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-cutoff-notice"></p>
						
				        <form action="" method="post" id ="coderockz_category_cutoff_form_submit">
				            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
				            <div class="coderockz-woo-delivery-form-group">
				            	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Disable Category Wise Cutoff if Cart Has Regular Category Product', 'coderockz-woo-delivery'); ?></span>
				            	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If cart has regular category product along with cutoff category, the current date/today isn't available to select. If you want to enable current date/today in this scenario, enable this option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_disable_category_wise_cutoff_regular_category">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_category_wise_cutoff_regular_category" id="coderockz_woo_delivery_disable_category_wise_cutoff_regular_category" <?php echo (isset($time_settings['disable_category_wise_cutoff_regular_category']) && !empty($time_settings['disable_category_wise_cutoff_regular_category'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
				        	</div>


				        	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_consider_multiple_cutoff_category_condition"><?php _e('Cutoff Time Consider if Cart has Multiple Cutoff Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If cart has multiple cutoff categories product exists, then which cutoff time it takes to disable the current date/today. Default taking the earliest one.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_consider_multiple_cutoff_category_condition" style="width:200px!important;">
	                    			<option value="first" <?php if(isset($time_settings['consider_multiple_cutoff_category_condition']) && $time_settings['consider_multiple_cutoff_category_condition'] == "first"){ echo "selected"; } ?>><?php _e('The earliest cutoff time','coderockz-woo-delivery'); ?></option>
									<option value="last" <?php if(isset($time_settings['consider_multiple_cutoff_category_condition']) && $time_settings['consider_multiple_cutoff_category_condition'] == "last"){ echo "selected"; } ?>><?php _e('The last cutoff time','coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>




				            <div class="coderockz-woo-delivery-category-wise-cutoff">

				            <?php
				            $time_format = ['am' => "AM", 'pm' => "PM"];
							if(isset($time_settings['category_wise_cutoff']) && !empty($time_settings['category_wise_cutoff'])) {
								$category_cutoff_html = "";
								foreach($time_settings['category_wise_cutoff'] as $category => $cutoff) {

									$cutoff = (int)$cutoff;
									$category_cutoff_hour = "";
									$category_cutoff_min = "";
									$category_cutoff_format= "am";


									if($cutoff > 0 && $cutoff <= 59) {

				    					$category_cutoff_hour = "12";
				    					$category_cutoff_min = sprintf("%02d", $cutoff);
				    					$category_cutoff_format= "am";
				    				} elseif($cutoff > 59 && $cutoff <= 719) {
										$category_cutoff_min = sprintf("%02d", (int)$cutoff%60);
										$category_cutoff_hour = sprintf("%02d", ((int)$cutoff-$category_cutoff_min)/60);
										$category_cutoff_format= "am";
										
				    				} elseif($cutoff > 719 && $cutoff <= 1439) {
										$category_cutoff_min = sprintf("%02d", (int)$cutoff%60);
										$category_cutoff_hour = sprintf("%02d", ((int)$cutoff-$category_cutoff_min)/60);
										if($category_cutoff_hour>12) {
											$category_cutoff_hour = sprintf("%02d", $category_cutoff_hour-12);
										}
										$category_cutoff_format= "pm";
				    				} elseif($cutoff === 0) {
										$category_cutoff_min = "00";
										$category_cutoff_hour = "12";
										$category_cutoff_format= "am";
				    				}


									$category_cutoff_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_cutoff_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_cutoff_html .= '<select style="width:230px!important" class="coderockz-woo-delivery-select-field" name="coderockz_delivery_cutoff_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_cutoff_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_cutoff_html .= '</select>';

									//$category_cutoff_html .= '<div class="coderockz-woo-delivery-form-group">';
						            $category_cutoff_html .= '<div class="coderockz_woo_delivery_category_wise_cutoff_category" style="width: 255px!important;display: inline-flex!important;">';
						                    			
						            $category_cutoff_html .= '<input style="width: 31.33%!important;" name="coderockz_woo_delivery_category_wise_cutoff_hour_'.$category.'" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="'.$category_cutoff_hour.'" placeholder="'.__('Hour', 'coderockz-woo-delivery').'" autocomplete="off"/>';
						            $category_cutoff_html .= '<input style="width: 41.33%!important;" name="coderockz_woo_delivery_category_wise_cutoff_min_'.$category.'" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="'.$category_cutoff_min.'" placeholder="'.__('Minutes', 'coderockz-woo-delivery').'" autocomplete="off"/>';
						            $category_cutoff_html .= '<select style="width: 26.33%!important;" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_category_wise_cutoff_format_'.$category.'">';

						            foreach ($time_format as $key => $value) {
										$selected = $category_cutoff_format == $key ? "selected" : "";
										$category_cutoff_html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
									}

									$category_cutoff_html .= '</select></div>';

									if(array_keys($time_settings['category_wise_cutoff'])[0] != $category){
										$category_cutoff_html .= '<button class="coderockz-woo-delivery-category-wise-cutoff-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $category_cutoff_html .= '</div>';
								}
								echo $category_cutoff_html;
							} else {

				            ?>
				                <div class="coderockz-woo-delivery-form-group">
				                	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select style="width:230px!important" class="coderockz-woo-delivery-select-field" name="coderockz_delivery_cutoff_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
				            		<div class="coderockz_woo_delivery_category_wise_cutoff_category" style="width: 255px!important;display: inline-flex!important;">
				            			
				                	<input style="width: 31.33%!important;" name="coderockz_woo_delivery_category_wise_cutoff_hour_category" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off" disabled="disabled"/>
				                	<input style="width: 41.33%!important;" name="coderockz_woo_delivery_category_wise_cutoff_min_category" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off" disabled="disabled"/>
				                	<select style="width: 26.33%!important;" class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_category_wise_cutoff_format_category" disabled="disabled">
										<option value="am">AM</option>
										<option value="pm">PM</option>
									</select>
				                	</div>
						                    	
				            	</div>
				            <?php } ?>
				        	</div>
				        	<button class="coderockz-woo-delivery-add-category-wise-cutoff-btn"><span class="dashicons dashicons-plus"></span></button>
				            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_cutoff_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
				        </form>
					</div>

				</div>


            </div>
			<div data-tab="tab13" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Overall Processing Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-overall-processing-days-notice"></p>
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('In Exclude Individual Product option, if product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
	                    <form action="" method="post" id ="coderockz_overall_processing_days_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_overall_processing_days"><?php _e('Overall Processing Days for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you need delivery processing days for all of your products, put the number of days here. Default is 0 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_overall_processing_days" name="coderockz_delivery_overall_processing_days" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($processing_days_settings['overall_processing_days']) && !empty($processing_days_settings['overall_processing_days'])) ? $processing_days_settings['overall_processing_days'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_overall_processing_days_pickup"><?php _e('Overall Processing Days for Pickup', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you need processing days for all of your products, put the number of days here. Default is 0 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_overall_processing_days_pickup" name="coderockz_delivery_overall_processing_days_pickup" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($processing_days_settings['overall_processing_days_pickup']) && !empty($processing_days_settings['overall_processing_days_pickup'])) ? $processing_days_settings['overall_processing_days_pickup'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_backorder_processing_days"><?php _e('Processing Days If Cart Has Backorder Products', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you need processing days when cart contains a backorder product, put the number of days here. Default is 0 days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_backorder_processing_days" name="coderockz_delivery_backorder_processing_days" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($processing_days_settings['backorder_processing_days']) && !empty($processing_days_settings['backorder_processing_days'])) ? $processing_days_settings['backorder_processing_days'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Categories from Overall Processing Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product categories for which you don't want the processing days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_categories_processing_days" name="coderockz_woo_delivery_exclude_categories_processing_days[]" class="coderockz_woo_delivery_exclude_categories_processing_days" multiple>
                                
                                <?php
                                $exclude_categories_processing_days = [];
								if(isset($processing_days_settings['exclude_categories']) && !empty($processing_days_settings['exclude_categories'])) {
									foreach ($processing_days_settings['exclude_categories'] as $hide_cat) {
										$exclude_categories_processing_days[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($processing_days_settings['exclude_categories']) && !empty($processing_days_settings['exclude_categories']) && in_array(htmlspecialchars_decode($cat->name),$exclude_categories_processing_days) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Product from Overall Processing Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want the processing days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_product_processing_days" name="coderockz_woo_delivery_exclude_product_processing_days[]" class="coderockz_woo_delivery_exclude_product_processing_days" multiple>
                                
                                <?php
                                
                                foreach ($store_products as $key=>$value) {

                                	$selected = isset($processing_days_settings['exclude_products']) && !empty($processing_days_settings['exclude_products']) && in_array($key,$processing_days_settings['exclude_products']) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Product from Overall Processing Days', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want the processing days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$exclude_products_input_processing_days = isset($processing_days_settings['exclude_products']) && !empty($processing_days_settings['exclude_products']) ? $processing_days_settings['exclude_products'] : array();
	                        	$exclude_products_input_processing_days = implode(",",$exclude_products_input_processing_days);
	                        	?>
	                    		<input id="coderockz_woo_delivery_exclude_product_input_processing_days" name="coderockz_woo_delivery_exclude_product_input_processing_days" type="text" class="coderockz_woo_delivery_exclude_product_input_processing_days coderockz-woo-delivery-input-field" value="<?php echo $exclude_products_input_processing_days; ?>" placeholder="<?php _e('Comma(,) separated Product/Variation ID', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_overall_processing_days_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>
                </div>
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Processing Days Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-processing-days-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_processing_days_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Processing Days calculate including with Off days', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If any offday is in processing days, they are not counting as processing days by default. By enabling this option, offdays are counting as procesing days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_processing_days_off_days">
							       <input type="checkbox" name="coderockz_delivery_date_processing_days_off_days" id="coderockz_delivery_date_processing_days_off_days" <?php echo (isset($processing_days_settings['processing_days_consider_off_days']) && !empty($processing_days_settings['processing_days_consider_off_days'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Processing Days calculate including with weekends', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If any weekend is in processing days, they are not counting as processing days by default. By enabling this option, weekends are counting as procesing days.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_processing_days_weekend_days">
							       <input type="checkbox" name="coderockz_delivery_date_processing_days_weekend_days" id="coderockz_delivery_date_processing_days_weekend_days" <?php echo (isset($processing_days_settings['processing_days_consider_weekends']) && !empty($processing_days_settings['processing_days_consider_weekends'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Processing Days calculate including with Current Day', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you still want to consider current day as processing day then enable it. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_processing_days_current_day">
							       <input type="checkbox" name="coderockz_delivery_date_processing_days_current_day" id="coderockz_delivery_date_processing_days_current_day" <?php echo (isset($processing_days_settings['processing_days_consider_current_day']) && !empty($processing_days_settings['processing_days_consider_current_day'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_processing_days_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Processing Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-processing-days-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_category_processing_days_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Enable Category Wise Processing Days', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable category wise processing days. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_category_wise_processing_days">
							       <input type="checkbox" name="coderockz_woo_delivery_category_wise_processing_days" id="coderockz_woo_delivery_category_wise_processing_days" <?php echo (isset($processing_days_settings['enable_category_wise_processing_days']) && !empty($processing_days_settings['enable_category_wise_processing_days'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-processing-days">

	                        <?php
	                        $category_processing_days_html = "";
							if(isset($processing_days_settings['category_processing_days']) && !empty($processing_days_settings['category_processing_days'])) {
								foreach($processing_days_settings['category_processing_days'] as $category => $days) {
									$category_processing_days_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_processing_days_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_processing_days_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_days_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_processing_days_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_processing_days_html .= '</select>';
									$category_processing_days_html .= '<input type="number" class="coderockz-woo-delivery-number-field" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" name="coderockz-woo-delivery-processing-days-'.str_replace(" ","c-w-d",$category).'" value="'.$days.'" style="vertical-align:top;width: 150px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									if(array_keys($processing_days_settings['category_processing_days'])[0] != $category){
										$category_processing_days_html .= '<button class="coderockz-woo-delivery-processing-days-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $category_processing_days_html .= '</div>';
								}
								echo $category_processing_days_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_days_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-processing-category-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_processing_days_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Product Wise Processing Days', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('One ID per line. If product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-product-processing-days-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_product_processing_days_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Product Wise Processing Days', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable product wise processing days. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_product_wise_processing_days">
							       <input type="checkbox" name="coderockz_woo_delivery_product_wise_processing_days" id="coderockz_woo_delivery_product_wise_processing_days" <?php echo (isset($processing_days_settings['enable_product_wise_processing_days']) && !empty($processing_days_settings['enable_product_wise_processing_days'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Multiply Processing Days By Quantity', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you need to calculate processing day based on product quantity then enable it. For example, if you need 1 day of a burger processing day and if you need 2 days for 2 burgers processing day then enable it. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_product_processing_day_quantity">
							       <input type="checkbox" name="coderockz_woo_delivery_product_processing_day_quantity" id="coderockz_woo_delivery_product_processing_day_quantity" <?php echo (isset($processing_days_settings['enable_product_processing_day_quantity']) && !empty($processing_days_settings['enable_product_processing_day_quantity'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                        <div class="coderockz-woo-delivery-product-processing-days">

	                        <?php
	                        $product_processing_days_html = "";
							if(isset($processing_days_settings['product_processing_days']) && !empty($processing_days_settings['product_processing_days'])) {
								foreach($processing_days_settings['product_processing_days'] as $product => $days) {
									$product_processing_days_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_processing_days_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_processing_days_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_days_products[]">
								    <option value="">'.__('Select Product', 'coderockz-woo-delivery').'</option>';
									foreach ($store_products as $key=>$value) {
										$selected = ($key == $product) ? "selected" : "";
										$product_processing_days_html .= '<option value="'.$key.'"'.$selected.'>'.$value.' (ID: '.$key.')</option>';
									}
									$product_processing_days_html .= '</select>';
									$product_processing_days_html .= '<input type="number" class="coderockz-woo-delivery-number-field" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" name="coderockz-woo-delivery-product-processing-days-'.$product.'" value="'.$days.'" style="vertical-align:top;width: 150px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									if(array_keys($processing_days_settings['product_processing_days'])[0] != $product){
										$product_processing_days_html .= '<button class="coderockz-woo-delivery-product-processing-days-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $product_processing_days_html .= '</div>';
								}
								echo $product_processing_days_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_days_products[]">
								    <option value=""><?php _e('Select Product', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($store_products as $key=>$value) {
										echo '<option value="'.$key.'">'.$value.' (ID: '.$key.')</option>';
									}
									?>
									</select>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<?php } else { ?>

	                    	<div class="coderockz-woo-delivery-product-processing-days">

	                        <?php
	                        $product_processing_days_html = "";
							if(isset($processing_days_settings['product_processing_days']) && !empty($processing_days_settings['product_processing_days'])) {
								foreach($processing_days_settings['product_processing_days'] as $product => $days) {
									$product_processing_days_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_processing_days_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_processing_days_html .= '<input name="coderockz_delivery_processing_days_products_input" type="text" class="coderockz-woo-delivery-input-field" value="'.$product.'" placeholder="Product/Variation ID" autocomplete="off"/>';
									$product_processing_days_html .= '<input type="number" class="coderockz-woo-delivery-number-field" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" name="coderockz-woo-delivery-product-processing-days-'.$product.'" value="'.$days.'" style="vertical-align:top;width: 150px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									if(array_keys($processing_days_settings['product_processing_days'])[0] != $product){
										$product_processing_days_html .= '<button class="coderockz-woo-delivery-product-processing-days-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $product_processing_days_html .= '</div>';
								}
								echo $product_processing_days_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
									<input name="coderockz_delivery_processing_days_products_input" type="text" class="coderockz-woo-delivery-input-field" placeholder="Product/Variation ID" autocomplete="off"/>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<?php } ?>
	                    	<button class="coderockz-woo-delivery-add-processing-product-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_product_processing_days_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
				<p class="coderockz-woo-delivery-card-header"><?php _e('Weekday Wise Processing Days', 'coderockz-woo-delivery'); ?></p>
				<div class="coderockz-woo-delivery-card-body">
					<p class="coderockz-woo-delivery-weekday-wise-processing-days-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
			        <form action="" method="post" id ="coderockz_woo_delivery_weekday_wise_processing_days_form_submit">
			            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
			            <div class="coderockz-woo-delivery-form-group">
			            	<span class="coderockz-woo-delivery-form-label" style="width:365px!important"><?php _e('Enable Weekday Wise Processing Days', 'coderockz-woo-delivery'); ?></span>
			            	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want different processing days for different week day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
						    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_weekday_wise_processing_days">
						       <input type="checkbox" class="coderockz_woo_delivery_enable_weekday_wise_processing_days" name="coderockz_woo_delivery_enable_weekday_wise_processing_days" id="coderockz_woo_delivery_enable_weekday_wise_processing_days" <?php echo (isset($processing_days_settings['enable_weekday_wise_processing_days']) && !empty($processing_days_settings['enable_weekday_wise_processing_days'])) ? "checked" : "" ?>/>
						       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
						    </label>
			        	</div>
			        	<?php
			        	$weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
			            foreach ($weekday as $key => $value) { 

			            	$fee = isset($processing_days_settings['weekday_wise_processing_days'][$key]) && !empty($processing_days_settings['weekday_wise_processing_days'][$key]) ? $processing_days_settings['weekday_wise_processing_days'][$key] : "";
							?>

							<div class="coderockz-woo-delivery-form-group">
			            		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_wise_processing_days_<?php echo $key; ?>"><?php echo $value; ?> <?php _e('Processing Days', 'coderockz-woo-delivery'); ?></label>
			                	<input style="width:100px!important;" id="coderockz_woo_delivery_weekday_wise_processing_days_<?php echo $key; ?>" name="coderockz_woo_delivery_weekday_wise_processing_days_<?php echo $key; ?>" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" class="coderockz-woo-delivery-number-field" value="<?php echo $fee; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php  _e('Days','coderockz-woo-delivery') ?></span>
			            	</div>

							<?php
			            }
			            ?>

			            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_weekday_wise_processing_days_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
			        </form>
				</div>

			</div>
			<div class="coderockz-woo-delivery-card">
				<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping Zone Wise Processing Days', 'coderockz-woo-delivery'); ?></p>
				<div class="coderockz-woo-delivery-card-body">
					<p class="coderockz-woo-delivery-zone-wise-processingdays-notice"></p>
			        <form action="" method="post" id ="coderockz_zone_wise_processingdays_form_submit">
			            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

			            <!-- <div class="coderockz-woo-delivery-zone-wise-offdays"> -->

			            <?php
			            $zone_wise_processingdays_html = "";
			            $i = 1;

						if(isset($processing_days_settings['zone_wise_processing_days']) && !empty($processing_days_settings['zone_wise_processing_days'])) {
							foreach($processing_days_settings['zone_wise_processing_days'] as $zone => $days) {
								$zone_wise_processingdays_html .= '<div class="coderockz-woo-delivery-zone-wise-processingdays">';
								$zone_wise_processingdays_html .= '<div class="coderockz-woo-delivery-form-group">';
						        $zone_wise_processingdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
								$zone_wise_processingdays_html .= '<select style="width: 250px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_processingdays_zone" name="coderockz_delivery_zone_wise_processingdays_zone[]">
							    <option value="">'.__('Select Shipping Zone', 'coderockz-woo-delivery').'</option>';
								foreach ($zone_name as $key => $value) {
									$selected = ($key == $zone) ? "selected" : "";
									$zone_wise_processingdays_html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
								}
								$zone_wise_processingdays_html .= '</select>';

			                    $zone_wise_processingdays_html .= '<input style="width:100px!important;" class="coderockz-woo-delivery-number-field coderockz-delivery-zone-wise-processingdays-zone-day" name="coderockz-delivery-zone-wise-processingdays-zone-day-'.$zone.'" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" value="'.$days.'" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code">'.__('Days','coderockz-woo-delivery').'</span>';
			                    
								if($i!=1){
									$zone_wise_processingdays_html .= '<button class="coderockz-woo-delivery-zone-wise-processingdays-remove"><span class="dashicons dashicons-trash"></span></button>';
								}

								$i = $i+1;
								
						        $zone_wise_processingdays_html .= '</div>';
						        $zone_wise_processingdays_html .= '</div>';
							}

						}


						if($zone_wise_processingdays_html != "") {
							echo $zone_wise_processingdays_html;
						} else {

			            ?>
			                <div class="coderockz-woo-delivery-zone-wise-processingdays">
			                <div class="coderockz-woo-delivery-form-group">
			                	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							    <select style="width: 250px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_processingdays_zone" name="coderockz_delivery_zone_wise_processingdays_zone[]" autocomplete="off">
							    <option value=""><?php _e('Select Shipping Zone', 'coderockz-woo-delivery'); ?></option>
								<?php
			                    foreach ($zone_name as $key => $value) {
			                        echo '<option value="'.$key.'">'.$value.'</option>';
			                    }
			                    ?>
								</select>
								<input style="width:100px!important;" class="coderockz-woo-delivery-number-field coderockz-delivery-zone-wise-processingdays-zone-day" name="coderockz-delivery-zone-wise-processingdays-zone-day" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" value="" placeholder="" autocomplete="off" disabled="disabled"/><span class="coderockz-woo-delivery-currency-code"><?php _e('Days','coderockz-woo-delivery'); ?></span>
			            	</div>
			            	</div>
			            <?php } ?>
			        	
			        	<button class="coderockz-woo-delivery-add-zone-wise-processingdays-btn"><span class="dashicons dashicons-plus"></span></button>
			            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_zone_wise_processingdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
			        </form>
				</div>

			</div>

			<div class="coderockz-woo-delivery-card">
				<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping Method Wise Processing Days', 'coderockz-woo-delivery'); ?></p>
				<div class="coderockz-woo-delivery-card-body">
					<p class="coderockz-woo-delivery-shippingmethod-wise-processingdays-notice"></p>
					
			        <form action="" method="post" id ="coderockz_shippingmethod_wise_processingdays_form_submit">
			            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

			            <?php
			            $shippingmethod_wise_processingdays_html = "";
						$applicable_for = array("delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
						$i = 1;
						foreach ($applicable_for as $applicable_key => $applicable_value) {
							if(isset($processing_days_settings['shippingmethod_wise_processingdays'][$applicable_key]) && !empty($processing_days_settings['shippingmethod_wise_processingdays'][$applicable_key])) {
								foreach($processing_days_settings['shippingmethod_wise_processingdays'][$applicable_key] as $shippingmethod => $days) {
									$shippingmethod_wise_processingdays_html .= '<div class="coderockz-woo-delivery-shippingmethod-wise-processingdays">';
									$shippingmethod_wise_processingdays_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $shippingmethod_wise_processingdays_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$shippingmethod_wise_processingdays_html .= '<select style="width: 200px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod" name="coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod[]">
								    <option value="">'.__('Select Shipping Method', 'coderockz-woo-delivery').'</option>';
									foreach ($shipping_methods_for_offdays as $key => $value) {
										$selected = ($key == $shippingmethod) ? "selected" : "";
										$shippingmethod_wise_processingdays_html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
									}
									$shippingmethod_wise_processingdays_html .= '</select>';


									$shippingmethod_wise_processingdays_html .= '<input type="number" class="coderockz-woo-delivery-number-field coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod_day" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" name="coderockz-delivery-shippingmethod-wise-processingdays-shippingmethod-day-'.$shippingmethod.'-'.$applicable_key.'" value="'.$days.'" style="vertical-align:top;width: 150px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';

							        $shippingmethod_wise_processingdays_html .= '<select style="width: 115px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_processingdays_applicable_for" name="coderockz_delivery_shippingmethod_wise_processingdays_applicable_for_'.$shippingmethod.'_'.$applicable_key.'" autocomplete="off">';
							        
							        foreach ($applicable_for as $key => $value) {
							        	if($key == $applicable_key) {
							            	$shippingmethod_wise_processingdays_html .= '<option value="'.$key.'" selected='.$selected.'>'.$value.'</option>';
							            } else {
							            	$shippingmethod_wise_processingdays_html .= '<option value="'.$key.'">'.$value.'</option>';
							            }		
							        }
									$shippingmethod_wise_processingdays_html .= '</select>';
									if($i!=1){
										$shippingmethod_wise_processingdays_html .= '<button class="coderockz-woo-delivery-shippingmethod-wise-processingdays-remove"><span class="dashicons dashicons-trash"></span></button>';
									}

									$i = $i+1;
									
							        $shippingmethod_wise_processingdays_html .= '</div>';
							        $shippingmethod_wise_processingdays_html .= '</div>';
								}

							}

						}

						if($shippingmethod_wise_processingdays_html != "") {
							echo $shippingmethod_wise_processingdays_html;
						} else {

						?>
						    <div class="coderockz-woo-delivery-shippingmethod-wise-processingdays">
						    <div class="coderockz-woo-delivery-form-group">
						    	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							    <select style="width: 200px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod" name="coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod[]" autocomplete="off">
							    <option value=""><?php _e('Select Shipping Method', 'coderockz-woo-delivery'); ?></option>
								<?php

						        foreach ($shipping_methods_for_offdays as $key => $value) {
						        	echo '<option value="'.$key.'">'.$value.'</option>';
						            
						        }
						        ?>
								</select>


								<input style="width:100px!important;" class="coderockz-woo-delivery-number-field coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod_day" name="coderockz_delivery_shippingmethod_wise_processingdays_shippingmethod_day" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" value="" placeholder="" autocomplete="off" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days','coderockz-woo-delivery'); ?></span>

						        <select style="width: 115px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_shippingmethod_wise_processingdays_applicable_for" name="coderockz_delivery_shippingmethod_wise_processingdays_applicable_for[]" autocomplete="off" disabled = "disabled">
								<?php
						        $applicable_for = array("delivery"=>__("For Delivery",'coderockz-woo-delivery'), "pickup"=>__("For Pickup",'coderockz-woo-delivery'));
						        foreach ($applicable_for as $key => $value) {
						            echo '<option value="'.$key.'">'.$value.'</option>';		
						        }
						        ?>
								</select>
							</div>
							</div>
						<?php } ?>

			        	<button class="coderockz-woo-delivery-add-shippingmethod-wise-processingdays-btn"><span class="dashicons dashicons-plus"></span></button>
			            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_shippingmethod_wise_processingdays_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
			        </form>
				</div>

			</div>

			</div>

			<div data-tab="tab14" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Processing Time Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-processing-time-notice"></p>
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('In Exclude Individual Product option, if product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
	                    <form action="" method="post" id ="coderockz_processing_time_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce');?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:44%!important;text-align:right!important"><?php _e('Disable timeslot range in which the sum of current time & processing time exist', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to disable the timeslot that has the sum of current time & processing time, Disable it. This feature is available when the timeslot is a time range. Default is Enable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_processing_time_disable_timeslot_with_processing_time">
							       <input type="checkbox" name="coderockz_woo_delivery_processing_time_disable_timeslot_with_processing_time" id="coderockz_woo_delivery_processing_time_disable_timeslot_with_processing_time" <?php echo (isset($processing_time_settings['disable_timeslot_with_processing_time']) && !empty($processing_time_settings['disable_timeslot_with_processing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <?php
	                    		$duration = ""; 
	                    		$identity = "min";
                    			if(isset($processing_time_settings['overall_processing_time']) && !empty($processing_time_settings['overall_processing_time'])) {
                    				$overall_processing_time = (int)$processing_time_settings['overall_processing_time'];
                    				if($overall_processing_time <= 59) {
                    					$duration = $overall_processing_time;
                    				} else {
                    					$overall_processing_time = $overall_processing_time/60;
                    					$helper = new Coderockz_Woo_Delivery_Helper();
                    					if($helper->containsDecimal($overall_processing_time)){
                    						$duration = $overall_processing_time*60;
                    						$identity = "min";
                    					} else {
                    						$duration = $overall_processing_time;
                    						$identity = "hour";
                    					}
                    				}
                    			}
                    			$pickup_duration = ""; 
	                    		$pickup_identity = "min";
                    			if(isset($processing_time_settings['overall_processing_time_pickup']) && !empty($processing_time_settings['overall_processing_time_pickup'])) {
                    				$overall_processing_time_pickup = (int)$processing_time_settings['overall_processing_time_pickup'];
                    				if($overall_processing_time_pickup <= 59) {
                    					$pickup_duration = $overall_processing_time_pickup;
                    				} else {
                    					$overall_processing_time_pickup = $overall_processing_time_pickup/60;
                    					$helper = new Coderockz_Woo_Delivery_Helper();
                    					if($helper->containsDecimal($overall_processing_time_pickup)){
                    						$pickup_duration = $overall_processing_time_pickup*60;
                    						$pickup_identity = "min";
                    					} else {
                    						$pickup_duration = $overall_processing_time_pickup;
                    						$pickup_identity = "hour";
                    					}
                    				}
                    			}
	                    	?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_overall_processing_time_duration"><?php _e('Overall Processing Time for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("add the time with current time that is specified here. Only numerical value is accepted. Leave blank for no processing time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_overall_processing_time_duration" class="coderockz_woo_delivery_overall_processing_time_duration">
	                        	<input name="coderockz_woo_delivery_overall_processing_time" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="<?php echo $duration; ?>" placeholder="" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_overall_processing_time_format">
									<option value="min" <?php selected($identity,"min",true); ?>><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
									<option value="hour" <?php selected($identity,"hour",true); ?>><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_overall_processing_time_pickup_duration"><?php _e('Overall Processing Time for Pickup', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("add the time with current time that is specified here. Only numerical value is accepted. Leave blank for no processing time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_woo_delivery_overall_processing_time_pickup_duration" class="coderockz_woo_delivery_overall_processing_time_pickup_duration">
	                        	<input name="coderockz_woo_delivery_overall_processing_time_pickup" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="<?php echo $pickup_duration; ?>" placeholder="" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_overall_processing_time_pickup_format">
									<option value="min" <?php selected($pickup_identity,"min",true); ?>><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
									<option value="hour" <?php selected($pickup_identity,"hour",true); ?>><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
								</select>
	                        	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Categories from Overall Processing Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product categories for which you don't want the processing time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_categories_processing_time" name="coderockz_woo_delivery_exclude_categories_processing_time[]" class="coderockz_woo_delivery_exclude_categories_processing_time" multiple>
                                
                                <?php
                                $exclude_categories_processing_time = [];
								if(isset($processing_time_settings['exclude_categories']) && !empty($processing_time_settings['exclude_categories'])) {
									foreach ($processing_time_settings['exclude_categories'] as $hide_cat) {
										$exclude_categories_processing_time[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($processing_time_settings['exclude_categories']) && !empty($processing_time_settings['exclude_categories']) && in_array(htmlspecialchars_decode($cat->name),$exclude_categories_processing_time) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Product from Overall Processing Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want the processing time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_product_processing_time" name="coderockz_woo_delivery_exclude_product_processing_time[]" class="coderockz_woo_delivery_exclude_product_processing_time" multiple>
                                
                                <?php
                                
                                foreach ($store_products as $key=>$value) {

                                	$selected = isset($processing_time_settings['exclude_products']) && !empty($processing_time_settings['exclude_products']) && in_array($key,$processing_time_settings['exclude_products']) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Exclude Product from Overall Processing Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want the processing time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$exclude_products_input_processing_time = isset($processing_time_settings['exclude_products']) && !empty($processing_time_settings['exclude_products']) ? $processing_time_settings['exclude_products'] : array();
	                        	$exclude_products_input_processing_time = implode(",",$exclude_products_input_processing_time);
	                        	?>
	                    		<input id="coderockz_woo_delivery_exclude_product_input_processing_time" name="coderockz_woo_delivery_exclude_product_input_processing_time" type="text" class="coderockz_woo_delivery_exclude_product_input_processing_time coderockz-woo-delivery-input-field" value="<?php echo $exclude_products_input_processing_time; ?>" placeholder="<?php _e('Comma(,) separated Product/Variation ID', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_processing_time_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Processing Time', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-processing-time-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_category_processing_time_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Enable Category Wise Processing time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable category wise processing time. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_category_wise_processing_time">
							       <input type="checkbox" name="coderockz_woo_delivery_category_wise_processing_time" id="coderockz_woo_delivery_category_wise_processing_time" <?php echo (isset($processing_time_settings['enable_category_wise_processing_time']) && !empty($processing_time_settings['enable_category_wise_processing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-processing-time">

	                        <?php
	                        $category_processing_time_html = "";
							if(isset($processing_time_settings['category_processing_time']) && !empty($processing_time_settings['category_processing_time'])) {
								foreach($processing_time_settings['category_processing_time'] as $category => $time) {


									$duration = ""; 
		                    		$identity = "min";
		                			if(isset($time) && !empty($time)) {
		                				$time = (int)$time;
		                				if($time <= 59) {
		                					$duration = $time;
		                				} else {
		                					$time = $time/60;
		                					$helper = new Coderockz_Woo_Delivery_Helper();
		                					if($helper->containsDecimal($time)){
		                						$duration = $time*60;
		                						$identity = "min";
		                					} else {
		                						$duration = $time;
		                						$identity = "hour";
		                					}
		                				}
		                			}

									$category_processing_time_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_processing_time_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_processing_time_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_time_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_processing_time_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_processing_time_html .= '</select>';
									$selected = ($identity == "min") ? "selected" : "";
									$selected2 = ($identity == "hour") ? "selected" : "";
									$category_processing_time_html .= '<div id="coderockz_woo_delivery_category_processing_time_duration" class="coderockz_woo_delivery_category_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_category_processing_time-'.str_replace(" ","c-w-d",$category).'" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="'. $duration.'" placeholder="" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_category_processing_time_format-'.str_replace(" ","c-w-d",$category).'">
											<option value="min" '.$selected.'>'.__('Minutes', 'coderockz-woo-delivery').'</option>
											<option value="hour" '.$selected2.'>'.__('Hour', 'coderockz-woo-delivery').'</option>
										</select>
		                        	</div>';
		                        	if(array_keys($processing_time_settings['category_processing_time'])[0] != $category){
										$category_processing_time_html .= '<button class="coderockz-woo-delivery-category-processing-time-remove"><span class="dashicons dashicons-trash"></span></button>';
									}



									
							        $category_processing_time_html .= '</div>';
								}
								echo $category_processing_time_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_time_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
								    <div id="coderockz_woo_delivery_category_processing_time_duration" class="coderockz_woo_delivery_category_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_category_processing_time" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="" placeholder="" autocomplete="off" disabled="disabled"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_category_processing_time_format" disabled="disabled">
											<option value="min"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
											<option value="hour"><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
										</select>
		                        	</div>

		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-processing-time-category-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_processing_time_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Product Wise Processing Time', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('One ID per line. If product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-product-processing-time-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_product_processing_time_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Enable Product Wise Processing time', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable product wise processing time. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_product_wise_processing_time">
							       <input type="checkbox" name="coderockz_woo_delivery_product_wise_processing_time" id="coderockz_woo_delivery_product_wise_processing_time" <?php echo (isset($processing_time_settings['enable_product_wise_processing_time']) && !empty($processing_time_settings['enable_product_wise_processing_time'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Multiply Processing Time By Quantity', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you need to calculate processing time based on product quantity then enable it. For example, if you need 10 min of a burger processing time and if you need 20 mintues for 2 burgers processing time then enable it. Default is disabled.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_product_processing_time_quantity">
							       <input type="checkbox" name="coderockz_woo_delivery_product_processing_time_quantity" id="coderockz_woo_delivery_product_processing_time_quantity" <?php echo (isset($processing_time_settings['enable_product_processing_time_quantity']) && !empty($processing_time_settings['enable_product_processing_time_quantity'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                        <div class="coderockz-woo-delivery-product-processing-time">

	                        <?php
	                        $product_processing_time_html = "";
							if(isset($processing_time_settings['product_processing_time']) && !empty($processing_time_settings['product_processing_time'])) {
								foreach($processing_time_settings['product_processing_time'] as $product => $time) {


									$duration = ""; 
		                    		$identity = "min";
		                			if(isset($time) && !empty($time)) {
		                				$time = (int)$time;
		                				if($time <= 59) {
		                					$duration = $time;
		                				} else {
		                					$time = $time/60;
		                					$helper = new Coderockz_Woo_Delivery_Helper();
		                					if($helper->containsDecimal($time)){
		                						$duration = $time*60;
		                						$identity = "min";
		                					} else {
		                						$duration = $time;
		                						$identity = "hour";
		                					}
		                				}
		                			}

									$product_processing_time_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_processing_time_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_processing_time_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_time_products[]">
								    <option value="">'.__('Select Product', 'coderockz-woo-delivery').'</option>';
									foreach ($store_products as $key=>$value) {
										$selected = ($key == $product) ? "selected" : "";
										$product_processing_time_html .= '<option value="'.$key.'"'.$selected.'>'.$value.' (ID: '.$key.')</option>';
									}
									$product_processing_time_html .= '</select>';
									$selected = ($identity == "min") ? "selected" : "";
									$selected2 = ($identity == "hour") ? "selected" : "";
									$product_processing_time_html .= '<div id="coderockz_woo_delivery_product_processing_time_duration" class="coderockz_woo_delivery_product_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_product_processing_time-'.$product.'" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="'. $duration.'" placeholder="" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_product_processing_time_format-'.$product.'">
											<option value="min" '.$selected.'>'.__('Minutes', 'coderockz-woo-delivery').'</option>
											<option value="hour" '.$selected2.'>'.__('Hour', 'coderockz-woo-delivery').'</option>
										</select>
		                        	</div>';
		                        	if(array_keys($processing_time_settings['product_processing_time'])[0] != $product){
										$product_processing_time_html .= '<button class="coderockz-woo-delivery-product-processing-time-remove"><span class="dashicons dashicons-trash"></span></button>';
									}



									
							        $product_processing_time_html .= '</div>';
								}
								echo $product_processing_time_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_processing_time_products[]">
								    <option value=""><?php _e('Select Product', 'coderockz-woo-delivery'); ?></option>
									
									<?php
									foreach ($store_products as $key=>$value) {
										echo '<option value="'.$key.'">'.$value.' (ID: '.$key.')</option>';
									}
									?>
									</select>
								    <div id="coderockz_woo_delivery_product_processing_time_duration" class="coderockz_woo_delivery_product_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_product_processing_time" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="" placeholder="" autocomplete="off" disabled="disabled"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_product_processing_time_format" disabled="disabled">
											<option value="min"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
											<option value="hour"><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
										</select>
		                        	</div>

		                    	</div>
		                    <?php } ?>
	                    	</div>

	                    	<?php } else { ?>

	                    	<div class="coderockz-woo-delivery-product-processing-time">

	                        <?php
	                        $product_processing_time_html = "";
							if(isset($processing_time_settings['product_processing_time']) && !empty($processing_time_settings['product_processing_time'])) {
								foreach($processing_time_settings['product_processing_time'] as $product => $time) {


									$duration = ""; 
		                    		$identity = "min";
		                			if(isset($time) && !empty($time)) {
		                				$time = (int)$time;
		                				if($time <= 59) {
		                					$duration = $time;
		                				} else {
		                					$time = $time/60;
		                					$helper = new Coderockz_Woo_Delivery_Helper();
		                					if($helper->containsDecimal($time)){
		                						$duration = $time*60;
		                						$identity = "min";
		                					} else {
		                						$duration = $time;
		                						$identity = "hour";
		                					}
		                				}
		                			}

									$product_processing_time_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $product_processing_time_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$product_processing_time_html .= '<input name="coderockz_delivery_processing_time_products_input" type="text" class="coderockz-woo-delivery-input-field" value="'.$product.'" placeholder="Product/Variation ID" autocomplete="off"/>';
									$selected = ($identity == "min") ? "selected" : "";
									$selected2 = ($identity == "hour") ? "selected" : "";
									$product_processing_time_html .= '<div id="coderockz_woo_delivery_product_processing_time_duration" class="coderockz_woo_delivery_product_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_product_processing_time-'.$product.'" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="'. $duration.'" placeholder="" autocomplete="off"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_product_processing_time_format-'.$product.'">
											<option value="min" '.$selected.'>'.__('Minutes', 'coderockz-woo-delivery').'</option>
											<option value="hour" '.$selected2.'>'.__('Hour', 'coderockz-woo-delivery').'</option>
										</select>
		                        	</div>';
		                        	if(array_keys($processing_time_settings['product_processing_time'])[0] != $product){
										$product_processing_time_html .= '<button class="coderockz-woo-delivery-product-processing-time-remove"><span class="dashicons dashicons-trash"></span></button>';
									}



									
							        $product_processing_time_html .= '</div>';
								}
								echo $product_processing_time_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
									<input name="coderockz_delivery_processing_time_products_input" type="text" class="coderockz-woo-delivery-input-field" placeholder="Product/Variation ID" autocomplete="off"/>
								    <div id="coderockz_woo_delivery_product_processing_time_duration" class="coderockz_woo_delivery_product_processing_time_duration">
			                        	<input name="coderockz_woo_delivery_product_processing_time" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="" placeholder="" autocomplete="off" disabled="disabled"/>
			                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_product_processing_time_format" disabled="disabled">
											<option value="min"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
											<option value="hour"><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
										</select>
		                        	</div>

		                    	</div>
		                    <?php } ?>
	                    	</div>

	                    	<?php } ?>
	                    	
	                    	<button class="coderockz-woo-delivery-add-processing-time-product-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_product_processing_time_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>


                <div class="coderockz-woo-delivery-card">
				<p class="coderockz-woo-delivery-card-header"><?php _e('Weekday Wise Processing Time', 'coderockz-woo-delivery'); ?></p>
				<div class="coderockz-woo-delivery-card-body">
					<p class="coderockz-woo-delivery-weekday-processing-time-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
				    <form action="" method="post" id ="coderockz_woo_delivery_weekday_processing_time_settings_submit">
				        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
				        <div class="coderockz-woo-delivery-form-group">
				        	<span class="coderockz-woo-delivery-form-label" style="width:365px!important"><?php _e('Enable Weekday Wise Processing Time', 'coderockz-woo-delivery'); ?></span>
				        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want different processing time for different week day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
						    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_weekday_wise_processing_time">
						       <input type="checkbox" class="coderockz_woo_delivery_enable_weekday_wise_processing_time" name="coderockz_woo_delivery_enable_weekday_wise_processing_time" id="coderockz_woo_delivery_enable_weekday_wise_processing_time" <?php echo (isset($processing_time_settings['enable_weekday_wise_processing_time']) && !empty($processing_time_settings['enable_weekday_wise_processing_time'])) ? "checked" : "" ?>/>
						       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
						    </label>
				    	</div>
				    	<?php
				    	$weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
				        foreach ($weekday as $key => $value) { 

				        	$fee = isset($processing_time_settings['weekday_wise_processing_time'][$key]) && !empty($processing_time_settings['weekday_wise_processing_time'][$key]) ? $processing_time_settings['weekday_wise_processing_time'][$key] : "";
							?>

							<div class="coderockz-woo-delivery-form-group">
				        		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_wise_processing_time_<?php echo $key; ?>"><?php echo $value; ?> <?php _e('Processing Time', 'coderockz-woo-delivery'); ?></label>
				            	<input style="width:100px!important;" id="coderockz_woo_delivery_weekday_wise_processing_time_<?php echo $key; ?>" name="coderockz_woo_delivery_weekday_wise_processing_time_<?php echo $key; ?>" type="text" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo $fee; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php  _e('Minutes') ?></span>
				        	</div>

							<?php
				        }
				        ?>

				        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_weekday_processing_time_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
				    </form>
				</div>

				</div>

				<div class="coderockz-woo-delivery-card">
				<p class="coderockz-woo-delivery-card-header"><?php _e('Shipping Zone Wise Processing Time', 'coderockz-woo-delivery'); ?></p>
				<div class="coderockz-woo-delivery-card-body">
					<p class="coderockz-woo-delivery-zone-wise-processingtime-notice"></p>
			        <form action="" method="post" id ="coderockz_zone_wise_processingtime_form_submit">
			            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

			            <!-- <div class="coderockz-woo-delivery-zone-wise-offdays"> -->

			            <?php
			            $zone_wise_processingtime_html = "";
			            $i = 1;

						if(isset($processing_time_settings['zone_wise_processing_time']) && !empty($processing_time_settings['zone_wise_processing_time'])) {
							foreach($processing_time_settings['zone_wise_processing_time'] as $zone => $days) {
								$zone_wise_processingtime_html .= '<div class="coderockz-woo-delivery-zone-wise-processingtime">';
								$zone_wise_processingtime_html .= '<div class="coderockz-woo-delivery-form-group">';
						        $zone_wise_processingtime_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
								$zone_wise_processingtime_html .= '<select style="width: 250px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_processingtime_zone" name="coderockz_delivery_zone_wise_processingtime_zone[]">
							    <option value="">'.__('Select Shipping Zone', 'coderockz-woo-delivery').'</option>';
								foreach ($zone_name as $key => $value) {
									$selected = ($key == $zone) ? "selected" : "";
									$zone_wise_processingtime_html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
								}
								$zone_wise_processingtime_html .= '</select>';

			                    $zone_wise_processingtime_html .= '<input style="width:100px!important;" class="coderockz-woo-delivery-number-field coderockz-delivery-zone-wise-processingtime-zone-day" name="coderockz-delivery-zone-wise-processingtime-zone-day-'.$zone.'" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" value="'.$days.'" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code">'.__('Minutes','coderockz-woo-delivery').'</span>';
			                    
								if($i!=1){
									$zone_wise_processingtime_html .= '<button class="coderockz-woo-delivery-zone-wise-processingtime-remove"><span class="dashicons dashicons-trash"></span></button>';
								}

								$i = $i+1;
								
						        $zone_wise_processingtime_html .= '</div>';
						        $zone_wise_processingtime_html .= '</div>';
							}

						}


						if($zone_wise_processingtime_html != "") {
							echo $zone_wise_processingtime_html;
						} else {

			            ?>
			                <div class="coderockz-woo-delivery-zone-wise-processingtime">
			                <div class="coderockz-woo-delivery-form-group">
			                	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
							    <select style="width: 250px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_zone_wise_processingtime_zone" name="coderockz_delivery_zone_wise_processingtime_zone[]" autocomplete="off">
							    <option value=""><?php _e('Select Shipping Zone', 'coderockz-woo-delivery'); ?></option>
								<?php
			                    foreach ($zone_name as $key => $value) {
			                        echo '<option value="'.$key.'">'.$value.'</option>';
			                    }
			                    ?>
								</select>
								<input style="width:100px!important;" class="coderockz-woo-delivery-number-field coderockz-delivery-zone-wise-processingtime-zone-day" name="coderockz-delivery-zone-wise-processingtime-zone-day" type="number" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" value="" placeholder="" autocomplete="off" disabled="disabled"/><span class="coderockz-woo-delivery-currency-code"><?php _e('Minutes','coderockz-woo-delivery'); ?></span>
			            	</div>
			            	</div>
			            <?php } ?>
			        	
			        	<button class="coderockz-woo-delivery-add-zone-wise-processingtime-btn"><span class="dashicons dashicons-plus"></span></button>
			            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_zone_wise_processingtime_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
			        </form>
				</div>

			</div>

               
			</div>

			<div data-tab="tab15" class="coderockz-woo-delivery-tabcontent">
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Urgent Delivery Fee', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' The timeslots between this mentioned min/hour from current time is hidden from timeslot list.', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-conditional-delivery-fee-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_conditional_delivery_fee_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width: 250px!important;text-align:unset!important"><?php _e('Enable Conditional Delivery Fee', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("By enabling this option, you can add a conditional base delivery fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_enable_conditional_delivery_fee">
							       <input type="checkbox" name="coderockz_delivery_enable_conditional_delivery_fee" id="coderockz_delivery_enable_conditional_delivery_fee" <?php echo (isset($delivery_fee_settings['enable_conditional_delivery_fee']) && !empty($delivery_fee_settings['enable_conditional_delivery_fee'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>


	                    	<?php 
                    			$conditional_delivery_start_hour = "";
            					$conditional_delivery_start_min = "";
            					$conditional_delivery_start_format= "am";
                    			
                    			if(isset($delivery_fee_settings['conditional_delivery_time_starts']) && (string)$delivery_fee_settings['conditional_delivery_time_starts'] !='') {
                    				$conditional_delivery_time_starts = (int)$delivery_fee_settings['conditional_delivery_time_starts'];

                    				if($conditional_delivery_time_starts == 0) {
		            					$conditional_delivery_start_hour = "12";
		            					$conditional_delivery_start_min = "00";
		            					$conditional_delivery_start_format= "am";
		            				} elseif($conditional_delivery_time_starts > 0 && $conditional_delivery_time_starts <= 59) {

                    					$conditional_delivery_start_hour = "12";
                    					$conditional_delivery_start_min = sprintf("%02d", $conditional_delivery_time_starts);
                    					$conditional_delivery_start_format= "am";
                    				} elseif($conditional_delivery_time_starts > 59 && $conditional_delivery_time_starts <= 719) {
										$conditional_delivery_start_min = sprintf("%02d", (int)$conditional_delivery_time_starts%60);
										$conditional_delivery_start_hour = sprintf("%02d", ((int)$conditional_delivery_time_starts-$conditional_delivery_start_min)/60);
										$conditional_delivery_start_format= "am";
										
                    				} else {
										$conditional_delivery_start_min = sprintf("%02d", (int)$conditional_delivery_time_starts%60);
										$conditional_delivery_start_hour = sprintf("%02d", ((int)$conditional_delivery_time_starts-$conditional_delivery_start_min)/60);
										if($conditional_delivery_start_hour>12) {
											$conditional_delivery_start_hour = sprintf("%02d", $conditional_delivery_start_hour-12);
										}
										$conditional_delivery_start_format= "pm";
                    				}

                    			}
                    		?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_conditional_delivery_time_slot_starts"><?php _e('Conditional Delivery Time Starts From', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Conditional Delivery Time starts from the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_conditional_delivery_time_slot_starts" class="coderockz_conditional_delivery_time_slot_starts">
	                    			
	                        	<input name="coderockz_conditional_delivery_time_slot_starts_hour" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $conditional_delivery_start_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_conditional_delivery_time_slot_starts_min" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $conditional_delivery_start_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_conditional_delivery_time_slot_starts_format">
									<option value="am" <?php selected($conditional_delivery_start_format,"am",true); ?>>AM</option>
									<option value="pm" <?php selected($conditional_delivery_start_format,"pm",true); ?>>PM</option>
								</select>
	                        	</div>
	                    	</div>
	                    	<?php 
                    			$conditional_delivery_end_hour = "";
            					$conditional_delivery_end_min = "";
            					$conditional_delivery_end_format= "am";
                    			
                    			if(isset($delivery_fee_settings['conditional_delivery_time_ends']) && (string)$delivery_fee_settings['conditional_delivery_time_ends'] !='') {
                    				$conditional_delivery_time_ends = (int)$delivery_fee_settings['conditional_delivery_time_ends'];
                    				if($conditional_delivery_time_ends == 0) {
		            					$conditional_delivery_end_hour = "12";
		            					$conditional_delivery_end_min = "00";
		            					$conditional_delivery_end_format= "am";
		            				} elseif($conditional_delivery_time_ends > 0 && $conditional_delivery_time_ends <= 59) {
                    					$conditional_delivery_end_hour = "12";
                    					$conditional_delivery_end_min = sprintf("%02d", $conditional_delivery_time_ends);
                    					$conditional_delivery_end_format= "am";
                    				} elseif($conditional_delivery_time_ends > 59 && $conditional_delivery_time_ends <= 719) {
										$conditional_delivery_end_min = sprintf("%02d", (int)$conditional_delivery_time_ends%60);
										$conditional_delivery_end_hour = sprintf("%02d", ((int)$conditional_delivery_time_ends-$conditional_delivery_end_min)/60);
										$conditional_delivery_end_format= "am";
										
                    				} elseif($conditional_delivery_time_ends > 719 && $conditional_delivery_time_ends <= 1439) {
										$conditional_delivery_end_min = sprintf("%02d", (int)$conditional_delivery_time_ends%60);
										$conditional_delivery_end_hour = sprintf("%02d", ((int)$conditional_delivery_time_ends-$conditional_delivery_end_min)/60);
										if($conditional_delivery_end_hour>12) {
											$conditional_delivery_end_hour = sprintf("%02d", $conditional_delivery_end_hour-12);
										}
										$conditional_delivery_end_format= "pm";
                    				} elseif($conditional_delivery_time_ends == 1440) {
										$conditional_delivery_end_min = "00";
										$conditional_delivery_end_hour = "12";
										$conditional_delivery_end_format= "am";
                    				}


                    			}
                    		?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_slot_ends"><?php _e('Conditional Delivery Time Ends At', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Conditional Delivery Time ends at the time that is specified here. Only numerical value is accepted.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<div id="coderockz_conditional_delivery_time_slot_ends" class="coderockz_conditional_delivery_time_slot_ends">
	                        	<input name="coderockz_conditional_delivery_time_slot_ends_hour" type="number" class="coderockz-woo-delivery-number-field" max="12" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 12 || this.value < 1) this.value = null;" value="<?php echo $conditional_delivery_end_hour; ?>" placeholder="<?php _e('Hour', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input name="coderockz_conditional_delivery_time_slot_ends_min" type="number" class="coderockz-woo-delivery-number-field" max="59" min="0" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value > 59 || this.value < 0) this.value = null;" value="<?php echo $conditional_delivery_end_min; ?>" placeholder="<?php _e('Minutes', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_conditional_delivery_time_slot_ends_format">
									<option value="am" <?php selected($conditional_delivery_end_format,"am",true); ?>>AM</option>
									<option value="pm" <?php selected($conditional_delivery_end_format,"pm",true); ?>>PM</option>
								</select>
	                        	</div>
	                        	<p class="coderockz_conditional_delivery_time_greater_notice">End Time Must after Start Time</p>
	                    	</div>

	                        <div class="coderockz-woo-delivery-form-group" style="display:inline-block!important;">
	                    		<label style="width:unset!important;" class="coderockz-woo-delivery-form-label" for="coderockz_delivery_conditional_delivery_fee"><?php _e('Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                        	<input style="width:60px!important;" id="coderockz_delivery_conditional_delivery_fee" name="coderockz_delivery_conditional_delivery_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo isset($delivery_fee_settings['conditional_delivery_fee']) && !empty($delivery_fee_settings['conditional_delivery_fee']) ? esc_attr($delivery_fee_settings['conditional_delivery_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group" style="display:inline!important;">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_conditional_delivery_shipping_method" style="width:unset!important;text-align:left!important"><?php _e('OR Use shipping Method ', 'coderockz-woo-delivery'); ?></label>
	                        	<select class="coderockz-woo-delivery-select-field" id="coderockz_woo_delivery_conditional_delivery_shipping_method" name="coderockz_woo_delivery_conditional_delivery_shipping_method" style="width:200px!important;">
	                        		<option value=""><?php _e('Select Shipping Method', 'coderockz-woo-delivery'); ?></option>
									<?php
			                        foreach ($shipping_methods as $method) { 
		                			?>
									<option value="<?php echo $method; ?>"  <?php if(isset($delivery_fee_settings['conditional_delivery_shipping_method']) && $delivery_fee_settings['conditional_delivery_shipping_method'] == $method){ echo "selected"; } ?>><?php echo $method; ?></option>
									<?php
			                        } 
		                			?>
								</select>
	                    	</div>

	                    	<?php
	                    		$duration = ""; 
	                    		$identity = "min";
                    			if(isset($delivery_fee_settings['conditional_delivery_fee_duration']) && !empty($delivery_fee_settings['conditional_delivery_fee_duration'])) {
                    				$conditional_delivery_fee_duration = (int)$delivery_fee_settings['conditional_delivery_fee_duration'];
                    				if($conditional_delivery_fee_duration <= 59) {
                    					$duration = $conditional_delivery_fee_duration;
                    				} else {
                    					$conditional_delivery_fee_duration = $conditional_delivery_fee_duration/60;
                    					$helper = new Coderockz_Woo_Delivery_Helper();
                    					if($helper->containsDecimal($conditional_delivery_fee_duration)){
                    						$duration = $conditional_delivery_fee_duration*60;
                    						$identity = "min";
                    					} else {
                    						$duration = $conditional_delivery_fee_duration;
                    						$identity = "hour";
                    					}
                    				}
                    			}
	                    	?>
	                    	<div class="coderockz-woo-delivery-form-group" style="display:inline!important;">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_conditional_delivery_fee_duration" style="width:unset!important;text-align:left!important"><?php _e('For the next available', 'coderockz-woo-delivery'); ?></label>
	                    		<div id="coderockz_woo_delivery_conditional_delivery_fee_duration" class="coderockz_woo_delivery_conditional_delivery_fee_duration" style="width:unset!important;">
	                        	<input name="coderockz_woo_delivery_conditional_delivery_fee_time" type="number" min="1" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-number-field" value="<?php echo $duration; ?>" placeholder="" autocomplete="off" style="width:70px!important;"/>
	                        	<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_conditional_delivery_fee_format" style="width:90px!important;">
									<option value="min" <?php selected($identity,"min",true); ?>><?php _e('Minutes', 'coderockz-woo-delivery'); ?></option>
									<option value="hour" <?php selected($identity,"hour",true); ?>><?php _e('Hour', 'coderockz-woo-delivery'); ?></option>
								</select>
	                        	</div>
	                    	</div>

	                    	<p class="coderockz_conditional_delivery_method_choose_notice">You have to choose either delivery fee or shipping method</p>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width: 420px!important;text-align:unset!important"><?php _e('Diasble the timeslot Range Where The Next X Hour End', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Suppose you have a timeslot of 3:00PM - 5:00PM and you set conditional delivery for next 3 hours. So when a customer comes to order at 1:00PM, the conditional delivery time ends 4:00PM. So if you want to disable the timeslot 3:00PM - 5:00PM, enable the option.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_disable_inter_timeslot_conditional">
							       <input type="checkbox" name="coderockz_delivery_disable_inter_timeslot_conditional" id="coderockz_delivery_disable_inter_timeslot_conditional" <?php echo (isset($delivery_fee_settings['disable_inter_timeslot_conditional']) && !empty($delivery_fee_settings['disable_inter_timeslot_conditional'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_conditional_delivery_text"><?php _e('Conditional Delivery Text in Timeslot Dropdown', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The text you want to show in timeslot dropdown. Default is Delivery within X hour/min for Y amount.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_conditional_delivery_text" name="coderockz_woo_delivery_conditional_delivery_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_fee_settings['conditional_delivery_dropdown_text']) && !empty($delivery_fee_settings['conditional_delivery_dropdown_text'])) ? stripslashes(esc_attr($delivery_fee_settings['conditional_delivery_dropdown_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_conditional_delivery_fee_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Date Fee', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-date-fee-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_date_fee_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div style="border:1px solid #ddd;border-radius: 4px;">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Deliver Date Fee', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("By enabling this option, any fee for ordering in same day, next day and other days can be added.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_enable_delivery_date_fee">
							       <input type="checkbox" name="coderockz_delivery_date_enable_delivery_date_fee" id="coderockz_delivery_date_enable_delivery_date_fee" <?php echo (isset($delivery_fee_settings['enable_delivery_date_fee']) && !empty($delivery_fee_settings['enable_delivery_date_fee'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_same_day_fee"><?php _e('Same Day Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                        	<input style="width:100px!important;" id="coderockz_delivery_date_same_day_fee" name="coderockz_delivery_date_same_day_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_fee_settings['same_day_fee']) && !empty($delivery_fee_settings['same_day_fee'])) ? esc_attr($delivery_fee_settings['same_day_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_next_day_fee"><?php _e('Next Day Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                        	<input style="width:100px!important;" id="coderockz_delivery_date_next_day_fee" name="coderockz_delivery_date_next_day_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_fee_settings['next_day_fee']) && !empty($delivery_fee_settings['next_day_fee'])) ? esc_attr($delivery_fee_settings['next_day_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_day_after_tomorrow_fee"><?php _e('Day After Tomorrow Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                        	<input style="width:100px!important;" id="coderockz_delivery_date_day_after_tomorrow_fee" name="coderockz_delivery_date_day_after_tomorrow_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_fee_settings['day_after_tomorrow_fee']) && !empty($delivery_fee_settings['day_after_tomorrow_fee'])) ? esc_attr($delivery_fee_settings['day_after_tomorrow_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_date_other_days_fee"><?php _e('Other Days Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                        	<input style="width:100px!important;" id="coderockz_delivery_date_other_days_fee" name="coderockz_delivery_date_other_days_fee" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($delivery_fee_settings['other_days_fee']) && !empty($delivery_fee_settings['other_days_fee'])) ? esc_attr($delivery_fee_settings['other_days_fee']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>
	                    	</div>
	                    	<div style="border:1px solid #ddd;border-radius: 4px;margin: 10px 0;padding: 20px;">
	                    	<div class="coderockz-woo-delivery-form-group" style="display:inline!important;">
								<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_conditional_delivery_day_shipping_method" style="width:unset!important;text-align:left!important"><?php _e('Use Shipping Method ', 'coderockz-woo-delivery'); ?></label>
								<select class="coderockz-woo-delivery-select-field" id="coderockz_woo_delivery_conditional_delivery_day_shipping_method" name="coderockz_woo_delivery_conditional_delivery_day_shipping_method" style="width:200px!important;">
									<option value=""><?php _e('Select Shipping Method', 'coderockz-woo-delivery'); ?></option>
									<?php
							        foreach ($shipping_methods as $method) { 
									?>
									<option value="<?php echo $method; ?>"  <?php if(isset($delivery_fee_settings['conditional_delivery_day_shipping_method']) && $delivery_fee_settings['conditional_delivery_day_shipping_method'] == $method){ echo "selected"; } ?>><?php echo $method; ?></option>
									<?php
							        } 
									?>
								</select>
							</div>
							<div class="coderockz-woo-delivery-form-group" style="display:inline!important;">
								<label class="coderockz-woo-delivery-form-label" style="width:unset!important;text-align:left!important"><?php _e('For the First ', 'coderockz-woo-delivery'); ?></label>

								<input type="number" name="coderockz_woo_delivery_conditional_delivery_day_shipping_method_total_day" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($delivery_fee_settings['conditional_delivery_day_shipping_method_total_day']) && $delivery_fee_settings['conditional_delivery_day_shipping_method_total_day'] != "") ? esc_attr($delivery_fee_settings['conditional_delivery_day_shipping_method_total_day']) : ""; ?>" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>

							</div>
							</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_date_fee_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e(' Weekday Wise Delivery Date Fee', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-weekday-wise-fee-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_weekday_wise_fee_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:365px!important"><?php _e('Enable Weekday Wise Delivery Date Fee', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want different delivery fee for different week day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_weekday_wise_delivery_fee">
							       <input type="checkbox" class="coderockz_woo_delivery_enable_weekday_wise_delivery_fee" name="coderockz_woo_delivery_enable_weekday_wise_delivery_fee" id="coderockz_woo_delivery_enable_weekday_wise_delivery_fee" <?php echo (isset($delivery_fee_settings['enable_weekday_wise_delivery_fee']) && !empty($delivery_fee_settings['enable_weekday_wise_delivery_fee'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php
	                    	$weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                        foreach ($weekday as $key => $value) { 

	                        	$fee = isset($delivery_fee_settings['weekday_wise_delivery_fee'][$key]) && !empty($delivery_fee_settings['weekday_wise_delivery_fee'][$key]) ? $delivery_fee_settings['weekday_wise_delivery_fee'][$key] : "";
                				?>

                				<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_wise_fee_<?php echo $key; ?>"><?php echo $value; ?> <?php _e('Delivery Fee', 'coderockz-woo-delivery'); ?></label>
		                        	<input style="width:100px!important;" id="coderockz_woo_delivery_weekday_wise_fee_<?php echo $key; ?>" name="coderockz_woo_delivery_weekday_wise_fee_<?php echo $key; ?>" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo $fee; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
		                    	</div>

                				<?php
	                        }
	                        ?>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_weekday_wise_fee_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>

                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Specific Date Wise Delivery Fee', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-specific-date-fee-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
				        <form action="" method="post" id ="coderockz_woo_delivery_specific_date_fee_form_submit">
				            <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

				            <div class="coderockz-woo-delivery-specific-date-fees">
				            <?php

				            $specific_date_fee_html = "";
				            
							if(isset($delivery_fee_settings['specific_date_fee']) && !empty($delivery_fee_settings['specific_date_fee'])) {

								foreach($delivery_fee_settings['specific_date_fee'] as $specific_date => $fee) {
									$specific_date_fee_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $specific_date_fee_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
								    $specific_date_fee_html .= '<input type="text" value ="'.$specific_date.'" name="coderockz_woo_delivery_specific_date[]" class="coderockz-woo-delivery-input-field" autocomplete="off" placeholder="'.__('YYYY-MM-DD', 'coderockz-woo-delivery').'"/>';
										
									$specific_date_fee_html .= '<input type="text" class="coderockz-woo-delivery-input-field" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" name="coderockz-woo-delivery-specific-date-fee-'.$specific_date.'" value="'.$fee.'" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="Fee"/><span class="coderockz-woo-delivery-currency-code">'.$currency_code.'</span>';
									if(array_keys($delivery_fee_settings['specific_date_fee'])[0] != $specific_date){
										$specific_date_fee_html .= '<button class="coderockz-woo-delivery-specific-date-fee-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $specific_date_fee_html .= '</div>';
								}
					
								echo $specific_date_fee_html;
							} else {

				            ?>
				                <div class="coderockz-woo-delivery-form-group">
				                	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
									<input type="text" name="coderockz_woo_delivery_specific_date[]" class="coderockz-woo-delivery-input-field" autocomplete="off" placeholder="<?php _e('YYYY-MM-DD', 'coderockz-woo-delivery'); ?>"/>
								    <input type="text" class="coderockz-woo-delivery-input-field" value="" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="<?php _e('Fee', 'coderockz-woo-delivery'); ?>" disabled="disabled"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
				            	</div>
				            <?php } ?>
				        	</div>
				        	<button class="coderockz-woo-delivery-specific-date-fee-btn"><span class="dashicons dashicons-plus"></span></button>
				            <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_specific_date_fee_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
				        </form>
					</div>

				</div>


				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e(' Weekday Wise Pickup Date Fee', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-weekday-wise-pickup-fee-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_weekday_wise_pickup_fee_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:365px!important"><?php _e('Enable Weekday Wise Pickup Date Fee', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want different pickup fee for different week day. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_weekday_wise_pickup_fee">
							       <input type="checkbox" class="coderockz_woo_delivery_enable_weekday_wise_pickup_fee" name="coderockz_woo_delivery_enable_weekday_wise_pickup_fee" id="coderockz_woo_delivery_enable_weekday_wise_pickup_fee" <?php echo (isset($delivery_fee_settings['enable_weekday_wise_pickup_fee']) && !empty($delivery_fee_settings['enable_weekday_wise_pickup_fee'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php
	                    	$weekday = array("0"=>__("Sunday",'coderockz-woo-delivery'), "1"=>__("Monday",'coderockz-woo-delivery'), "2"=>__("Tuesday",'coderockz-woo-delivery'), "3"=>__("Wednesday",'coderockz-woo-delivery'), "4"=>__("Thursday",'coderockz-woo-delivery'), "5"=>__("Friday",'coderockz-woo-delivery'), "6"=>__("Saturday",'coderockz-woo-delivery'));
	                        foreach ($weekday as $key => $value) { 

	                        	$fee = isset($delivery_fee_settings['weekday_wise_pickup_fee'][$key]) && !empty($delivery_fee_settings['weekday_wise_pickup_fee'][$key]) ? $delivery_fee_settings['weekday_wise_pickup_fee'][$key] : "";
                				?>

                				<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_wise_pickup_fee_<?php echo $key; ?>"><?php echo $value; ?> <?php _e('Pickup Fee', 'coderockz-woo-delivery'); ?></label>
		                        	<input style="width:100px!important;" id="coderockz_woo_delivery_weekday_wise_pickup_fee_<?php echo $key; ?>" name="coderockz_woo_delivery_weekday_wise_pickup_fee_<?php echo $key; ?>" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10))) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo $fee; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
		                    	</div>

                				<?php
	                        }
	                        ?>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_weekday_wise_pickup_fee_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>


				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Delivery Date Wise Discount Coupon', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Date range is accepted, saperated with ...(3 dots). Format example is 2023-02-12...2023-02-15', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-specific-date-coupon-notice"></p>
					    <form action="" method="post" id ="coderockz_woo_delivery_specific_date_coupon_form_submit">
					        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

					        <!-- <div class="coderockz-woo-delivery-zone-wise-offdays"> -->

					        <?php if(get_option('coderockz_woo_delivery_large_coupons_list') == false || get_option('coderockz_woo_delivery_large_coupons_list') == 'no') { 
					        $specific_date_coupon_html = "";
					        $i = 1;

							if(isset($delivery_fee_settings['specific_date_coupon']) && !empty($delivery_fee_settings['specific_date_coupon'])) {
								foreach($delivery_fee_settings['specific_date_coupon'] as $coupon => $days) {
									$specific_date_coupon_html .= '<div class="coderockz-woo-delivery-date-wise-coupon">';
									$specific_date_coupon_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $specific_date_coupon_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$specific_date_coupon_html .= '<select style="width: 195px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_date_wise_coupon_date" name="coderockz_delivery_date_wise_coupon_date[]">
								    <option value="">'.__('Select Discount Coupon', 'coderockz-woo-delivery').'</option>';
									foreach ($discount_coupons as $discount_coupon) {
										$selected = ($discount_coupon == $coupon) ? "selected" : "";
										$specific_date_coupon_html .= '<option value="'.$discount_coupon.'"'.$selected.'>'.$discount_coupon.'</option>';
									}
									$specific_date_coupon_html .= '</select>';

									if(isset($days['type']) &&  $days['type'] == "range"){
										$specific_date_coupon_html .= '<input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day-'.$coupon.'" type="text"  value="'.$days['range_short'].'" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off"/>';
									} else {
										$specific_date_coupon_html .= '<input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day-'.$coupon.'" type="text"  value="'.implode(',', $days['range_value']).'" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off"/>';
									}

					                
					                
									if($i!=1){
										$specific_date_coupon_html .= '<button class="coderockz-woo-delivery-date-wise-coupon-remove"><span class="dashicons dashicons-trash"></span></button>';
									}

									$i = $i+1;
									
							        $specific_date_coupon_html .= '</div>';
							        $specific_date_coupon_html .= '</div>';
								}

							}


							if($specific_date_coupon_html != "") {
								echo $specific_date_coupon_html;
							} else {

					        ?>
					            <div class="coderockz-woo-delivery-date-wise-coupon">
					            <div class="coderockz-woo-delivery-form-group">
					            	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select style="width: 195px!important;" class="coderockz-woo-delivery-select-field coderockz_delivery_date_wise_coupon_date" name="coderockz_delivery_date_wise_coupon_date[]" autocomplete="off">
								    <option value=""><?php _e('Select Discount Coupon', 'coderockz-woo-delivery'); ?></option>
									<?php
					                foreach ($discount_coupons as $discount_coupon) {
					                    echo '<option value="'.$discount_coupon.'">'.$discount_coupon.'</option>';
					                }
					                ?>
									</select>
									<input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day" type="text" value="" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off" disabled="disabled"/>
					        	</div>
					        	</div>
					        <?php }  } else { 
	                        $specific_date_coupon_html = "";
							if(isset($delivery_fee_settings['specific_date_coupon']) && !empty($delivery_fee_settings['specific_date_coupon'])) {
								foreach($delivery_fee_settings['specific_date_coupon'] as $coupon => $days) {
									$specific_date_coupon_html .= '<div class="coderockz-woo-delivery-date-wise-coupon">';
									$specific_date_coupon_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $specific_date_coupon_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$specific_date_coupon_html .= '<input name="coderockz_delivery_date_wise_coupon_date_input" type="text" class="coderockz-woo-delivery-input-field" value="'.$coupon.'" placeholder="Coupon code" autocomplete="off"/>';
									if(isset($days['type']) &&  $days['type'] == "range"){
										$specific_date_coupon_html .= '<input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day-'.$coupon.'" type="text"  value="'.$days['range_short'].'" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off"/>';
									} else {
										$specific_date_coupon_html .= '<input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day-'.$coupon.'" type="text"  value="'.implode(',', $days['range_value']).'" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off"/>';
									}
									if(array_keys($delivery_fee_settings['specific_date_coupon'])[0] != $coupon){
										$specific_date_coupon_html .= '<button class="coderockz-woo-delivery-date-wise-coupon-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $specific_date_coupon_html .= '</div></div>';
								}
								echo $specific_date_coupon_html;
							} else {

	                        ?>
	                        <div class="coderockz-woo-delivery-date-wise-coupon">
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								<input name="coderockz_delivery_date_wise_coupon_date_input" type="text" class="coderockz-woo-delivery-input-field" placeholder="Coupon code" autocomplete="off"/>
							    <input style="width:430px!important;" class="coderockz-woo-delivery-input-field coderockz-delivery-date-wise-coupon-date-day" name="coderockz-delivery-date-wise-coupon-date-day" type="text" value="" placeholder="Comma(,) Separated Date, format yyyy-mm-dd(Ex. 2020-12-24)" autocomplete="off" disabled="disabled"/>
	                    	</div>
	                    	</div>
		                    <?php } } ?> 
					    	
					    	<button class="coderockz-woo-delivery-add-date-wise-coupon-btn"><span class="dashicons dashicons-plus"></span></button>
					        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_specific_date_coupon_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
					    </form>
					</div>

				</div>


			</div>

			<div data-tab="tab16" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Common Email Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-common-email-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_common_email_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <div class="coderockz-woo-delivery-form-group">
								
								<span style="vertical-align:bottom" class="coderockz-woo-delivery-form-label"><?php _e('Email Header Logo', 'coderockz-woo-delivery'); ?></span>
								<p style="vertical-align:bottom" class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Set a logo at the top of email.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								<div style="display:inline-block;vertical-align: middle;">
									<div class='coderockz-woo-delivery-notify-email-logo-preview-wrapper'>
									<?php
									if ( isset($notify_email_settings['notify-email-logo-id']) && !empty( $notify_email_settings['notify-email-logo-id'] ) ) {
										$coderockz_woo_delivery_notify_email_logo = wp_get_attachment_url( $notify_email_settings['notify-email-logo-id'] );
										?>
										<img style="max-width:90px;display: block;margin:0 auto 10px;padding-right: 15px;" id='coderockz-woo-delivery-notify-email-logo-preview' src='<?php echo esc_url( $coderockz_woo_delivery_notify_email_logo ); ?>'>
										<?php
									} else {
										?>
										<img style="max-width:90px;display: block;margin:0 auto 10px;padding-right: 15px;" id='coderockz-woo-delivery-notify-email-logo-preview' src=''>
										<?php
									}

									?>
								</div>
									<?php wp_enqueue_media(); ?>
									<input id="coderockz-woo-delivery-notify-email-logo-upload-btn" type="button" class="button" value="<?php _e( 'Upload Logo', 'coderockz-woo-delivery' ); ?>"/>
									<input type='hidden' name='coderockz-woo-delivery-notify-email-logo-upload-id' id='coderockz-woo-delivery-notify-email-logo-upload-id' value="<?php echo (isset($notify_email_settings['notify-email-logo-id']) && !empty($notify_email_settings['notify-email-logo-id'])) ? esc_attr($notify_email_settings['notify-email-logo-id']) : "" ?>">
								</div>
							</div>
							<div class="coderockz-woo-delivery-form-group">
								<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_logo_width"><?php _e('Notify Email Logo Width', 'coderockz-woo-delivery'); ?></label>
								<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to change the width of header logo, input it here. Default is 120px.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								<input style="width:150px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_woo_delivery_notify_email_logo_width" name="coderockz_woo_delivery_notify_email_logo_width" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($notify_email_settings['notify_email_logo_width']) && !empty($notify_email_settings['notify_email_logo_width'])) ? stripslashes(esc_attr($notify_email_settings['notify_email_logo_width'])) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder">px</span>
							</div>
							<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_heading_color"><?php _e('Email Heading Color', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notify Email Heading Color. Default is #96588a.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<input type="text" style="width: 130px!important;line-height:unset!important;border: 1px solid #ccc!important;max-height: 30px!important;border-top-right-radius: 0!important;border-bottom-right-radius: 0!important;" class="coderockz-woo-delivery-input-field" id="coderockz_woo_delivery_notify_email_heading_color" name="coderockz_woo_delivery_notify_email_heading_color" value="<?php echo (isset($notify_email_settings['notify_email_heading_color']) && !empty($notify_email_settings['notify_email_heading_color'])) ? esc_attr($notify_email_settings['notify_email_heading_color']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Send Email from Different Email & Name', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to send the notify email from different email and name. Default is sending notify email from default admin email and website name.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_notify_email_different_name_email">
							       <input type="checkbox" name="coderockz_woo_delivery_notify_email_different_name_email" id="coderockz_woo_delivery_notify_email_different_name_email" <?php echo (isset($notify_email_settings['notify_email_different_name_email']) && !empty($notify_email_settings['notify_email_different_name_email'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz_woo_delivery_notify_email_different_name_email_section" style="display:none;">
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_send_email_from_email"><?php _e('From Email', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Send email from this email. Default is going from Administration Email Address.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_send_email_from_email" name="coderockz_woo_delivery_send_email_from_email" type="email" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['send_email_from_email']) && $notify_email_settings['send_email_from_email'] != ""?esc_attr($notify_email_settings['send_email_from_email']): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_send_email_from_name"><?php _e('From Name', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Send email from this name. Default name is Website title.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_send_email_from_name" name="coderockz_woo_delivery_send_email_from_name" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['send_email_from_name']) && $notify_email_settings['send_email_from_name'] != ""?stripslashes(esc_attr($notify_email_settings['send_email_from_name'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_order_text"><?php _e('Order Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Order.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_order_text" name="coderockz_woo_delivery_notify_email_order_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_order_text']) && $notify_email_settings['notify_email_order_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_order_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_product_text"><?php _e('Product Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Product.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_product_text" name="coderockz_woo_delivery_notify_email_product_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_product_text']) && $notify_email_settings['notify_email_product_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_product_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_quantity_text"><?php _e('Quantity Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Quantity.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_quantity_text" name="coderockz_woo_delivery_notify_email_quantity_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_quantity_text']) && $notify_email_settings['notify_email_quantity_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_quantity_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_price_text"><?php _e('Price Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Price.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_price_text" name="coderockz_woo_delivery_notify_email_price_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_price_text']) && $notify_email_settings['notify_email_price_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_price_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_shipping_text"><?php _e('Shipping Method Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Shipping Method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_shipping_text" name="coderockz_woo_delivery_notify_email_shipping_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_shipping_text']) && $notify_email_settings['notify_email_shipping_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_shipping_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_payment_text"><?php _e('Payment Method Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Payment Method.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_payment_text" name="coderockz_woo_delivery_notify_email_payment_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_payment_text']) && $notify_email_settings['notify_email_payment_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_payment_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_tax_text"><?php _e('Tax Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Tax.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_tax_text" name="coderockz_woo_delivery_notify_email_tax_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_tax_text']) && $notify_email_settings['notify_email_tax_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_tax_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_total_text"><?php _e('Total Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Total.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_total_text" name="coderockz_woo_delivery_notify_email_total_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_total_text']) && $notify_email_settings['notify_email_total_text'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_total_text'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_billing_address_heading"><?php _e('Billing Address Heading Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Billing Address.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_billing_address_heading" name="coderockz_woo_delivery_notify_email_billing_address_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_billing_address_heading']) && $notify_email_settings['notify_email_billing_address_heading'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_billing_address_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_email_shipping_address_heading"><?php _e('Shipping Address Heading Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Shipping Address.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_email_shipping_address_heading" name="coderockz_woo_delivery_notify_email_shipping_address_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_email_shipping_address_heading']) && $notify_email_settings['notify_email_shipping_address_heading'] != ""?stripslashes(esc_attr($notify_email_settings['notify_email_shipping_address_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_common_email_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Reminder Email Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-reminder-email-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_reminder_email_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Reminder Email for Customers', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When your website gets the first visitor, Reminder emails of that day's delivery/pickup will be sent. The same day's delivery/pickup isn't getting the reminder email.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_reminder_email">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_reminder_email" id="coderockz_woo_delivery_enable_reminder_email" <?php echo (isset($notify_email_settings['enable_reminder_email']) && !empty($notify_email_settings['enable_reminder_email'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_reminder_delivery_email_subject"><?php _e('Reminder Delivery Email Subject', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Subject of reminder delivery email that is sent from the order page metabox. Default is Reminder of your delivery order [#order_number].", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_reminder_delivery_email_subject" name="coderockz_woo_delivery_reminder_delivery_email_subject" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['reminder_delivery_email_subject']) && $notify_email_settings['reminder_delivery_email_subject'] != ""?stripslashes(esc_attr($notify_email_settings['reminder_delivery_email_subject'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_reminder_pickup_email_subject"><?php _e('Reminder Pickup Email Subject', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Subject of reminder pickup email that is sent from the order page metabox. Default is Reminder of your pickup order [#order_number].", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_reminder_pickup_email_subject" name="coderockz_woo_delivery_reminder_pickup_email_subject" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['reminder_pickup_email_subject']) && $notify_email_settings['reminder_pickup_email_subject'] != ""?stripslashes(esc_attr($notify_email_settings['reminder_pickup_email_subject'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_reminder_email_heading"><?php _e('Reminder Delivery Email Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notify Delivery Email Heading. Default is Reminder of your delivery order [#order_number].", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_reminder_email_heading" name="coderockz_woo_delivery_delivery_reminder_email_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['delivery_reminder_email_heading']) && $notify_email_settings['delivery_reminder_email_heading'] != ""?stripslashes(esc_attr($notify_email_settings['delivery_reminder_email_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_reminder_email_heading"><?php _e('Reminder Pickup Email Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notify Pickup Email Heading. Default is Reminder of your pickup order [#order_number].", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_reminder_email_heading" name="coderockz_woo_delivery_pickup_reminder_email_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['pickup_reminder_email_heading']) && $notify_email_settings['pickup_reminder_email_heading'] != ""?stripslashes(esc_attr($notify_email_settings['pickup_reminder_email_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_reminder_email_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Notify Email Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-notify-email-tab-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_notify_email_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_delivery_email_subject"><?php _e('Notify Delivery Email Subject', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Subject of notify delivery email that is sent from the order page metabox. Default is Your delivery information is changed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_delivery_email_subject" name="coderockz_woo_delivery_notify_delivery_email_subject" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_delivery_email_subject']) && $notify_email_settings['notify_delivery_email_subject'] != ""?stripslashes(esc_attr($notify_email_settings['notify_delivery_email_subject'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_notify_pickup_email_subject"><?php _e('Notify Pickup Email Subject', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Subject of notify pickup email that is sent from the order page metabox. Default is Your pickup information is changed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_notify_pickup_email_subject" name="coderockz_woo_delivery_notify_pickup_email_subject" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['notify_pickup_email_subject']) && $notify_email_settings['notify_pickup_email_subject'] != ""?stripslashes(esc_attr($notify_email_settings['notify_pickup_email_subject'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_notify_email_heading"><?php _e('Notify Delivery Email Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notify Delivery Email Heading. Default is Your delivery information is changed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_notify_email_heading" name="coderockz_woo_delivery_delivery_notify_email_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['delivery_notify_email_heading']) && $notify_email_settings['delivery_notify_email_heading'] != ""?stripslashes(esc_attr($notify_email_settings['delivery_notify_email_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_notify_email_heading"><?php _e('Notify Pickup Email Heading', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notify Pickup Email Heading. Default is Your pickup information is changed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_notify_email_heading" name="coderockz_woo_delivery_pickup_notify_email_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo isset($notify_email_settings['pickup_notify_email_heading']) && $notify_email_settings['pickup_notify_email_heading'] != ""?stripslashes(esc_attr($notify_email_settings['pickup_notify_email_heading'])): ""; ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_notify_email_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
                	<div class="coderockz-woo-delivery-reminder-notify-email-preview">
                		<div class="coderockz-woo-delivery-reminder-email-preview">
                			<p class="coderockz-woo-delivery-card-header"><?php _e('Reminder Email Preview', 'coderockz-woo-delivery'); ?></p>
							<div class="coderockz-woo-delivery-card-body">
								<img src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/reminder-email-preview.png" alt="" style="display: block;margin: 0 auto;width:100%">
		                	</div>
                		</div>
                		<div class="coderockz-woo-delivery-notify-email-preview">
                			<p class="coderockz-woo-delivery-card-header"><?php _e('Notify Email Preview', 'coderockz-woo-delivery'); ?></p>
							<div class="coderockz-woo-delivery-card-body">
								<img src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/notify-email-preview.png" alt="" style="display: block;margin: 0 auto;width:100%">
		                	</div>
                		</div>
                	</div>

                </div>
			</div>
			<div data-tab="tab17" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Additional Field Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-additional-field-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_additional_field_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Enable Additional field', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable Additional textarea field in woocommerce order checkout page. This field is helpful when customer want to give special instructions to seller about the order.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_enable_additional_field">
							       <input type="checkbox" name="coderockz_enable_additional_field" id="coderockz_enable_additional_field" <?php echo (isset($additional_field_settings['enable_additional_field']) && !empty($additional_field_settings['enable_additional_field'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Make Additional Field Mandatory', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Make Additional textarea field mandatory in woocommerce order checkout page. Default is optional.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_additional_field_mandatory">
							       <input type="checkbox" name="coderockz_additional_field_mandatory" id="coderockz_additional_field_mandatory" <?php echo (isset($additional_field_settings['additional_field_mandatory']) && !empty($additional_field_settings['additional_field_mandatory'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_additional_field_label"><?php _e('Additional Field Label', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Additional textarea field label. Default is Special Note About Delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_additional_field_label" name="coderockz_additional_field_label" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($additional_field_settings['field_label']) && !empty($additional_field_settings['field_label'])) ? stripslashes(esc_attr($additional_field_settings['field_label'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_additional_field_placeholder"><?php _e('Additional Field Placeholder', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Additional textarea field placeholder. Default is nothing.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_additional_field_placeholder" name="coderockz_additional_field_placeholder" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($additional_field_settings['field_placeholder']) && !empty($additional_field_settings['field_placeholder'])) ? stripslashes(esc_attr($additional_field_settings['field_placeholder'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_additional_field_ch_limit"><?php _e('Additional Field Character Limit', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Restrict the character of Additional textarea field that customer is written. Only numerical value is excepted. Default is unlimited characters.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_additional_field_ch_limit" name="coderockz_additional_field_ch_limit" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($additional_field_settings['character_limit']) && !empty($additional_field_settings['character_limit'])) ? stripslashes(esc_attr($additional_field_settings['character_limit'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_additional_field_character_remaining_text"><?php _e('Character Remaining Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is X characters remaining.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_additional_field_character_remaining_text" name="coderockz_woo_delivery_additional_field_character_remaining_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($additional_field_settings['character_remaining_text']) && !empty($additional_field_settings['character_remaining_text'])) ? stripslashes(esc_attr($additional_field_settings['character_remaining_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Additional Field For', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show your customers the additional field for delivery or pickup, specify it here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_hide_additional_field_for" name="coderockz_woo_delivery_hide_additional_field_for[]" class="coderockz_woo_delivery_hide_additional_field_for" multiple>
                                <?php
                                $option = array("delivery"=>"Delivery", "pickup"=>"Pickup");
	                                foreach ($option as $key => $value) {
	                                	$selected = isset($additional_field_settings['hide_additional_field_for']) && !empty($additional_field_settings['hide_additional_field_for']) && in_array($key,$additional_field_settings['hide_additional_field_for']) ? "selected" : "";
	                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }
                                ?>
                                </select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable WooCommerce Order Notes', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("After enabling our additional fields, there are two textarea which does exactly same work. One is our additional field and another is WooCommerce default order notes. If you don't need the two then you can disable the WooComerce default order notes from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" 2for="coderockz_woo_delivery_disable_order_notes">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_order_notes" id="coderockz_woo_delivery_disable_order_notes" <?php echo (isset($additional_field_settings['disable_order_notes']) && !empty($additional_field_settings['disable_order_notes'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_additional_field_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
			</div>
			<div data-tab="tab18" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Localization', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-localization-settings-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_localization_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                      
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_order_limit_notice"><?php _e('Maximum Delivery Limit Exceed', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Maximum Delivery Limit Notice. Default is Maximum Delivery Limit Exceed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_order_limit_notice" name="coderockz_woo_delivery_order_limit_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['order_limit_notice']) && !empty($localization_settings['order_limit_notice'])) ? stripslashes(esc_attr($localization_settings['order_limit_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_limit_notice"><?php _e('Maximum Pickup Limit Exceed', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Maximum Pickup Limit Notice. Default is Maximum Pickup Limit Exceed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_limit_notice" name="coderockz_woo_delivery_pickup_limit_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_limit_notice']) && !empty($localization_settings['pickup_limit_notice'])) ? stripslashes(esc_attr($localization_settings['pickup_limit_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_location_limit_notice"><?php _e('Maximum Pickup Limit Exceed For This Location', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Maximum Pickup for This Location Limit Notice. Default is Maximum Pickup Limit Exceed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_location_limit_notice" name="coderockz_woo_delivery_pickup_location_limit_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_location_limit_notice']) && !empty($localization_settings['pickup_location_limit_notice'])) ? stripslashes(esc_attr($localization_settings['pickup_location_limit_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_heading_checkout"><?php _e('Delivery Information', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_heading_checkout" name="coderockz_woo_delivery_delivery_heading_checkout" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_heading_checkout']) && !empty($localization_settings['delivery_heading_checkout'])) ? stripslashes(esc_attr($localization_settings['delivery_heading_checkout'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_heading_checkout"><?php _e('Pickup Information', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_heading_checkout" name="coderockz_woo_delivery_pickup_heading_checkout" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_heading_checkout']) && !empty($localization_settings['pickup_heading_checkout'])) ? stripslashes(esc_attr($localization_settings['pickup_heading_checkout'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_pickup_heading_checkout"><?php _e('Delivery/Pickup Information', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Checkout heading text of delivery section. Default is Delivery Information.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_pickup_heading_checkout" name="coderockz_woo_delivery_delivery_pickup_heading_checkout" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_pickup_heading_checkout']) && !empty($localization_settings['delivery_pickup_heading_checkout'])) ? stripslashes(esc_attr($localization_settings['delivery_pickup_heading_checkout'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_no_timeslot_available_notice"><?php _e('No Timeslot Available To Select', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no timeslot is available to select, this text will appear in delivery time field. Default is No Timeslot Available To Select.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_no_timeslot_available_notice" name="coderockz_woo_delivery_no_timeslot_available_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['no_timeslot_available']) && !empty($localization_settings['no_timeslot_available'])) ? stripslashes(esc_attr($localization_settings['no_timeslot_available'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_delivery_date_notice"><?php _e('Select Delivery Date First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no date is selected, this text will appear in delivery time field. Default is Select Delivery Date First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_delivery_date_notice" name="coderockz_woo_delivery_select_delivery_date_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_delivery_date_notice']) && !empty($localization_settings['select_delivery_date_notice'])) ? stripslashes(esc_attr($localization_settings['select_delivery_date_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_date_notice"><?php _e('Select Pickup Date First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no date is selected, this text will appear in pickup time field. Default is Select Pickup Date First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_date_notice" name="coderockz_woo_delivery_select_pickup_date_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_date_notice']) && !empty($localization_settings['select_pickup_date_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_date_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_date_location_notice"><?php _e('Select Pickup Date & Location First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no date & location is selected, this text will appear in pickup time field. Default is Select Pickup Date & Location First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_date_location_notice" name="coderockz_woo_delivery_select_pickup_date_location_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_date_location_notice']) && !empty($localization_settings['select_pickup_date_location_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_date_location_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_date_time_notice"><?php _e('Select Pickup Date & Time First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no date & time is selected, this text will appear in pickup location field. Default is Select Pickup Date & Time First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_date_time_notice" name="coderockz_woo_delivery_select_pickup_date_time_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_date_time_notice']) && !empty($localization_settings['select_pickup_date_time_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_date_time_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_location_notice"><?php _e('Select Pickup Location First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("When no location is selected, this text will appear in pickup time field. Default is Select Pickup Location First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_location_notice" name="coderockz_woo_delivery_select_pickup_location_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_location_notice']) && !empty($localization_settings['select_pickup_location_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_location_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_time_notice"><?php _e('Select Pickup Time First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Select Pickup Time First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_time_notice" name="coderockz_woo_delivery_select_pickup_time_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_time_notice']) && !empty($localization_settings['select_pickup_time_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_time_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_select_pickup_time_delivery_date_notice"><?php _e('Select Pickup Time & Delivery Date First', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Select Pickup Time First.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_select_pickup_time_delivery_date_notice" name="coderockz_woo_delivery_select_pickup_time_delivery_date_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['select_pickup_time_delivery_date_notice']) && !empty($localization_settings['select_pickup_time_delivery_date_notice'])) ? stripslashes(esc_attr($localization_settings['select_pickup_time_delivery_date_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_details_text"><?php _e('Delivery Details', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Details text in order page, single order page, customer account page. Default is Delivery Details.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_details_text" name="coderockz_woo_delivery_delivery_details_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_details_text']) && !empty($localization_settings['delivery_details_text'])) ? stripslashes(esc_attr($localization_settings['delivery_details_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_status_text"><?php _e('Delivery Status', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Status text in order page, single order page, customer account page. Default is Delivery Status.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_status_text" name="coderockz_woo_delivery_delivery_status_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_status_text']) && !empty($localization_settings['delivery_status_text'])) ? stripslashes(esc_attr($localization_settings['delivery_status_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_status_not_delivered_text"><?php _e('Not Delivered', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Not Completed Status text in order page, single order page, customer account page. Default is Not Delivered.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_status_not_delivered_text" name="coderockz_woo_delivery_delivery_status_not_delivered_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_status_not_delivered_text']) && !empty($localization_settings['delivery_status_not_delivered_text'])) ? stripslashes(esc_attr($localization_settings['delivery_status_not_delivered_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_delivery_status_delivered_text"><?php _e('Delivery Completed', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Completed Status text in order page, single order page, customer account page. Default is Delivery Completed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_delivery_status_delivered_text" name="coderockz_woo_delivery_delivery_status_delivered_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_status_delivered_text']) && !empty($localization_settings['delivery_status_delivered_text'])) ? stripslashes(esc_attr($localization_settings['delivery_status_delivered_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_status_not_picked_text"><?php _e('Not Picked', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Not Picked Status text in order page, single order page, customer account page. Default is Not Picked.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_status_not_picked_text" name="coderockz_woo_delivery_pickup_status_not_picked_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_status_not_picked_text']) && !empty($localization_settings['pickup_status_not_picked_text'])) ? stripslashes(esc_attr($localization_settings['pickup_status_not_picked_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_status_picked_text"><?php _e('Pickup Completed', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Completed Status text in order page, single order page, customer account page. Default is Pickup Completed.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_pickup_status_picked_text" name="coderockz_woo_delivery_pickup_status_picked_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_status_picked_text']) && !empty($localization_settings['pickup_status_picked_text'])) ? stripslashes(esc_attr($localization_settings['pickup_status_picked_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_order_metabox_heading"><?php _e('Delivery/Pickup Date & Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Single order page metabox heading text. Default is Delivery Date & Time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_order_metabox_heading" name="coderockz_woo_delivery_order_metabox_heading" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['order_metabox_heading']) && !empty($localization_settings['order_metabox_heading'])) ? stripslashes(esc_attr($localization_settings['order_metabox_heading'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_delivery_option_notice"><?php _e('Please Select Your Order Type', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the order type field required but not given any value to the field. Default is Please Select Your Order Type.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_delivery_option_notice" name="coderockz_woo_delivery_checkout_delivery_option_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_delivery_option_notice']) && !empty($localization_settings['checkout_delivery_option_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_delivery_option_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_date_notice"><?php _e('Please Enter Delivery Date', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the delivery date field required but not given any value to the field. Default is Please Enter Delivery Date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_date_notice" name="coderockz_woo_delivery_checkout_date_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_date_notice']) && !empty($localization_settings['checkout_date_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_date_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_pickup_date_notice"><?php _e('Please Enter Pickup Date', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the pickup date field required but not given any value to the field. Default is Please Enter Pickup Date.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_pickup_date_notice" name="coderockz_woo_delivery_checkout_pickup_date_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_pickup_date_notice']) && !empty($localization_settings['checkout_pickup_date_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_pickup_date_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_time_notice"><?php _e('Please Enter Delivery Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the delivery time field required but not given any value to the field. Default is Please Enter Delivery Time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_time_notice" name="coderockz_woo_delivery_checkout_time_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_time_notice']) && !empty($localization_settings['checkout_time_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_time_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_tips_notice"><?php _e('Please Enter Delivery Tips', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the delivery tips field required but customer not given any value to the field. Default is Please Enter Delivery Tips.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_tips_notice" name="coderockz_woo_delivery_checkout_tips_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_tips_notice']) && !empty($localization_settings['checkout_tips_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_tips_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_pickup_time_notice"><?php _e('Please Enter Pickup Time', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the pickup time field required but not given any value to the field. Default is Please Enter Pickup Time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_pickup_time_notice" name="coderockz_woo_delivery_checkout_pickup_time_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_pickup_time_notice']) && !empty($localization_settings['checkout_pickup_time_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_pickup_time_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_pickup_notice"><?php _e('Please Enter Pickup Location', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the pickup location field required but not given any value to the field. Default is Please Enter Pickup Location.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input data-get_site_url_script="<?php echo get_site_url().'/wp-content/plugins/'.basename( plugin_dir_path(  dirname( __FILE__ , 2 ) ) ).'/admin/js/coderockz-woo-delivery-admin-js-plugin.js?ver='.CODEROCKZ_WOO_DELIVERY_VERSION; ?>" id="coderockz_woo_delivery_checkout_pickup_notice" name="coderockz_woo_delivery_checkout_pickup_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_pickup_notice']) && !empty($localization_settings['checkout_pickup_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_pickup_notice'])) : "" ?>" placeholder="" autocomplete="off"/>

	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_pickup_location_map_notice"><?php _e('Pickup Location Map Notice(Under Pickup Location Field)', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the pickup location field required but not given any value to the field. Default is Please Enter Pickup Location.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		
	                    		<div id="coderockz_woo_delivery_pickup_location_map_notice" class="coderockz_woo_delivery_pickup_location_map_notice">
	                        	<input id="coderockz_woo_delivery_location_map_click_here" name="coderockz_woo_delivery_location_map_click_here" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['location_map_click_here']) && !empty($localization_settings['location_map_click_here'])) ? stripslashes(esc_attr($localization_settings['location_map_click_here'])) : "" ?>" placeholder="<?php _e('Click here', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	<input id="coderockz_woo_delivery_to_see_map_location" name="coderockz_woo_delivery_to_see_map_location" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['to_see_map_location']) && !empty($localization_settings['to_see_map_location'])) ? stripslashes(esc_attr($localization_settings['to_see_map_location'])) : "" ?>" placeholder="<?php _e('to see map location', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                        	</div>
	                        	
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_additional_field_notice"><?php _e('Pickup Location Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Default is Pickup Location Fee", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input data-get_site_url="<?php echo home_url(); ?>" id="coderockz_woo_delivery_pickup_location_fee_text" name="coderockz_woo_delivery_pickup_location_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_location_fee_text']) && !empty($localization_settings['pickup_location_fee_text'])) ? stripslashes(esc_attr($localization_settings['pickup_location_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_additional_field_notice"><?php _e('Please Enter Special Note for Delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice if you make the additional field required but not given any value to the field. Default is Please Enter Special Note for Delivery.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_additional_field_notice" name="coderockz_woo_delivery_checkout_additional_field_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['checkout_additional_field_notice']) && !empty($localization_settings['checkout_additional_field_notice'])) ? stripslashes(esc_attr($localization_settings['checkout_additional_field_notice'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_delivery_fee_text"><?php _e('Delivery Time Slot Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Delivery Time Slot Fee Text in the order summary box in checkout page. Default is Delivery Time Slot Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_delivery_fee_text" name="coderockz_woo_delivery_checkout_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['delivery_fee_text']) && !empty($localization_settings['delivery_fee_text'])) ? stripslashes(esc_attr($localization_settings['delivery_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_as_soon_as_possible_fee_text"><?php _e('As Soon As Possible Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("As Soon As Possible Fee Text in the order summary box in checkout page. Default is As Soon As Possible Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_as_soon_as_possible_fee_text" name="coderockz_woo_delivery_checkout_as_soon_as_possible_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['as_soon_as_possible_fee_text']) && !empty($localization_settings['as_soon_as_possible_fee_text'])) ? stripslashes(esc_attr($localization_settings['as_soon_as_possible_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_checkout_pickup_fee_text"><?php _e('Pickup Slot Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Pickup Slot Fee Text in the order summary box in checkout page. Default is Pickup Slot Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_checkout_pickup_fee_text" name="coderockz_woo_delivery_checkout_pickup_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['pickup_fee_text']) && !empty($localization_settings['pickup_fee_text'])) ? stripslashes(esc_attr($localization_settings['pickup_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_conditional_fee_text"><?php _e('Conditional Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Conditional Delivery Fee Text in the order summary box in checkout page. Default is Conditional Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_conditional_fee_text" name="coderockz_woo_delivery_conditional_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['conditional_fee_text']) && !empty($localization_settings['conditional_fee_text'])) ? stripslashes(esc_attr($localization_settings['conditional_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_same_day_delivery_fee_text"><?php _e('Same Day Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Same Day Delivery Fee Text in the order summary box in checkout page. Default is Same Day Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_same_day_delivery_fee_text" name="coderockz_woo_delivery_same_day_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['sameday_fee_text']) && !empty($localization_settings['sameday_fee_text'])) ? stripslashes(esc_attr($localization_settings['sameday_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_next_day_delivery_fee_text"><?php _e('Next Day Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Next Day Delivery Fee Text in the order summary box in checkout page. Default is Next Day Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_next_day_delivery_fee_text" name="coderockz_woo_delivery_next_day_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['nextday_fee_text']) && !empty($localization_settings['nextday_fee_text'])) ? stripslashes(esc_attr($localization_settings['nextday_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_day_after_tomorrow_delivery_fee_text"><?php _e('Day After Tomorrow Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Day After Tomorrow Delivery Fee Text in the order summary box in checkout page. Default is Day After Tomorrow Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_day_after_tomorrow_delivery_fee_text" name="coderockz_woo_delivery_day_after_tomorrow_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['day_after_tomorrow_fee_text']) && !empty($localization_settings['day_after_tomorrow_fee_text'])) ? stripslashes(esc_attr($localization_settings['day_after_tomorrow_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_other_day_delivery_fee_text"><?php _e('Other Day Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Other Day Delivery Fee Text in the order summary box in checkout page. Default is Other Day Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_other_day_delivery_fee_text" name="coderockz_woo_delivery_other_day_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['other_fee_text']) && !empty($localization_settings['other_fee_text'])) ? stripslashes(esc_attr($localization_settings['other_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_fee_text"><?php _e('Weekday Delivery Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Weekday Delivery Fee Text in the order summary box in checkout page. Default is Weekday Delivery Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_weekday_fee_text" name="coderockz_woo_delivery_weekday_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['weekday_fee_text']) && !empty($localization_settings['weekday_fee_text'])) ? stripslashes(esc_attr($localization_settings['weekday_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_weekday_pickup_fee_text"><?php _e('Weekday Pickup Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Weekday pickup Fee Text in the order summary box in checkout page. Default is Weekday Pickup Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_weekday_pickup_fee_text" name="coderockz_woo_delivery_weekday_pickup_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['weekday_pickup_fee_text']) && !empty($localization_settings['weekday_pickup_fee_text'])) ? stripslashes(esc_attr($localization_settings['weekday_pickup_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_specific_date_fee_text"><?php _e('Delivery Date Fee', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Specific Delivery Date Fee Text in the order summary box in checkout page. Default is Delivery Date Fee.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_specific_date_fee_text" name="coderockz_woo_delivery_specific_date_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['specific_date_fee_text']) && !empty($localization_settings['specific_date_fee_text'])) ? stripslashes(esc_attr($localization_settings['specific_date_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_only_available_for_today_text"><?php _e('only available for today', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of only available for today", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_only_available_for_today_text" name="coderockz_woo_delivery_only_available_for_today_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['only_available_for_today_text']) && !empty($localization_settings['only_available_for_today_text'])) ? stripslashes(esc_attr($localization_settings['only_available_for_today_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_free_shipping_other_day_text"><?php _e('is not available for today', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of is not only available for today", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_free_shipping_other_day_text" name="coderockz_woo_delivery_free_shipping_other_day_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['free_shipping_other_day_text']) && !empty($localization_settings['free_shipping_other_day_text'])) ? stripslashes(esc_attr($localization_settings['free_shipping_other_day_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_only_available_for_text"><?php _e('only available for', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of only available for", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_only_available_for_text" name="coderockz_woo_delivery_only_available_for_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['only_available_for_text']) && !empty($localization_settings['only_available_for_text'])) ? stripslashes(esc_attr($localization_settings['only_available_for_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_urgent_delivery_fee_text"><?php _e('Delivery only possible today. Shipping Method will change accordingly', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Notice of Urgent Delivery fee from Additional fees. Default is Delivery only possible today. Shipping Method will change accordingly.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_urgent_delivery_fee_text" name="coderockz_woo_delivery_urgent_delivery_fee_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['urgent_delivery_fee_text']) && !empty($localization_settings['urgent_delivery_fee_text'])) ? stripslashes(esc_attr($localization_settings['urgent_delivery_fee_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_need_to_select_text"><?php _e('and need to select delivery time', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of and need to select delivery time", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_need_to_select_text" name="coderockz_woo_delivery_need_to_select_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['need_to_select_text']) && !empty($localization_settings['need_to_select_text'])) ? stripslashes(esc_attr($localization_settings['need_to_select_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_if_available_text"><?php _e('if available', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of if available", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_if_available_text" name="coderockz_woo_delivery_if_available_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['if_available_text']) && !empty($localization_settings['if_available_text'])) ? stripslashes(esc_attr($localization_settings['if_available_text'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_purchase_products_separately_delivery_text"><?php _e('Please purchase the products separately for delivery', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of Please purchase the products separately for delivery", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_purchase_products_separately_delivery_text" name="coderockz_woo_delivery_purchase_products_separately_delivery_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['purchase_products_separately_delivery']) && !empty($localization_settings['purchase_products_separately_delivery'])) ? stripslashes(esc_attr($localization_settings['purchase_products_separately_delivery'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_purchase_products_separately_pickup_text"><?php _e('Please purchase the products separately for pickup', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Text replacement of Please purchase the products separately for pickup", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_purchase_products_separately_pickup_text" name="coderockz_woo_delivery_purchase_products_separately_pickup_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['purchase_products_separately_pickup']) && !empty($localization_settings['purchase_products_separately_pickup'])) ? stripslashes(esc_attr($localization_settings['purchase_products_separately_pickup'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_metabox_order_creation_text"><?php _e('Please create the order first', 'coderockz-woo-delivery', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Please create the order first", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_metabox_order_creation_text" name="coderockz_woo_delivery_metabox_order_creation_text" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($localization_settings['metabox_order_creation']) && !empty($localization_settings['metabox_order_creation'])) ? stripslashes(esc_attr($localization_settings['metabox_order_creation'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_localization_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
			</div>
			<div data-tab="tab19" class="coderockz-woo-delivery-tabcontent">
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Exclusion Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('Please follow the documentation ', 'coderockz-woo-delivery'); ?><a href="https://coderockz.com/documentations/accommodate-shipping-with-delivery-or-pickup-or-both/" target="_blank"><?php _e('from here.', 'coderockz-woo-delivery'); ?></a><?php _e(' for using the Hide for Shipping Method feature correctly', 'coderockz-woo-delivery'); ?></p>
						<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') {} else { ?>
							<p class="coderockz-woo-delivery-timezone-tab-warning"><span class="dashicons dashicons-megaphone"></span><?php _e('In Hide for Individual Product option, if product is simple input the product ID and if product is variable input the variation ID', 'coderockz-woo-delivery'); ?></p>
						<?php } ?>
						<p class="coderockz-woo-delivery-exclusion-settings-notice"></p>
	                    <form action="" method="post" id ="coderockz_woo_delivery_exclusion_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div style="border:1px solid #ddd;border-radius: 4px;padding-left: 10px;">
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Plugin Module for Categories', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product categories for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_product_categories" name="coderockz_woo_delivery_exclude_product_categories[]" class="coderockz_woo_delivery_exclude_product_categories" multiple>
                                
                                <?php
                                $exclude_categories = [];
								if(isset($exclude_settings['exclude_categories']) && !empty($exclude_settings['exclude_categories'])) {
									foreach ($exclude_settings['exclude_categories'] as $hide_cat) {
										$exclude_categories[] = stripslashes($hide_cat);
									}
								}
                                foreach ($all_categories as $cat) {

                                	$selected = isset($exclude_settings['exclude_categories']) && !empty($exclude_settings['exclude_categories']) && in_array(htmlspecialchars_decode($cat->name),$exclude_categories) ? "selected" : "";
                                    echo '<option value="'.$cat->name.'" '.$selected.'>'.$cat->name.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php if(get_option('coderockz_woo_delivery_large_product_list') == false || get_option('coderockz_woo_delivery_large_product_list') == 'no') { ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Plugin Module for Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_individual_product" name="coderockz_woo_delivery_exclude_individual_product[]" class="coderockz_woo_delivery_exclude_individual_product" multiple>
                                
                                <?php
                                
                                foreach ($store_products as $key=>$value) {

                                	$selected = isset($exclude_settings['exclude_products']) && !empty($exclude_settings['exclude_products']) && in_array($key,$exclude_settings['exclude_products']) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>
	                    	<?php } else { ?>

                    		<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Plugin Module for Individual Product', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the product for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$exclude_products_input = isset($exclude_settings['exclude_products']) && !empty($exclude_settings['exclude_products']) ? $exclude_settings['exclude_products'] : array();
	                        	$exclude_products_input = implode(",",$exclude_products_input);
	                        	?>
	                    		<input id="coderockz_woo_delivery_exclude_individual_product_input" name="coderockz_woo_delivery_exclude_individual_product_input" type="text" class="coderockz_woo_delivery_exclude_individual_product_input coderockz-woo-delivery-input-field" value="<?php echo $exclude_products_input; ?>" placeholder="<?php _e('Comma(,) separated Product/Variation ID', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<?php } ?>

	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show Also If Cart Has Other Categories Or Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If there is exclusion category's products or exclusion products in the cart then whatever there are other category's products or other products, the Delivery Date and Time section is hidden. Enable it if you want to reverse it.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_exclusion_reverse_current_condition">
							       <input data-get_store_product_meta="<?php echo get_option(base64_decode('Y29kZXJvY2t6LXdvby1kZWxpdmVyeS1saWNlbnNlLWtleQ=='))!=false&&strlen(trim(get_option(base64_decode('Y29kZXJvY2t6LXdvby1kZWxpdmVyeS1saWNlbnNlLWtleQ=='))))==32&&get_option(base64_decode('Y29kZXJvY2t6LXdvby1kZWxpdmVyeS1saWNlbnNlLXN0YXR1cw=='))==base64_decode('dmFsaWQ=')?true:false; ?>" type="checkbox" name="coderockz_delivery_exclusion_reverse_current_condition" id="coderockz_delivery_exclusion_reverse_current_condition" <?php echo (isset($exclude_settings['reverse_current_condition']) && !empty($exclude_settings['reverse_current_condition'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide for Shipping Method', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the shipping methods for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_shipping_methods" name="coderockz_woo_delivery_exclude_shipping_methods[]" class="coderockz_woo_delivery_exclude_shipping_methods" multiple>
                                
                                <?php
                                $exclude_shipping_methods = [];
								if(isset($exclude_settings['exclude_shipping_methods']) && !empty($exclude_settings['exclude_shipping_methods'])) {
									foreach ($exclude_settings['exclude_shipping_methods'] as $hide_method) {
										$exclude_shipping_methods[] = stripslashes($hide_method);
									}
								}
								
                                foreach ($shipping_methods_with_pickup as $shipping_method) {

                                	$selected = isset($exclude_settings['exclude_shipping_methods']) && !empty($exclude_settings['exclude_shipping_methods']) && in_array(htmlspecialchars_decode($shipping_method),$exclude_shipping_methods) ? "selected" : "";
                                    echo '<option value="'.$shipping_method.'" '.$selected.'>'.$shipping_method.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide for Shipping Method Title', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Input the comma separated shipping method title for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$exclude_shipping_method_title = isset($exclude_settings['exclude_shipping_method_title']) && !empty($exclude_settings['exclude_shipping_method_title']) ? $exclude_settings['exclude_shipping_method_title'] : array();
	                        	$exclude_shipping_method_title = implode(",",$exclude_shipping_method_title);
	                        	?>
	                    		<input id="coderockz_woo_delivery_exclude_shipping_method_title" name="coderockz_woo_delivery_exclude_shipping_method_title" type="text" class="coderockz_woo_delivery_exclude_shipping_method_title coderockz-woo-delivery-input-field" value="<?php echo $exclude_shipping_method_title; ?>" placeholder="<?php _e('Comma(,) separated shipping method title', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide for User Role', 'coderockz-woo-delivery'); ?><br/><span style="font-size: 11px;font-style: italic;color: lightseagreen;"><?php _e('(User must be Logged in)', 'coderockz-woo-delivery'); ?></span></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the user role for which you don't want to show the plugin module.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_exclude_user_roles" name="coderockz_woo_delivery_exclude_user_roles[]" class="coderockz_woo_delivery_exclude_user_roles" multiple>
                                
                                <?php
                                $exclude_user_roles = [];
								if(isset($exclude_settings['exclude_user_roles']) && !empty($exclude_settings['exclude_user_roles'])) {
									foreach ($exclude_settings['exclude_user_roles'] as $hide_role) {
										$exclude_user_roles[] = stripslashes($hide_role);
									}
								}
								
                                foreach ($user_roles as $key => $value) {

                                	$selected = isset($exclude_settings['exclude_user_roles']) && !empty($exclude_settings['exclude_user_roles']) && in_array($key,$exclude_user_roles) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>


	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Plugin Module for Non Logged in User', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show our plugin module only for logged in user, enable this option.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_exclusion_non_logged_in_user">
							       <input type="checkbox" name="coderockz_delivery_exclusion_non_logged_in_user" id="coderockz_delivery_exclusion_non_logged_in_user" <?php echo (isset($exclude_settings['exclusion_non_logged_in_user']) && !empty($exclude_settings['exclusion_non_logged_in_user'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	</div>

	                    	<div style="border:1px solid #ddd;border-radius: 4px;margin-top: 10px;margin-bottom: 10px;">

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_minimum_amount_hide_plugin"><?php _e('Hide Plugin Module if Order Total is Less Than', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Minimum amout in the cart to show the plugin module. Default is no restriction.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:100px!important;" id="coderockz_woo_delivery_minimum_amount_hide_plugin" name="coderockz_woo_delivery_minimum_amount_hide_plugin" type="text" onkeyup="if(isNaN(parseFloat(Number(this.value))) || isNaN(parseInt(Number(this.value), 10)) || this.value < 1) this.value = null;" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($exclude_settings['minimum_amount_hide_plugin']) && !empty($exclude_settings['minimum_amount_hide_plugin'])) ? esc_attr($exclude_settings['minimum_amount_hide_plugin']) : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-currency-code"><?php echo $currency_code; ?></span>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Discount', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including discount. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_discount_hide_plugin">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_discount_hide_plugin" id="coderockz_woo_delivery_calculating_include_discount_hide_plugin" <?php echo (isset($exclude_settings['calculating_include_discount_hide_plugin']) && !empty($exclude_settings['calculating_include_discount_hide_plugin'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style = "width: 365px!important;"><?php _e('Order Total Calculating Including Tax', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable it if you want to calculate the minimum cart amount including tax. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calculating_include_tax_hide_plugin">
							       <input type="checkbox" name="coderockz_woo_delivery_calculating_include_tax_hide_plugin" id="coderockz_woo_delivery_calculating_include_tax_hide_plugin" <?php echo (isset($exclude_settings['calculating_include_tax_hide_plugin']) && !empty($exclude_settings['calculating_include_tax_hide_plugin'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label style = "width: 365px!important;" class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_hide_plugin_amount_restriction_notice"><?php _e('Minimum Cart Amount Notice For Showing Plugin Module', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If the cart total not reach the certain amount then the notice appears in top. Default is Your cart amount must have 'X' to get the Free Shipping", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_hide_plugin_amount_restriction_notice" name="coderockz_woo_delivery_hide_plugin_amount_restriction_notice" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($exclude_settings['hide_plugin_amount_restriction_notice']) && !empty($exclude_settings['hide_plugin_amount_restriction_notice'])) ? $exclude_settings['hide_plugin_amount_restriction_notice'] : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	</div>


	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_exclusion_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
			</div>
			<div data-tab="tab20" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Google Calendar Integration Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' To configure Google calendar integration with the plugin, Please follow the instructions ', 'coderockz-woo-delivery'); ?><a href="https://coderockz.com/documentations/how-to-integrate-plugin-google-calendar" target="_blank"><?php _e('from here.', 'coderockz-woo-delivery'); ?></a></p>
						<p class="coderockz-woo-delivery-google_calendar-settings-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_google_calendar_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Automatically Sync to Google Calendar', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add orders information as an event of Google calendar then enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_google_calendar_sync">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_google_calendar_sync" id="coderockz_woo_delivery_enable_google_calendar_sync" <?php echo (isset($google_calendar_settings['google_calendar_sync']) && !empty($google_calendar_settings['google_calendar_sync'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_google_calendar_id"><?php _e('Calendar ID', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add the order details as an event in a custom calendar. put the calendar ID here. Otherwise event will be created in default calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_google_calendar_id" name="coderockz_woo_delivery_google_calendar_id" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($google_calendar_settings['google_calendar_id']) && !empty($google_calendar_settings['google_calendar_id'])) ? stripslashes(esc_attr($google_calendar_settings['google_calendar_id'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_google_calendar_client_id"><?php _e('Client ID', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_google_calendar_client_id" name="coderockz_woo_delivery_google_calendar_client_id" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($google_calendar_settings['google_calendar_client_id']) && !empty($google_calendar_settings['google_calendar_client_id'])) ? stripslashes(esc_attr($google_calendar_settings['google_calendar_client_id'])) : "" ?>" placeholder="" autocomplete="off" required/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_google_calendar_client_secret"><?php _e('Client Secret', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_google_calendar_client_secret" name="coderockz_woo_delivery_google_calendar_client_secret" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($google_calendar_settings['google_calendar_client_secret']) && !empty($google_calendar_settings['google_calendar_client_secret'])) ? stripslashes(esc_attr($google_calendar_settings['google_calendar_client_secret'])) : "" ?>" placeholder="" autocomplete="off" required/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Order Status That Will Sync With Google Calendar', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Select the status of order which you want to sync with google calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_order_status_sync" name="coderockz_woo_delivery_order_status_sync[]" class="coderockz_woo_delivery_order_status_sync" multiple>
                                
                                <?php
                                $order_status_sync = [];
								if(isset($google_calendar_settings['order_status_sync']) && !empty($google_calendar_settings['order_status_sync'])) {
									foreach ($google_calendar_settings['order_status_sync'] as $order_status) {
										$order_status_sync[] = stripslashes($order_status);
									}
								}

								$order_status = [];
								foreach(wc_get_order_statuses() as $key => $value) {
									$order_status[substr($key, 3)] = $value;
								}
								$order_status['partially-paid'] = 'Partially Paid';

								$order_status = array_diff_assoc($order_status,['cancelled' => 'Cancelled','failed' => 'Failed','refunded' => 'Refunded', 'pending' => 'Pending payment']);

                                foreach ($order_status as $key => $value) {

                                	$selected = isset($google_calendar_settings['order_status_sync']) && !empty($google_calendar_settings['order_status_sync']) && in_array($key,$order_status_sync) ? "selected" : "";
                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                                }
                                ?>
                                </select>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Custom Field That Will Sync With Google Calendar', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Input the comma separated custom field name.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<?php 
	                        	$sync_custom_field_name = isset($google_calendar_settings['sync_custom_field_name']) && !empty($google_calendar_settings['sync_custom_field_name']) ? $google_calendar_settings['sync_custom_field_name'] : array();
	                        	$sync_custom_field_name = implode(",",$sync_custom_field_name);
	                        	?>
	                    		<input id="coderockz_woo_delivery_sync_custom_field_name" name="coderockz_woo_delivery_sync_custom_field_name" type="text" class="coderockz_woo_delivery_sync_custom_field_name coderockz-woo-delivery-input-field" value="<?php echo $sync_custom_field_name; ?>" placeholder="<?php _e('Comma(,) separated custom field name', 'coderockz-woo-delivery'); ?>" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Google Calendar Sync Option for Customers', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to give the opportunity to your customer to sync in their google calendar then enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_google_calendar_customer_sync">
							       <input type="checkbox" name="coderockz_woo_delivery_google_calendar_customer_sync" id="coderockz_woo_delivery_google_calendar_customer_sync" <?php echo (isset($google_calendar_settings['google_calendar_customer_sync']) && !empty($google_calendar_settings['google_calendar_customer_sync'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_order_received_page_btn_txt"><?php _e('Add to Google Calendar Button Text', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The button text from the order confirmation page. Default is Add to Google Calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_order_received_page_btn_txt" name="coderockz_woo_delivery_order_received_page_btn_txt" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($google_calendar_settings['google_calendar_order_received_page_btn_txt']) && !empty($google_calendar_settings['google_calendar_order_received_page_btn_txt'])) ? stripslashes(esc_attr($google_calendar_settings['google_calendar_order_received_page_btn_txt'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_order_added_page_btn_txt"><?php _e('Button text After Order Added To Google Calendar', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The button text from the order confirmation page. Default is Add to Google Calendar.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_order_added_page_btn_txt" name="coderockz_woo_delivery_order_added_page_btn_txt" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($google_calendar_settings['google_calendar_order_added_page_btn_txt']) && !empty($google_calendar_settings['google_calendar_order_added_page_btn_txt'])) ? stripslashes(esc_attr($google_calendar_settings['google_calendar_order_added_page_btn_txt'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>

	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_google_calendar_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <?php

				$calendar_sync_customer = isset($google_calendar_settings['google_calendar_customer_sync']) && !empty($google_calendar_settings['google_calendar_customer_sync']) ? $google_calendar_settings['google_calendar_customer_sync'] : false;

				$enable_calendar_sync_client = isset($google_calendar_settings['google_calendar_sync']) && !empty($google_calendar_settings['google_calendar_sync']) ? $google_calendar_settings['google_calendar_sync'] : false;

				$calendar_sync_customer_client_id = isset($google_calendar_settings['google_calendar_client_id']) && !empty($google_calendar_settings['google_calendar_client_id']) ? $google_calendar_settings['google_calendar_client_id'] : "";
				
				$calendar_sync_customer_client_secret = isset($google_calendar_settings['google_calendar_client_secret']) && !empty($google_calendar_settings['google_calendar_client_secret']) ? $google_calendar_settings['google_calendar_client_secret'] : "";
                if(($calendar_sync_customer && $calendar_sync_customer_client_id != "" && $calendar_sync_customer_client_secret != "") || ($enable_calendar_sync_client && $google_calendar_settings['google_calendar_client_id'] != "" && $google_calendar_settings['google_calendar_client_secret'] != "" )) {
		
		            $calendar_sync_customer_redirect_url = home_url().'/wp-admin/admin.php?page=coderockz-woo-delivery-settings';
                    
                   	$client = new Google_Client();
                    $client->setClientId($calendar_sync_customer_client_id);
                    $client->setClientSecret($calendar_sync_customer_client_secret);
                    $client->setRedirectUri($calendar_sync_customer_redirect_url);
                    $client->addScope("https://www.googleapis.com/auth/calendar.events");
                    $client->setAccessType('offline');
                    $client->setApprovalPrompt("force");
                    
                    $auth_url = $client->createAuthUrl(); 
                            
                    if(isset($_GET['code'])) {
                        $client->authenticate($_GET['code']);
                        $access_token = $client->getAccessToken();
                        update_option('coderockz_woo_delivery_google_calendar_access_token',$access_token);
                        wp_redirect($calendar_sync_customer_redirect_url);
                        header("Refresh:0");
                        exit();
                    
                    }
                    
                ?>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Google Calendar Authentication', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning" style="margin-bottom:20px;"><span class="dashicons dashicons-megaphone"></span><?php _e(' You have to authenticate with Google to get the new order information in your Google Calendar.', 'coderockz-woo-delivery'); ?></p>

	                    
	                    <?php
	                    
	                    if(get_option('coderockz_woo_delivery_google_calendar_access_token')) {

	                         $client->setAccessToken(get_option('coderockz_woo_delivery_google_calendar_access_token'));
	                    
    	                    if($client->isAccessTokenExpired()) {
    	                        $client->fetchAccessTokenWithRefreshToken(get_option('coderockz_woo_delivery_google_calendar_access_token')['refresh_token']);
    	                        $access_token = $client->getAccessToken();
    	                        if(get_option('coderockz_woo_delivery_google_calendar_access_token')['access_token'] != $access_token['access_token']) {
    	                        	update_option('coderockz_woo_delivery_google_calendar_access_token',$access_token);
                                	wp_redirect($calendar_sync_customer_redirect_url);
                                	exit();
    	                        }
                                
    	                        
    	                    }
	                        
                            $auth_text = '<a href="#" class="coderockz-woo-delivery-submit-btn coderockz-woo-delivery-google-unauth-btn">'. __('Unauthenticate', 'coderockz-woo-delivery').'</a><p class="coderockz-woo-delivery-no-auth-text" style="color: #1DA160;"><i class="dashicons dashicons-yes" style="margin-bottom: 3px;"></i>'.__('Authenticated', 'coderockz-woo-delivery').'</p>';
                        
                        } else {
                        
                            $auth_text = '<a href="'.$auth_url.'" class="coderockz-woo-delivery-submit-btn coderockz-woo-delivery-google-auth-btn">'. __('Authenticate', 'coderockz-woo-delivery').'</a><p class="coderockz-woo-delivery-no-auth-text" style="color: #DD5246;"><i class="dashicons dashicons-no-alt" style="margin-bottom: 3px;"></i>'.__('No Authentication', 'coderockz-woo-delivery').'</p>';
                        }
                        
                        echo $auth_text;
	                    ?>
                	</div>

                </div>
            	<?php } ?>
			</div>
			<div data-tab="tab21" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Laundry Store Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-laundry-store-notice"></p>
	                    <form action="" method="post" id ="coderockz_overall_laundry_store_settings_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Enable Plugin for Laundry Store', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_laundry_store_settings">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_laundry_store_settings" id="coderockz_woo_delivery_enable_laundry_store_settings" <?php echo (isset($laundry_store_settings['enable_laundry_store_settings']) && !empty($laundry_store_settings['enable_laundry_store_settings'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_overall_after_pickup_dates"><?php _e('Delivery Dates After Selected Pickup Date', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width:98px!important" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1) this.value = null;" id="coderockz_delivery_overall_after_pickup_dates" name="coderockz_delivery_overall_after_pickup_dates" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($laundry_store_settings['overall_after_pickup_dates']) && !empty($laundry_store_settings['overall_after_pickup_dates'])) ? $laundry_store_settings['overall_after_pickup_dates'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Delivery Dates After Selected Pickup Date Including Selected Pickup Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_consider_selected_pickup_date">
							       <input type="checkbox" name="coderockz_delivery_date_consider_selected_pickup_date" id="coderockz_delivery_date_consider_selected_pickup_date" <?php echo (isset($laundry_store_settings['delivery_date_consider_selected_pickup_date']) && !empty($laundry_store_settings['delivery_date_consider_selected_pickup_date'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:398px!important"><?php _e('Delivery Dates After Selected Pickup Date Including All Offdays', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_delivery_date_consider_disabled_days">
							       <input type="checkbox" name="coderockz_delivery_date_consider_disabled_days" id="coderockz_delivery_date_consider_disabled_days" <?php echo (isset($laundry_store_settings['delivery_date_consider_disabled_days']) && !empty($laundry_store_settings['delivery_date_consider_disabled_days'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_overall_after_pickup_time"><?php _e(' Delivery Time After Pickup Time, If Dates Are Same', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Maximum 
	                    		1440 mintues here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input style="width: 75px!important;" onkeyup="if(!Number.isInteger(Number(this.value)) || this.value < 1 || this.value > 1440) this.value = null;" id="coderockz_delivery_overall_after_pickup_time" name="coderockz_delivery_overall_after_pickup_time" type="number" class="coderockz-woo-delivery-number-field" value="<?php echo (isset($laundry_store_settings['overall_after_pickup_time']) && !empty($laundry_store_settings['overall_after_pickup_time'])) ? $laundry_store_settings['overall_after_pickup_time'] : ""; ?>" placeholder="" autocomplete="off"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Minutes', 'coderockz-woo-delivery'); ?></span>
	                    	</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_overall_laundry_store_settings_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>
                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Category Wise Delivery Dates After Selected Pickup Date', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-category-after-pickup-dates-notice"></p>
						
	                    <form action="" method="post" id ="coderockz_category_after_pickup_dates_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label" style="width:295px!important"><?php _e('Enable Category Wise Delivery Dates After Selected Pickup Date', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip=""><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_enable_category_after_pickup_dates">
							       <input type="checkbox" name="coderockz_woo_delivery_enable_category_after_pickup_dates" id="coderockz_woo_delivery_enable_category_after_pickup_dates" <?php echo (isset($laundry_store_settings['enable_category_after_pickup_dates']) && !empty($laundry_store_settings['enable_category_after_pickup_dates'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-category-after-pickup-dates">

	                        <?php
	                        $category_after_pickup_dates_html = "";
							if(isset($laundry_store_settings['category_after_pickup_dates']) && !empty($laundry_store_settings['category_after_pickup_dates'])) {
								foreach($laundry_store_settings['category_after_pickup_dates'] as $category => $days) {
									$category_after_pickup_dates_html .= '<div class="coderockz-woo-delivery-form-group">';
							        $category_after_pickup_dates_html .= '<img class="coderockz-arrow" src="'.CODEROCKZ_WOO_DELIVERY_URL.'/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">';
									$category_after_pickup_dates_html .= '<select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_after_pickup_days_categories[]">
								    <option value="">'.__('Select Category', 'coderockz-woo-delivery').'</option>';
									foreach ($all_categories as $cat) {
										$selected = (htmlspecialchars_decode($cat->name) == stripslashes($category)) ? "selected" : "";
										$category_after_pickup_dates_html .= '<option value="'.str_replace(" ","c-w-d",$cat->name).'"'.$selected.'>'.$cat->name.'</option>';
									}
									$category_after_pickup_dates_html .= '</select>';
									$category_after_pickup_dates_html .= '<input type="number" class="coderockz-woo-delivery-number-field" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" name="coderockz-woo-delivery-after-pickup-days-'.str_replace(" ","c-w-d",$category).'" value="'.$days.'" style="vertical-align:top;width: 150px!important;" autocomplete="off" placeholder=""/><span class="coderockz-woo-delivery-processing-days-placeholder">'.__('Days', 'coderockz-woo-delivery').'</span>';
									if(array_keys($laundry_store_settings['category_after_pickup_dates'])[0] != $category){
										$category_after_pickup_dates_html .= '<button class="coderockz-woo-delivery-after-pickup-days-remove"><span class="dashicons dashicons-trash"></span></button>';
									}
									
							        $category_after_pickup_dates_html .= '</div>';
								}
								echo $category_after_pickup_dates_html;
							} else {

	                        ?>
		                        <div class="coderockz-woo-delivery-form-group">
		                        	<img class="coderockz-arrow" src="<?php echo CODEROCKZ_WOO_DELIVERY_URL ?>/admin/images/arrow.png" alt="" style="width: 20px;vertical-align: top;margin-top: 12px;margin-right: 15px;">
								    <select class="coderockz-woo-delivery-select-field" name="coderockz_delivery_after_pickup_days_categories[]">
								    <option value=""><?php _e('Select Category', 'coderockz-woo-delivery'); ?></option>
									<?php
									foreach ($all_categories as $cat) {
										echo '<option value="'.str_replace(" ","c-w-d",$cat->name).'">'.$cat->name.'</option>';
									}
									?>
									</select>
								    <input type="number" class="coderockz-woo-delivery-number-field" value="" onkeyup="if(!Number.isInteger(Number(this.value))) this.value = null;" style="vertical-align:top;width: 100px!important;" autocomplete="off" placeholder="" disabled="disabled"/><span class="coderockz-woo-delivery-processing-days-placeholder"><?php _e('Days', 'coderockz-woo-delivery'); ?></span>
		                    	</div>
		                    <?php } ?>
	                    	</div>
	                    	<button class="coderockz-woo-delivery-add-after-pickup-days-category-btn"><span class="dashicons dashicons-plus"></span></button>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_category_after_pickup_dates_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
			</div>
			<div data-tab="tab22" class="coderockz-woo-delivery-tabcontent">
				<div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Other Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-other-settings-notice"><span class="dashicons dashicons-yes"></span><?php _e(' Settings Changed Successfully', 'coderockz-woo-delivery'); ?></p>
	                    <form action="" method="post" id ="coderockz_delivery_other_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <div class="coderockz-woo-delivery-form-group">
								
								<span style="vertical-align:bottom" class="coderockz-woo-delivery-form-label"><?php _e('Spinner Animation in Checkout', 'coderockz-woo-delivery'); ?></span>
								<p style="vertical-align:bottom" class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Change the spinner animation while loading from here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
								<div style="display:inline-block;vertical-align: middle;">
									<div class='coderockz-woo-delivery-animation-preview-wrapper'>
									<?php
									if ( isset($other_settings['spinner-animation-id']) && !empty( $other_settings['spinner-animation-id'] ) ) {
										$coderockz_woo_delivery_spinner_animation = wp_get_attachment_url( $other_settings['spinner-animation-id'] );
										?>
										<img style="max-width:90px;display: block;margin:0 auto 10px;padding-right: 15px;" id='coderockz-woo-delivery-animation-preview' src='<?php echo esc_url( $coderockz_woo_delivery_spinner_animation ); ?>'>
										<?php
									} else {
										?>
										<img style="max-width:90px;display: block;margin:0 auto 10px;padding-right: 15px;" id='coderockz-woo-delivery-animation-preview' src=''>
										<?php
									}

									?>
								</div>
									<?php wp_enqueue_media(); ?>
									<input id="coderockz-woo-delivery-spinner-upload-btn" type="button" class="button" value="<?php _e( 'Upload Animation', 'coderockz-woo-delivery' ); ?>"/>
									<?php if(isset($other_settings['spinner-animation-id']) && !empty($other_settings['spinner-animation-id'])){ ?>
									<input id="coderockz-woo-delivery-spinner-clear-btn" type="button" class="button" value="<?php _e( 'Clear', 'coderockz-woo-delivery' ); ?>"/>
									<?php } ?>
									<input type='hidden' name='coderockz-woo-delivery-spinner-upload-id' id='coderockz-woo-delivery-spinner-upload-id' value="<?php echo (isset($other_settings['spinner-animation-id']) && !empty($other_settings['spinner-animation-id'])) ? esc_attr($other_settings['spinner-animation-id']) : "" ?>">
								</div>
							</div>
							<?php if(!WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>
							<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_spinner_animation_background"><?php _e('Spinner Animation Background', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Spinner animation background color. Default is Green.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<input type="text" style="width: 130px!important;line-height:unset!important;border: 1px solid #ccc!important;max-height: 30px!important;border-top-right-radius: 0!important;border-bottom-right-radius: 0!important;" class="coderockz-woo-delivery-input-field" id="coderockz_woo_delivery_spinner_animation_background" name="coderockz_woo_delivery_spinner_animation_background" value="<?php echo (isset($other_settings['spinner_animation_background']) && !empty($other_settings['spinner_animation_background'])) ? esc_attr($other_settings['spinner_animation_background']) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<?php } ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Tax to Any Delivery/Pickup Fee', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable this option if you want to add tax in any delivery/pickup fee. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_add_tax_delivery_pickup_fee">
							       <input type="checkbox" name="coderockz_woo_delivery_add_tax_delivery_pickup_fee" id="coderockz_woo_delivery_add_tax_delivery_pickup_fee" <?php echo (isset($other_settings['add_tax_delivery_pickup_fee']) && !empty($other_settings['add_tax_delivery_pickup_fee'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz_delivery_shipping_tax_class_section">
		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_shipping_tax_class"><?php _e('Shipping Tax Class for Fee/Tips', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("You need to specify the tax class here. Default is standard tax class.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                    		<select style="width: 250px!important;" id="coderockz_delivery_shipping_tax_class" class="coderockz-woo-delivery-select-field" name="coderockz_delivery_shipping_tax_class">
		                    			<?php foreach(wc_get_product_tax_class_options() as $key=>$value) { ?>
		                    			<option value="<?php echo $key; ?>" <?php if(isset($other_settings['shipping_tax_class']) && $other_settings['shipping_tax_class'] == $key){ echo "selected"; } ?>><?php echo $value; ?></option>
		                    			<?php } ?>
									</select>
		                    	</div>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Heading of Delivery Section From Checkout Page', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable if you want to hide the heading of the plugin module. Default is Delivery Information.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_hide_heading_delivery_section">
							       <input type="checkbox" name="coderockz_woo_delivery_hide_heading_delivery_section" id="coderockz_woo_delivery_hide_heading_delivery_section" <?php echo (isset($other_settings['hide_heading_delivery_section']) && !empty($other_settings['hide_heading_delivery_section'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                        <div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show Plugin Module For Virtual/Downloadable Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the delivery fields if there is any virtual or downloadable products in the cart. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_disable_fields_for_downloadable_products">
							       <input type="checkbox" name="coderockz_disable_fields_for_downloadable_products" id="coderockz_disable_fields_for_downloadable_products" <?php echo (isset($other_settings['disable_fields_for_downloadable_products']) && !empty($other_settings['disable_fields_for_downloadable_products'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Show Plugin Module For (Virtual/Downloadable + Regular) Products', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Enable the delivery fields if there is any virtual/downloadable products as well as regular products in the cart. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_disable_fields_for_downloadable_regular_products">
							       <input type="checkbox" name="coderockz_disable_fields_for_downloadable_regular_products" id="coderockz_disable_fields_for_downloadable_regular_products" <?php echo (isset($other_settings['disable_fields_for_downloadable_regular_products']) && !empty($other_settings['disable_fields_for_downloadable_regular_products'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Give Plugin Settings Access Shop Manager', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want that the shop manager can do everything with the plugin settings, enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_access_shop_manager">
							       <input type="checkbox" name="coderockz_woo_delivery_access_shop_manager" id="coderockz_woo_delivery_access_shop_manager" <?php echo (isset($other_settings['access_shop_manager']) && !empty($other_settings['access_shop_manager'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Give Delivery Calendar Access Shop Manager', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want that the shop manager can do everything with the delivery calendar, enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_calendar_access_shop_manager">
							       <input type="checkbox" name="coderockz_woo_delivery_calendar_access_shop_manager" id="coderockz_woo_delivery_calendar_access_shop_manager" <?php echo (isset($other_settings['calendar_access_shop_manager']) && !empty($other_settings['calendar_access_shop_manager'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Add Delivery Info in Order Note', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to add delivery information in order note then enable it. The feature is super handy becuase WooCommerce app doesn't allow any custom information. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_add_delivery_info_order_note">
							       <input type="checkbox" name="coderockz_woo_delivery_add_delivery_info_order_note" id="coderockz_woo_delivery_add_delivery_info_order_note" <?php echo (isset($other_settings['add_delivery_info_order_note']) && !empty($other_settings['add_delivery_info_order_note'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Remove Delivery/Pickup Status Column & Functionality', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to remove the delivery status column from the orders page and single order page, enable this option. Default is showing all delivery status functionaity and column.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_remove_delivery_status_column">
							       <input type="checkbox" name="coderockz_woo_delivery_remove_delivery_status_column" id="coderockz_woo_delivery_remove_delivery_status_column" <?php echo (isset($other_settings['remove_delivery_status_column']) && !empty($other_settings['remove_delivery_status_column'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>

	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Disable Changing Shipping Methods Based on Delivery/Pickup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("The plugin is hidden Local pickup if Delivery option is selected in the Checkout and hidden all shipping methods except Local pickup if Pickup option is selected in the checkout. If you want to disable it, enable it. Default is enable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_disable_dynamic_shipping_methods">
							       <input type="checkbox" name="coderockz_woo_delivery_disable_dynamic_shipping_methods" id="coderockz_woo_delivery_disable_dynamic_shipping_methods" <?php echo (isset($other_settings['disable_dynamic_shipping']) && !empty($other_settings['disable_dynamic_shipping'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Shipping Address for Pickup', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the shipping address section if a customer selects the pickup then enable it. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_hide_shipping_address">
							       <input type="checkbox" name="coderockz_woo_delivery_hide_shipping_address" id="coderockz_woo_delivery_hide_shipping_address" <?php echo (isset($other_settings['hide_shipping_address']) && !empty($other_settings['hide_shipping_address'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Mark Delivery/Pickup Completed if Order status Completed', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to mark the delivery/pickup status completed when the order marks as completed then enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_mark_delivery_completed_with_order_completed">
							       <input type="checkbox" name="coderockz_woo_delivery_mark_delivery_completed_with_order_completed" id="coderockz_woo_delivery_mark_delivery_completed_with_order_completed" <?php echo (isset($other_settings['mark_delivery_completed_with_order_completed']) && !empty($other_settings['mark_delivery_completed_with_order_completed'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Plugin Module if Cart Subtotal Zero', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide the pluign module from the checkout page when cart subtotal is zero, enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_hide_module_cart_total_zero">
							       <input type="checkbox" name="coderockz_woo_delivery_hide_module_cart_total_zero" id="coderockz_woo_delivery_hide_module_cart_total_zero" <?php echo (isset($other_settings['hide_module_cart_total_zero']) && !empty($other_settings['hide_module_cart_total_zero'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide All the Disabled Timeslots', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide all the timeslots that are disabled, enable the option. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_hide_disabled_timeslot">
							       <input type="checkbox" name="coderockz_woo_delivery_hide_disabled_timeslot" id="coderockz_woo_delivery_hide_disabled_timeslot" <?php echo (isset($other_settings['hide_disabled_timeslot']) && !empty($other_settings['hide_disabled_timeslot'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                        	<span class="coderockz-woo-delivery-form-label"><?php _e('Hide Meta Data of Products from Google Sync, Delivery Reports and Calendar', 'coderockz-woo-delivery'); ?></span>
	                        	<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to hide meta data of products from delivery reports and delivery calendar, enable it. Default is disable.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
							    <label class="coderockz-woo-delivery-toogle-switch" for="coderockz_woo_delivery_hide_metadata_reports_calendar">
							       <input type="checkbox" name="coderockz_woo_delivery_hide_metadata_reports_calendar" id="coderockz_woo_delivery_hide_metadata_reports_calendar" <?php echo (isset($other_settings['hide_metadata_reports_calendar']) && !empty($other_settings['hide_metadata_reports_calendar'])) ? "checked" : "" ?>/>
							       <div class="coderockz-woo-delivery-toogle-slider coderockz-woo-delivery-toogle-round"></div>
							    </label>
	                    	</div>
	                    	<?php if(WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )) { ?>

		                    	<div class="coderockz-woo-delivery-form-group">
		                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_format"><?php _e('Field Position', 'coderockz-woo-delivery'); ?></label>
		                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Position of all the fields that are enabled by this plugin. Default is after order notes.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
		                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_block_field_position">
		                    			<option value="" <?php if(isset($other_settings['block_field_position']) && $other_settings['block_field_position'] == ""){ echo "selected"; } ?>><?php _e('Select Position', 'coderockz-woo-delivery'); ?></option>
										<option value="contact-information" <?php if(isset($other_settings['block_field_position']) && $other_settings['block_field_position'] == "contact-information"){ echo "selected"; } ?>><?php _e('After Contact Information Section', 'coderockz-woo-delivery'); ?></option>
										<option value="shipping-address" <?php if(isset($other_settings['block_field_position']) && $other_settings['block_field_position'] == "shipping-address"){ echo "selected"; } ?>><?php _e('After Shipping Address Section', 'coderockz-woo-delivery'); ?></option>
										<option value="billing-address" <?php if(isset($other_settings['block_field_position']) && $other_settings['block_field_position'] == "billing-address"){ echo "selected"; } ?>><?php _e('After Billing Address Section', 'coderockz-woo-delivery'); ?></option>

									</select>
		                    	</div>
	                        
	                    	<?php } else {?>
	                        <div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_delivery_time_format"><?php _e('Field Position', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("Position of all the fields that are enabled by this plugin. Default is after order notes.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                    		<select class="coderockz-woo-delivery-select-field" name="coderockz_woo_delivery_field_position">
	                    			<option value="" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == ""){ echo "selected"; } ?>><?php _e('Select Position', 'coderockz-woo-delivery'); ?></option>
									<option value="before_billing" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_billing"){ echo "selected"; } ?>><?php _e('Before Billing Address', 'coderockz-woo-delivery'); ?></option>
									<option value="after_billing" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "after_billing"){ echo "selected"; } ?>><?php _e('After Billing Address', 'coderockz-woo-delivery'); ?></option>
									<option value="before_shipping" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_shipping"){ echo "selected"; } ?>><?php _e('Before Shipping Address', 'coderockz-woo-delivery'); ?></option>
									<option value="after_shipping" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "after_shipping"){ echo "selected"; } ?>><?php _e('After Shipping Address', 'coderockz-woo-delivery'); ?></option>
									<option value="before_notes" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_notes"){ echo "selected"; } ?>><?php _e('Before Order Notes', 'coderockz-woo-delivery'); ?></option>
									<option value="after_notes" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "after_notes"){ echo "selected"; } ?>><?php _e('After Order Notes', 'coderockz-woo-delivery'); ?></option>
									<option value="before_payment" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_payment"){ echo "selected"; } ?>><?php _e('Between Your Order And Payment Section', 'coderockz-woo-delivery'); ?></option>
									<option value="before_your_order" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_your_order"){ echo "selected"; } ?>><?php _e('Before Your Order Section', 'coderockz-woo-delivery'); ?></option>
									<option value="before_customer_details" <?php if(isset($other_settings['field_position']) && $other_settings['field_position'] == "before_customer_details"){ echo "selected"; } ?>><?php _e('Before Customer Details', 'coderockz-woo-delivery'); ?></option>
								</select>
	                    	</div>
	                    	<?php } ?>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label" for="coderockz_woo_delivery_additional_message"><?php _e('Additional Message Before Delivery Section', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want to show any additional message to your customer then put it here. It will show before the delivery section. For Ex. We will try our best to deliver in time.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<input id="coderockz_woo_delivery_additional_message" name="coderockz_woo_delivery_additional_message" type="text" class="coderockz-woo-delivery-input-field" value="<?php echo (isset($other_settings['additional_message']) && !empty($other_settings['additional_message'])) ? stripslashes(esc_attr($other_settings['additional_message'])) : "" ?>" placeholder="" autocomplete="off"/>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Hide Additional Message For', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you don't want to show your customers the Additional Message for delivery or pickup, specify it here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<select id="coderockz_woo_delivery_hide_additional_message_for" name="coderockz_woo_delivery_hide_additional_message_for[]" class="coderockz_woo_delivery_hide_additional_message_for" multiple>
                                <?php
                                $option = array("delivery"=>"Delivery", "pickup"=>"Pickup");
	                                foreach ($option as $key => $value) {
	                                	$selected = isset($other_settings['hide_additional_message_for']) && !empty($other_settings['hide_additional_message_for']) && in_array($key,$other_settings['hide_additional_message_for']) ? "selected" : "";
	                                    echo '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';		
	                                }
                                ?>
                                </select>
	                    	</div>
	                    	<div class="coderockz-woo-delivery-form-group">
	                    		<label class="coderockz-woo-delivery-form-label"><?php _e('Custom CSS', 'coderockz-woo-delivery'); ?></label>
	                    		<p class="coderockz-woo-delivery-tooltip" tooltip="<?php _e("If you want some custom css to avoid the plugin/theme conflict, put the css code here.", 'coderockz-woo-delivery'); ?>"><span class="dashicons dashicons-editor-help"></span></p>
	                        	<textarea id="coderockz_woo_delivery_code_editor_css" name="coderockz_woo_delivery_code_editor_css" class="coderockz-woo-delivery-textarea-field" placeholder="" autocomplete="off"><?php echo (isset($other_settings['custom_css']) && !empty($other_settings['custom_css'])) ? stripslashes(esc_attr($other_settings['custom_css'])) : "" ?>
                                </textarea>
	                    	</div>
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_delivery_other_settings_form_submit" value="<?php _e('Save Changes', 'coderockz-woo-delivery'); ?>" />

	                    </form>
                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Export Plugin Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">

	                    <button class="coderockz-woo-delivery-export-settings-btn"><a style="color: #fff;text-decoration: none;" target="_blank"><?php _e('Export Settings', 'coderockz-woo-delivery'); ?></a></button>

                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header"><?php _e('Import Plugin Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' Before importing settings file, please reset the plugin settings first from bellow.', 'coderockz-woo-delivery'); ?></p>
						<p class="coderockz-woo-delivery-time-slot-fee-warning"><span class="dashicons dashicons-megaphone"></span><?php _e(' After importing the file, please ', 'coderockz-woo-delivery'); ?><span class="coderockz-woo-delivery-refresh-btn"><?php _e('refresh the page', 'coderockz-woo-delivery'); ?></span><?php _e(' to see the settings', 'coderockz-woo-delivery'); ?></p>
						<?php


						global $wpdb;

						// Table name
						$tablename = $wpdb->prefix."options";


						if(isset($_POST['coderockz_woo_delivery_import_settings_form_submit'])){

							// File extension
							$extension = pathinfo($_FILES['coderockz_woo_delivery_import_plugin_settings_file']['name'], PATHINFO_EXTENSION);

							// If file extension is 'csv'
							if(!empty($_FILES['coderockz_woo_delivery_import_plugin_settings_file']['name']) && $extension == 'csv'){

								// Open file in read mode
								$csvFile = fopen($_FILES['coderockz_woo_delivery_import_plugin_settings_file']['tmp_name'], 'r');

								/*fgetcsv($csvFile);*/ // Skipping header row

								// Read file
								while(($csvData = fgetcsv($csvFile)) !== FALSE) {

									/*$csvData = array_map("utf8_encode", $csvData);*/

									// Row column length
									$dataLen = count($csvData);

									// Skip row if length != 2
									if( !($dataLen == 2) ) continue;

									// Assign value to variables
									$option_name = trim($csvData[0]);
									$option_value = trim($csvData[1]);

									$option_value = str_replace('c-w-d',',',$option_value);
									$option_value = str_replace('d-e-l',PHP_EOL,$option_value);
									
									// Check record already exists or not
									$cntSQL = "SELECT count(*) as count FROM {$tablename} where option_name='".$option_name."'";
									$record = $wpdb->get_results($cntSQL, OBJECT);

									if($record[0]->count==0){

										// Check if variable is empty or not
										if( !empty($option_name) && !empty($option_value) ) {
											// Insert Record
											$wpdb->insert($tablename, array(
											'option_name' =>$option_name,
											'option_value' =>$option_value
											));

										}

									}

								}

							} else {

							   $invalid_extension = "Please upload a CSV file";

							}

						}

						?>



						<p style="color:#ca4a1f;font-size: 20px;font-style: italic;font-weight:bold;"><?php echo (isset($invalid_extension) && !empty($invalid_extension)) ? stripslashes(esc_attr($invalid_extension)) : ""; ?></p>
	                    <form action="<?= $_SERVER['REQUEST_URI']; ?>" method="post" enctype='multipart/form-data'>
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>
	                        <input style="margin-bottom: 20px;" type="file" name="coderockz_woo_delivery_import_plugin_settings_file" >
	                        <input class="coderockz-woo-delivery-submit-btn" type="submit" name="coderockz_woo_delivery_import_settings_form_submit" value="<?php _e('Import Settings', 'coderockz-woo-delivery'); ?>" />
	                    </form>

                	</div>

                </div>
                <div class="coderockz-woo-delivery-card">
					<p class="coderockz-woo-delivery-card-header coderockz-woo-delivery-reset-header"><?php _e('Reset Plugin Settings', 'coderockz-woo-delivery'); ?></p>
					<div class="coderockz-woo-delivery-card-body">
	                    <form action="" method="post" id ="coderockz_woo_delivery_reset_settings_form_submit">
	                        <?php wp_nonce_field('coderockz_woo_delivery_nonce'); ?>

	                        <input class="coderockz-woo-delivery-submit-btn coderockz-woo-delivery-reset-btn" type="submit" name="coderockz_woo_delivery_reset_settings_form_submit" value="<?php _e('Reset Settings', 'coderockz-woo-delivery'); ?>" />
	                    </form>
                	</div>

                </div>
			</div>
		</div>
	</div>

</div>

</div>



