<?php echo Bug_Monitor_Dashboard::get_description($data);?>
<?php if (!empty($data['details']['issue']) && $data['details']['issue'] == 'missing'):?>
      <?php esc_html_e('The meta description is important for several reasons:', 'bug-monitor');?>
      <ol>
            <li><?php esc_html_e('Search Engine Optimization (SEO): It helps search engines understand the content of a webpage, which can influence its ranking in search results.', 'bug-monitor');?></li>
            <li><?php esc_html_e('Click-Through Rates: A well-written meta description can entice users to click on your link in search results, increasing the likelihood of visits to your site.', 'bug-monitor');?></li>
            <li><?php esc_html_e('User Experience: It provides a summary of the webpage\'s content, helping users decide if the page is relevant to their search query before they click.', 'bug-monitor');?></li>
      </ol>
      <?php echo sprintf(esc_html__('It is recommended to use a %sSEO plugin%s to add missing meta descriptions.', 'bug-monitor'), '<a href="https://wordpress.org/plugins/search/seo/" target="_blank">', '</a>');?>
<?php else: ?>
      <?php esc_html_e('A good meta description typically has the following characteristics:', 'bug-monitor');?>
      <ol>
            <li><?php esc_html_e('Relevant and Informative: It accurately summarizes the page content and provides value to the reader.', 'bug-monitor');?></li>
            <li><?php esc_html_e('Length: Ideally between 150-160 characters. Longer descriptions might be truncated in search results.', 'bug-monitor');?></li>
            <li><?php esc_html_e('Engaging: Written in an active voice and enticing enough to encourage clicks, without being misleading.', 'bug-monitor');?></li>
            <li><?php esc_html_e('Contains Keywords: Includes relevant keywords for SEO, but avoids keyword stuffing.', 'bug-monitor');?></li>
            <li><?php esc_html_e('Unique for Each Page: Tailored specifically to each page\'s content to avoid duplicate meta descriptions across the site.', 'bug-monitor');?></li>
      </ol>

<?php endif;